Option Explicit
Global DR, DG, DB, RI, GI, BI, RE, GE, BE, StepColor As Integer, InitialColor, FinalColor As Long

Sub CalcSetka ()
    If StepColor = 0 Then StepColor = 50
    If InitialColor = 0 Then InitialColor = RGB(0, 0, 255)
    If FinalColor = 0 Then FinalColor = RGB(0, 0, 32)

        RI = InitialColor \ 65536

        GI = (InitialColor - RGB(0, 0, RI)) \ 256

        BI = InitialColor - RGB(0, GI, RI)


        RE = FinalColor \ 65536
        GE = (FinalColor - RGB(0, 0, RE)) \ 256
        BE = FinalColor - RGB(0, GE, RE)

        DR = Fix((RE - RI) / StepColor)
        DG = Fix((GE - GI) / StepColor)
        DB = Fix((BE - BI) / StepColor)

End Sub

Sub DrawForm (Form As Form)
    Dim I, Y0, YM, DY, R, G, b, X0, XM
    Form.DrawStyle = 5
    Form.DrawWidth = 1
    Form.ScaleMode = 3
     Y0 = Form.ScaleTop
     DY = Fix(Form.ScaleHeight / StepColor)
     YM = Y0 + DY
        R = RI
        G = GI
        b = BI
     For I = 1 To StepColor
        If I = StepColor Then YM = Form.ScaleHeight - 1
        Form.Line (Form.ScaleLeft, Y0)-(Form.ScaleLeft + Form.ScaleWidth - 1, YM), RGB(b, G, R), BF
            Y0 = YM - 1
            YM = YM + DY
            R = R + DR
            G = G + DG
            b = b + DB
     Next I
     Form.ForeColor = &HFFFFFF - InitialColor
     Form.CurrentX = 1
     Form.CurrentY = 1
     Form.Print "Resize Me or Click Me!"
End Sub

