VERSION 4.00
Begin VB.Form frmVolume 
   Appearance      =   0  'Flat
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Volume"
   ClientHeight    =   2925
   ClientLeft      =   6510
   ClientTop       =   2595
   ClientWidth     =   1560
   BeginProperty Font 
      name            =   "MS Sans Serif"
      charset         =   0
      weight          =   700
      size            =   8.25
      underline       =   0   'False
      italic          =   0   'False
      strikethrough   =   0   'False
   EndProperty
   ForeColor       =   &H80000008&
   Height          =   3330
   Icon            =   "VOL.frx":0000
   Left            =   6450
   LinkTopic       =   "Form1"
   ScaleHeight     =   2925
   ScaleWidth      =   1560
   Top             =   2250
   Width           =   1680
   Begin VB.CommandButton cmdOK 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      Caption         =   "&OK"
      Height          =   375
      Left            =   360
      TabIndex        =   2
      Top             =   2400
      Width           =   855
   End
   Begin VB.VScrollBar RScroll 
      Height          =   1815
      LargeChange     =   10
      Left            =   1200
      Max             =   0
      Min             =   100
      TabIndex        =   1
      Top             =   50
      Width           =   255
   End
   Begin VB.VScrollBar LScroll 
      Height          =   1815
      LargeChange     =   10
      Left            =   120
      Max             =   0
      Min             =   100
      TabIndex        =   0
      Top             =   50
      Width           =   255
   End
   Begin MCI.MMControl MMControl1 
      Height          =   4215
      Left            =   1680
      TabIndex        =   6
      Top             =   0
      Width           =   420
      _Version        =   65536
      Orientation     =   1
      _ExtentX        =   741
      _ExtentY        =   7435
      _StockProps     =   32
   End
   Begin Threed.SSCheck chkLock 
      Height          =   195
      Left            =   420
      TabIndex        =   5
      Top             =   2130
      Width           =   735
      _Version        =   65536
      _ExtentX        =   1296
      _ExtentY        =   344
      _StockProps     =   78
      Caption         =   "&Lock"
      Value           =   -1  'True
   End
   Begin VB.Label lblRight 
      Appearance      =   0  'Flat
      AutoSize        =   -1  'True
      BackColor       =   &H00C0C0C0&
      Caption         =   "R"
      ForeColor       =   &H80000008&
      Height          =   195
      Left            =   1245
      TabIndex        =   4
      Top             =   1920
      Width           =   150
   End
   Begin VB.Label lblLeft 
      Appearance      =   0  'Flat
      AutoSize        =   -1  'True
      BackColor       =   &H00C0C0C0&
      Caption         =   "L"
      ForeColor       =   &H80000008&
      Height          =   195
      Left            =   195
      TabIndex        =   3
      Top             =   1920
      Width           =   120
   End
   Begin VB.Line lnRight 
      BorderColor     =   &H00808080&
      BorderWidth     =   2
      X1              =   1020
      X2              =   1020
      Y1              =   1700
      Y2              =   150
   End
   Begin VB.Line lnTop 
      BorderColor     =   &H00FFFFFF&
      BorderWidth     =   2
      X1              =   555
      X2              =   1025
      Y1              =   150
      Y2              =   150
   End
   Begin VB.Line lnLeft 
      BorderColor     =   &H00FFFFFF&
      BorderWidth     =   2
      X1              =   1020
      X2              =   555
      Y1              =   1700
      Y2              =   150
   End
End
Attribute VB_Name = "frmVolume"
Attribute VB_Creatable = False
Attribute VB_Exposed = False

    'General Declarations:
    Option Explicit

    Dim FirstFlag As Integer

    Dim DevID As Integer
    Dim RVol As Long, LVol As Long

    Dim LScrollPrevValue As Integer, RScrollPrevValue As Integer

    Dim lk As Integer

Private Sub cmdOK_Click()

    Unload frmVolume

End Sub

Private Function Cnvrt2Volume(LeftVol As Long, RightVol As Long) As Long
  Dim IVolumes As CnvrtIVolumesType
  Dim LVolume As CnvrtLVolumeType

  IVolumes.LeftVolume = CInt("&H" & Hex$(LeftVol))
  IVolumes.RightVolume = CInt("&H" & Hex$(RightVol))
  LSet LVolume = IVolumes
  Cnvrt2Volume = LVolume.Volume
End Function

Private Sub DisplayErrorAndExit(ErrNum As Integer)
  Select Case ErrNum
    Case MMSYSERR_BADDEVICEID
      MsgBox "Specified device ID is out of range."
    Case MMSYSERR_NODRIVER
      MsgBox "The driver failed to install."
  End Select
  End
End Sub

Private Sub Form_Load()
    'Center Volume Form
    Move (Screen.Width - Width) \ 2, (Screen.Height - Height) \ 2
    
    'Declare variables
    Dim IniVol As Long
    Dim RetVal As Integer

  FirstFlag = True

  DevID = GetSoundBoardCDAudioID()

  MMControl1.DeviceType = "CDAudio"
  MMControl1.Command = "Open"

  RetVal = auxGetVolume(DevID, IniVol)
  If RetVal <> 0 Then Call DisplayErrorAndExit(RetVal)
  LVol = IniVol And &HFFFF&
  RVol = (IniVol And &HFFFF0000) / &H10000

  LScroll.Value = Abs(CInt((LVol * 100&) / &HFFFF&))
  LScrollPrevValue = LScroll.Value
  RScroll.Value = Abs(CInt((RVol * 100&) / &HFFFF&))
  RScrollPrevValue = RScroll.Value

  FirstFlag = False

   
End Sub

Private Sub Form_Unload(Cancel As Integer)
    MMControl1.Command = "Close"
    
End Sub

Private Function GetSoundBoardCDAudioID()
  Dim NumAuxDevs As Integer
  Dim DevNum As Integer
  Dim DevCaps As AUXCAPS
  Dim RetVal As Integer, Pos As Integer

  NumAuxDevs = auxGetNumDevs()
  GetSoundBoardCDAudioID = 0
  For DevNum = 0 To (NumAuxDevs - 1)
    RetVal = auxGetDevCaps(DevNum, DevCaps, 92)
    If RetVal <> 0 Then Call DisplayErrorAndExit(RetVal)
    Pos = InStr(DevCaps.szPname, "CD")
    If Pos <> 0 Then
      GetSoundBoardCDAudioID = DevNum
      Exit Function
    End If
  Next DevNum
End Function

Private Sub LScroll_Change()
    If chkLock.Value = True Then
        RScroll.Value = LScroll.Value
    End If
    
    Dim DeltaLScroll As Integer, DeltaVolume As Long
    Dim RetVal As Integer

    If Not FirstFlag Then
        DeltaLScroll = LScroll.Value - LScrollPrevValue
        LScrollPrevValue = LScroll.Value
        DeltaVolume = ((&HFFFF& * CLng(Abs(DeltaLScroll))) / 100&)
    If DeltaLScroll < 0 Then
        LVol = LVol - DeltaVolume
        If LVol < &H0& Then LVol = &H0&
        Else
        LVol = LVol + DeltaVolume
        If LVol > &HFFFF& Then LVol = &HFFFF&
        End If
        RetVal = auxSetVolume(DevID, Cnvrt2Volume(LVol, RVol))
        If RetVal <> 0 Then Call DisplayErrorAndExit(RetVal)
    End If

End Sub

Private Sub RScroll_Change()
    If chkLock.Value = True Then
        LScroll.Value = RScroll.Value
    End If

    
    Dim DeltaRScroll As Integer, DeltaVolume As Long
    Dim RetVal As Integer

  If Not FirstFlag Then
    DeltaRScroll = RScroll.Value - RScrollPrevValue
    RScrollPrevValue = RScroll.Value
    DeltaVolume = ((&HFFFF& * CLng(Abs(DeltaRScroll))) / 100&)
    If DeltaRScroll < 0 Then
      RVol = RVol - DeltaVolume
      If RVol < &H0& Then RVol = &H0&
    Else
      RVol = RVol + DeltaVolume
      If RVol > &HFFFF& Then RVol = &HFFFF&
    End If
    RetVal = auxSetVolume(DevID, Cnvrt2Volume(LVol, RVol))
    If RetVal <> 0 Then Call DisplayErrorAndExit(RetVal)
  End If


End Sub

