VERSION 2.00
Begin Form frmVolume 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Volume"
   ClientHeight    =   3015
   ClientLeft      =   5820
   ClientTop       =   2595
   ClientWidth     =   1560
   Height          =   3420
   Icon            =   VOL2.FRX:0000
   Left            =   5760
   LinkTopic       =   "Form1"
   ScaleHeight     =   3015
   ScaleWidth      =   1560
   Top             =   2250
   Width           =   1680
   Begin SSCheck chkLock 
      Caption         =   "&Lock"
      Height          =   195
      Left            =   420
      TabIndex        =   6
      Top             =   2250
      Value           =   -1  'True
      Width           =   735
   End
   Begin CommandButton cmdOK 
      BackColor       =   &H00C0C0C0&
      Caption         =   "&OK"
      Height          =   375
      Left            =   360
      TabIndex        =   3
      Top             =   2520
      Width           =   855
   End
   Begin VScrollBar RScroll 
      Height          =   1815
      LargeChange     =   10
      Left            =   1200
      Max             =   0
      Min             =   100
      TabIndex        =   2
      Top             =   120
      Width           =   255
   End
   Begin VScrollBar LScroll 
      Height          =   1815
      LargeChange     =   10
      Left            =   120
      Max             =   0
      Min             =   100
      TabIndex        =   1
      Top             =   120
      Width           =   255
   End
   Begin MMControl MMControl1 
      Height          =   2730
      Left            =   3120
      Orientation     =   1  'Vertical
      TabIndex        =   0
      Top             =   0
      Visible         =   0   'False
      Width           =   450
   End
   Begin Label lblRight 
      AutoSize        =   -1  'True
      BackColor       =   &H00C0C0C0&
      Caption         =   "R"
      Height          =   195
      Left            =   1245
      TabIndex        =   5
      Top             =   2040
      Width           =   150
   End
   Begin Label lblLeft 
      AutoSize        =   -1  'True
      BackColor       =   &H00C0C0C0&
      Caption         =   "L"
      Height          =   195
      Left            =   195
      TabIndex        =   4
      Top             =   2040
      Width           =   120
   End
   Begin Line lnRight 
      BorderColor     =   &H00808080&
      BorderWidth     =   2
      X1              =   1020
      X2              =   1020
      Y1              =   1800
      Y2              =   240
   End
   Begin Line lnTop 
      BorderColor     =   &H00FFFFFF&
      BorderWidth     =   2
      X1              =   555
      X2              =   1025
      Y1              =   240
      Y2              =   240
   End
   Begin Line lnLeft 
      BorderColor     =   &H00FFFFFF&
      BorderWidth     =   2
      X1              =   1025
      X2              =   555
      Y1              =   1800
      Y2              =   240
   End
End
    'General Declarations:
    Option Explicit

    Dim FirstFlag As Integer

    Dim DevID As Integer
    Dim RVol As Long, LVol As Long

    Dim LScrollPrevValue As Integer, RScrollPrevValue As Integer

    Dim lk As Integer

Sub cmdOK_Click ()

    Unload frmVolume

End Sub

Function Cnvrt2Volume (LeftVol As Long, RightVol As Long) As Long
  Dim IVolumes As CnvrtIVolumesType
  Dim LVolume As CnvrtLVolumeType

  IVolumes.LeftVolume = CInt("&H" & Hex$(LeftVol))
  IVolumes.RightVolume = CInt("&H" & Hex$(RightVol))
  LSet LVolume = IVolumes
  Cnvrt2Volume = LVolume.Volume
End Function

Sub DisplayErrorAndExit (ErrNum As Integer)
  Select Case ErrNum
    Case MMSYSERR_BADDEVICEID
      MsgBox "Specified device ID is out of range."
    Case MMSYSERR_NODRIVER
      MsgBox "The driver failed to install."
  End Select
  End
End Sub

Sub Form_Load ()
    'Center Volume Form
    Move (Screen.Width - Width) \ 2, (Screen.Height - Height) \ 2
    
    'Declare variables
    Dim IniVol As Long
    Dim RetVal As Integer

  FirstFlag = True

  DevID = GetSoundBoardCDAudioID()

  MMControl1.DeviceType = "CDAudio"
  MMControl1.Command = "Open"

  RetVal = auxGetVolume(DevID, IniVol)
  If RetVal <> 0 Then Call DisplayErrorAndExit(RetVal)
  LVol = IniVol And &HFFFF&
  RVol = (IniVol And &HFFFF0000) / &H10000

  LScroll.Value = Abs(CInt((LVol * 100&) / &HFFFF&))
  LScrollPrevValue = LScroll.Value
  RScroll.Value = Abs(CInt((RVol * 100&) / &HFFFF&))
  RScrollPrevValue = RScroll.Value

  FirstFlag = False

   
End Sub

Sub Form_Unload (Cancel As Integer)
    MMControl1.Command = "Close"
End Sub

Function GetSoundBoardCDAudioID ()
  Dim NumAuxDevs As Integer
  Dim DevNum As Integer
  Dim DevCaps As AUXCAPS
  Dim RetVal As Integer, Pos As Integer

  NumAuxDevs = auxGetNumDevs()
  GetSoundBoardCDAudioID = 0
  For DevNum = 0 To (NumAuxDevs - 1)
    RetVal = auxGetDevCaps(DevNum, DevCaps, 92)
    If RetVal <> 0 Then Call DisplayErrorAndExit(RetVal)
    Pos = InStr(DevCaps.szPname, "CD")
    If Pos <> 0 Then
      GetSoundBoardCDAudioID = DevNum
      Exit Function
    End If
  Next DevNum
End Function

Sub LScroll_Change ()
    If chkLock.Value = True Then
        RScroll.Value = LScroll.Value
    End If
    
    Dim DeltaLScroll As Integer, DeltaVolume As Long
    Dim RetVal As Integer

    If Not FirstFlag Then
        DeltaLScroll = LScroll.Value - LScrollPrevValue
        LScrollPrevValue = LScroll.Value
        DeltaVolume = ((&HFFFF& * CLng(Abs(DeltaLScroll))) / 100&)
    If DeltaLScroll < 0 Then
        LVol = LVol - DeltaVolume
        If LVol < &H0& Then LVol = &H0&
        Else
        LVol = LVol + DeltaVolume
        If LVol > &HFFFF& Then LVol = &HFFFF&
        End If
        RetVal = auxSetVolume(DevID, Cnvrt2Volume(LVol, RVol))
        If RetVal <> 0 Then Call DisplayErrorAndExit(RetVal)
    End If

End Sub

Sub RScroll_Change ()
    If chkLock.Value = True Then
        LScroll.Value = RScroll.Value
    End If

    
    Dim DeltaRScroll As Integer, DeltaVolume As Long
    Dim RetVal As Integer

  If Not FirstFlag Then
    DeltaRScroll = RScroll.Value - RScrollPrevValue
    RScrollPrevValue = RScroll.Value
    DeltaVolume = ((&HFFFF& * CLng(Abs(DeltaRScroll))) / 100&)
    If DeltaRScroll < 0 Then
      RVol = RVol - DeltaVolume
      If RVol < &H0& Then RVol = &H0&
    Else
      RVol = RVol + DeltaVolume
      If RVol > &HFFFF& Then RVol = &HFFFF&
    End If
    RetVal = auxSetVolume(DevID, Cnvrt2Volume(LVol, RVol))
    If RetVal <> 0 Then Call DisplayErrorAndExit(RetVal)
  End If


End Sub

