Option Explicit

Global Const szgNul = ""

Type MhMuscleType
    'MhMuscleType definition
    'Copyright 1990-1993 MicroHelp, Inc.  ALL RIGHTS RESERVED.
    'Don't alter the number or order of these elements without
    'also modifying ALL assembler code!
    Shift                   As Integer
    Scan                    As Integer
    Ascii                   As Integer
    Lb                      As Integer
    Rb                      As Integer
    RbTerminateAscii        As Integer
    RbTerminateScan         As Integer
    CursorNormalStart       As Integer
    CursorNormalEnd         As Integer
    CursorInsertStart       As Integer
    CursorInsertEnd         As Integer
    MonitorSeg              As Integer
    MonitorType             As Integer
    MonitorRows             As Integer
    MonitorColumns          As Integer
    VideoMode               As Integer
    MouseInstalled          As Integer
    Verify                  As Integer
    CaseSens                As Integer
    TableSize               As Integer
    DontRestore             As Integer
    TopRow                  As Integer
    LeftColumn              As Integer
    BottomRow               As Integer
    RightColumn             As Integer
    BoxType                 As Integer
    BoxColor                As Long
    ShadowColor             As Long
    ShadowPosition          As Integer
    FillColor               As Long
    InverseColor            As Long
    HighlightColor          As Long
    NormalColor             As Long
    TitleColor              As Long
    WordWrapWidth           As Integer
    LastElement             As Integer
    TabStop                 As Integer
    SelectionWrap           As Integer
    DeselectColor           As Long
    DeselectInverseColor    As Long
    BarColor                As Long
    InverseBarColor         As Long
    KeyHighlightColor       As Long
    DescriptionRow          As Integer
    DescriptionColor        As Long
    MenuNumber              As Integer
    SelectionNumber         As Integer
    Range                   As Integer
    Month                   As Integer
    Day                     As Integer
    Year                    As Integer
    Startyear               As Integer
    DisplayMode             As Integer
    ForceRead               As Integer
    MemSeg                  As Integer
    MemOffset               As Integer
    MaxFiles                As Integer
    Fillcharacter           As Integer
    SoundOff                As Integer
    Gen1                    As Integer
    Gen2                    As Integer
    Gen3                    As Integer
    Gen4                    As Integer
    ShadowColumns           As Integer
    ShadowRows              As Integer
    SnowCheck               As Integer
    Drive                   As Integer
    FileAttributes          As Integer
    DosMajorVersion         As Integer
    DosMinorVersion         As Integer
    MouseStatus             As Integer
    ExitIfMouseOutside      As Integer
    HugeArrayNum            As Integer
    AutoTerminate           As Integer
    DefaultInsertState      As Integer
    GeneralCount            As Integer
    GenLong1                As Long
    GenLong2                As Long
    Bytes                   As Long
    CurrentPos              As Integer
    NoDestroy               As Integer
End Type 'MhMuscleType

Declare Function SAdd% Lib "Muscle.vbx" (Varbl$)
Declare Function SSeg% Lib "Muscle.vbx" (Varbl$)
Declare Function MhASCIIMid% Lib "Muscle.vbx" (A$, ByVal Position%)
Declare Function MhDirectoryExists% Lib "Muscle.vbx" (ByVal DirSpec$)
Declare Function MhDiskReadAbsolute% Lib "Muscle.vbx" (MuVar As MhMuscleType)
Declare Function MhEcode% Lib "Muscle.vbx" ()
Declare Function MhHexStrInt$ Lib "Muscle.vbx" (ByVal Fmt%, IntVal%)
Declare Function MhMuscleErrorText$ Lib "Muscle.vbx" (ByVal ErrorNum%)
Declare Sub MhECodeSet Lib "Muscle.vbx" (ByVal Valu%)

Dim MuVar As MhMuscleType

Private Sub MhErrorMessage (szSuffix As String)
    Dim fMhErrorCode As Integer
    Dim szMessage As String

    fMhErrorCode = MhEcode()
    If fMhErrorCode > 0 Then
        szMessage = MhMuscleErrorText$(fMhErrorCode)
    End If
    If Len(szMessage) = 0 Then
        szMessage = "Error # " + Str$(fMhErrorCode)
    End If
    MsgBox szMessage + szSuffix
End Sub

Function VolSerialNo (szDrive As String) As String

    Dim fMhErrorCode As Integer
    Dim iByte As Integer
    Dim iCounter As Integer
    Dim szBuffer As String
    Dim szByte As String
    Dim szTemp As String

    If Len(szDrive) Then
        szDrive = UCase$(Left$(szDrive, 1))
        If Not MhDirectoryExists(szDrive + ":\") Then
            MsgBox "Disk not found... try again!"
            Exit Function
        Else
            MuVar.Drive = Asc(szDrive) - 64     'Drive number A=1, etc
            MuVar.GenLong1 = 0                  'Boot sector
            MuVar.GeneralCount = 1              'Read 1 sector
            szBuffer = String$((2 * 512), 0)    'Create a buffer
            MuVar.MemSeg = SSeg(szBuffer)       'Point to it
            MuVar.MemOffset = SAdd(szBuffer)
            fMhErrorCode = MhDiskReadAbsolute(MuVar)
            If fMhErrorCode Then
                MhECodeSet (MhEcode() Mod 256)
                MhErrorMessage " while reading sectors"
                Exit Function
            Else
                'The volume serial number is 4 hex numbers long
                'The first hex number is in the last sector
                'So read the serial number in backwards
                szTemp = szgNul
                For iCounter = 43 To 40 Step -1
                    iByte = MhASCIIMid(szBuffer, iCounter)
                    szByte = Right$(MhHexStrInt(1, iByte), 2)
                    szTemp = szTemp + szByte
                    'Add the hyphen that DOS displays
                    If iCounter = 42 Then szTemp = szTemp & "-"
                Next
                VolSerialNo = szTemp
            End If
        End If
    End If
End Function

