{---------------------------------------------}
{ This program create DLL file                }
{ (custom control) for Visual Basic           }
{---------------------------------------------}
library Red_Green;
{$R REDGREEN.RES}
uses WinTypes,WinProcs,BPVBApi;
{---------------------------------------------}
{ Red_Green control data and structs          }
{---------------------------------------------}
type PRedGreen=^TRedGreen;
     TRedGreen=record
       Value:Bool;
     end;
{------------------------------}
{ Set new Item in Property     }
{------------------------------}
const Property_Value:TPROPINFO=(
      npszName:NPnt(PChar('Value'));
      fl:DT_Bool or PF_fGetData or PF_fSetData or PF_fSaveData or PF_fSetMsg;
      offsetData:Byte(0);
      infoData:0;
      dataDefault:0;
      npszEnumList:0;
      enumMax:0);
{------------------------------}
{ Set new all Property         }
{------------------------------}
      PropListRed_Green:array[0..10]of PPROPINFO =(
      PPROPINFO_STD_CTLNAME,
      PPROPINFO_STD_INDEX,
      PPROPINFO_STD_LEFT,
      PPROPINFO_STD_TOP,
      PPROPINFO_STD_WIDTH,
      PPROPINFO_STD_HEIGHT,
      PPROPINFO_STD_VISIBLE,
      PPROPINFO_STD_PARENT,
      PPROPINFO_STD_TAG,
      PPropInfo(@Property_Value),
      0);
{------------------------------------------------}
{ Event procedure parameter prototypes           }
{ Event list                                     }
{ Define the consecutive indicies for the events }
{------------------------------------------------}
      EventListRed_Green:array[0..1]of PEVENTINFO=(
      PEVENTINFO_STD_MOUSEMOVE,
      0);
{------------------------------}
{ Constans and Variables       }
{------------------------------}
var   NewBMP:hBitmap;
      Value:Bool;
{------------------------------}
{ Show Bitmap (RED or GREEN)   }
{------------------------------}
procedure PaintBitmap(Control:hCtl;Wnd:hWnd;NewDC:hDC);
const hbrOld:hBrush=0;
var hBR:hBrush;
    MemDC:hDC;
begin
  hBR:=GetBrushOrg(NewDC);                           {Get brush}
  if Bool(hbr) then hbrOld:=SelectObject(NewDC,hBR); {Select Object to Paint and Save old Brush}
  MemDC:=CreateCompatibleDC(NewDC);                  {Put Bitmap to Memory}
  SelectObject(MemDC,NewBMP);                        {Select Object to Paint}
  VBGetControlProperty(Control,9,@Value);
  if Value then BitBlt(NewDC,0,0,29,16,MemDC,0,0,SrcCopy)  {Show Bitmap (GREEN) in Window}
  else BitBlt(NewDC,0,0,29,16,MemDC,0,16,SrcCopy);   {Show Bitmap (RED) in Window}
  SelectObject(Newdc,hbrOld);                        {Restore old brush}
  DeleteDC(MemDC);                                   {Delete Bitmap from Memory}
end;
{-----------------------------------------------------}
{ Control Procedure                                   }
{ This routine is called for all VB and Windows Msgs. }
{-----------------------------------------------------}
function Red_GreenCtlProc(Control:HCtl;Wnd:HWnd;Msg,WParam:Word;LParam:LongInt):LongInt; export;
var TP:TPaintStruct;
begin
  case Msg of
    WM_PAINT:begin                         {If Paint Window}
      BeginPaint(Wnd,TP);                  {Begin Paint Bitmap}
      PaintBitmap(Control,Wnd,TP.hDC);     {Show the Bitmap}
      EndPaint(Wnd,TP);                    {End Paint Bitmap}
      Exit;                                {Exit from Message}
    end;
    VBM_SETPROPERTY:                       {If Check item from Property}
    begin
      if wParam=9 then InvalidateRect(Wnd,nil,False);
    end;
  end;
  Red_GreenCtlProc:=VBDefControlProc(Control,Wnd,Msg,WParam,LParam);
end;
{--------------------------------------------}
{ Model struct                               }
{ Define the control model                   }
{ (using the event and property structures). }
{--------------------------------------------}
const   modelRed_Green:TMODEL=(
	usVersion:VB_VERSION;		       { VB version used by control}
	fl:0;                                  { Bitfield structure}
	ctlproc:TFarProc(@Red_GreenCtlProc);   { The control procudere.}
	fsClassStyle:cs_VRedraw or cs_HRedraw; { Window class style}
	flWndStyle:0; 		               { Default window style}
	cbCtlExtra:sizeof(TRedGreen);          { # bytes alloc'd for HCTL structure}
	idBmpPalette:8000;		       { BITMAP id for tool palette}
	DefCtlName:NPnt(PChar('Red_Green'));   { Default control name prefix. Typecasts PChar to a NPnt.}
	ClassName:NPnt(PChar('Red_Green'));    { Visual Basic class name}
	ParentClassName:0;		       { Parent window class if subclassed}
	proplist:ofs(PropListRed_Green)	;      { Property list}
	eventlist:ofs(EventListRed_Green);     { Event list}
	nDefProp:0;		               { Index of default property}
	nDefEvent:0);		               { Index of default event}
{----------------------------------------------}
{ Register custom control.                     }
{ This routine is called by VB when the custom }
{ control DLL is loaded for use.               }
{----------------------------------------------}
function VBINITCC(usVersion: Word; fRunTime: Boolean): Boolean; export;
begin
  NewBMP:=LoadBitmap(hInstance,'RED_GREEN');{Load Bitmap from RESOURCE}
  VBINITCC:=VBRegisterModel(HInstance, modelRed_Green);
end;
{---------------------------------------------}
{ Export the Function and Procedures from DLL }
{---------------------------------------------}
exports
  VBINITCC         index 2,
  Red_GreenCtlProc index 3;
begin
end. {End of program}