{---------------------------------------------}
{ This program create DLL file                }
{ (custom control) for Visual Basic           }
{---------------------------------------------}
library BmpFilm;
{$R BMPFILM.RES}
uses WinTypes,WinProcs,BPVBAPI,Strings;
{---------------------------------------------}
{ BmpFilm control data and structs            }
{---------------------------------------------}
type PBmpFilm=^TBmpFilm;
     TBmpFilm=record
       Cols:Integer;     {Property 'Cols'}
       Rows:Integer;     {Property 'Rows'}
       Bitmap:HPic;      {Property 'Bitmap'}
       Interval:Integer; {Property 'Interval'}
     end;
{------------------------------}
{ Set new Item in Property     }
{------------------------------}
const Property_Cols:TPROPINFO=(
      npszName:NPnt(PChar('Cols'));
      fl:DT_Short or PF_fGetMsg or PF_fSetMsg or PF_fGetData or PF_fSetData or PF_fSaveData;
      offsetData:Byte(0);
      infoData:0;
      dataDefault:0;
      npszEnumList:0;
      enumMax:0);
      Property_Rows:TPROPINFO=(
      npszName:NPnt(PChar('Rows'));
      fl:DT_Short or PF_fGetMsg or PF_fSetMsg or PF_fGetData or PF_fSetData or PF_fSaveData;
      offsetData:Byte(2);
      infoData:0;
      dataDefault:0;
      npszEnumList:0;
      enumMax:0);
      {Property Item 'Bitmap'}
      Property_Bitmap:TPROPINFO=(
      npszName:NPnt(PChar('Bitmap'));
      fl:DT_Picture or PF_fGetData or PF_fSetData or PF_fSetMsg or PF_fSaveData;
      offsetData:Byte(4);
      infoData:0;
      dataDefault:0;
      npszEnumList:0;
      enumMax:0);
      {Property Item 'Interval'}
      Property_Interval:TPROPINFO=(
      npszName:NPnt(PChar('Interval'));
      fl:DT_Short or PF_fGetMsg or PF_fSetMsg or PF_fGetData or PF_fSetData or PF_fSaveData;
      offsetData:Byte(6);
      infoData:0;
      dataDefault:0;
      npszEnumList:0;
      enumMax:0);
{------------------------------}
{ Set all Property             }
{------------------------------}
      PropListBmpFilm:array[0..13]of PPROPINFO=(
      PPROPINFO_STD_CTLNAME,          {0}
      PPropInfo(@Property_Cols),      {1}
      PPropInfo(@Property_Rows),      {2}
      PPropInfo(@Property_Bitmap),    {3}
      PPropInfo(@Property_Interval),  {4}
      PPROPINFO_STD_ENABLED,
      PPROPINFO_STD_INDEX,
      PPROPINFO_STD_LEFT,
      PPROPINFO_STD_TOP,
      PPROPINFO_STD_WIDTH,
      PPROPINFO_STD_HEIGHT,
      PPROPINFO_STD_VISIBLE,
      PPROPINFO_STD_TAG,
      0);
{------------------------------------------------}
{ Event procedure parameter prototypes           }
{ Event list                                     }
{ Define the consecutive indicies for the events }
{------------------------------------------------}
      Event_Change:TEVENTINFO=(
      npszName:NPnt(PChar('Change'));
      cParms:0;
      cwParms:0;
      npParmTypes:0;
      npszParmProf:NPnt(PChar(''));
      fl:0);
      EventListBmpFilm:array[0..2]of PEVENTINFO=(
      PEventInfo(@Event_Change),
      PEVENTINFO_STD_MOUSEMOVE,
      0);
{------------------------------}
{ Constans and Variables       }
{------------------------------}
var Pic:TPic;         {Picture-Bitmap}
    Interval:Integer; {Interval}
    Col,Row,Cols,Rows:Integer;{Col,Row,Cols and Rows}
    Width,Height:Word;{Width and Height of Bitmap}
    MemDC:hDC;        {MemDc}
{------------------------------------------------}
{ Paint the BackGround from Bitmap               }
{------------------------------------------------}
procedure PaintBitmap(Wnd:hWnd;NewDC:hDC);
const hbrOld:hBrush=0;
var hBR:hBrush;
begin
    hBR:=GetBrushOrg(NewDC);                           {Get brush}
    if Bool(hbr) then hbrOld:=SelectObject(NewDC,hBR); {Select Object to Paint and Save old Brush}
    MemDC:=CreateCompatibleDC(NewDC);                  {Put Bitmap to Memory}
    SelectObject(MemDC,Pic.PicData.Bitmap);            {Select Object to Paint}
    BitBlt(NewDC,0,0,Width,Height,MemDC,Col*Width,Row*Height,SrcCopy);{Show Bitmap in Window}
    SelectObject(NewDC,hbrOld);                        {Restore old brush}
    DeleteDC(MemDC);                                   {Delete Bitmap from Memory}
end;
function BmpFilmCtlProc(Control:HCtl;Wnd:HWnd;Msg,WParam:Word;LParam:LongInt):LongInt; export;
var TP:TPaintStruct;
    BMP:TBitmap;
    Rec:TRect;
begin
  case Msg of
    WM_CREATE:
    begin
      Pic.PicData.Bitmap:=0;                     {Set bitmap}
      if VBGetMode=Mode_Design then
        begin
          Width:=32; Height:=32;                 {Set default Width and Height}
          VBSetControlProperty(Control,1,6);     {Set control property 'Cols - 100'}
          VBSetControlProperty(Control,2,3);     {Set control property 'Rows - 100'}
        end;
    end;
    WM_TIMER:                                    {Next Picture}
    begin
      if Col=Cols-1 then
        begin
          Col:=0;                          {Set first Col}
          Row:=Row+1;                      {Inc Row}
        end
      else Col:=Col+1;                     {Inc Cols}
      if Row=Rows then
        begin
          Row:=0;                          {Set first Row}
          Col:=0;                          {Set first Col}
        end;
      InvalidateRect(Wnd,nil,False);       {Paint New Bitmap}
    end;
    WM_PAINT:
    begin
      SetWindowPos(Wnd,0,0,0,Width,Height,Swp_NoMove);{Set just Window Size}
      BeginPaint(Wnd,TP);                  {Begin Paint Bitmap}
      PaintBitmap(Wnd,TP.hDC);             {Show the Bitmap}
      VBFireEvent(Control,0,nil);          {Fire Event Change}
      EndPaint(Wnd,TP);                    {End Paint Bitmap}
      Exit;                                {Exit from Message}
    end;
    VBM_SETPROPERTY:                       {If Check item from Property}
    begin
      case wParam of
        1,2:InvalidateRect(Wnd,nil,True);  {Paint Bitmap again}
        3:                                 {'Bitmap'}
        begin
          VBGetPic(HPic(LParam),@Pic);
          if Pic.picType=PICTYPE_BITMAP then {If Bitmap then}
            begin
              GetObject(Pic.PicData.Bitmap,sizeof(TBitMap),PChar(@Bmp)); {Get information of new BITMAP}
              VBGetControlProperty(Control,1,@Cols);{Get Cols Property}
              VBGetControlProperty(Control,2,@Rows);{Get Rows Property}
              Width:=Bmp.bmWidth div Cols;  {Get width}
              Height:=Bmp.bmHeight div Rows;{Get height}
              Col:=0;                       {Set first Col}
              Row:=0;                       {Set first Row}
              InvalidateRect(Wnd,nil,True); {Paint Bitmap}
            end
          else
            begin                          {Else exit on Error}
              BmpFilmCtlProc:=380;         {'Invalid Property Value'}
	      Exit;
            end;
        end;
        4:                                 {'Interval' Property}
        begin
          VBGetControlProperty(Control,4,@Interval);{Get Interval Property}
          if VBGetMode=Mode_Run then SetTimer(Wnd,100,Interval,nil);
        end;
      end;
    end;
  end;
  BmpFilmCtlProc:=VBDefControlProc(Control,Wnd,Msg,WParam,LParam);
  if Msg=WM_DESTROY then begin KillTimer(Wnd,100); ReleaseDC(Wnd,MemDC); end;
end;
{--------------------------------------------}
{ Model struct                               }
{ Define the control model                   }
{ (using the event and property structures). }
{--------------------------------------------}
const   Model_BmpFilm:TMODEL=(
	usVersion:VB_VERSION;		       { VB version used by control}
	fl:0;                                  { Bitfield structure}
	ctlproc:TFarProc(@BmpFilmCtlProc);     { The control procudere.}
	fsClassStyle:cs_VRedraw or cs_HRedraw; { Window class style}
	flWndStyle:0; 		               { Default window style}
	cbCtlExtra:sizeof(TBmpFilm);           { # bytes alloc'd for HCTL structure}
	idBmpPalette:8000;		       { BITMAP id for tool palette}
	DefCtlName:NPnt(PChar('BmpFilm'));     { Default control name prefix. Typecasts PChar to a NPnt.}
	ClassName:NPnt(PChar('BmpFilm'));      { Visual Basic class name}
	ParentClassName:0;		       { Parent window class if subclassed}
	proplist:ofs(PropListBmpFilm);         { Property list}
	eventlist:ofs(EventListBmpFilm);       { Event list}
	nDefProp:0;		               { Index of default property}
	nDefEvent:0);		               { Index of default event}
{----------------------------------------------}
{ Register custom control.                     }
{ This routine is called by VB when the custom }
{ control DLL is loaded for use.               }
{----------------------------------------------}
function VBINITCC(usVersion: Word; fRunTime: Boolean): Boolean; export;
begin
  VBINITCC:=VBRegisterModel(hInstance,Model_BmpFilm);
end;
{---------------------------------------------}
{ Export the Function and Procedures from DLL }
{---------------------------------------------}
exports
  VBINITCC         index 2,
  BmpFilmCtlProc   index 3;
begin
end. {End of program}