
      /*  Custom groupbox control for Visual Basic  May 1992 by Mark Gamber  */


#include "windows.h"
#include "commdlg.h"
#include "vbapi.h"

                                                                                                        /*  Function prototypes  */

LONG _export FAR PASCAL GroupWndProc( HCTL, HWND, WORD, WORD, LONG );
void PaintButton( HCTL, HWND );
BOOL _export FAR PASCAL SetColor( HWND, WORD, WORD, LONG );
LONG _export FAR PASCAL PopupWndProc( HWND, WORD, WORD, LONG );


typedef struct {                                                                      /*  Control data structure passed by HCTL  */
   HSZ WaveFile;
   int Width, Height, WaveOn;
   int Raised, WaveStyle;
   int Shadow, Align, WaveLoop;
   long ShadowColor;
   long Hilite;
   long Lolite;
   HFONT hFont;
   HSZ hszCaption;
} GPSTRUCT;

#define GPDEREF(hctl) ((GPSTRUCT far *)VBDerefControl(hctl))                  /*  Use this macro to lock HCTL in window process  */

char GPAlignTypes[] = "0 - Left\0"\
                    "1 - Center\0"\
                    "2 - Right\0"\
                    "\0";

char WaveStyles[] = "0 - Synchronous\0"\
                    "1 - Asynchronous\0"\
                    "";

char *CLASSPOPUP = "CPopup";

PROPINFO Prop_Width =
{
   "Width",
   DT_SHORT | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   0, 0, NULL, 0
};

PROPINFO Prop_Height =
{
   "Height",
   DT_SHORT | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   2, 0, NULL, 0
};

PROPINFO Prop_Raised =
{
   "Raised",
   DT_BOOL | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   4, 0, NULL, 0
};

PROPINFO Prop_Shadow =
{
   "TextShadow",
   DT_BOOL | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   6, 0, NULL, 0
};

PROPINFO Prop_ShadowColor =
{
   "TextShadowCol",
   DT_COLOR | PF_fSetMsg | PF_fGetMsg | PF_fSaveData | PF_fEditable,
   8, 0, NULL, 0
};

PROPINFO Prop_Align =
{
   "Alignment",
   DT_ENUM | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   0, 0, 0, GPAlignTypes, 2
};

PROPINFO Prop_Hilite =
{
   "HiliteColor",
   DT_COLOR | PF_fSetMsg | PF_fGetMsg | PF_fSaveData | PF_fEditable,
   0, 0, NULL, 0
};

PROPINFO Prop_Lolite =
{
   "ShadowColor",
   DT_COLOR | PF_fSetMsg | PF_fGetMsg | PF_fSaveData | PF_fEditable,
   0, 0, NULL, 0
};

PROPINFO Prop_WaveFile =
{
   "WaveFile",
   DT_HSZ | PF_fSetData | PF_fGetData | PF_fSaveData | PF_fEditable,
   0, 0, NULL, 0
};

PROPINFO Prop_WaveStyle =
{
   "WaveStyle",
   DT_ENUM | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   0, 0, 0, WaveStyles, 1
};

PROPINFO Prop_WaveLoop =
{
   "WaveLoop",
   DT_BOOL | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   0, 0, NULL, 0
};

PROPINFO Prop_WaveEnabled =
{
   "WaveEnabled",
   DT_BOOL | PF_fSetMsg | PF_fGetMsg | PF_fSaveData,
   0, 0, NULL, 0
};

PROPINFO Prop_Version =
{
   "Version",
   DT_SHORT | PF_fGetMsg,
   0, 0, NULL, 0
};

#define VBGP_BASE        12
#define VBGP_HEIGHT      (VBGP_BASE)
#define VBGP_WIDTH       (VBGP_BASE+1)
#define VBGP_RAISED      (VBGP_BASE+2)
#define VBGP_SHADOW      (VBGP_BASE+3)
#define VBGP_SHCOLOR     (VBGP_BASE+4)
#define VBGP_ALIGN       (VBGP_BASE+5)
#define VBGP_HILITE      (VBGP_BASE+6)
#define VBGP_LOLITE      (VBGP_BASE+7)
#define VBGP_WAVEFILE    (VBGP_BASE+8)
#define VBGP_WAVESTYLE   (VBGP_BASE+9)
#define VBGP_WAVELOOP    (VBGP_BASE+10)
#define VBGP_WAVEENABLED (VBGP_BASE+11)
#define VBGP_VERSION     (VBGP_BASE+12)

PPROPINFO proplistGP[] =
{
   PPROPINFO_STD_CAPTION,
   PPROPINFO_STD_CTLNAME,
   PPROPINFO_STD_BACKCOLOR,
   PPROPINFO_STD_FORECOLOR,
   PPROPINFO_STD_LEFT,
   PPROPINFO_STD_TOP,
   PPROPINFO_STD_FONTNAME,
   PPROPINFO_STD_FONTBOLD,
   PPROPINFO_STD_FONTITALIC,
   PPROPINFO_STD_FONTSTRIKE,
   PPROPINFO_STD_FONTUNDER,
   PPROPINFO_STD_FONTSIZE,
   &Prop_Height,
   &Prop_Width,
   &Prop_Raised,
   &Prop_Shadow,
   &Prop_ShadowColor,
   &Prop_Align,
   &Prop_Hilite,
   &Prop_Lolite,
   &Prop_WaveFile,
   &Prop_WaveStyle,
   &Prop_WaveLoop,
   &Prop_WaveEnabled,
   &Prop_Version,
   NULL
};

EVENTINFO Event_Clicked =
{
   "Clicked", 0, 0,
   NULL, NULL
};

PEVENTINFO eventlistGP[] =
{
   &Event_Clicked,
   NULL
};


MODEL modelGP =
{
   VB_VERSION,
   MODEL_fChildrenOk | MODEL_fMnemonic,
   (PCTLPROC)GroupWndProc,
   NULL,
   WS_CHILD | WS_CLIPCHILDREN,
   sizeof(GPSTRUCT),
   8000,
   "GrpBox",
   "GrpBox",
   NULL,
   proplistGP,
   eventlistGP
};


HANDLE hmodDLL;
HCTL ColorHctl;
HWND ColorHwnd;
WORD ColorID;
char MMSystem[] = "MMSYSTEM.DLL";


BOOL FAR PASCAL LibMain( HANDLE hmod, HANDLE segDS, USHORT cbHeapSize )
{
   hmodDLL = hmod;

   UnlockData( 0 );
   return( TRUE );
}


BOOL _export FAR PASCAL VBINITCC( USHORT usVersion, BOOL fRunTime )
{
   if( ! fRunTime )
   {
      WNDCLASS wc;

      wc.style = 0;
      wc.lpfnWndProc = (WNDPROC)PopupWndProc;
      wc.cbClsExtra = 0;
      wc.cbWndExtra = 0;
      wc.hInstance = hmodDLL;
      wc.hIcon = NULL;
      wc.hCursor = NULL;
      wc.hbrBackground = NULL;
      wc.lpszMenuName = NULL;
      wc.lpszClassName = CLASSPOPUP;

      if( ! RegisterClass( &wc ) )
         return( FALSE );
   }
   return( VBRegisterModel( hmodDLL, &modelGP ) );
}


LONG _export FAR PASCAL GroupWndProc( HCTL hCtl, HWND hWnd, WORD msg, WORD wParam, LONG lParam )
{
   switch( msg )
   {
      case WM_CREATE:
      {
         GPSTRUCT far *Gp = GPDEREF( hCtl );

         Gp->Width = 50;
         Gp->Height = 30;
         Gp->Raised = 1;
         Gp->Shadow = 0;
         Gp->ShadowColor = 0L;
         Gp->hszCaption = NULL;
         Gp->Align = 0;
         Gp->Hilite = RGB( 255, 255, 255 );
         Gp->Lolite = RGB( 128, 128, 128 );
         break;
      }

      case WM_SETFONT:
      {
         GPSTRUCT far *Gp = GPDEREF( hCtl );

         Gp->hFont = wParam;
         PaintButton( hCtl, hWnd );
         break;
      }

      case WM_GETFONT:
      {
         GPSTRUCT far *Gp = GPDEREF( hCtl );

         return( Gp->hFont );
      }

      case WM_SETTEXT:
      {
         GPSTRUCT far *Gp = GPDEREF( hCtl );
         HSZ hsz;

         if( Gp->hszCaption )
            VBDestroyHsz( Gp->hszCaption );

         hsz = VBCreateHsz( (_segment)hCtl, (LPSTR)lParam );
         Gp = GPDEREF( hCtl );

         Gp->hszCaption = hsz;
         PaintButton( hCtl, hWnd );
         return( NULL );
      }

      case WM_GETTEXT:
      {
         GPSTRUCT far *Gp = GPDEREF( hCtl );
         LPSTR lpStr;
         WORD cch;

         if( Gp->hszCaption == NULL )
         {
            *(LPSTR)lParam = 0L;
            wParam = 1;
         }
         else
         {
            lpStr = VBDerefHsz( Gp->hszCaption );
            cch = lstrlen( lpStr ) + 1;
            if( wParam > cch )
               wParam = cch;

            lstrcpy( (LPSTR)lParam, lpStr );
         }
         return( (LONG)( wParam - 1 ) );
      }

      case WM_GETTEXTLENGTH:
      {
         GPSTRUCT far *Gp = GPDEREF( hCtl );

         if( Gp->hszCaption == NULL )
            return( 0L );

         return( lstrlen( VBDerefHsz( Gp->hszCaption ) ) );
      }

      case WM_SIZE:
      {
         GPSTRUCT far *Gp = GPDEREF( hCtl );

         Gp->Width = LOWORD( lParam );
         Gp->Height = HIWORD( lParam );
         PaintButton( hCtl, hWnd );
         break;
      }

      case WM_PAINT:
      {
         PAINTSTRUCT Ps;

         BeginPaint( hWnd, &Ps );
         PaintButton( hCtl, hWnd );
         EndPaint( hWnd, &Ps );
         break;
      }

      case WM_LBUTTONDBLCLK:
      case WM_LBUTTONDOWN:
      {
         GPSTRUCT far *Gp = GPDEREF( hCtl );
         WORD WinVer;
         LPSTR lpStr;
         HANDLE hMM;
         FARPROC lpfnSndPlaySound;

         if( Gp->WaveOn )
         {
            WinVer = GetVersion();
            if( HIBYTE( WinVer ) >= 10 && LOBYTE( WinVer ) >= 3 )
            {
               lpStr = VBDerefHsz( Gp->WaveFile );
               if( lstrlen( lpStr ) )
               {
                  hMM = LoadLibrary( MMSystem );
                  if( hMM )
                  {
                     lpfnSndPlaySound = GetProcAddress( hMM, (LPSTR)(DWORD)2 );

                     if( lpfnSndPlaySound )
                        ( *lpfnSndPlaySound )( (LPSTR)lpStr,
                                               (int)8 * ( Gp->WaveLoop != 0 ) );

                     FreeLibrary( hMM );
                  }
               }
            }
         }
         VBFireEvent( hCtl, 0, NULL );
         break;
      }

      case VBM_GETPROPERTY:
      {
         GPSTRUCT far *Gp = GPDEREF( hCtl );

         switch( wParam )
         {
            case VBGP_HEIGHT:
               *(WORD far *)lParam = Gp->Height;
               return( FALSE );

            case VBGP_WIDTH:
               *(WORD far *)lParam = Gp->Width;
               return( FALSE );

            case VBGP_RAISED:
               *(WORD far *)lParam = Gp->Raised;
               return( FALSE );

            case VBGP_SHADOW:
               *(WORD far *)lParam = Gp->Shadow;
               return( FALSE );

            case VBGP_SHCOLOR:
               *(LONG FAR *)lParam = Gp->ShadowColor;
               return( FALSE );

            case VBGP_ALIGN:
               *(WORD far *)lParam = Gp->Align;
               return( FALSE );

            case VBGP_HILITE:
               *(LONG far *)lParam = Gp->Hilite;
               return( FALSE );

            case VBGP_LOLITE:
               *(LONG far *)lParam = Gp->Lolite;
               return( FALSE );

            case VBGP_WAVESTYLE:
               *(LONG far *)lParam = Gp->WaveStyle;
               return( FALSE );

            case VBGP_WAVELOOP:
               *(WORD far *)lParam = Gp->WaveLoop;
               return( FALSE );

            case VBGP_WAVEENABLED:
               *(WORD far *)lParam = Gp->WaveOn;
               return( FALSE );

            case VBGP_VERSION:
               *(WORD far *)lParam = 100;
               return( FALSE );
         }
         break;
      }

      case VBM_SETPROPERTY:
      {
         GPSTRUCT far *Gp = GPDEREF( hCtl );

         switch( wParam )
         {
            case VBGP_HEIGHT:
               if( Gp->Height != LOWORD( lParam ) )
               {
                  Gp->Height = LOWORD( lParam );
                  PaintButton( hCtl, hWnd );
               }
               return( FALSE );

            case VBGP_WIDTH:
               if( Gp->Width != LOWORD( lParam ) )
               {
                  Gp->Width = LOWORD( lParam );
                  PaintButton( hCtl, hWnd );
               }
               return( FALSE );

            case VBGP_RAISED:
               if( LOWORD( lParam ) != Gp->Raised )
               {
                  Gp->Raised = LOWORD( lParam );
                  PaintButton( hCtl, hWnd );
               }
               return( FALSE );

            case VBGP_SHADOW:
               if( LOWORD( lParam ) != Gp->Shadow )
               {
                  Gp->Shadow = LOWORD( lParam );
                  PaintButton( hCtl, hWnd );
               }
               return( FALSE );

            case VBGP_SHCOLOR:
               if( lParam != Gp->ShadowColor )
               {
                  Gp->ShadowColor = lParam;
                  PaintButton( hCtl, hWnd );
               }
               return( FALSE );

            case VBGP_ALIGN:
               Gp->Align = LOWORD( lParam );
               PaintButton( hCtl, hWnd );
               return( FALSE );

            case VBGP_HILITE:
               Gp->Hilite = lParam;
               PaintButton( hCtl, hWnd );
               return( FALSE );

            case VBGP_LOLITE:
               Gp->Lolite = lParam;
               PaintButton( hCtl, hWnd );
               return( FALSE );

            case VBGP_WAVESTYLE:
               Gp->WaveStyle = LOWORD( lParam );
               return( FALSE );

            case VBGP_WAVELOOP:
               Gp->WaveLoop = LOWORD( lParam );
               return( FALSE );

            case VBGP_WAVEENABLED:
               Gp->WaveOn = LOWORD( lParam );
               return( FALSE );
         }
         break;
      }

      case VBM_INITPROPPOPUP:
      {
         GPSTRUCT far *Gp = GPDEREF( hCtl );

         switch( wParam )
         {
            case 2:
            case 3:
            case VBGP_LOLITE:
            case VBGP_HILITE:
            case VBGP_SHCOLOR:
            case VBGP_WAVEFILE:
            {
               FARPROC DlgProc;

               if( VBGetMode() == MODE_DESIGN )
               {
                  ColorHctl = hCtl;
                  ColorID = wParam;
                  ColorHwnd = hWnd;

                  return( CreateWindow( CLASSPOPUP, NULL, WS_POPUP, 0, 0, 0, 0,
                                        NULL, NULL, hmodDLL, NULL ) );
               }
               return( NULL );
            }
         }
         break;
      }
   }
   return( VBDefControlProc( hCtl, hWnd, msg, wParam, lParam ) );
}



LONG _export FAR PASCAL PopupWndProc( HWND hWnd, WORD msg, WORD wParam, LONG lParam )
{
   switch( msg )
   {
      case WM_SHOWWINDOW:
         if( wParam )
         {
            PostMessage( hWnd, WM_USER, 0, 0L );
            return( 0L );
         }
         break;

      case WM_USER:
         if( ColorID == VBGP_WAVEFILE )
         {
            GPSTRUCT far *Gp = GPDEREF( ColorHctl );
            OPENFILENAME Of;
            HSZ hsz;
            char str[ 128 ];

            lstrcpy( str, "*.WAV" );
            Of.lStructSize = sizeof(OPENFILENAME);
            Of.hwndOwner = hWnd;
            Of.hInstance = (HANDLE)NULL;
            Of.lpstrFilter = "Wave Files  (*.WAV)\0*.WAV\0All Files   (*.*)\0*.*\0\0";
            Of.lpstrCustomFilter = (LPSTR)NULL;
            Of.nMaxCustFilter = (DWORD)0;
            Of.nFilterIndex = (DWORD)0;
            Of.lpstrFile = str;
            Of.nMaxFile = (DWORD)128;
            Of.lpstrFileTitle = (LPSTR)NULL;
            Of.nMaxFileTitle = (DWORD)NULL;
            Of.lpstrInitialDir = (LPSTR)NULL;
            Of.lpstrTitle = "Attach Wave File...";
            Of.Flags = (DWORD)NULL;
            Of.nFileOffset = 0;
            Of.nFileExtension = 0;
            Of.lpstrDefExt = (LPSTR)NULL;
            Of.lCustData = NULL;
            Of.lpfnHook = NULL;
            Of.lpTemplateName = (LPSTR)NULL;

            if( GetOpenFileName( &Of ) )
               VBSetControlProperty( ColorHctl, VBGP_WAVEFILE, (LONG)(LPSTR)str );
            return( 0L );
         }

         VBDialogBoxParam( hmodDLL, "SETCOLOR", MakeProcInstance( SetColor, hmodDLL ), 0L );
         return( 0L );
   }
   return( DefWindowProc( hWnd, msg, wParam, lParam ) );
}



BOOL _export FAR PASCAL SetColor( HWND hDlg, WORD msg, WORD wParam, LONG lParam )
{
   switch( msg )
   {
      case WM_INITDIALOG:
      {
         GPSTRUCT far *Gp = GPDEREF( ColorHctl );
         WORD Red, Green, Blue;
         DWORD dwColor;
         char str[ 6 ];

         VBGetControlProperty( ColorHctl, ColorID, &dwColor );                                /*  Get current color of property  */

         if( dwColor & 0x80000000 )                                         /*  If it's a system color offset, get system color  */
            dwColor = GetSysColor( LOWORD( lParam ) + 1 );

         Red = GetRValue( dwColor );                                                            /*  Break color into components  */
         Green = GetGValue( dwColor );
         Blue = GetBValue( dwColor );

         SetProp( hDlg, MAKEINTRESOURCE( 1 ), CreateSolidBrush( RGB ( Red, Green, Blue ) ) );            /*  Save created brush  */

         SetScrollRange( GetDlgItem( hDlg, 100 ), SB_CTL, 0, 255, TRUE );                        /*  Initialize scrollbar sizes  */
         SetScrollRange( GetDlgItem( hDlg, 102 ), SB_CTL, 0, 255, TRUE );
         SetScrollRange( GetDlgItem( hDlg, 104 ), SB_CTL, 0, 255, TRUE );

         SetScrollPos( GetDlgItem( hDlg, 100 ), SB_CTL, Red, TRUE );                          /*  Initialze scrollbar positions  */
         SetScrollPos( GetDlgItem( hDlg, 102 ), SB_CTL, Green, TRUE );
         SetScrollPos( GetDlgItem( hDlg, 104 ), SB_CTL, Blue, TRUE );

         wsprintf( str, "%d", Red );
         SetDlgItemText( hDlg, 101, str );                                       /*  Change editbox text to reflect color comp.  */
         wsprintf( str, "%d", Green );
         SetDlgItemText( hDlg, 103, str );
         wsprintf( str, "%d", Blue );
         SetDlgItemText( hDlg, 105, str );
         return( TRUE );
      }

      case WM_DRAWITEM:
      {
         LPDRAWITEMSTRUCT lpDs = (LPDRAWITEMSTRUCT)lParam;

         if( lpDs->CtlID == 106 )
         {
            RECT Rect;
            HDC hDC;

            hDC = GetDC( GetDlgItem( hDlg, lpDs->CtlID ) );
            SelectObject( hDC, GetProp( hDlg, MAKEINTRESOURCE( 1 ) ) );
            GetWindowRect( GetDlgItem( hDlg, lpDs->CtlID ), &Rect );
            Rectangle( hDC, 0, 0, Rect.right - Rect.left, Rect.bottom - Rect.top );
            SelectObject( lpDs->hDC, GetStockObject( NULL_BRUSH ) );
         }
         break;
      }

      case WM_HSCROLL:
      {
         DWORD dwColor;
         int Pos;
         char str[ 10 ];
         int junk;

         Pos = GetScrollPos( HIWORD( lParam ), SB_CTL );

         switch( wParam )
         {
            case SB_BOTTOM:
               SetScrollPos( HIWORD( lParam ), SB_CTL, 0, TRUE );
               break;

            case SB_TOP:
               SetScrollPos( HIWORD( lParam ), SB_CTL, 255, TRUE );
               break;

            case SB_THUMBPOSITION:
            case SB_THUMBTRACK:
               SetScrollPos( HIWORD( lParam ), SB_CTL, LOWORD( lParam ), TRUE );
               break;

            case SB_PAGEDOWN:
               if( Pos > 240 )
                  SetScrollPos( HIWORD( lParam ), SB_CTL, 255, TRUE );
               else
                  SetScrollPos( HIWORD( lParam ), SB_CTL, Pos + 16, TRUE );
               break;

            case SB_PAGEUP:
               if( Pos < 16 )
                  SetScrollPos( HIWORD( lParam ), SB_CTL, 0, TRUE );
               else
                  SetScrollPos( HIWORD( lParam ), SB_CTL, Pos - 16, TRUE );
               break;

            case SB_LINEDOWN:
               if( Pos < 255 )
                  SetScrollPos( HIWORD( lParam ), SB_CTL, Pos + 1, TRUE );
               break;

            case SB_LINEUP:
               if( Pos > 0 )
                  SetScrollPos( HIWORD( lParam ), SB_CTL, Pos - 1, TRUE );
               break;
         }

         wsprintf( str, "%d", GetScrollPos( GetDlgItem( hDlg, 100 ), SB_CTL ) );
         SetDlgItemText( hDlg, 101, str );

         wsprintf( str, "%d", GetScrollPos( GetDlgItem( hDlg, 102 ), SB_CTL ) );
         SetDlgItemText( hDlg, 103, str );

         wsprintf( str, "%d", GetScrollPos( GetDlgItem( hDlg, 104 ), SB_CTL ) );
         SetDlgItemText( hDlg, 105, str );

         dwColor = RGB( GetDlgItemInt( hDlg, 101, &junk, TRUE ),
                        GetDlgItemInt( hDlg, 103, &junk, TRUE ),
                        GetDlgItemInt( hDlg, 105, &junk, TRUE ) );

         DeleteObject( GetProp( hDlg, MAKEINTRESOURCE( 1 ) ) );
         SetProp( hDlg, MAKEINTRESOURCE( 1 ), CreateSolidBrush( dwColor ) );

         InvalidateRect( GetDlgItem( hDlg, 106 ), NULL, FALSE );
         break;
      }

      case WM_COMMAND:
         if( HIWORD( lParam ) == EN_KILLFOCUS )
         {
            DWORD dwColor;
            int junk;

            dwColor = RGB( GetDlgItemInt( hDlg, 101, &junk, TRUE ),
                           GetDlgItemInt( hDlg, 103, &junk, TRUE ),
                           GetDlgItemInt( hDlg, 105, &junk, TRUE ) );

            DeleteObject( GetProp( hDlg, MAKEINTRESOURCE( 1 ) ) );
            SetProp( hDlg, MAKEINTRESOURCE( 1 ), CreateSolidBrush( dwColor ) );

            InvalidateRect( GetDlgItem( hDlg, 106 ), NULL, FALSE );
            break;
         }

         if( wParam == IDOK || wParam == IDCANCEL )
         {
            if( wParam == IDOK )
            {
               int junk;
               DWORD dwColor;
               GPSTRUCT far *Gp = GPDEREF( ColorHctl );

               dwColor = RGB( GetDlgItemInt( hDlg, 101, &junk, TRUE ),
                              GetDlgItemInt( hDlg, 103, &junk, TRUE ),
                              GetDlgItemInt( hDlg, 105, &junk, TRUE ) );

               VBSetControlProperty( ColorHctl, ColorID, dwColor );
            }

            DeleteObject( GetProp( hDlg, MAKEINTRESOURCE( 1 ) ) );
            RemoveProp( hDlg, MAKEINTRESOURCE( 1 ) );

            if( wParam == IDOK )
               InvalidateRect( ColorHwnd, NULL, TRUE );

            EndDialog( hDlg, TRUE );
            return( TRUE );
         }
         break;
   }
   return( FALSE );
}


void PaintButton( HCTL hCtl, HWND hWnd )
{
   TEXTMETRIC Tm;
   GPSTRUCT far *Gp = GPDEREF( hCtl );
   HDC hDC;
   int Yoff, Align, Len;
   HPEN hWhite;
   HPEN hGray;
   RECT Rect;
   DWORD OldColor;
   LPSTR lpStr;

   hDC = GetDC( hWnd );
   SelectObject( hDC, Gp->hFont );
   GetTextMetrics( hDC, &Tm );

   SelectObject( hDC, SendMessage( GetParent( hWnd ), WM_CTLCOLOR, hDC, MAKELONG( hWnd, 0 ) ) );
   SelectObject( hDC, GetStockObject( NULL_PEN ) );
   Rectangle( hDC, 0, 0, Gp->Width + 1, Gp->Height + 1 );

   hWhite = CreatePen( PS_SOLID, 1, Gp->Hilite );
   hGray = CreatePen( PS_SOLID, 1, Gp->Lolite );

   Yoff = Tm.tmHeight / 2;

   if( Gp->Raised )
      SelectObject( hDC, hWhite );
   else
      SelectObject( hDC, hGray );

   MoveTo( hDC, Gp->Width, Yoff );
   LineTo( hDC, 0, Yoff );
   LineTo( hDC, 0, Gp->Height );

   MoveTo( hDC, 2, Gp->Height - 2 );
   LineTo( hDC, Gp->Width - 2, Gp->Height - 2 );
   LineTo( hDC, Gp->Width - 2, Yoff + 1 );

   if( Gp->Raised )
      SelectObject( hDC, hGray );
   else
      SelectObject( hDC, hWhite );

   MoveTo( hDC, Gp->Width, Yoff + 1 );
   LineTo( hDC, 1, Yoff + 1 );
   LineTo( hDC, 1, Gp->Height - 1 );

   MoveTo( hDC, 1, Gp->Height - 1 );
   LineTo( hDC, Gp->Width - 1, Gp->Height - 1 );
   LineTo( hDC, Gp->Width - 1, Yoff + 1 );

   if( Gp->hszCaption )
   {
      lpStr = VBDerefHsz( Gp->hszCaption );
      Len = (int)GetTextExtent( hDC, lpStr, lstrlen( lpStr ) );

      if( Gp->Align == 0 )
         Align = 0;

      if( Gp->Align == 1 )
         Align = ( ( Gp->Width - Len ) / 2 ) - 12;

      if( Gp->Align == 2 )
         Align = Gp->Width - Len - 24;

      if( lstrlen( lpStr ) );
      {
         if( Gp->Shadow )
         {
            OldColor = GetTextColor( hDC );

            SetBkMode( hDC, OPAQUE );
            SetTextColor( hDC, Gp->ShadowColor );
            Rect.top = 0;
            Rect.left = 12 + Align;
            Rect.bottom = Tm.tmHeight;
            Rect.right = 24 + Len + Align;
            DrawText( hDC, lpStr, lstrlen( lpStr ), &Rect, DT_LEFT | DT_TOP );

            SetTextColor( hDC, OldColor );
         }
         if( Gp->Shadow )
            SetBkMode( hDC, TRANSPARENT );
         else
            SetBkMode( hDC, OPAQUE );

         Rect.top = 0 + ( Gp->Shadow != 0 );
         Rect.bottom = Tm.tmHeight + ( Gp->Shadow != 0 );
         Rect.left = 12 + ( Gp->Shadow != 0 ) + Align;
         Rect.right = 24 + (WORD)GetTextExtent( hDC, lpStr, lstrlen( lpStr ) ) + ( Gp->Shadow != 0 ) + Align;

         DrawText( hDC, lpStr, lstrlen( lpStr ), &Rect, DT_LEFT | DT_TOP );
      }
   }

   ReleaseDC( hWnd, hDC );
   DeleteObject( hWhite );
   DeleteObject( hGray );
}

