#include "windows.h"
#include <stdio.h>
#include <string.h>

#define MAXBUFF  512

HINSTANCE hLibInst;
char sztmp1[MAXBUFF];
char sztmp2[MAXBUFF]; 

typedef struct {
	unsigned short	year;
	unsigned char	month;
	unsigned char	day;
	unsigned char	hour;
	unsigned char	minute;
	unsigned char	second;
} DATETIME;

void DateTimeParse(double dt, DATETIME *pdtparsed);


BOOL FAR PASCAL LibMain(HINSTANCE hInstance, WORD wDataSeg, WORD cbHeap, DWORD ignore)
{

    hLibInst = hInstance;

    return TRUE;
}


unsigned long __export CALLBACK CRTfopen(LPSTR filename, LPSTR mode)
{
    return (unsigned long)fopen(filename, mode);
}

int __export CALLBACK CRTfclose(FILE *stream)
{
    return fclose(stream);
}

int __export CALLBACK CRTfputs(LPSTR string, FILE *stream)
{
    return fputs(string, stream);
}

int __export CALLBACK CRTfgets(LPSTR string, int n, FILE *stream)
{
    if (fgets(string, n, stream) == NULL)
        return 0;
    else
        return 1;
}

int __export CALLBACK CRT_fcloseall(void)
{
    return _fcloseall();
}

int __export CALLBACK CRTfflush(FILE *stream)
{
    return fflush(stream);
}

int __export CALLBACK CRT_flushall(void)
{
    return _flushall();
}

unsigned long __export CALLBACK CRTtmpfile(void)
{
    return (unsigned long)tmpfile();
}

int __export CALLBACK CRTtmpnam(LPSTR string)
{
    if (tmpnam(string) == NULL)
        return 0;
    else
        return 1;
}

int __export CALLBACK CRT_rmtmp(void)
{
    return _rmtmp();
}

int __export CALLBACK CRTfeof(FILE *stream)
{
    return feof(stream);
}

int __export CALLBACK CRTferror(FILE *stream)
{
    return ferror(stream);
}

void __export CALLBACK CRTclearerr(FILE *stream)
{
    clearerr(stream);
}

int __export CALLBACK CRTfgetc(FILE *stream)
{
    return fgetc(stream);
}

int __export CALLBACK CRTfputc(int c, FILE *stream)
{
    return fputc(c, stream);
}

UINT __export CALLBACK CRTfread(LPSTR buffer, UINT size, UINT count, FILE *stream)
{
    return fread(buffer, size, count, stream);
}

int __export CALLBACK CRTfseek(FILE *stream, long offset, int orign)
{
    return fseek(stream, offset, orign);
}

long __export CALLBACK CRTftell(FILE *stream)
{
    return ftell(stream);
}

UINT __export CALLBACK CRTfwrite(LPSTR buffer, UINT size, UINT count, FILE *stream)
{
    return fwrite(buffer, size, count, stream);
}

void __export CALLBACK CRTrewind(FILE *stream)
{
    rewind(stream);
}

void __export CALLBACK DTParse(double dt)
{
	DATETIME dtp;
	char sztmp[80];
	
	DateTimeParse(dt, &dtp);
	sprintf(sztmp, "%u/%u/%u %u:%u:%u", dtp.month, dtp.day, dtp.year, dtp.hour, dtp.minute, dtp.second);
	MessageBox(NULL, sztmp, "Current Date/Time", MB_OK);
}
	

void DateTimeParse(double dt, DATETIME *pdtparsed)
	{
	long        julian;
	int         cent;
	unsigned long frac;
	long        temp;
	double      dDay;

	unsigned short	year;
	unsigned char	month;
	unsigned char	day;
	unsigned char	hour;
	unsigned char	minute;
	unsigned char	second;

	dDay = dt;
	julian = (long)dDay;
	dDay -= julian;
	if (julian < 0)
		dDay *= -1;
	frac = (unsigned long) ((dDay * 86400) + 0.5);
	julian += 109511;

	cent = (int) ((4 * julian + 3) / 146097);

	julian += cent - cent / 4;
	year = (unsigned short) ((julian * 4 + 3) / 1461);
	temp = julian - (year * 1461L) / 4;
	month = (unsigned char) ((temp * 10 + 5) / 306);
	day = (unsigned char) (temp - (month * 306L + 5) / 10 + 1);

	month += 3;
	if (month > 12)
		{
		month -= 12;
		year  += 1;
		}
	year += 1600;

	hour = (unsigned char) (frac / 3600);
	minute = (unsigned char) ((frac / 60) % 60);
	second = (unsigned char) (frac % 60);

	//	return structure values
	//
	pdtparsed->year = year;
	pdtparsed->month = month;
	pdtparsed->day = day;
	pdtparsed->hour = hour;
	pdtparsed->minute = minute;
	pdtparsed->second = second;
	}

