#include "windows.h"


//---------------------------------------------------------------------------
// Global Variables...
//---------------------------------------------------------------------------

HANDLE hInstance;       // Global instance handle for application
HWND hwndMain;          // Main hwnd.  Needed in callback


//---------------------------------------------------------------------------
// Function declarations
//---------------------------------------------------------------------------


LONG __export CALLBACK VBDebugWndProc (HWND, UINT, WPARAM, LPARAM);


//---------------------------------------------------------------------------
// WinMain
//---------------------------------------------------------------------------


int PASCAL WinMain (HINSTANCE hInst, HINSTANCE hInstPrev, LPSTR lpstrCmdLine, int
                    cmdShow)
{
   MSG msgMain;
   WNDCLASS wc;

   // Set the global instance variable

   hInstance = hInst;

   // Register the window class if this is the first instance.
   if (hInstPrev == NULL)
   {
      wc.lpszMenuName = NULL;
      wc.lpszClassName = "VBDebug";
      wc.hInstance = hInst;
      wc.hIcon = NULL;
      wc.hCursor = LoadCursor(NULL, IDC_ARROW);
      wc.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);
      wc.style = 0;
      wc.lpfnWndProc = VBDebugWndProc;
      wc.cbClsExtra = 0;
      wc.cbWndExtra = 0;
      if (!RegisterClass(&wc))
         return (0);
   }

   // Create the main window
   if ((hwndMain = CreateWindow("VBDebug", "Stub App to Load VB DLL",
                                WS_OVERLAPPEDWINDOW, CW_USEDEFAULT, 0,
                                CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, hInst
                                , NULL)) == NULL)
      return (0);

   // Show the window and make sure it is updated.
   ShowWindow(hwndMain, cmdShow);
   UpdateWindow(hwndMain);

   // Main message "pump"
   while (GetMessage((LPMSG)&msgMain, NULL, 0, 0))
   {
      TranslateMessage((LPMSG)&msgMain);
      DispatchMessage((LPMSG)&msgMain);
   }

   return (0);
}



//---------------------------------------------------------------------------
// VBDebugWndProc
//
// Window procedure for the applications window.
//
//---------------------------------------------------------------------------


LONG __export CALLBACK VBDebugWndProc (HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
    switch (msg)
    {
        case WM_DESTROY:
            PostQuitMessage(0);
            break;

        default:
            return (DefWindowProc(hwnd, msg, wParam, lParam));
    }
    return (0);
}
