'======================================
' STDCTL3D  -  Funzioni per un look 3D dei pannelli
'              v. 1.1  -  1995/06/06
'--------------------------------------
' Functions
' CTL3D_Start  ---> Call during frmMain load
' CTL3D_Stop   ---> Call during frmMain unload (and in fatal error routine)
' CTL3D_VB     ---> Use to check if in VB environment
' It's required a frmMain in your Project!!!
'--------------------------------------
'Ver 1.1 Added CTL3D_VB Function
'======================================

'======================================
'STDCTL3D - Give a look 3D to your panels
'
'Unless other similar routines, this one has two more features:
'1. Uses CTL3DV2.DLL or (if not found) CTL3D.DLL or (if not found) NONE
'2. Checks if in VB environment. This allows to avoid GPF's during
'   program developement or test.

'One, unresolved problem, are GPF's when executable program ends
'after a non-trapped error.
'Since VB3 hasn't a centralized error management, you must write your
'centralized routine (that calls CTL3D_Stop before ending) and
'must add necessary code to call your centralized routine (suggestions
'accepted).
'
'I found CTL3D_VB function very useful. When in VB environment I try
'my programs as they were registered yet. This avoids me all nag screens
'watermarks, unwanted sound and so on <g>.
'--------------------------------------
' For every comment/suggestion, feel free to
' contact me at 100265,1725@CompuServe.com
'--------------------------------------
' For other source code (and shareware programs <g>)
' check for the TCI-SS keyword in Cis:Italfor Section 17
'======================================

Option Explicit

Dim nm_Ctl3D_Type As Integer  '0 - None  1 - V1  2 - V2
Const CTL3D_NONE = 0
Const CTL3D_V1 = 1
Const CTL3D_V2 = 2
Const FILE_CTL3D_V1 = "CTL3D.DLL"
Const FILE_CTL3D_V2 = "CTL3DV2.DLL"

'=================================
'===           API             ===
'=================================

'===== Functions

'----- CTL3DV1
Declare Function Ctl3DAutoSubclassV1 Lib "Ctl3D.DLL" Alias "Ctl3DAutoSubclass" (ByVal hInst As Integer) As Integer
Declare Function Ctl3DRegisterV1 Lib "Ctl3D.DLL" Alias "Ctl3DRegister" (ByVal hInst As Integer) As Integer
Declare Function Ctl3DUnregisterV1 Lib "Ctl3D.DLL" Alias "Ctl3DUnregister" (ByVal hInst As Integer) As Integer
Declare Function Ctl3DGetVerV1 Lib "Ctl3D.DLL" Alias "Ctl3DGetVer" () As Integer
'----- CTL3DV2
Declare Function Ctl3DAutoSubclassV2 Lib "Ctl3Dv2.DLL" Alias "Ctl3DAutoSubclass" (ByVal hInst As Integer) As Integer
Declare Function Ctl3DRegisterV2 Lib "Ctl3Dv2.DLL" Alias "Ctl3DRegister" (ByVal hInst As Integer) As Integer
Declare Function Ctl3DUnregisterV2 Lib "Ctl3Dv2.DLL" Alias "Ctl3DUnregister" (ByVal hInst As Integer) As Integer
Declare Function Ctl3DGetVerV2 Lib "Ctl3Dv2.DLL" Alias "Ctl3DGetVer" () As Integer
'----- MISC
Declare Function CTL3D_GETMF Lib "Kernel" Alias "GetModuleFileName" (ByVal hModule As Integer, ByVal lpFilename As String, ByVal nSize As Integer) As Integer
Declare Function CTL3D_GETWW Lib "User" Alias "GetWindowWord" (ByVal hWnd As Integer, ByVal nIndex As Integer) As Integer
Declare Function CTL3D_WINDIR Lib "Kernel" Alias "GetWindowsDirectory" (ByVal lpBuffer As String, ByVal nSize As Integer) As Integer
Declare Function CTL3D_SYSTEM Lib "Kernel" Alias "GetSystemDirectory" (ByVal lpBuffer As String, ByVal nSize As Integer) As Integer

Const GWW_HINSTANCE = (-6)

Sub CTL3D_Start ()
    '===== Use this to start the 3D dialogs
    Dim rc_Inst         As Integer
    Dim rc_3D           As Integer
    Dim rc              As Integer
    Dim lpRetStr        As String
    Dim sz_ModuleName   As String
    '----- Is there a loaded form?
    If Forms.Count = 0 Then
        Dim Msg As String
        Msg = "There is no loaded form.  "
        Msg = Msg & "To register your app with CTL3D "
        Msg = Msg & "there must be at least one loaded form.  "
        Msg = Msg & Chr$(13) & Chr$(13)
        Msg = Msg & "Use the Load statement to load a form, "
        Msg = Msg & "use Ctl3D_Start, then unload the form."
        MsgBox Msg, 48, "No Form Loaded"
        Exit Sub
    End If

    '----- Find Ctrl3D
    If nm_Ctl3D_Type <> CTL3D_NONE Then
        Exit Sub
    End If
    If CTR3D_FileExist(FILE_CTL3D_V1) Then
        nm_Ctl3D_Type = CTL3D_V1
    End If
    If CTR3D_FileExist(FILE_CTL3D_V2) Then
        nm_Ctl3D_Type = CTL3D_V2
    End If
    '----- Are we in a VB environment?
    lpRetStr = Space$(128)
    rc_Inst = CTL3D_GETWW(Forms(0).hWnd, GWW_HINSTANCE) 'Get the Word of Frm
    rc = CTL3D_GETMF(rc_Inst, lpRetStr, Len(lpRetStr))
    If rc Then
        sz_ModuleName = Left$(lpRetStr, rc)
        ' Get the "." in the file name. Then go back three characters.
        ' FileName should = \VB.EXE, so check for the backslash (\)
        ' because FileName could be GVB.EXE, which isn't the
        ' VB executable name:
        If InStr(sz_ModuleName, "\VB.EXE") Then
            Exit Sub
        End If
    End If
    '----- Activate
    Select Case nm_Ctl3D_Type
    Case CTL3D_NONE
        'Nop
    Case CTL3D_V1
        rc_3D = Ctl3DRegisterV1(rc_Inst)
        rc_3D = Ctl3DAutoSubclassV1(rc_Inst)
    Case CTL3D_V2
        rc_3D = Ctl3DRegisterV2(rc_Inst)
        rc_3D = Ctl3DAutoSubclassV2(rc_Inst)
    End Select
End Sub

Sub CTL3D_Stop ()
    '===== This Sub is used to end the 3D effects
    '      IMPORTANT: you must end 3D effects before your app ends
    Dim rc_Get As Integer
    Dim rc_3D As Integer
    rc_Get = CTL3D_GETWW(Forms(0).hWnd, GWW_HINSTANCE) 'Get the Word of Frm
    Select Case nm_Ctl3D_Type
    Case CTL3D_NONE
        'Nop
    Case CTL3D_V1
        rc_3D = Ctl3DUnregisterV1(rc_Get)   ' Unregister the program.
    Case CTL3D_V2
        rc_3D = Ctl3DUnregisterV2(rc_Get)   ' Unregister the program.
    End Select
    nm_Ctl3D_Type = CTL3D_NONE
End Sub

Function CTL3D_VB () As Integer
    '===== Use this to find if in a VB environment
    Dim b_Vb            As Integer
    Dim rc_Inst         As Integer
    Dim rc              As Integer
    Dim lpRetStr        As String
    Dim sz_ModuleName   As String
    '----- Are we in a VB environment?
    b_Vb = False
    lpRetStr = Space$(128)
    rc_Inst = CTL3D_GETWW(Forms(0).hWnd, GWW_HINSTANCE) 'Get the Word of Frm
    rc = CTL3D_GETMF(rc_Inst, lpRetStr, Len(lpRetStr))
    If rc Then
        sz_ModuleName = Left$(lpRetStr, rc)
        ' Get the "." in the file name. Then go back three characters.
        ' FileName should = \VB.EXE, so check for the backslash (\)
        ' because FileName could be GVB.EXE, which isn't the
        ' VB executable name:
        If InStr(sz_ModuleName, "\VB.EXE") Then
            b_Vb = True
        End If
    End If
    CTL3D_VB = b_Vb
End Function

Private Function CTR3D_FileExist (sz_FileName As String) As Integer
    '===== Returns True if File Exists
    Dim lpRetStr        As String
    Dim rc              As Integer
    Dim sz_File As String
    Dim sz_Test As String
    '===== Start
    lpRetStr = Space$(256)
    sz_File = sz_FileName: GoSub FindFile
    rc = CTL3D_SYSTEM(lpRetStr, Len(lpRetStr))
    sz_File = Left$(lpRetStr, rc) & "\" & sz_FileName: GoSub FindFile
    rc = CTL3D_WINDIR(lpRetStr, Len(lpRetStr))
    sz_File = Left$(lpRetStr, rc) & "\" & sz_FileName: GoSub FindFile
    CTR3D_FileExist = False
    Exit Function

FindFile:
     sz_Test = Dir$(sz_File)
     If sz_Test <> "" Then
         CTR3D_FileExist = True
         Exit Function
     End If
     Return

End Function

