' ! This is a Visual Basic BAS-file !                     '
' ******************************************************* '
' *   This module contains a function which will help   * '
' *       to avoid GPFs or other unkind events in       * '
' *             VB development environment.             * '
' ******************************************************* '
'                                                         '
'  As long as you are designing your code, add this new   '
'        function 'IsVBenviron' to your project.          '
'  Every event you want to 'switch off' while you are     '
'    still testing your code will be successfully         '
'                   suppressed now.                       '
'                                                         '
'                        + + +                            '
'                                                         '
' Feel free to use this code whenever you need it.        '
' For questions (or advices) don't hesitate to e-mail me. '
'                                                         '
' Code by: Christian Germelmann                           '
'          35039 Marburg - Germany                        '
'          CompuServe 100520,2644                                '
'                                                         '

Option Explicit

Const GWW_HINSTANCE% = (-6)
Const GWW_HWNDPARENT% = (-8)

Declare Function GetModuleFileName% Lib "KERNEL" Alias "#49" (ByVal hModule%, ByVal lpFilename$, ByVal nSize%)
Declare Function GetWindowWord% Lib "USER" Alias "#133" (ByVal hWnd%, ByVal nIndex%)


' ***************************************************
' * If you are puzzled by the 'Alias' just scip it: *
' ***************************************************
'
'Declare Function GetModuleFileName% Lib "KERNEL"  (ByVal hModule%, ByVal lpFilename$, ByVal nSize%)
'Declare Function GetWindowWord% Lib "USER"  (ByVal hWnd%, ByVal nIndex%)

'>>>------------------------------------------------------------------------------
'                                                         '
'   Adds the backslash where it is needed.                '
'                                                         '
'
Function Backslash$ (FilePath$)
    
        If Right$(FilePath, 1) = "\" Then
                Backslash = FilePath
            Else
                Backslash = FilePath + "\"
        End If
        

' **********************************************************************
' * DO NOT USE this variation: it alters the FilePath-value itself !!! *
' *  (--> unless you definitely want this, of course !)                *
' **********************************************************************
'                                                                      '
'    If Right$(FilePath, 1) <> "\" Then FilePath = FilePath + "\"      '
'                                                                      '
'                                                                      '
' ******************************************************************
' * In case you definitely want this, you'd rather use a SUB like: *
' ******************************************************************
'                                                                  '
' Sub Backslash (FilePath$)                                        '
'                                                                  '
'   If Right$(FilePath, 1) <> "\" Then FilePath = FilePath + "\"   '
'                                                                  '
' End Sub                                                          '
'                                                                  '

End Function

'>>>------------------------------------------------------------------------------
' *****************************************************************
' *    This function gleans whether the application runs under    *
' *             VB (development environment) or not.              *
' *****************************************************************
'
Function IsVBenviron% ()

Dim hModule%, FileBuffer$, NumberOfBytes%, ModuleFileName$, AppFileName$
    
    ' *************************************************************
    ' * retrieve the filename of the (this !) running application *
    ' *                         via API                           *
    ' *************************************************************
    
    ' get the instance handle of the module that owns the given window
    hModule = GetWindowWord(Forms(0).hWnd, GWW_HINSTANCE)
    ' preset the buffer that receives the null-terminated filename
    FileBuffer = Space$(128)
    ' retrieve the full path and filename of the executable file
    '  from which the specified module was loaded
    '   --> In VB environment this is the full VB.EXE path
    '       (or - not in VB environment - the app's full path)
    NumberOfBytes = GetModuleFileName(hModule, FileBuffer, Len(FileBuffer))
    ModuleFileName = Left$(FileBuffer, NumberOfBytes)
    

    ' ***************************************************************
    ' * let the running application retrieve its filename by itself *
    ' *                       via VB command                        *
    ' ***************************************************************

    ' Assemble the full application path using 'App.Path' and 'App.EXEName'
    AppFileName = Backslash((App.Path)) + App.EXEName + ".EXE"
    

    ' *************************************************************
    ' *                compare the filenames finally:             *
    ' *  In case they are NOT identical we are in VB environment  *
    ' *     (make sure: set both filenames to the same case)      *
    ' *************************************************************
    
    ' So it doesn't matter whether VB.EXE has a different filename
    '  (as you now: you can launch a second VB instance by simply renaming VB.EXE !)
    IsVBenviron = (UCase$(ModuleFileName) <> UCase$(AppFileName))

' Additionally...                                                     '
' You could save a few bytes if you exchange the following lines:     '
' (I didn't write them above to make the code better to understand)   '
'                                                                     '
'  >>  ModuleFileName = Left$(FileBuffer, NumberOfBytes-4)                '
'  >>  AppFileName = Backslash((App.Path)) + App.EXEName              '

End Function

'>>>------------------------------------------------------------------------------
'                                                         '
' IDENTICAL with 'IsVBenviron' but without any comment !!!'
' --> So you can see how short this routine really is.    '
'     (when using later, remove the 'XYZ' again)          '
'                                                         '
'
Function IsVBenvironXYZ% ()

Dim hModule%, FileBuffer$, NumberOfBytes%, ModuleFileName$, AppFileName$
     
        hModule = GetWindowWord(Forms(0).hWnd, GWW_HINSTANCE)
         
        FileBuffer = Space$(128)
        NumberOfBytes = GetModuleFileName(hModule, FileBuffer, Len(FileBuffer))
        ModuleFileName = Left$(FileBuffer, NumberOfBytes - 4)
         
        AppFileName = Backslash((App.Path)) + App.EXEName
         
    IsVBenvironXYZ = (UCase$(ModuleFileName) <> UCase$(AppFileName))
 
End Function

