Option Explicit

'
'  Calling LinkMenu binds the "Button" to a Menu
'
Sub BindMenus ()
   Dim F As MDI
   Set F = MDI
   Call LinkMenu(BUTTON_NEW, F.mnu_File_New)
   Call LinkMenu(BUTTON_OPEN, F.mnu_File_Open)
   Call LinkMenu(BUTTON_PRINT, F.mnu_File_Print)
   Call LinkMenu(BUTTON_CUT, F.mnu_Edit_Cut)
   Call LinkMenu(BUTTON_COPY, F.mnu_Edit_Copy)
   Call LinkMenu(BUTTON_PASTE, F.mnu_Edit_Paste)
   Call LinkMenu(BUTTON_FIND, F.mnu_Search_Find)
   Call LinkMenu(BUTTON_TOOLTIPS, F.mnu_Options_Tooltips)
   Call LinkMenu(BUTTON_HELP, F.mnu_Help_HelpTopics)
   Call SynchButtons
End Sub

Sub FileOpen ()
   Dim FO As CD_OPENFILE_TYPE
   Dim Fname As String
   Dim Temp$
   FO.Flags = OFN_HIDEREADONLY
   FO.Filter = "Text Files|*.txt;*.ini;*.bat;*.c;*.bas;*.mak;*.frm|All Files (*.*)|*.*"
   Call CD_OpenFile(FO)
   Fname = Trim(FO.Filename)
   If Len(Fname) Then
      Temp$ = OpenFile(Fname)
      If Len(Temp$) Then
        Call NewFile
        MDI.ActiveForm.Caption = Fname
        MDI.ActiveForm.txtTextEdit = Temp$
      End If
   End If
End Sub

Sub FileSave ()
    Dim Filename As String
    Dim F As Form
    Set F = MDI.ActiveForm
    Filename = F.Caption
    If Filename = NEW_FILE_TITLE Then
       Filename = " "
       Filename = FileSaveAs(Filename)
    End If
    If Len(Filename) Then
       Call WriteFile(Filename, CStr(F.ActiveControl))
       F.Caption = Filename
       If Not Err Then
         ' Reset the "modified" status of the Textbox
         If SendMessage(F.ActiveControl.hWnd, EM_SETMODIFY, False, ByVal 0&) Then
         End If
       End If
    End If
End Sub

Function FileSaveAs (Filename As String) As String
   Dim FS As CD_OPENFILE_TYPE
   FS.Flags = OFN_OVERWRITEPROMPT Or OFN_HIDEREADONLY
   FS.DefaultExt = "TXT"
   FS.Filename = Filename
   FS.Filter = "Text Files|*.txt;*.ini;*.bat;*.c;*.bas;*.mak;*.frm|All Files (*.*)|*.*"
   Call CD_SaveFile(FS)
   FileSaveAs = FS.Filename
End Function

Sub NewFile ()
    Dim X As Integer
    Dim NF As NextForm_Type
    NF.Formclass = CLASS_frmTextEdit
    Call Nextform(Forms_frmTextEdit(), NF)
    X = NF.Index
    Forms_frmTextEdit(X).Tag = NF.Tag
    Forms_frmTextEdit(X).Caption = NEW_FILE_TITLE
End Sub

