Option Explicit
Global QuickInfo        As Integer      ' use QuickInfo
Global ToolhWnd         As Integer      ' is Toolwnd loaded
Global stppx            As Integer      ' Screen.TwipsPerPixelX
Global stppy            As Integer      ' Screen.TwipsPerPixelY
Type apiPoint
    x       As Integer
    Y       As Integer
End Type
Type apiRect
    Left    As Integer
    Top     As Integer
    Right   As Integer
    Bottom  As Integer
End Type

Declare Function ExtFloodFill Lib "GDI" (ByVal hDC As Integer, ByVal x As Integer, ByVal Y As Integer, ByVal crColor As Long, ByVal wFillType As Integer) As Integer
Declare Sub GetCursorPos Lib "User" (sPoint As apiPoint)
Global Const MF_BYPOSITION = &H400&
Global Const SrcCopy = &HCC0020
           
Global Const MP_Uhr = 11
Global Const MP_Normal = 0
Global MP_Alt               As Integer

Declare Function GetSystemMenu Lib "User" (ByVal hWnd As Integer, ByVal bRevert As Integer) As Integer
Declare Function RemoveMenu Lib "User" (ByVal hMenu As Integer, ByVal nPosition As Integer, ByVal wFlags As Integer) As Integer
Declare Function GetSystemMetrics Lib "user" (ByVal Param As Integer) As Integer
Declare Function GetWindowWord Lib "User" (ByVal hWnd As Integer, ByVal nIndex As Integer) As Integer
Declare Function ExtractIcon Lib "Shell.dll" (ByVal hWnd As Integer, ByVal FileName As String, ByVal i As Integer) As Integer
Declare Function DrawIcon Lib "User" (ByVal hDC As Integer, ByVal x As Integer, ByVal Y As Integer, ByVal hIcon As Integer) As Integer
Declare Function BitBlt Lib "GDI" (ByVal hDestDC As Integer, ByVal x As Integer, ByVal Y As Integer, ByVal nWidth As Integer, ByVal nHeight As Integer, ByVal hSrcDC As Integer, ByVal XSrc As Integer, ByVal YSrc As Integer, ByVal dwRop As Long) As Integer
Declare Function GetKeyState Lib "User" (ByVal nVirtKey As Integer) As Integer
Declare Sub GetWindowRect Lib "User" (ByVal hWnd As Integer, lpRect As apiRect)
Declare Sub SetWindowPos Lib "User" (ByVal hWnd As Integer, ByVal hWndInsertAfter As Integer, ByVal x As Integer, ByVal Y As Integer, ByVal cx As Integer, ByVal cy As Integer, ByVal wFlags As Integer)
Declare Function GetTickCount Lib "user" () As Long
Declare Function StretchBlt Lib "GDI" (ByVal hDC%, ByVal x%, ByVal Y%, ByVal nWidth%, ByVal nHeight%, ByVal hSrcDC%, ByVal XSrc%, ByVal YSrc%, ByVal nSrcWidth%, ByVal nSrcHeight%, ByVal dwRop&) As Integer
Declare Function GetSysColor Lib "User" (ByVal nIndex As Integer) As Long
Declare Function CreateDC Lib "GDI" (ByVal Driver$, ByVal Dev&, ByVal O&, ByVal Init&) As Integer
Declare Function DeleteDC Lib "GDI" (ByVal dc As Integer) As Integer
Declare Sub DrawFocusRect Lib "User" (ByVal hDC As Integer, lpRect As apiRect)

Sub FakeMove (MyForm As Form)
Dim dc As Integer, dx As Integer, dy As Integer, x As Integer, Y As Integer
Dim mPos As apiPoint, oldPos As apiPoint
Dim mRect As apiRect
    MP_Alt = Screen.MousePointer
    Screen.MousePointer = 1
    dc = CreateDC("DISPLAY", 0, 0, 0)
    dx = MyForm.Width / stppx
    dy = MyForm.Height / stppy
    GetCursorPos mPos
    oldPos = mPos
    GetWindowRect MyForm.hWnd, mRect
    x = mPos.x - mRect.Left
    Y = mPos.Y - mRect.Top
    mRect.Left = mPos.x - x
    mRect.Top = mPos.Y - Y
    mRect.Right = mRect.Left + dx
    mRect.Bottom = mRect.Top + dy
    DrawFocusRect dc, mRect
    Do
        DoEvents
        oldPos = mPos
        GetCursorPos mPos
        If oldPos.x <> mPos.x Or oldPos.Y <> mPos.Y Then
            DrawFocusRect dc, mRect
            mRect.Left = mPos.x - x
            mRect.Top = mPos.Y - Y
            mRect.Right = mRect.Left + dx
            mRect.Bottom = mRect.Top + dy
            DrawFocusRect dc, mRect
        End If
    Loop Until GetKeyState(1) >= 0
    DrawFocusRect dc, mRect
    dc = DeleteDC(dc)
    MyForm.Move stppx * (mPos.x - x), stppy * (mPos.Y - Y)
    MyForm.Cls
    Screen.MousePointer = MP_Alt
End Sub

Sub MakeUpperStatusBar (Bar As PictureBox)
Dim OldParentMode As Integer, MyOldMode As Integer, MDICorr As Integer
Dim OldRedraw As Integer, wRect As apiRect
    Bar.Align = 1
    OldRedraw = Bar.AutoRedraw
    Bar.AutoRedraw = True
    Bar.BackColor = RGB(192, 192, 192)
    Bar.BorderStyle = False
    GetWindowRect Bar.hWnd, wRect           '<<<!!!
    MyOldMode = Bar.ScaleMode
    Bar.ScaleMode = 3
    Bar.Line (1, wRect.Bottom - wRect.Top - 2)-(wRect.Right - wRect.Left, wRect.Bottom - wRect.Top - 2), RGB(128, 128, 128)
    Bar.Line (0, 0)-(wRect.Right - wRect.Left, 0), RGB(255, 255, 255)
    Bar.Line (0, 1)-(0, wRect.Bottom - wRect.Top), RGB(255, 255, 255)
    Bar.Line (0, wRect.Bottom - wRect.Top - 1)-(wRect.Right - wRect.Left, wRect.Bottom - wRect.Top - 1), RGB(0, 0, 0)
    If MDICorr = 1 Then
        Bar.Parent.ScaleMode = OldParentMode
    End If
    Bar.ScaleMode = MyOldMode
    Bar.AutoRedraw = OldRedraw
End Sub

Sub MenuRight (MyMenu As Control)
    MyMenu.Caption = Chr$(8) + MyMenu.Caption
End Sub

Function PutIconToPicture (MyIcon As Control, FileName As String, IconCnt As Integer) As Integer
Dim rc As Integer, iHwnd As Integer
    On Error Resume Next
    MyIcon.AutoRedraw = True
    MyIcon.Picture = LoadPicture("")
    MyIcon.Cls
    MyIcon.ScaleMode = 3
    SetWindowPos MyIcon.hWnd, 0, 0, 0, GetSystemMetrics(11) + 2, GetSystemMetrics(12) + 2, &H2
    iHwnd = GetWindowWord(MyIcon.Parent.hWnd, -6)
    rc = ExtractIcon(iHwnd, FileName, IconCnt)
    rc = DrawIcon(MyIcon.hDC, 0, 0, rc)
    MyIcon.Refresh
    If rc <> 0 Then PutIconToPicture = True
End Function

Function ButtonDown (MyButton As Control) As Integer
Dim rc As Integer, mWidth As Integer, mHeight As Integer, rp As Integer, rd As Integer
Dim ButtonState As Integer, ds As Integer, dm As Integer
Dim wPoint As apiPoint, wRect As apiRect
    On Error Resume Next
    MyButton.Cls
    GetWindowRect MyButton.hWnd, wRect
    rd = MyButton.ScaleMode
    ds = MyButton.DrawStyle
    dm = MyButton.DrawMode
    MyButton.ScaleMode = 3
    MyButton.DrawStyle = 0
    MyButton.DrawMode = 13
    mWidth = MyButton.Width
    mHeight = MyButton.Height
    Do
        rc = GetKeyState(1)
        DoEvents
        If rc = 0 Then Exit Do
        If rc = 1 Then Exit Do
        GetCursorPos wPoint
        If wPoint.x < wRect.Left Or wPoint.x > wRect.Right - 1 Or wPoint.Y < wRect.Top Or wPoint.Y > wRect.Bottom Then
            If ButtonState Then MyButton.Cls
            ButtonState = False
        Else
            If ButtonState = False Then
                rc = BitBlt(MyButton.hDC, 3, 3, mWidth - 4, mHeight - 4, MyButton.hDC, 2, 2, SrcCopy)
                MyButton.Line (2, 2)-(mWidth - 2, 2), RGB(192, 192, 192)
                MyButton.Line (2, 3)-(2, mHeight - 2), RGB(192, 192, 192)
                MyButton.Line (1, 1)-(1, mHeight - 2), RGB(128, 128, 128)
                MyButton.Line (1, 1)-(mWidth - 2, 1), RGB(128, 128, 128)
                MyButton.Line (2, mHeight - 2)-(mWidth - 2, mHeight - 2), RGB(192, 192, 192)'RGB(255, 255, 255)
                MyButton.Line (mWidth - 2, 2)-(mWidth - 2, mHeight - 1), RGB(192, 192, 192)'RGB(255, 255, 255)
            End If
            ButtonState = True
        End If
    Loop
    ButtonDown = ButtonState
    MyButton.ScaleMode = rd
    MyButton.DrawStyle = ds
    MyButton.DrawMode = dm
    MyButton.Cls
    MyButton.Refresh
End Function

Sub WaitZehntel (Sec As Integer)
Dim StartTime!, StoppTime!
    StoppTime! = GetTickCount() / 1000
    Do
        StoppTime! = GetTickCount() / 1000
        DoEvents
        If StartTime! + (Sec / 10) <= StoppTime! Then Exit Do
    Loop
End Sub

