
Sub Frame (C As Control)
  Dim Offset As Single

  Screen.ActiveForm.ScaleMode = PIXELS
  Offset = 1
  Screen.ActiveForm.DrawWidth = 2
  Screen.ActiveForm.ForeColor = WHITE
  'bottom:
  Screen.ActiveForm.Line (C.Left - Offset, C.Top + C.Height + Offset)-(C.Left + C.Width + Offset, C.Top + C.Height + Offset)
  'right:
  Screen.ActiveForm.Line -(C.Left + C.Width + Offset, C.Top - Offset)
  Screen.ActiveForm.ForeColor = DARKGREY
  'top:
  Screen.ActiveForm.Line -(C.Left - Offset, C.Top - Offset)
  'left:
  Screen.ActiveForm.Line -(C.Left - Offset, C.Top + C.Height)
End Sub

Sub PixelsToTwips (PIXELS As POINTAPI, TWIPS As POINTAPI)

    TWIPS.x = PIXELS.x * (Screen.Width / GetDeviceCaps(Screen.ActiveForm.hDC, HORZRES))
    TWIPS.y = PIXELS.y * (Screen.Height / GetDeviceCaps(Screen.ActiveForm.hDC, VERTRES))
    
End Sub

Sub PositionFormRelative (ChildForm As Form, ParentForm As Form)
    Dim x As Integer, y As Integer

    x = ParentForm.Left
    If (ParentForm.Left + ChildForm.Width > Screen.Width) Then
        x = Screen.Width - ChildForm.Width
    End If
    y = ParentForm.Top
    If (ParentForm.Top + ChildForm.Height > Screen.Height) Then
        y = Screen.Height - ChildForm.Height
    End If
    ChildForm.Move x, y

End Sub

Sub TwipsToPixels (TWIPS As POINTAPI, PIXELS As POINTAPI)

    PIXELS.x = TWIPS.x * (GetDeviceCaps(Screen.ActiveForm.hDC, HORZRES) / Screen.Width)
    PIXELS.y = TWIPS.y * (GetDeviceCaps(Screen.ActiveForm.hDC, VERTRES) / Screen.Height)

End Sub

Function OpenFile (FileName$, Mode%, RecordLen%) As Integer
    'Opens a file in specified access mode
    'Arguments: FileName$   -   String representing a valid OS pathname
    '           Mode%       -   Enumerated integer representing the file-access mode
    '           RecordLen%  -   Integer specifying length of one record
    'Returns:   File Handle (file number). NULL if open fails.

    FileNum% = FreeFile         'Get a free file handle from OS
    On Error GoTo OpenError     'Prepare for possible errors
    Select Case Mode            'Select specified access mode
        Case REPLACEFILE        'Sequential output.
            Open FileName For Output As FileNum%
        Case READFILE           'Sequential input.
            Open FileName For Input As FileNum%
        Case APPENDFILE         'Sequential append.
            Open FileName For Append As FileNum%
        Case RANDOMFILE         'Random Access.
            Open FileName For Random As FileNum% Len = RecordLen%
        Case BINARYFILE         'Binary Access.
            Open FileName For Binary As FileNum%
        Case Else
            Exit Function
    End Select
    OpenFile = FileNum%     'Return file handle.
Exit Function
OpenError:
    Action% = FileError(Err, FileName$)
    Select Case Action%
        Case 0
            Resume
        Case Else
            OpenFile = 0
            Exit Function
    End Select

End Function

Function FileError (ErrorValue As Integer, FileName$) As Integer
    'Return Value:
    '   0 = Resume
    '   1 = Resume Next
    '   2 = Unrecoverable error
    '   3 = Unrecognized error

    msgType% = MB_ICONEXCLAMATION
    Select Case ErrorValue
        Case 68                         'Device Unavailable
            Msg$ = "Device is unavailable."
            msgType% = MB_ICONEXCLAMATION + 4
    
        Case 71                         'Disk Not Ready
            Msg$ = "Insert a disk in the drive and close the door."
    
        Case 57                         'Device I/O
            Msg$ = "Internal disk error."
            msgType% = MB_ICONEXCLAMATION + 4
    
        Case 61                         'Disk Full
            Msg$ = "Disk is full! Continue?"
            msgType% = 35
    
        Case 64, 52                     'Bad filename or bad filenumber
            Msg$ = "Illegal Filename."
    
        Case 76                         'Path does not exist
            Msg$ = "Pathname does not exist."
    
        Case 54                         'Bad File Mode
            Msg$ = "Requested Access mode denied."
    
        Case 55                         'File Open
            Msg$ = "Requested file is already open."

        Case 62                         'Input past EOF
            Msg$ = "File has nonstandard EOF marker or "
            Msg$ = Msg$ + "an attempt was made to read beyond EOF."

        Case Else
            FileError = 3
            Exit Function
    End Select
    response% = MsgBox(Msg$, msgType%, FileName$)
    Select Case response%
        Case 1, 4   'OK, Retry butons.
            FileError = 0
        Case 5      'Ignore button.
            FileError = 1
        Case 2, 3   'Cancel, Abort buttons.
            FileError = 2
        Case Else
            FileError = 3
    End Select

End Function

Sub InvertGraphic (C As Control)

  C.ScaleMode = PIXELS
  C.DrawWidth = 1
  C.DrawMode = INVERT
  C.FillStyle = TRANSPARENT
  C.FillColor = WHITE
  C.ForeColor = BLACK
  C.Line (1, 1)-Step(C.Width - 2, C.Height - 2), , B

End Sub

Sub Outline (C As Control, boolean As Integer)

  Screen.ActiveForm.ScaleMode = PIXELS
  Offset = 1
  Screen.ActiveForm.DrawWidth = 2
  Screen.ActiveForm.ForeColor = WHITE
  If boolean Then Screen.ActiveForm.ForeColor = DARKGREY
  'bottom:
  Screen.ActiveForm.Line (C.Left - Offset, C.Top + C.Height + Offset)-(C.Left + C.Width + Offset, C.Top + C.Height + Offset)
  'right:
  Screen.ActiveForm.Line -(C.Left + C.Width + Offset, C.Top - Offset)
  Screen.ActiveForm.ForeColor = DARKGREY
  If boolean Then Screen.ActiveForm.ForeColor = WHITE
  'top:
  Screen.ActiveForm.Line -(C.Left - Offset, C.Top - Offset)
  'left:
  Screen.ActiveForm.Line -(C.Left - Offset, C.Top + C.Height)

End Sub

Sub PrintFormattedText (ByVal PrintText As String)
    'Procedure to format long strings into shorter strings which fit on printer.

    Dim PrintString As String
    Dim StartString As Integer
    Dim EndString As Integer
    Dim MaxLine As Integer

    StartString = 1
    EndString = -1
    Printer.ScaleMode = INCHES
    PrintText = PrintText + Chr$(13) + Chr$(10) 'Ensure search string in text
    MaxLine = 7! / Printer.TextWidth(Mid$(PrintText, 1, 1))
    Do
        Skip% = 2
        'Search for carriage return/line feed
        EndString = InStr(StartString, PrintText, Chr$(13) + Chr$(10))
        'If not found then exit
        If EndString = 0 Then Exit Do
        'If found then adjust string segment to fit on one line, otherwise print it.
        If EndString - StartString > MaxLine Then
            Skip% = 0
            EndString = StartString + MaxLine
            'Break string segments at a space
            Do Until Mid$(PrintText, EndString, 1) = " "
                EndString = EndString - 1
                Skip% = 1
            Loop
        End If
        Printer.Print Mid$(PrintText, StartString, EndString - StartString)
        StartString = EndString + Skip%
    Loop

End Sub

Function GetDirPathToModule (ModuleName As String) As String
    'Returns path of directory containing ModuleName
    'Argument List:
    '   ModuleName - Null-terminated string containing module name
    Dim hModule As Integer
    Dim lpFileName As String * 255

    hModule = GetModuleHandle(UCase$(ModuleName))
    If GetModuleFileName(hModule, lpFileName, Len(lpFileName)) Then
        GetDirPathToModule = Left$(lpFileName, InStr(1, lpFileName, "\" + UCase$(ModuleName)))
    Else
        GetDirPathToModule = ""
    End If

End Function

