Attribute VB_Name = "ToolHelp32"
Option Explicit
' =======================================================
' TOOLHELP32 functions, constants and types
' for the Windows 95 (TM) operating system
' for use with Microsoft's Visual Basic 4 programming tool.
'
' Version 1.0
' First Compiled:   20 Sept. 1995
'             by:   Michael Lambrellis
'                   Microsoft Certified Solution Developer
'                   Compuserve: (100406,2064)
'
' If you find any bugs in this code or suggestions for
' modifications. Please inform me via email - DO NOT
' MAKE CHANGES TO THIS FILE!!! I would like to ensure that
' changes are vetted before being redistributed. Proper
' acknowledgement of accepted changes will be made in this
' file.
' =======================================================

' =======================================================
' !!!IMPORTANT!!!    *** DISCLAIMER ***    !!!IMPORTANT!!!
'
' The following declarations are my personal translation
' of the TLHELP32.H file which comes with Microsoft's
' Win32 SDK. I take no responsibility for the use that
' these functions are put to nor for any damage arising
' from such use whether proper or improper. I make no
' guarantee that these functions are good for anything at
' all (Microsoft don't so why should I?). The bottom line
' is CAVEAT EMPTOR - "let the buyer beware!". And since
' I am making this freely available as a public service
' don't *expect* any support at all for this stuff (that's
' not to say there won't be any just that it will merely
' be at my discretion whether I choose to support it or not!)
' Furthermore, use of these functions (whether this disclaimer
' has been read or not) constitutes automatic acceptance on
' the part of the user of all the aforementioned conditions.
'
' BTW, if this disclaimer is not satisfactory...too bad!
' =======================================================


' this is required to close the handle to the snapshot
' object created by CreateToolhelp32Snapshot() (which
' is described below)
Public Declare Function CloseHandle Lib "kernel32" _
    (ByVal hObject As Long) As Long


'/*****************************************************************************\
'* tlhelp32.h -  WIN32 tool help functions, types, and definitions         *
'* Version 1.0                                     *
'* NOTE: windows.h/winbase.h must be #included first               *
'* Copyright (c) 1994-1995, Microsoft Corp.   All rights reserved.         *
'\*****************************************************************************/

Public Const MAX_MODULE_NAME32 = 255
' VB can't evaluate expressions in constant declarations
' so we have to fake it...
Public Const MAX_MODULE_NAME32PLUS1 = 256
Public Const MAX_PATH = 260

'/****** Shapshot function **********************************************/

Public Declare Function CreateToolhelp32Snapshot Lib "kernel32" _
        (ByVal dwFlags As Long, _
         ByVal th32ProcessID As Long) As Long

'//
'// The th32ProcessID argument is only used if TH32CS_SNAPHEAPLIST or
'// TH32CS_SNAPMODULE is specified. th32ProcessID == 0 means the current
'// process.
'//
'// NOTE that all of the snapshots are global except for the heap and module
'//  lists which are process specific. To enumerate the heap or module
'//  state for all WIN32 processes call with TH32CS_SNAPALL and the
'//  current process. Then for each process in the TH32CS_SNAPPROCESS
'//  list that isn't the current process, do a call with just
'//  TH32CS_SNAPHEAPLIST and/or TH32CS_SNAPMODULE.
'//
'// dwFlags
'//

Public Const TH32CS_SNAPHEAPLIST = &H1&
Public Const TH32CS_SNAPPROCESS = &H2&
Public Const TH32CS_SNAPTHREAD = &H4&
Public Const TH32CS_SNAPMODULE = &H8&
'#define TH32CS_SNAPALL      (TH32CS_SNAPHEAPLIST | TH32CS_SNAPPROCESS | TH32CS_SNAPTHREAD | TH32CS_SNAPMODULE)
Public Const TH32CS_SNAPALL = &H15&
Public Const TH32CS_INHERIT = &H80000000

'//
'// Use CloseHandle to destroy the snapshot
'//

'/****** heap walking ***************************************************/

Public Type HEAPLIST32
    dwSize As Long
    th32ProcessID As Long   ' owning process
    th32HeapID As Long      ' heap (in owning process's context!)
    dwFlags As Long
End Type

'//
'// dwFlags
'//

Public Const HF32_DEFAULT = 1   ' process's default heap
Public Const HF32_SHARED = 2    ' is shared heap

Public Declare Function Heap32ListFirst Lib "kernel32" _
        (ByVal hSnapshot As Long, _
         lphl As HEAPLIST32) As Boolean

Public Declare Function Heap32ListNext Lib "kernel32" _
        (ByVal hSnapshot As Long, _
         lphl As HEAPLIST32) As Boolean

Public Type HEAPENTRY32
    dwSize As Long
    hHandle As Long         ' Handle of this heap block
    dwAddress As Long       ' Linear address of start of block
    dwBlockSize As Long     ' Size of block in bytes
    dwFlags As Long
    dwLockCount As Long
    dwResvd As Long
    th32ProcessID As Long   ' owning process
    th32HeapID As Long      ' heap block is in
End Type

'//
'// dwFlags
'//

Public Const LF32_FIXED = &H1&
Public Const LF32_FREE = &H2&
Public Const LF32_MOVEABLE = &H4&

Public Declare Function Heap32First Lib "kernel32" _
        (lphe As HEAPENTRY32, _
         ByVal th32ProcessID As Long, _
         ByVal th32HeapID As Long) As Boolean

Public Declare Function Heap32Next Lib "kernel32" _
        (lphe As HEAPENTRY32) As Boolean
        
Public Declare Function Toolhelp32ReadProcessMemory Lib "kernel32" _
        (ByVal th32ProcessID As Long, _
         ByVal lpBaseAddress As Long, _
         ByVal cbRead As Long, _
         ByVal lpNumberOfBytesRead As Long) As Boolean

'/***** Process walking *************************************************/

Public Type PROCESSENTRY32
    dwSize As Long
    cntUsage As Long
    th32ProcessID As Long       ' this process
    th32DefaultHeapID As Long
    th32ModuleID As Long        ' associated exe
    cntThreads As Long
    th32ParentProcessID As Long ' this process's parent process
    pcPriClassBase As Long      ' base priority of process's threads
    dwFlags As Long
    szExeFile As String * MAX_PATH  ' Path
End Type

Public Declare Function Process32First Lib "kernel32" _
        (ByVal hSnapshot As Long, _
         lppe As PROCESSENTRY32) As Boolean
        
Public Declare Function Process32Next Lib "kernel32" _
        (ByVal hSnapshot As Long, _
         lppe As PROCESSENTRY32) As Boolean

'/***** Thread walking **************************************************/

Public Type THREADENTRY32
    dwSize As Long
    cntUsage As Long
    th32ThreadID As Long        ' this thread
    th32OwnerProcessID As Long  ' process this thread is associated with
    tpBasePri As Long
    tpDeltaPri As Long
    dwFlags As Long
End Type

Public Declare Function Thread32First Lib "kernel32" _
        (ByVal hSnapshot As Long, _
         lpte As THREADENTRY32) As Boolean

Public Declare Function Thread32Next Lib "kernel32" _
        (ByVal hSnapshot As Long, _
         lpte As THREADENTRY32) As Boolean

'/***** Module walking *************************************************/

Public Type MODULEENTRY32
    dwSize As Long
    th32ModuleID As Long        ' this module
    th32ProcessID As Long       ' owning process
    GlblcntUsage As Long        ' global usage count on the module
    ProccntUsage As Long        ' module usage count in th32ProcessID's context
    modBaseAddr As Long         ' base address of module in th32ProcessID's context
    modBaseSize As Long         ' size in bytes of module starting at modBaseAddr
    hModule As Long             ' the hModule of this module in th32ProcessID's context
    szModule As String * MAX_MODULE_NAME32PLUS1
    szExePath As String * MAX_PATH
End Type

'//
'// NOTE CAREFULLY that the modBaseAddr and hModule fields are valid ONLY
'// in th32ProcessID's process context.
'//

Public Declare Function Module32First Lib "kernel32" _
        (ByVal hSnapshot As Long, _
         lpme As MODULEENTRY32) As Boolean
        
Public Declare Function Module32Next Lib "kernel32" _
        (ByVal hSnapshot As Long, _
         lpme As MODULEENTRY32) As Boolean
        

