Option Explicit

' Standard rectangle structure
Type RECT
   left As Integer
   top As Integer
   right As Integer
   bottom As Integer
End Type

' Win16 API calls
Declare Function SendMessage Lib "User" (ByVal hWnd As Integer, ByVal wMsg As Integer, ByVal wParam As Integer, lParam As Any) As Long
Declare Function GetWindow Lib "User" (ByVal hWnd As Integer, ByVal wCmd As Integer) As Integer
Declare Sub GetClientRect Lib "User" (ByVal hWnd As Integer, lpRect As RECT)
Declare Function GetDC Lib "User" (ByVal hWnd As Integer) As Integer
Declare Function CreateCompatibleDC Lib "GDI" (ByVal hDC As Integer) As Integer
Declare Function CreateCompatibleBitmap Lib "GDI" (ByVal hDC As Integer, ByVal nWidth As Integer, ByVal nHeight As Integer) As Integer
Declare Function ReleaseDC Lib "User" (ByVal hWnd As Integer, ByVal hDC As Integer) As Integer
Declare Function DeleteDC Lib "GDI" (ByVal hDC As Integer) As Integer
Declare Function GetSysColor Lib "User" (ByVal nIndex As Integer) As Long
Declare Function SelectObject Lib "GDI" (ByVal hDC As Integer, ByVal hObject As Integer) As Integer
Declare Function DeleteObject Lib "GDI" (ByVal hObject As Integer) As Integer
Declare Function CreateSolidBrush Lib "GDI" (ByVal crColor As Long) As Integer
Declare Function FillRect Lib "User" (ByVal hDC As Integer, lpRect As RECT, ByVal hBrush As Integer) As Integer
Declare Function BitBlt Lib "GDI" (ByVal hDestDC As Integer, ByVal x As Integer, ByVal Y As Integer, ByVal nWidth As Integer, ByVal nHeight As Integer, ByVal hSrcDC As Integer, ByVal XSrc As Integer, ByVal YSrc As Integer, ByVal dwRop As Long) As Integer


' BitBlt RasterOp constant
Global Const SRCCOPY = &HCC0020

' GetWindow constant to retrieve first child
Global Const GW_CHILD = 5

' System color constant for MDI background fill
Global Const COLOR_APPWORKSPACE = 12

Sub mdiBitBltCentered (Src As PictureBox, Dest As MDIForm, FillColor As Long)
   Dim nRet As Integer
   Dim dDC As Integer, dWnd As Integer, cDC As Integer
   Dim sR As RECT, dR As RECT
   Dim hBmp As Integer, oldBmp As Integer
   Dim hBrush As Integer
   Dim dX As Integer, dY As Integer
   '
   ' Get DC to client space
   '
   dWnd = GetWindow(Dest.hWnd, GW_CHILD)
   dDC = GetDC(dWnd)
   '
   ' Get source and destination rectangles
   '
   Call GetClientRect(Src.hWnd, sR)
   Call GetClientRect(dWnd, dR)
   '
   ' Create a memory bitmap to build image in
   '
   cDC = CreateCompatibleDC(dDC)
   hBmp = CreateCompatibleBitmap(dDC, dR.right, dR.bottom)
   oldBmp = SelectObject(cDC, hBmp)
   '
   ' Create new brush and paint background
   '
   hBrush = CreateSolidBrush(FillColor)
   nRet = FillRect(cDC, dR, hBrush)
   '
   ' Calc upper-left position parameters to place image
   '
   dX = (dR.right - sR.right) \ 2
   If dR.bottom > sR.bottom Then
      dY = (dR.bottom - sR.bottom) \ 3
   Else
      dY = (dR.bottom - sR.bottom) \ 2
   End If
   '
   ' BitBlt first to memory DC, then from memory to screen
   '
   nRet = BitBlt(cDC, dX, dY, sR.right, sR.bottom, Src.hDC, 0, 0, SRCCOPY)
   nRet = BitBlt(dDC, 0, 0, dR.right, dR.bottom, cDC, 0, 0, SRCCOPY)
   '
   ' and clean up
   '
   nRet = DeleteObject(hBrush)
   nRet = SelectObject(cDC, oldBmp)
   nRet = DeleteObject(hBmp)
   nRet = DeleteDC(cDC)
   nRet = ReleaseDC(dWnd, dDC)
End Sub

