VERSION 2.00
Begin Form Form1 
   BackColor       =   &H8000000F&
   Caption         =   "Clipboard Viewer"
   ClientHeight    =   5430
   ClientLeft      =   1200
   ClientTop       =   2160
   ClientWidth     =   7470
   Height          =   5835
   Left            =   1140
   LinkTopic       =   "Form1"
   ScaleHeight     =   5430
   ScaleWidth      =   7470
   Top             =   1815
   Width           =   7590
   Begin MsgHook MsgHook 
      Left            =   6210
      Top             =   225
   End
   Begin TextBox Text1 
      Height          =   1500
      Left            =   3645
      MultiLine       =   -1  'True
      TabIndex        =   1
      Text            =   "Text1"
      Top             =   90
      Visible         =   0   'False
      Width           =   2220
   End
   Begin PictureBox Picture1 
      Height          =   1500
      Left            =   90
      ScaleHeight     =   1470
      ScaleWidth      =   3090
      TabIndex        =   0
      Top             =   90
      Width           =   3120
   End
End
Option Explicit

' Note: ALWAYS stop this application via the control
'       window when running within the VB IDE!!!
'       Failure to do so will corrupt the clipboard
'       viewer chain.

' Static handle to next window in clipboard chain
Dim hWndNext As Integer

' Static var to hold current clipboard format
Dim ClipFmt As Integer

Sub Form_Load ()
   '
   ' Rearrange controls and form
   '
   Text1.Visible = False
   Text1.Text = ""
   Picture1.Visible = False
   Picture1.Top = Picture1.Left
   App.Title = Me.Caption
   '
   ' Install app in viewer chain
   '
   hWndNext = SetClipboardViewer(hWnd)
   '
   ' Setup MsgHook control
   '
   MsgHook.HwndHook = Me.hWnd
   MsgHook.Message(WM_CHANGECBCHAIN) = True
   MsgHook.Message(WM_DRAWCLIPBOARD) = True
   '
   ' Paint whatever's in the clipboard currently
   '
   UpdateClipView
End Sub

Sub Form_Resize ()
   '
   ' Adjust control positions
   '
   Picture1.Move Picture1.Left, Picture1.Top, Me.Width - 2 * Picture1.Left - (Me.Width - Me.ScaleWidth), Me.Height - 2 * Picture1.Top - (Me.Height - Me.ScaleHeight)
   Text1.Move Picture1.Left, Picture1.Top, Picture1.Width, Picture1.Height
   '
   ' If owner-drawn format, repaint it
   '
   If ClipFmt = CF_OWNERDISPLAY Then
      UpdateClipView
   End If
End Sub

Sub Form_Unload (Cancel As Integer)
   Dim nRet As Integer
   '
   ' Remove Me from the clipboard viewer chain.
   ' DO NOT stop execution from VB menu or toolbar!
   '
   nRet = ChangeClipboardChain(Me.hWnd, hWndNext)
End Sub

Sub MsgHook_Message (Msg As Integer, wParam As Integer, lParam As Long, Result As Long)
   Dim nRet As Long
   '
   ' Take appropriate action based on incoming message.
   '
   Select Case Msg
      Case WM_CHANGECBCHAIN
         '
         ' If the window being removed is the next window in the
         ' chain, the window specified by the hwndNext parameter
         ' becomes the next window and clipboard messages are
         ' passed on to it.
         '
         If wParam = hWndNext Then
            hWndNext = WordLo(lParam)
         End If
            
      Case WM_DRAWCLIPBOARD
         '
         ' Contents of clipboard have changed.
         ' Call routine to read.
         '
         UpdateClipView

   End Select
   '
   ' Each window that receives the either of these messages should
   ' call the SendMessage function to pass the message on to the
   ' next window in the clipboard-viewer chain.
   '
   nRet = SendMessage(hWndNext, WM_CHANGECBCHAIN, wParam, lParam)
   Result = 0
End Sub

Sub UpdateClipView ()
   
   ReDim PriorityList(0 To 20) As Integer
   Dim hWndOwner As Integer
   Dim nRet As Long
   Dim hGlb As Integer
   Dim rView As RECT
   Dim ps As PAINTSTRUCT

   PriorityList(0) = CF_TEXT
   PriorityList(1) = CF_BITMAP
   PriorityList(2) = CF_METAFILEPICT
   PriorityList(3) = CF_OEMTEXT
   PriorityList(4) = CF_DSPTEXT
   PriorityList(5) = CF_DSPBITMAP
   PriorityList(6) = CF_DSPMETAFILEPICT
   PriorityList(7) = CF_OWNERDISPLAY

   ClipFmt = GetPriorityClipboardFormat(PriorityList(0), 8)

   Select Case ClipFmt
      Case CF_TEXT, CF_OEMTEXT, CF_DSPTEXT
         Picture1.Visible = False
         Text1.Text = Clipboard.GetText()
         Text1.Visible = True
         Me.Caption = App.Title & ": CF_TEXT"
      Case CF_BITMAP, CF_DSPBITMAP
         Text1.Visible = False
         Picture1.Picture = Clipboard.GetData(CF_BITMAP)
         Picture1.Visible = True
         Me.Caption = App.Title & ": CF_BITMAP"
      Case CF_METAFILEPICT, CF_DSPMETAFILEPICT
         Text1.Visible = False
         Picture1.Picture = Clipboard.GetData(CF_METAFILEPICT)
         Picture1.Visible = True
         Me.Caption = App.Title & ": CF_METAFILEPICT"
      Case CF_OWNERDISPLAY
         Text1.Visible = False
         Call GetClientRect(Picture1.hWnd, rView)
         hGlb = GlobalAlloc(GMEM_FIXED Or GMEM_ZEROINIT, Len(rView))
         nRet = GlobalLock(hGlb)
         Call HMemCpy(nRet, rView, Len(rView))
         hWndOwner = GetClipboardOwner()
         nRet = SendMessage(hWndOwner, WM_SIZECLIPBOARD, Me.hWnd, ByVal MakeLong(0, hGlb))
         nRet = GlobalUnlock(hGlb)
         nRet = GlobalFree(hGlb)
         Picture1.Cls
         Picture1.Visible = True
         ps.hDC = Picture1.hDC
         ps.fErase = True
         ps.rcPaint = rView
         hGlb = GlobalAlloc(GMEM_FIXED Or GMEM_ZEROINIT, Len(ps))
         nRet = GlobalLock(hGlb)
         Call HMemCpy(nRet, ps, Len(ps))
         nRet = SendMessage(hWndOwner, WM_PAINTCLIPBOARD, Me.hWnd, ByVal MakeLong(0, hGlb))
         nRet = GlobalUnlock(hGlb)
         nRet = GlobalFree(hGlb)
         Me.Caption = App.Title & ": CF_OWNERDISPLAY"
      Case Else
         Text1.Visible = False
         Picture1.Visible = False
         Me.Caption = App.Title & ": No Supported Format"
   End Select
   
End Sub

