VERSION 2.00
Begin Form Form1 
   Caption         =   "Owner-Draw Menu Demo"
   ClientHeight    =   2880
   ClientLeft      =   4020
   ClientTop       =   3645
   ClientWidth     =   4470
   Height          =   3570
   Left            =   3960
   LinkTopic       =   "Form1"
   ScaleHeight     =   2880
   ScaleWidth      =   4470
   Top             =   3015
   Width           =   4590
   Begin MsgHook MsgHook 
      Left            =   120
      Top             =   120
   End
   Begin Menu mnuFile 
      Caption         =   "&File"
      Begin Menu mnuFileExit 
         Caption         =   "E&xit"
      End
   End
   Begin Menu mnuColor 
      Caption         =   "&Color"
      Begin Menu mnuColors 
         Caption         =   "<black>"
         Index           =   0
      End
      Begin Menu mnuColors 
         Caption         =   "<blue>"
         Index           =   1
      End
      Begin Menu mnuColors 
         Caption         =   "<green>"
         Index           =   2
      End
      Begin Menu mnuColors 
         Caption         =   "<cyan>"
         Index           =   3
      End
      Begin Menu mnuColors 
         Caption         =   "<red>"
         Index           =   4
      End
      Begin Menu mnuColors 
         Caption         =   "<magenta>"
         Index           =   5
      End
      Begin Menu mnuColors 
         Caption         =   "<yellow>"
         Index           =   6
      End
      Begin Menu mnuColors 
         Caption         =   "<white>"
         Index           =   7
      End
      Begin Menu mnuSep10 
         Caption         =   "-"
      End
      Begin Menu mnuColorDefault 
         Caption         =   "&Default"
      End
   End
End
Option Explicit

Sub Form_Load ()
    Dim hMenu As Integer
    Dim i As Integer, j As Integer
    Dim nID As Integer

    ' Get handle to "Colors" menu
    hMenu = GetMenu(Me.hWnd)
    hMenu = GetSubMenu(hMenu, 1)

    ' Modify commands to be owner-draw and to contain color info
    For i = 0 To 7
        ' Get menu ID
        j = GetMenuItemID(hMenu, i)
        ' Modify menu item (command ID is maintained)
        j = ModifyMenu(hMenu, j, MF_BYCOMMAND Or MF_OWNERDRAW, j, QBColor(8 + i))
    Next i

    ' Setup MsgHook
    MsgHook.HwndHook = Me.hWnd
    MsgHook.Message(WM_DRAWITEM) = True
    MsgHook.Message(WM_MEASUREITEM) = True

End Sub

Sub mnuColorDefault_Click ()
    ' Set background color
    BackColor = GetSysColor(COLOR_WINDOW)
End Sub

Sub mnuColors_Click (Index As Integer)
    ' Set background color
    BackColor = QBColor(8 + Index)
End Sub

Sub mnuFileExit_Click ()
    Unload Me
End Sub

Sub MsgHook_Message (msg As Integer, wParam As Integer, lParam As Long, result As Long)
    Dim tmp As Integer, rc As RECT
    Dim hBrush As Integer, hOldBrush As Integer
    Dim DrawInfo As DRAWITEMSTRUCT
    Dim MeasureInfo As MEASUREITEMSTRUCT

    Select Case msg

        Case WM_DRAWITEM
            If wParam = 0 Then  'If sent by menu
                ' Copy DRAWINFOSTRUCT data to local variable
                Call hmemcpy(DrawInfo, ByVal lParam, Len(DrawInfo))
                ' Paint area around color bar
                If DrawInfo.itemState And ODS_SELECTED Then
                    hBrush = CreateSolidBrush(GetSysColor(COLOR_HIGHLIGHT))
                Else
                    hBrush = CreateSolidBrush(GetSysColor(COLOR_MENU))
                End If
                rc = DrawInfo.rcItem
                tmp = FillRect(DrawInfo.hDC, rc, hBrush)
                tmp = DeleteObject(hBrush)
                ' Paint color bar
                tmp = (rc.bottom - rc.top) / 5
                Call InflateRect(rc, -tmp, -tmp)
                hBrush = CreateSolidBrush(DrawInfo.itemData)
                hOldBrush = SelectObject(DrawInfo.hDC, hBrush)
                tmp = Rectangle(DrawInfo.hDC, rc.left, rc.top, rc.right, rc.bottom)
                tmp = SelectObject(DrawInfo.hDC, hOldBrush)
                tmp = DeleteObject(hBrush)
            End If

        Case WM_MEASUREITEM
            ' Copy MEASUREITEMSTRUCT to local variable
            Call hmemcpy(MeasureInfo, ByVal lParam, Len(MeasureInfo))
            ' Tell Windows how big our owner-draw items are
            MeasureInfo.itemWidth = 70
            MeasureInfo.itemHeight = GetSystemMetrics(SM_CYMENU)
            ' Copy MEASUREITEMSTRUCT data back to Windows
            Call hmemcpy(ByVal lParam, MeasureInfo, Len(MeasureInfo))

        Case Else

    End Select

End Sub

