
Sub DisplayStatusWindow (WindowText As String)
    'Displays a bar graph during lengthy processes where an
    'hourglass mouse pointer would not be appropriate
    
    frmStatusDisplay.Show
    frmStatusDisplay.Caption = WindowText
End Sub

Sub RemoveStatusWindow ()
      'Removes progress bar graph.  This is done automatically
      'during updates when Progress reaches 100%.

    Unload frmStatusDisplay
End Sub

Sub UpdateStatusWindow (Progress As Single)
    'Updates progress bar graph using Progress as a
    'completion percentage.  Window closes when Progress
    'reaches 100%.
    'USAGE NOTES:
    '   Typically, this sub will be called by dividing two numbers
    '   and multiplying the results by 100.  For example:
    '           UpdateStatusWindow(ItemsProcessed/TotalItems*100)
    '   As a general rule, DO NOT multiply by 100 prior to the
    '   division like this:
    '           UpdateStatusWindow(100*ItemsProcessed/TotalItems)
    '   because if ItemsProcessed were defined as an integer, any value
    '   of ItemsProcessed greater than 327 will result in an intermediate
    '   result of a value greater than 32767, which is the maximum value
    '   for an integer.  This will probably cause the program to halt
    '   execution due to an overflow condition.   
    '   Developed by Jeff Trader, submitted by Rob Kraft 
    '   Send comments, questions, suggestions to RobKraft@aol.com
    '   This code is provided FREE   please distribute

    If Progress < 100 Then
        'prevent window thrashing, only change status when change > 2%
        If Progress - 2 > frmStatusDisplay.pnlStatusDisplay.FloodPercent Then
            frmStatusDisplay.pnlStatusDisplay.FloodPercent = Progress
        End If
    Else
        RemoveStatusWindow
    End If
End Sub

