Option Explicit
Declare Function GetPrivateProfileString Lib "Kernel" (ByVal AppName As String, ByVal KeyName As String, ByVal Default As String, ByVal ReturnedString As String, ByVal MaxSize As Integer, ByVal IniFileName As String) As Integer

' This is a simple demo to show how to access the default
' saver password. To use this in a Screen Saver you'll need
' to add the routines to check and change the password and
' save the encrypted password back to Control.Ini

' John Hayward. CIS 100034,320

Sub EncryptString (sArg As String)
Dim iArgPt As Integer
Dim iArgChar As Integer
Dim iArgLen As Integer

  iArgLen = Len(sArg)
  If iArgLen = 0 Then Exit Sub  ' Nothing to check
  sArg = UCase$(sArg)

' First Pass
  For iArgPt = 1 To iArgLen
    iArgChar = Asc(Mid$(sArg, iArgPt, 1))
    Call PassXor(iArgLen, iArgChar)
    If iArgPt = 1 Then
      Call PassXor(42, iArgChar)
    Else
      Call PassXor(iArgPt - 1, iArgChar)
      Call PassXor(Asc(Mid$(sArg, iArgPt - 1)), iArgChar)
    End If
    Mid$(sArg, iArgPt, 1) = Chr$(iArgChar)
  Next

' Second Pass
  If iArgLen > 1 Then
    For iArgPt = iArgLen To 1 Step -1
      iArgChar = Asc(Mid$(sArg, iArgPt, 1))
      Call PassXor(iArgLen, iArgChar)
      If iArgPt = iArgLen Then
        Call PassXor(42, iArgChar)
      Else
        Call PassXor(iArgPt - 1, iArgChar)
        Call PassXor(Asc(Mid$(sArg, iArgPt + 1, 1)), iArgChar)
      End If
    Mid$(sArg, iArgPt, 1) = Chr$(iArgChar)
    Next
  End If

End Sub

Function GetPassword () As String
Dim iret%
Dim PW As String * 25

  PW = Space$(25)
  iret% = GetPrivateProfileString("ScreenSaver", "Password", "", PW, 25, "Control.Ini")
  If iret% <= 0 Then
    MsgBox "Couldn't Read the Password"
    GetPassword = ""
  Else
    GetPassword = Left$(PW, iret%)
  End If

End Function

Sub PassXor (x1 As Integer, x2 As Integer)
 
  Select Case x2 Xor x1
    Case 0 To 32, 127 To 144, 147 To 159, 61, 91, 93
      ' not allowed
    Case Else
      x2 = x2 Xor x1
  End Select

End Sub

