/**************************************************************************************************

    SPELTEST
    Program to test spelling checker.

    Written and copyright by Brian J Quinion 1995.

    Version for Microsoft Windows.
    Version:  3.00
    Date:     13 July 1995
    Module:   ST-MAIN.C

**************************************************************************************************/

    /* include files common to all modules */
#define EXTERN
    #include "speltest.h"

    /* include files for this module only */
    #pragma  hdrstop
    /* NONE */

/***************************************************************************************************

    WinMain
    -------
    Main function for windows program

    Parameters : WinMain standard
    Called by  : Windows OS
    Calls      : 
    Modifies   : 
    Returns    : As standard

***************************************************************************************************/
#pragma argsused
int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
    HWND            hWnd;
    MSG             msg;

    if(hPrevInstance)
    {
	// Don't run another
	return FALSE;
    }

    // Make a copy of hInstance for global use
    g.hInst=hInstance;

    // Get the program path
    GetModuleFileName(g.hInst, g.szProgDir, MAXDIR);
    *(strrchr(g.szProgDir, '\\'))='\0';

    // Load settings
    LoadSettings();
    if (!LoadResources())
        return 0;

    // Start the main window
    RegisterSPELTEST_MAIN();
    hWnd=CreateWindow("SPELTEST_MAIN", "Spell Checker Tester", WS_OVERLAPPEDWINDOW, 10, 10, 400, 300,
                      NULL, NULL, g.hInst, NULL);
    ShowWindow(hWnd, SW_SHOW);

    // Enter the message loop
    while (GetMessage(&msg, (HWND) NULL, 0, 0))
    {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
    }

    // Save settings
    SaveSettings();
    FreeResources();

    return 0;
}

/***************************************************************************************************

	LoadSettings
	------------
	Load settings from the ini file and the dat file

	Parameters : none
	Called by  : WinMain
	Calls      : 
	Modifies   :
		o.SaveOptions		-
	Returns    :

***************************************************************************************************/
void LoadSettings(void)
{
}

/***************************************************************************************************

	SaveSettings
	------------
	Save settings to the ini file and the dat file

	Parameters : none
	Called by  : WinMain
	Calls      : 
	Modifies   : ini and dat files
	Returns    : nothing

***************************************************************************************************/
void SaveSettings(void)
{
}

/***************************************************************************************************

	LoadResources
	-------------
	Load resources, and initalise

	Parameters : none
	Called by  : WinMain
	Calls      : 
	Modifies   :
	Returns    :

***************************************************************************************************/
BOOL LoadResources(void)
{
    char            FileName[MAXPATH];
    // Load the checkedt module - done like this so that the program
    // could run without having the spelledt module available
    // Loading a Lib file in the project would result in an error
    // if the module was not available.

    // Get the path and try to load spellch3.dll
    GetPrivateProfileString("Modules", "spellch3", "spellch3.dll", FileName, MAXPATH, "Spelledt.ini");
    g.hModFull=LoadLibrary(FileName);
    if (g.hModFull<HINSTANCE_ERROR)
    {
        MessageBox(NULL, "Unable to load the module 'spellch3.dll'", "Spell setup", MB_ICONSTOP);
        return FALSE;
    }
    if (((FARPROC)g.LINK_SPCHK_Version=GetProcAddress(g.hModFull, "SPCHK_Version")) == NULL)
    {
        MessageBox(NULL, "Unable to find function 'SPCHK_Version' in module 'spellch3.dll'", "Spell setup", MB_ICONSTOP);
        FreeModule(g.hModFull);
        return FALSE;
    }
    if (g.LINK_SPCHK_Version()<300)
    {
        MessageBox(NULL, "Incorrect version of spellch3.dll", "Spell setup", MB_ICONSTOP);
        FreeModule(g.hModFull);
        return FALSE;
    }
    // Load the functions
    (FARPROC)g.LINK_SPCHK_CheckWord=GetProcAddress(g.hModFull, "SPCHK_CheckWord");
    (FARPROC)g.LINK_SPCHK_Options=GetProcAddress(g.hModFull, "SPCHK_Options");

    // Get the path and try to load spelledt.dll
    GetPrivateProfileString("Modules", "spelledt", "spelledt.dll", FileName, MAXPATH, "Spelledt.ini");
    g.hModQuick=LoadLibrary(FileName);
    if (g.hModQuick<HINSTANCE_ERROR)
    {
        MessageBox(NULL, "Unable to load the module 'spelledt.dll'", "Spell setup", MB_ICONSTOP);
        FreeModule(g.hModFull);
        return FALSE;
    }
    if (((FARPROC)g.LINK_SPEDT_Version=GetProcAddress(g.hModQuick, "SPEDT_Version")) == NULL)
    {
        MessageBox(NULL, "Unable to find function 'SPEDT_Version' in module 'spellch3.dll'", "Spell setup", MB_ICONSTOP);
        FreeModule(g.hModFull);
        FreeModule(g.hModQuick);
        return FALSE;
    }
    if (g.LINK_SPCHK_Version()<300)
    {
        MessageBox(NULL, "Incorrect version of spelledt.dll", "Spell setup", MB_ICONSTOP);
        FreeModule(g.hModFull);
        FreeModule(g.hModQuick);
        return FALSE;
    }

    (FARPROC)g.LINK_SPEDT_CheckEdit=GetProcAddress(g.hModQuick, "SPEDT_CheckEdit");
    (FARPROC)g.LINK_SPEDT_CheckEditCustom=GetProcAddress(g.hModQuick, "SPEDT_CheckEditCustom");
    (FARPROC)g.LINK_SPEDT_SetupBox=GetProcAddress(g.hModQuick, "SPEDT_SetupBox");
    (FARPROC)g.LINK_SPEDT_SetupBoxLimited=GetProcAddress(g.hModQuick, "SPEDT_SetupBoxLimited");
    (FARPROC)g.LINK_SPEDT_SetupCustom=GetProcAddress(g.hModQuick, "SPEDT_SetupCustom");
    (FARPROC)g.LINK_SPEDT_CheckGlobal=GetProcAddress(g.hModQuick, "SPEDT_CheckGlobal");
    (FARPROC)g.LINK_SPEDT_CheckGlobalCustom=GetProcAddress(g.hModQuick, "SPEDT_CheckGlobalCustom");

    return TRUE;
}

/***************************************************************************************************

	FreeResources
	-------------
	Free resources

	Parameters : none
	Called by  : WinMain
	Calls      : 
	Modifies   :
	Returns    :

***************************************************************************************************/
void FreeResources(void)
{
    FreeModule(g.hModFull);
    FreeModule(g.hModQuick);
}

/***************************************************************************************************

	WritePrivateProfileInt
	----------------------
	Suppliment function to GetPrivateProfileInt

	Parameters : 
	Called by  : 
	Calls      : 
	Modifies   :
	Returns    :

***************************************************************************************************/
BOOL WritePrivateProfileInt(LPSTR lpSection, LPSTR lpItem, DWORD Int, LPSTR lpFileName)
{
	char			Buffer[20];

	itoa((int)Int, Buffer, 10);
	return WritePrivateProfileString(lpSection, lpItem, (LPSTR)Buffer, lpFileName);
}
