Attribute VB_Name = "Shell"

'************************************************************************************************************
'  PROCESS STUFF
'************************************************************************************************************
Public Const PROCESS_QUERY_INFORMATION = &H400
Public Const PROCESS_TERMINATE = &H1
Public Const STILL_ACTIVE = &H103
'THE REMAINING CONSTANTS FOUND IN WINNT.H

Public Declare Function OpenProcess Lib "kernel32" (ByVal dwDesiredAccess&, ByVal bInheritHandle&, ByVal dwProcessId&) As Long
Public Declare Function GetExitCodeProcess Lib "kernel32" (ByVal hProcess As Long, lpExitCode As Long) As Long
Declare Function TerminateProcess Lib "kernel32" (ByVal hProcess As Long, ByVal uExitCode As Long) As Long


Sub ShellAndWait(strApp As String)
'***********************************************************************************************
' PURPOSE:      to shell to an app, wait for it to finish and then come back
'               only a 32 bit app.  Do not use TerminateProcess for app that loads .dlls but works
'               great for virtual dos sessons.

' EFFECTS:      the app shelled to and program execution here
' INPUTS:       the path and file name to the shelled app
' RETURNS:      Nothing
' CALLED FROM:
' AUTHOR DATE:  BruceJackson 10/95
'***********************************************************************************************
On Error GoTo ShellAndWait_Err
Dim lngShellReturn As Long
Dim lngOpenProcess As Long
Dim lngExit As Long
Dim lngTimer As Long
Dim msg As String
Const NOWINDOW = 0
Const WINDOWED = 1
Dim r
'***********************************************************************************************
    lngShellReturn = Shell(strApp, WINDOW)                 ' OPENS WITH WINDOW, USE NOWINDOW FOR HIDDEND
    lngTimer = Timer
    lngOpenProcess = OpenProcess(PROCESS_QUERY_INFORMATION + PROCESS_TERMINATE, False, lngShellReturn)
Back:
    Call GetExitCodeProcess(lngOpenProcess, lngExit)
    If lngExit = STILL_ACTIVE Then
        If Timer - lngTimer > 120 Then                                         ' only wait for two minutes
            msg = "An application has timed out!" & vbCrLf
            msg = msg & "The path and file name to the batch file is: " & strApp
            ' can also use ExitProcess
            r = TerminateProcess(lngOpenProcess, lngExit)                      ' FOR DOS APPS THAT DON'T CALL DLLS ONLY
            MsgBox msg, 64, "Time Out Error"
            Exit Sub
        End If
        If lngTimer > Timer Then lngTimer = Timer                              ' adjust after midnight
        DoEvents
        GoTo Back
    End If
'***********************************************************************************************
ShellAndWait_bye:
    Exit Sub
ShellAndWait_Err:
    MsgBox "ERROR: " & Error$ & Chr$(13) & Chr$(10) & "ERR#:  " & Err, 64, "ShellAndWait"
    GoTo ShellAndWait_bye
End Sub

