Declare Sub SortL Lib "QPRO200.DLL" (Array&, ByVal NumEls%, ByVal Direction%)

Global Array_A(1 To 10) As Long
Global Array_B(1 To 10) As Long
Global Array_C() As Long

Global A_Size As Long
Global B_Size As Long
Global C_Size As Long   ' needed to avoid subscript out of range error if the array is null

Sub DeDup ()

   Dim n As Long
   Dim i As Long

   ' when a dup is encountered, pull the elements down
   ' a notch
   
   For n = 1 To UBound(Array_C) - 1
      
      If Array_C(n + 1) = Array_C(n) Then

         For i = n + 1 To UBound(Array_C) - 1
            Array_C(i) = Array_C(i + 1)
         Next i

      End If

   Next n

   ' so far, the trailing elements can be a series of dups
   ' work backward from the end of the array to find where
   ' the series of dups ends, then cut off the trailing dups
   
   For n = UBound(Array_C) To 1 Step -1
   
      If Array_C(n - 1) <> Array_C(n) Then
      
         ReDim Preserve Array_C(1 To n)
         Exit For

      End If
   
   Next n

End Sub

Sub Difference ()
   
   ' amounts to "A and not B"

   Dim n As Long
   Dim i As Long
   Dim j As Long
   Dim found As Integer

   A_Size = UBound(Array_A)
   B_Size = UBound(Array_B)

   ' sort the arrays to optimize overall speed of
   ' comparison

   SortL Array_A(1), A_Size, 0
   SortL Array_B(1), B_Size, 0
   ' Crescent QuickPak Professional long integer sort routine
   ' Array_C(1) means begin sorting a element 1
   ' A_Size, B_Size means sort to the element so indicated
   ' 0 means sort in ascending order

   ' make room in a third array for all the elements
   ' of the two input arrays
   
   ReDim Array_C(1 To A_Size + B_Size) As Long

   ' compare elements and add common values to the
   ' intersection array
   
   For n = 1 To A_Size
      
      For i = 1 To B_Size

         If Array_B(i) = Array_A(n) Then
            found = 1
            Exit For                         ' exiting For works because both
         End If                              ' arrays are sorted, saves
                                             ' comparison time
      Next i
   
      If found = 0 Then
         j = j + 1
         Array_C(j) = Array_A(n)
      End If
      found = 0

   Next n

   ReDim Preserve Array_C(1 To j)

   C_Size = j

End Sub

Sub Intersection ()
   
   ' amounts to "A or B"

   Dim n As Long
   Dim i As Long
   Dim j As Long

   A_Size = UBound(Array_A)
   B_Size = UBound(Array_B)

   ' sort the arrays to optimize overall speed of
   ' comparison

   SortL Array_A(1), A_Size, 0
   SortL Array_B(1), B_Size, 0
   ' Crescent QuickPak Professional long integer sort routine
   ' Array_C(1) means begin sorting a element 1
   ' A_Size, B_Size means sort to the element so indicated
   ' 0 means sort in ascending order

   ' make room in a third array for all the elements
   ' of the two input arrays
   
   ReDim Array_C(1 To A_Size + B_Size) As Long

   ' compare elements and add common values to the
   ' intersection array
   
   For n = 1 To A_Size
      
      For i = 1 To B_Size

         If Array_B(i) > Array_A(n) Then Exit For     ' exiting for works
                                                      ' because both arrays
         If Array_B(i) = Array_A(n) Then              ' are sorted, and saves
            j = j + 1                                 ' comparison time
            Array_C(j) = Array_A(n)
            Exit For
         End If

      Next i
   
   Next n

   ReDim Preserve Array_C(1 To j)

   C_Size = j

End Sub

Sub SeedArrays ()

   Array_A(1) = 1
   Array_A(2) = 3
   Array_A(3) = 5
   Array_A(4) = 7
   Array_A(5) = 11
   Array_A(6) = 13
   Array_A(7) = 17
   Array_A(8) = 19
   Array_A(9) = 23
   Array_A(10) = 31

   Array_B(1) = 3
   Array_B(2) = 4
   Array_B(3) = 7
   Array_B(4) = 9
   Array_B(5) = 17
   Array_B(6) = 20
   Array_B(7) = 30
   Array_B(8) = 35
   Array_B(9) = 41
   Array_B(10) = 44

End Sub

Sub Union ()

   ' amounts to "A or B"

   Dim n As Long
   Dim i As Long

   A_Size = UBound(Array_A)
   B_Size = UBound(Array_B)

   ' make room in a third array for all the elements
   ' of the two input arrays
   
   ReDim Array_C(1 To A_Size + B_Size) As Long

   ' add the elements of the first array to the third
   
   For n = 1 To A_Size
      Array_C(n) = Array_A(n)
   Next n

   'add the elements of the second array to the third
   
   For n = A_Size + 1 To A_Size + B_Size
      i = i + 1
      Array_C(n) = Array_B(i)
   Next n

   ' sort the third array in preparation for deduping

   SortL Array_C(1), A_Size + B_Size, 0
   ' Crescent QuickPak Professional long integer sort routine
   ' Array_C(1) means begin sorting a element 1
   ' A_Size + B_Size means sort to the element so indicated
   ' 0 means sort in ascending order

   DeDup

End Sub

