{********************************************}
{*                                          *}
{* SELECT25.PAS generated from SELECT25.VBX *}
{*                                          *}
{********************************************}

unit Select25;

interface

uses SysUtils, Classes, Graphics, Forms, Controls, VBXCtrl, BIVBX;

{ $DEFINE InitTSelector}
{^- Remove space to enable default init data -- See documentation. }

type
  TSelectorChangeEvent = procedure (Sender: TObject) of object;

  { TSelector }

  TSelector = class(TVBXControl)
  protected
    FOnChange: TSelectorChangeEvent;
    { Event handler }
    procedure HandleVBXEvent(var Message: TWMVBXFireEvent); override;
    procedure DefineProperties(Filer: TFiler); override;
  public
    constructor Create(AOwner: TComponent); override;

    property Index: TVBInteger index 0 read GetIntProp;
    property FontName: TVBString index 13 read GetStringProp write
      SetStringProp;
    property FontBold: Boolean index 14 read GetBoolProp write SetBoolProp;
    property FontItalic: Boolean index 15 read GetBoolProp write SetBoolProp;
    property FontStrikethru: Boolean index 16 read GetBoolProp write
      SetBoolProp;
    property FontUnderline: Boolean index 17 read GetBoolProp write
      SetBoolProp;
    property FontSize: Single index 18 read GetSingleProp write SetSingleProp;
    property AVersion: Single index 19 read GetSingleProp write SetSingleProp;
    property ZLoad: TVBInteger index 20 read GetIntProp;
    property Angle: Single index 39 read GetSingleProp write SetSingleProp;
    property XScale: Single index 40 read GetSingleProp write SetSingleProp;
    property YScale: Single index 41 read GetSingleProp write SetSingleProp;
    property Radius: Single index 42 read GetSingleProp write SetSingleProp;
  published
    property Enabled;
    property Visible;
    property MousePointer: TVBEnum index 8 read GetEnumProp write SetEnumProp
      default 0;
    property TabOrder;
    property TabStop;
    property About: TVBString index 21 read GetStringProp {NoRT}write
      SetStringProp stored False;
    property BorderType: TVBEnum index 22 read GetEnumProp write SetEnumProp;
    property BevelWidth: TVBInteger index 23 read GetIntProp write SetIntProp;
    property BevelInner: TVBEnum index 24 read GetEnumProp write SetEnumProp;
    property BevelOuter: TVBEnum index 25 read GetEnumProp write SetEnumProp;
    property BorderWidth: TVBInteger index 26 read GetIntProp write
      SetIntProp;
    property OutlineTitle: TVBString index 27 read GetStringProp write
      SetStringProp;
    property OutlineColor: TColor index 28 read GetColorProp write
      SetColorProp;
    property OutlineWidth: TVBInteger index 29 read GetIntProp write
      SetIntProp;
    property OutlineAlign: TVBEnum index 30 read GetEnumProp write
      SetEnumProp;
    property FrameStyle: TVBEnum index 31 read GetEnumProp write SetEnumProp;
    property FrameScaleX: Single index 32 read GetSingleProp write
      SetSingleProp;
    property FrameScaleY: Single index 33 read GetSingleProp write
      SetSingleProp;
    property FrameColor: TColor index 34 read GetColorProp write SetColorProp;
    property FramePicture: TVBPic index 35 read GetPictureProp write
      SetPictureProp stored False;
    property BackgroundColor: TColor index 36 read GetColorProp write
      SetColorProp;
    property BackgroundPicture: TVBPic index 37 read GetPictureProp write
      SetPictureProp stored False;
    property MouseControl: Boolean index 38 read GetBoolProp write
      SetBoolProp;
    property AutoAlign: Boolean index 43 read GetBoolProp write SetBoolProp;
    property AutoAngle: Boolean index 44 read GetBoolProp write SetBoolProp;
    property AutoOffset: Boolean index 45 read GetBoolProp write SetBoolProp;
    property AutoOffsetStyle: TVBEnum index 46 read GetEnumProp write
      SetEnumProp;
    property AutoOffsetDistance: Single index 47 read GetSingleProp write
      SetSingleProp;
    property AutoStartAngle: Single index 48 read GetSingleProp write
      SetSingleProp;
    property AutoStopAngle: Single index 49 read GetSingleProp write
      SetSingleProp;
    property AutoRadius: Single index 50 read GetSingleProp write
      SetSingleProp;
    property LineDisplay: Boolean index 51 read GetBoolProp write SetBoolProp;
    property LineInnerRadius: Single index 52 read GetSingleProp write
      SetSingleProp;
    property LineThickness: TVBInteger index 53 read GetIntProp write
      SetIntProp;
    property Selections: TVBInteger index 54 read GetIntProp write SetIntProp
      stored False;
    property SelectionID: TVBInteger index 55 read GetIntProp write
      SetIntProp stored False;
    property SelectionCaption: TVBString index 56 read GetStringProp write
      SetStringProp stored False;
    property SelectionAlign: TVBEnum index 57 read GetEnumProp write
      SetEnumProp stored False;
    property SelectionOffsetX: Single index 58 read GetSingleProp write
      SetSingleProp stored False;
    property SelectionOffsetY: Single index 59 read GetSingleProp write
      SetSingleProp stored False;
    property SelectionRadius: Single index 60 read GetSingleProp write
      SetSingleProp stored False;
    property SelectionColor: TColor index 61 read GetColorProp write
      SetColorProp stored False;
    property SelectionAngle: Single index 62 read GetSingleProp write
      SetSingleProp stored False;
    property SelectionFontID: TVBInteger index 63 read GetIntProp write
      SetIntProp stored False;
    property Captions: TVBInteger index 64 read GetIntProp write SetIntProp
      stored False;
    property CaptionID: TVBInteger index 65 read GetIntProp write SetIntProp
      stored False;
    property Caption: TVBString index 66 read GetStringProp write
      SetStringProp stored False;
    property CaptionX: Single index 67 read GetSingleProp write SetSingleProp
      stored False;
    property CaptionY: Single index 68 read GetSingleProp write SetSingleProp
      stored False;
    property CaptionColor: TColor index 69 read GetColorProp write
      SetColorProp stored False;
    property CaptionFontID: TVBInteger index 70 read GetIntProp write
      SetIntProp stored False;
    property KnobStyle: TVBEnum index 71 read GetEnumProp write SetEnumProp;
    property KnobUserDefined: TVBString index 72 read GetStringProp write
      SetStringProp;
    property KnobRadius: Single index 73 read GetSingleProp write
      SetSingleProp;
    property KnobOriginX: Single index 74 read GetSingleProp write
      SetSingleProp;
    property KnobOriginY: Single index 75 read GetSingleProp write
      SetSingleProp;
    property KnobColor: TColor index 76 read GetColorProp write SetColorProp;
    property Value: TVBInteger index 77 read GetIntProp write SetIntProp;
    property MarkStyle: TVBEnum index 78 read GetEnumProp write SetEnumProp
      stored False;
    property MarkUserDefined: TVBString index 79 read GetStringProp write
      SetStringProp;
    property MarkColor: TColor index 80 read GetColorProp write SetColorProp
      stored False;
    property MarkInnerRadius: Single index 81 read GetSingleProp write
      SetSingleProp stored False;
    property MarkOuterRadius: Single index 82 read GetSingleProp write
      SetSingleProp stored False;
    property MarkWidth: Single index 83 read GetSingleProp write
      SetSingleProp stored False;
    property Highlight: Boolean index 84 read GetBoolProp write SetBoolProp;
    property HighlightColor: TColor index 85 read GetColorProp write
      SetColorProp;
    property FontID: TVBInteger index 86 read GetIntProp write SetIntProp;
    property Fonts: TVBInteger index 87 read GetIntProp write SetIntProp
      stored False;
    property FontDialog_: TVBString index 88 read GetStringProp {NoRT}write
      SetStringProp stored False;
    property AutoAngleConfine: Boolean index 89 read GetBoolProp write
      SetBoolProp;
    property OnClick;
    property OnEnter;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnExit;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnChange: TSelectorChangeEvent read FOnChange write FOnChange;
  end;

procedure Register;

implementation

{ Default form data for TSelector }

{$IFDEF InitTSelector}

const
  TSelectorInitLen = 565;

procedure TSelectorInitData; near; assembler;
asm
	DB	$00,$00,$00,$02,$06,$FF,$FF,$07,$FF,$FF,$08,$00,$09,$00,$00,$0A
	DB	$00,$00,$0B,$00,$0C,$08,$53,$65,$6C,$65,$63,$74,$6F,$72,$13,$00
	DB	$00,$00,$00,$14,$00,$00,$04,$00,$00,$00,$00,$00,$00,$00,$00,$00
	DB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$41,$00
	DB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	DB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	DB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	DB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	DB	$00,$00,$00,$00,$00,$00,$00,$00,$42,$00,$00,$00,$00,$00,$00,$00
	DB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	DB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	DB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	DB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	DB	$00,$00,$43,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	DB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	DB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	DB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	DB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$44,$00,$00,$00
	DB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	DB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	DB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	DB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	DB	$00,$00,$00,$00,$00,$00,$01,$00,$10,$00,$07,$00,$00,$00,$00,$00
	DB	$BC,$02,$00,$00,$00,$00,$01,$02,$02,$22,$53,$79,$73,$74,$65,$6D
	DB	$00,$65,$77,$20,$52,$6F,$6D,$61,$6E,$00,$20,$00,$11,$00,$00,$00
	DB	$00,$00,$90,$01,$00,$00,$53,$79,$6D,$62,$16,$01,$17,$02,$00,$18
	DB	$01,$19,$02,$1A,$02,$00,$1B,$00,$1C,$00,$00,$00,$00,$1D,$00,$00
	DB	$1E,$00,$1F,$00,$20,$00,$00,$00,$00,$21,$00,$00,$00,$00,$22,$00
	DB	$00,$00,$00,$24,$C0,$C0,$C0,$00,$26,$FF,$FF,$27,$00,$00,$00,$00
	DB	$28,$00,$00,$00,$00,$29,$00,$00,$00,$00,$2A,$00,$00,$00,$00,$2B
	DB	$FF,$FF,$2C,$FF,$FF,$2D,$FF,$FF,$2E,$01,$2F,$00,$00,$80,$3F,$30
	DB	$00,$00,$52,$43,$31,$00,$00,$A5,$43,$32,$CD,$CC,$4C,$3F,$33,$FF
	DB	$FF,$34,$CD,$CC,$CC,$3E,$35,$01,$00,$47,$02,$48,$00,$49,$9A,$99
	DB	$19,$3F,$4A,$00,$00,$00,$00,$4B,$00,$00,$00,$00,$4C,$80,$80,$80
	DB	$00,$4D,$00,$00,$4F,$00,$54,$00,$00,$55,$00,$00,$00,$00,$56,$00
	DB	$00,$59,$00,$00,$FF
end;

{$ENDIF}

{ TSelector }

constructor TSelector.Create(AOwner: TComponent);
begin
  FVBXFile := StrNew('SELECT25.VBX');
  FVBXClass := StrNew('SELECTOR');
  SetBounds(0, 0, 80, 32);
  inherited Create(AOwner);
  ControlStyle := ControlStyle - [csCaptureMouse, csClickEvents];
  TabStop := True;
  {$IFDEF InitTSelector}
  FHForm := VBXCreateFormFile(TSelectorInitLen, @TSelectorInitData);
  {$ENDIF}
end;

procedure TSelector.HandleVBXEvent(var Message: TWMVBXFireEvent);
begin
  case Message.VBXEvent^.EventIndex of
    0: DispatchNotifyEvent(OnClick);
    1: begin end; { VCL Handles OnGotFocus }
    2: DispatchKeyEvent(OnKeyDown, Message);
    3: DispatchKeyPressedEvent(OnKeyPress, Message);
    4: DispatchKeyEvent(OnKeyUp, Message);
    5: begin end; { VCL Handles OnLostFocus }
    6: DispatchMouseEvent(OnMouseDown, Message);
    7: DispatchMouseMoveEvent(OnMouseMove, Message);
    8: DispatchMouseEvent(OnMouseUp, Message);
    9: DispatchCustomEvent(FOnChange, Message, 9);
  end;
end;

procedure TSelector.DefineProperties(Filer: TFiler);
begin
  inherited DefineProperties(Filer);
  HandleProperty('AVersion', Filer, 19);
  HandleBinaryProperty('ZLoad', Filer, 20);
  HandleBinaryProperty('FramePicture_Data', Filer, 35);
  HandleBinaryProperty('BackgroundPicture_Data', Filer, 37);
  HandleProperty('Angle', Filer, 39);
  HandleProperty('XScale', Filer, 40);
  HandleProperty('YScale', Filer, 41);
  HandleProperty('Radius', Filer, 42);
end;

{ Designer registration }
procedure Register;
begin
  RegisterComponents('VBX', [
    TSelector]);
end;

end.
