VERSION 2.00
Begin Form Form1 
   Caption         =   "Find Directories"
   ClientHeight    =   6315
   ClientLeft      =   1095
   ClientTop       =   1770
   ClientWidth     =   6990
   Height          =   7005
   Left            =   1035
   LinkTopic       =   "Form1"
   ScaleHeight     =   6315
   ScaleWidth      =   6990
   Top             =   1140
   Width           =   7110
   Begin TextBox Text1 
      Height          =   360
      Left            =   465
      TabIndex        =   1
      Text            =   "Text1"
      Top             =   1305
      Width           =   2295
   End
   Begin CommandButton Command1 
      Caption         =   "&Search"
      Default         =   -1  'True
      Height          =   510
      Left            =   4560
      TabIndex        =   2
      Top             =   1155
      Width           =   1860
   End
   Begin ListBox List1 
      Height          =   3930
      Left            =   480
      Sorted          =   -1  'True
      TabIndex        =   0
      Top             =   1755
      Width           =   5940
   End
   Begin Label Label2 
      Height          =   885
      Left            =   495
      TabIndex        =   4
      Top             =   105
      Width           =   5955
   End
   Begin Label Label1 
      Caption         =   "Label1"
      Height          =   315
      Left            =   495
      TabIndex        =   3
      Top             =   5820
      Width           =   5355
   End
   Begin Menu mnuExit 
      Caption         =   "&Exit"
   End
End
Const ATTR_DIRECTORY = 16
Const ATTR_HIDDEN = 2

Dim directories$()
Dim Index%

Sub Command1_Click ()

    'Start fresh
    List1.Clear
    Erase directories$
    Index% = 0

    Label1 = "Searching...Please Wait."
    
    'Change cursor to hourglass
    Screen.MousePointer = 11

    'Start the search
    SearchDir

    'change cursor back to default
    Screen.MousePointer = 0
End Sub

Sub Form_Load ()

    Text1 = "C:\VB"
    Label1 = ""
    msg$ = "Type in desired directory and press ENTER.  "
    msg$ = msg$ + "The program will then list all subdirectories under "
    msg$ = msg$ + "the specified directory.  For example, to list ALL "
    msg$ = msg$ + "subdirectories on the hard drive, type ""C:\"""
    Label2 = msg$

    Me.Show
    Text1.SelStart = 0
    Text1.SelLength = Len(Text1)
    Text1.SetFocus

End Sub

Sub Form_Unload (Cancel As Integer)

    End

End Sub

Sub ListSubDirs (Path$)

'local variable to store the number of directories found in each call to this sub
Dim Count%

'local array to store the directory names found in each call to this sub
Dim Direct$()

Dim I%
Dim DirName$

On Error GoTo SubDirsError

    DoEvents
    
    'Get the first directory name
    DirName$ = Dir(Path$ & "\", ATTR_DIRECTORY + ATTR_HIDDEN)' Get first directory name.
    
    'repeatedly go through PATH$
    Do While (DirName$ <> "") And (ErrorOccured <> True)
        If DirName$ <> "." And DirName$ <> ".." Then
            If (GetAttr(Path$ & "\" & DirName$) And ATTR_DIRECTORY) = ATTR_DIRECTORY Then
                'Increment counter
                Count% = Count% + 1
                
                'Resize the array.
                ReDim Preserve Direct$(Count%)
                
                'Assign directory to local array
                Direct$(Count%) = DirName$
                
                'Increment total number of directories found
                Index% = Index% + 1
                
                'Resize array
                ReDim Preserve directories$(Index%)
                
                'Assign path and directory to modular-scope array
                directories$(Index%) = Path$ + "\" + DirName$
            End If
        End If
        DirName$ = Dir$   ' Get next directory name.
    Loop
    
    ' Now recursively iterate through each subdirectory.
    I% = 1
    While (I% <= Count%) And (Not ErrorOccured)
        Call ListSubDirs(Path$ & "\" & Direct$(I%))
        I% = I% + 1
    Wend
    

    
    Exit Sub

SubDirsError:

    MsgBox "Error reading subdirectories", 48
    ErrorOccured = True
    Exit Sub

End Sub

Sub mnuExit_Click ()
    Unload Me
End Sub

Sub SearchDir ()
Dim InitialDir$, I%
On Error Resume Next
    
    'Change to the specified directory
    InitialDir$ = Text1
    ChDir InitialDir$
    If Err Then
        Label1 = ""
        msg$ = "Invalid Directory"
        MsgBox msg$, 48
        Text1.SetFocus
        Exit Sub
    End If

    'Remove any trailing backslash
    If Right$(InitialDir$, 1) = "\" Then
        InitialDir$ = Left$(InitialDir$, Len(InitialDir$) - 1)
    End If
    
    'Recursively go through the directory tree structure
    Call ListSubDirs(InitialDir$)

    For I% = 1 To Index%
        List1.AddItem UCase$(directories$(I%))
    Next I%
    
    Label1 = "# of Subdirectories = " & Str$(Index%)
End Sub

