Option Explicit

Declare Function locking_open Lib "reclock.dll" (ByVal filename$, ByVal nTables%, ByVal nRecs%) As Integer
Declare Function locking_close Lib "reclock.dll" () As Integer
Declare Sub locking_resetAll Lib "reclock.dll" ()
Declare Sub locking_resetUser Lib "reclock.dll" (ByVal user$)
Declare Function locking_err Lib "reclock.dll" () As Integer

Declare Function locking_lock Lib "reclock.dll" (ByVal tableNo%, ByVal oid$, ByVal user$, ByVal timeout&) As Integer
Declare Function locking_unlock Lib "reclock.dll" (ByVal tableNo%, ByVal oid$) As Integer
Declare Function locking_isLocked Lib "reclock.dll" (ByVal tableNo%, ByVal oid$) As Integer

Declare Sub sysLocking_lockedBy Lib "reclock.dll" Alias "locking_lockedBy" (ByVal tableNo%, ByVal oid$, ByVal user$, userBufLen%, ByVal timestamp$, timestampBufLen%)

Sub locking_lockedBy (ByVal tableNo%, ByVal oid$, user$, timestamp$)
    Const USER_LEN = 20
    Const TIMESTAMP_LEN = 20
    Dim userLen%, timestampLen%, d%

    userLen = USER_LEN: timestampLen = TIMESTAMP_LEN
    user = String(USER_LEN, " "): timestamp = String(TIMESTAMP_LEN, " ")

    sysLocking_lockedBy tableNo, oid, user, userLen, timestamp, timestampLen

    If userLen = 0 Then
        user = ""
    Else
        user = Left$(user, userLen)
    End If

    If timestampLen = 0 Then
        timestamp = ""
    Else
        timestamp = Left$(timestamp, timestampLen)
    End If
End Sub

