VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "RGBColor"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
'-- RGBColor Class
'-- Copyright  1995-1996 Gregg Irwin. All Rights Reserved

Option Explicit
DefInt A-Z

#If Win16 Then
    Private Declare Function GetNearestColor Lib "gdi" (ByVal hDC As Integer, ByVal RGBColor As Long) As Long
    Private Declare Function GetSysColor Lib "user" (ByVal nIndex As Integer) As Long
#ElseIf Win32 Then
    Private Declare Function GetNearestColor Lib "gdi32" (ByVal hDC As Long, ByVal RGBColor As Long) As Long
    Private Declare Function GetSysColor Lib "user32" (ByVal nIndex As Long) As Long
#End If


'-- We can't use the Type def's in our public interface functions
'   where they would be most useful, and we don't need them for
'   any internal functions, so they're just here as documentation
'   of the API Type structure.

'Private Type T_RGBQuad
'    Blue    As Byte
'    Green   As Byte
'    Red     As Byte
'    Rsvd    As Byte
'End Type
'
'Private Type T_RGBTriple
'    Blue    As Byte
'    Green   As Byte
'    Red     As Byte
'End Type

Const COLOR_DEFBITON = &H80000000    ' bit set -> Win SysColor, not RGB

Private mValue As Long     ' Color value

'* PROPERTIES   *
' .BlueValue
' .GreenValue
' .RedValue
' .Value

'* METHODS      *
' .AsHexString
' .AsRgbQuad
' .AsRGBString
' .AsRgbTriple
' .FromHexString
' .FromRGBString
' .NearestSolidColor


'---------------------------------------------------
'-- PROPERTIES
'---------------------------------------------------

' .BlueValue
Public Property Let BlueValue(B As Integer)

    Call SetBValue(B)

End Property

Public Property Get BlueValue() As Integer

    BlueValue = GetBValue(Value)

End Property


' .GreenValue
Public Property Let GreenValue(G As Integer)

    Call SetGValue(G)

End Property

Public Property Get GreenValue() As Integer

    GreenValue = GetGValue(Value)

End Property


' .RedValue
Public Property Let RedValue(R As Integer)

    Call SetRValue(R)

End Property

Public Property Get RedValue() As Integer

    RedValue = GetRValue(Value)

End Property


' .Value
Public Property Let Value(NewColor As Long)
    
    '-- If the high bit is set then it's a system color
    If NewColor And COLOR_DEFBITON Then
        mValue = GetSysColor(NewColor And &HFFFFFF)
    Else
        mValue = NewColor
    End If
    
End Property

Public Property Get Value() As Long
    
    Value = mValue
    
End Property


'---------------------------------------------------
'-- METHODS
'---------------------------------------------------

' .AsHexString
Public Function AsHexString() As String

    AsHexString = Hex$(Value)

End Function


' .AsRgbQuad
Public Function AsRGBQuad() As Variant

    '-- We can't use a Type in a public interface so
    '   we return the 4 bytes in an array.
    AsRGBQuad = Array(CByte(BlueValue), _
                      CByte(GreenValue), _
                      CByte(RedValue), _
                      CByte(0))

End Function

' .AsRGBString
Public Function AsRGBString() As String

    AsRGBString = RGBStrFromColor(Value)
    
End Function


' .AsRgbTriple
Public Function AsRGBTriple() As Variant

    '-- We can't use a Type in a public interface so
    '   we return the 3 bytes in an array.
    AsRGBTriple = Array(CByte(BlueValue), _
                        CByte(GreenValue), _
                        CByte(RedValue))

End Function


' .FromHexString
Public Sub FromHexString(HexStr As String)

    Value = ColorFromHexStr(HexStr)

End Sub


' .FromRGBString
Public Sub FromRGBString(RGBStr As String)

    Value = ColorFromRGBStr(RGBStr)

End Sub


' .NearestSolidColor
Public Function NearestSolidColor(hDC As Long) As Long

    NearestSolidColor = GetNearestColor(hDC, Value)
    
End Function


'------------------------------------------------
'-- INTERNAL SUPPORT PROCEDURES
'------------------------------------------------

' .ColorFromHexStr
Private Function ColorFromHexStr(ByVal HexStr As String) As Long
    Dim tmpColor As Long
    
    '-- Prepend hex identifier if necessary (Val requires this)
    If Left$(UCase$(HexStr), 2) <> "&H" Then
        HexStr = "&H" & HexStr
    End If
    
    '-- Append trailing ampersand so value is cast to a long.
    '   This prevents overflow errors from the Val function.
    If Right(HexStr, 1) <> "&" Then
        HexStr = HexStr & "&"
    End If

    '-- This isn't necessarily a real color value yet. It could be
    '   a system color. Converting it at this point lets us check
    '   the value to see if the high bit is set, indicating that
    '   it's a system color.
    tmpColor = Val(HexStr)

    '-- If the high bit is set then it's a system color,
    '   otherwise it's an RGB value.
    If tmpColor And COLOR_DEFBITON Then
        ColorFromHexStr = GetSysColor(tmpColor And &HFFFFFF)
    Else
        ColorFromHexStr = tmpColor
    End If

End Function


' .ColorFromRGBStr
Private Function ColorFromRGBStr(RGBStr As String) As Long
'------------------------------------------------
'-- Acceptable Color formats: 255 255 255
'                             255, 255, 255
'------------------------------------------------
    Dim RVal    As Long
    Dim GVal    As Long
    Dim BVal    As Long
    Dim NextSpc As Integer
    Dim LastSpc As Integer
    
    On Error Resume Next
        LastSpc = 1
        NextSpc = InStr(RGBStr, " ")
        RVal = Val(Mid$(RGBStr, LastSpc, NextSpc - LastSpc))
        LastSpc = NextSpc
        
        NextSpc = InStr(LastSpc + 1, RGBStr, " ")
        GVal = Val(Mid$(RGBStr, LastSpc, NextSpc - LastSpc))
        LastSpc = NextSpc
        
        NextSpc = Len(RGBStr) + 1
        BVal = Val(Mid$(RGBStr, LastSpc, NextSpc - LastSpc))
    On Error GoTo 0

    ColorFromRGBStr = RVal + (GVal * &H100) + (BVal * &H10000)

End Function


' .GetBValue
Private Function GetBValue(Color As Long) As Integer
    
    GetBValue = (Color \ &H10000) And &HFF

End Function


' .GetGValue
Private Function GetGValue(Color As Long) As Integer
    
    GetGValue = (Color \ &H100) And &HFF

End Function


' .GetRValue
Private Function GetRValue(Color As Long) As Integer
    
    GetRValue = Color& And &HFF

End Function


' .RGBStrFromColor
Private Function RGBStrFromColor(Color As Long) As String
    Dim RVal As String
    Dim GVal As String
    Dim BVal As String

    RVal = CStr(GetRValue(Color))
    GVal = CStr(GetGValue(Color))
    BVal = CStr(GetBValue(Color))
    
    RGBStrFromColor = RVal & " " & GVal & " " & BVal

End Function


' .SetBValue
Private Sub SetBValue(B As Integer)
    
    mValue = RGB(RedValue, GreenValue, B)

End Sub


' .SetGValue
Private Sub SetGValue(G As Integer)
    
    mValue = RGB(RedValue, G, BlueValue)

End Sub


' .SetRValue
Private Sub SetRValue(R As Integer)
    
    mValue = RGB(R, GreenValue, BlueValue)

End Sub

