VERSION 4.00
Begin VB.Form frmMain 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "RGBColor Class Test"
   ClientHeight    =   3135
   ClientLeft      =   1170
   ClientTop       =   1575
   ClientWidth     =   5040
   Height          =   3570
   Left            =   1095
   ScaleHeight     =   209
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   336
   Top             =   1215
   Width           =   5190
   Begin VB.PictureBox picTest 
      BackColor       =   &H00000000&
      Height          =   1095
      Left            =   180
      ScaleHeight     =   71
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   77
      TabIndex        =   14
      Top             =   180
      Width           =   1185
      Begin VB.PictureBox picSolidColor 
         BackColor       =   &H00000000&
         Height          =   375
         Left            =   810
         ScaleHeight     =   345
         ScaleWidth      =   330
         TabIndex        =   15
         Top             =   720
         Width           =   360
      End
   End
   Begin VB.TextBox txtColorValue 
      Height          =   285
      Index           =   1
      Left            =   3540
      TabIndex        =   11
      Text            =   "000000"
      Top             =   1830
      Width           =   1335
   End
   Begin VB.TextBox txtColorValue 
      Height          =   285
      Index           =   0
      Left            =   3540
      TabIndex        =   10
      Text            =   "000 000 000"
      Top             =   1440
      Width           =   1335
   End
   Begin VB.PictureBox picPropDisplayArea 
      AutoRedraw      =   -1  'True
      BorderStyle     =   0  'None
      Height          =   1605
      Left            =   195
      ScaleHeight     =   107
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   150
      TabIndex        =   9
      Top             =   1380
      Width           =   2250
   End
   Begin VB.HScrollBar hscColor 
      Height          =   255
      Index           =   2
      LargeChange     =   8
      Left            =   1800
      Max             =   255
      TabIndex        =   2
      Top             =   990
      Width           =   2385
   End
   Begin VB.HScrollBar hscColor 
      Height          =   255
      Index           =   1
      LargeChange     =   8
      Left            =   1800
      Max             =   255
      TabIndex        =   1
      Top             =   600
      Width           =   2385
   End
   Begin VB.HScrollBar hscColor 
      Height          =   255
      Index           =   0
      LargeChange     =   8
      Left            =   1800
      Max             =   255
      TabIndex        =   0
      Top             =   210
      Width           =   2385
   End
   Begin VB.Label lblColorValue 
      Caption         =   "Hex Value:"
      Height          =   225
      Index           =   1
      Left            =   2610
      TabIndex        =   13
      Top             =   1860
      Width           =   915
   End
   Begin VB.Label lblColorValue 
      Caption         =   "RGB Value:"
      Height          =   225
      Index           =   0
      Left            =   2610
      TabIndex        =   12
      Top             =   1470
      Width           =   915
   End
   Begin VB.Label lblColorVal 
      Caption         =   "0"
      Height          =   195
      Index           =   2
      Left            =   4290
      TabIndex        =   8
      Top             =   1020
      Width           =   465
   End
   Begin VB.Label lblColorVal 
      Caption         =   "0"
      Height          =   195
      Index           =   1
      Left            =   4290
      TabIndex        =   7
      Top             =   630
      Width           =   465
   End
   Begin VB.Label lblColorVal 
      Caption         =   "0"
      Height          =   195
      Index           =   0
      Left            =   4290
      TabIndex        =   6
      Top             =   240
      Width           =   465
   End
   Begin VB.Label lblColor 
      BackColor       =   &H00FF0000&
      BorderStyle     =   1  'Fixed Single
      Height          =   255
      Index           =   2
      Left            =   1500
      TabIndex        =   5
      Top             =   990
      Width           =   255
   End
   Begin VB.Label lblColor 
      BackColor       =   &H0000FF00&
      BorderStyle     =   1  'Fixed Single
      Height          =   255
      Index           =   1
      Left            =   1500
      TabIndex        =   4
      Top             =   600
      Width           =   255
   End
   Begin VB.Label lblColor 
      BackColor       =   &H000000FF&
      BorderStyle     =   1  'Fixed Single
      Height          =   255
      Index           =   0
      Left            =   1500
      TabIndex        =   3
      Top             =   210
      Width           =   255
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
'-- RGBColor Test Project
'-- Copyright  1995-1996 Gregg Irwin. All Rights Reserved

Option Explicit
DefInt A-Z

Public gColor As New RGBColor


Const HSC_RED = 0
Const HSC_GREEN = 1
Const HSC_BLUE = 2

Const TXT_COLOR_RGB = 0
Const TXT_COLOR_HEX = 1


Private Sub Form_Load()

    Call DisplayColorProperties
    
End Sub


Private Sub hscColor_Change(Index As Integer)

    Call ScrollBarUpdate(Index)
    
End Sub

Private Sub hscColor_Scroll(Index As Integer)
'-- Use the Scroll event so the color is updated
'   continuously if they drag the thumb.

    Call ScrollBarUpdate(Index)
    
End Sub


Private Sub txtColorValue_KeyPress(Index As Integer, KeyAscii As Integer)

    '-- Use Enter key as trigger
    If KeyAscii = vbKeyReturn Then
        '-- Eat the key to avoid beep
        KeyAscii = 0
        '-- Update color from Textbox text
        Select Case Index
            Case TXT_COLOR_RGB
                Call gColor.FromRGBString((txtColorValue(Index).TEXT))
            Case TXT_COLOR_HEX
                Call gColor.FromHexString((txtColorValue(Index).TEXT))
        End Select
        '-- Update the scrollbars to display new value
        hscColor(0).Value = gColor.RedValue
        hscColor(1).Value = gColor.GreenValue
        hscColor(2).Value = gColor.BlueValue
    End If
    
End Sub

'------------------------------------------------------------------------
'-- End of Event Handlers
'------------------------------------------------------------------------

Private Sub ScrollBarUpdate(Index)
'-- Called when scrollbars change value
    
    lblColorVal(Index).Caption = CStr(hscColor(Index).Value)
    Select Case Index
        Case HSC_RED
            gColor.RedValue = hscColor(Index).Value
        Case HSC_GREEN
            gColor.GreenValue = hscColor(Index).Value
        Case HSC_BLUE
            gColor.BlueValue = hscColor(Index).Value
    End Select
    picTest.BackColor = gColor.Value
    picSolidColor.BackColor = gColor.NearestSolidColor(picSolidColor.hDC)
    Call DisplayColorProperties

End Sub


Sub DisplayColorProperties()
    Dim P       As PictureBox
    Dim RGBInfo As Variant '-- RGBQuad or RGBTriple
    
    Set P = picPropDisplayArea
        P.Cls
        P.Print "Value:", LTrim$(gColor.Value)
        P.Print "RedValue:", LTrim$(gColor.RedValue)
        P.Print "GreenValue", LTrim$(gColor.GreenValue)
        P.Print "BlueValue", LTrim$(gColor.BlueValue)
        P.Print "AsRGBString", gColor.AsRGBString
        P.Print "AsHexString", gColor.AsHexString
        RGBInfo = gColor.AsRGBQuad
        P.Print "AsRGBQuad:", LTrim$(RGBInfo(0)); RGBInfo(1); RGBInfo(2); RGBInfo(3)
        RGBInfo = gColor.AsRGBTriple
        P.Print "AsRGBTriple:", LTrim$(RGBInfo(0)); RGBInfo(1); RGBInfo(2)
    Set P = Nothing
    

End Sub


