VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "Connector"
Attribute VB_Creatable = True
Attribute VB_Exposed = True
Attribute VB_Description = "Restore Project Add-In"
'***************************************************
' Property Variables of Connector class
'***************************************************
' This class retrieves the name of the previous project
' and connect the Loader to the AfterNewProject event.

Option Explicit

Dim VBInstance As VBIDE.Application
Dim iLoader As Loader

Sub ConnectAddIn(VBDriverInstance As VBIDE.Application)
    Dim projectname$
    Dim hConnection As Long

    Set VBInstance = VBDriverInstance

    ' Get project name
    projectname = String$(255, Chr$(0))
    GetPrivateProfileString "Visual Basic", "RecentFile1", "", projectname$, Len(projectname$) + 1, "VB.INI"
    projectname$ = Left(projectname$, InStr(projectname$, Chr(0)) - 1)
    If projectname$ <> "" Then
      ' Create an instance of the Loader class
      Set iLoader = New Loader
      ' Connect it to the AfterNewProject event
      Set iLoader.VBInstance = VBInstance
      hConnection = VBInstance.Application.FileControl.ConnectEvents(iLoader)
      ' Pass the project name to the loader
      iLoader.NewProjectName = projectname$
    End If
End Sub

