'   ******************************************************
'   //THIS MODULE (REGMAX.BAS) IS DESIGNED TO BE INCLUDED IN YOUR
'   //OWN PROJECT, AND CONTAINS ALL THE GBLIB2 FUNCTIONS
'   //NECESSARY TO WRITE AND READ REGISTRATION DATA.
'   //IT MUST BE USED IN CONJUNCTION WITH GBLIB2.EXE.
'   //REGMAX.EXE, REGMAX.BAS (c)1995 Gordon Bamber//
'   ******************************************************

Option Explicit
'   /* Modified 02/01/95 [GB] */
'   /* Modified 31/12/94 [GB] */
'   /* Created 31/12/94 [GB] */

'   //Declares for the API in GBLIB2.EXE//

'   //This function is a crude string -> number algorithm//
'   //It can be used to make a checksum of the registration information//
Declare Function MakeAKey Lib "GBLIB2.EXE" (ByVal AString As String) As Long


'   //These two functions must NOT be used in development mode//
'   //on this project, because they are designed to//
'   //modify REGMAX.EXE file directly, and until it has been//
'   //compiled, there is no REGMAX.EXE to modify!
Declare Function WriteRegData Lib "GBLIB2.EXE" (ByVal sz_Name As String, ByVal sz_Org As String, ByVal sz_EXEPath As String, ByVal MyPhrase As String) As Integer
'**** Line below changed 02/01/95 [GB] ****
Declare Function ReadRegData Lib "GBLIB2.EXE" (ByVal sz_EXEPath As String, ByVal sz_Name As String, ByVal sz_Org As String, ByVal YMD As String, NameLen As Integer, OrgLen As Integer) As Integer

'   //These Subs simply show information//
Declare Sub ShowWinDir Lib "GBLIB2.EXE" ()
Declare Sub ShowSysDir Lib "GBLIB2.EXE" ()

'   //Registration variables//
Global USERNAME As String
Global USERORG As String
Global BRANDDATE As String

'   //Data constant//
Global Const MONTHSTRING = "JanFebMarAprMayJunJulAugSepOctNovDec"

'   //WIN31 API Function to bar accidents in development mode!//
Declare Function FindWindow Lib "User" (ByVal lpClassName As String, ByVal lpWindowName As String) As Integer

Sub DevMsg ()

'   /* Modified 31/12/94 [GB] */
'   /* Created 31/12/94 [GB] */

'   //This message is shown if ISVBRUNNING returns true//

Dim msg As String
msg = "You are working in Development Mode" & Chr$(10) & Chr$(10)
msg = msg & "I cannot therefore read or write data" & Chr$(10)
msg = msg & "to or from REGMAX.EXE," & Chr$(10)
msg = msg & "because you havn't compiled it yet!" & Chr$(10)
msg = msg & "Compile REGMAX.EXE, and run it outside" & Chr$(10)
msg = msg & "of the Visual Basic IDE entirely."
MsgBox msg, 48, "REGMAX - Get / PutDataIntoEXE"
End Sub

Sub GetDataFromEXE ()

'   /* Modified 02/01/95 [GB] */
'   /* Modified 30/12/94 [GB] */
'   /* Created 30/12/94 [GB] */

'   //Quit out in development mode//
If ISVBRUNNING() <> 0 Then
    DevMsg
    Exit Sub
End If

Dim i_RetValue As Integer
Dim sz_EXEPath As String
Dim NameLen As Integer
Dim OrgLen As Integer
Dim TUserName As String
Dim TUserOrg As String
Dim YMD As String

'   //Get the full path and filename of this application//
sz_EXEPath = App.Path
If Right$(sz_EXEPath, 1) <> "\" Then sz_EXEPath = sz_EXEPath & "\"
sz_EXEPath = sz_EXEPath & App.EXEName & ".EXE"

'   //You MUST initialise the strings to this length or VB cannot//
'   //cope with passing strings to/from the GBLIB2 API//
TUserName = String$(42, 0)
TUserOrg = String$(34, 0)
YMD = String$(4, 0)

'   //Read the Information from the EXE//
i_RetValue = ReadRegData(sz_EXEPath, TUserName, TUserOrg, YMD, NameLen, OrgLen)
'   //Return value is Zero if sz_EXEPath_EXEPath is branded OK//

'   //If the EXE is 'virgin' then X=1 and USERNAME and USERORG = 'UNLICENSED' //
USERNAME = Left$(TUserName, NameLen)
USERORG = Left$(TUserOrg, OrgLen)

'   //Now process the DATE information//
'   //If the EXE is virgin then YMD is all spaces//
If Left$(YMD, 1) = " " Then Exit Sub

'   //YMD = The Year-Month-Date in ASCII codes//
'   //Here I unpack the YMD data into the 'English' form of dd mmmm yyyy//

'   //1) Day//
BRANDDATE = Format$(Asc(Mid$(YMD, 3, 1)), "#0")

'   //2) Month//
BRANDDATE = BRANDDATE & " " & Mid$(MONTHSTRING, (Asc(Mid$(YMD, 2, 1))) * 3 - 2, 3)

'   //3) Year//
'   //NOTE it is returned as (YY+108)//
BRANDDATE = BRANDDATE & " 19" & Format$(Asc(Left$(YMD, 1)) - 108, "00")
End Sub

Function ISVBRUNNING () As Integer

'   /* Modified 31/12/94 [GB] */
'   /* Created 31/12/94 [GB] */

'   //Simple test to see if VB is in development mode//
If FindWindow("wndclass_desked_gsk", "Microsoft Visual Basic [run]") > 0 Then
    ISVBRUNNING = 1
Else
    ISVBRUNNING = 0
End If
End Function

Sub PutDataIntoEXE (AName As String, AnOrganisation As String, sz_Key As String)

'   /* Modified 31/12/94 [GB] */
'   /* Created 31/12/94 [GB] */

'   //OPTIONAL//
'   //Quit if running in development mode//
If ISVBRUNNING() <> 0 Then
    DevMsg
    Exit Sub
End If

Dim i_RetValue As Integer
Dim sz_EXEPath As String

'   //OPTIONAL//
'   //Build up the full path to this application//
sz_EXEPath = App.Path
If Right$(sz_EXEPath, 1) <> "\" Then sz_EXEPath = sz_EXEPath & "\"
sz_EXEPath = sz_EXEPath & App.EXEName & ".EXE"

'   //NOTE: sz_EXEPath could be set to any VB3 program, not//
'   //just this one.

'   //Do the deed. Note that AName and AnOrganisation will be truncated//
'   //if they are over 33 or 41 characters respectively//

i_RetValue = WriteRegData(AName, AnOrganisation, sz_EXEPath, sz_Key)
'   //Return value is zero for success/
'   //Return value is 1 if either item has been truncated//

End Sub

