Option Explicit

'   //=============================================================//

'   //******************************//
'   //                              //
'   //  REGDATA.BAS                 //
'   //  By gbamber@mistral.co.uk    //
'   //  (c)August 1995              //
'   //                              //
'   //******************************//

'   //    INSTRUCTIONS FOR USING THIS BAS FILE FOR YOUR OWN APPLICATION//
'   //    =============================================================
'   // 1) Look at AssignRegVars() and change the variables to suit//
'   // 2) Decide what level of registration you need, and set the FLAG variables//
'   // 3) If you are using the DATA drag-drop facilities, then make sure
'   //    that you app can respond to the '/open DATFILE.DAT' type of command$//
'   // 4) Make a dummy program that just calls Doregistration and DoUnregistration
'   //    and test it before plugging it into your SETUP1 and DeInstaller programs//



'   //INSTRUCTIONS FOR USE IN SETUP//
'   //1) Call Function DoRegistration()
'   //2) Return value is TRUE for success


'   //INSTRUCTIONS FOR USE IN UNINSTALL//
'   //1) Call Function DoUnRegistration()
'   //2) Return value is TRUE for success


'   //N.B. If you are going use an Uninstall program, put it in
'   //the user's WINDOWS PATH (suggest WINDOWS directory) because
'   //the Uninstall entry does not contain a discrete path.

'   //=============================================================//









'   //EXAMPLE VALUES FOR DOREGISTRATION PARAMETERS//
'xLongAppName = "Trademaker2.Bonds"'               //A short descriptive name//
'xAppEXEName = "TM2BOND1.EXE"'                     //The Application's EXE name//
'xAppEXEPath = "C:\BONDSIM\"'                      //Set by your SETUP program?//
'xAppUnInstallerName = "TM2DUMPB.EXE"'             //Your Uninstall Program//
'xAppUnInstallerPath = "C:\WINDOWS\"'              //Set up by your SETUP program?//
'xVersion = "1.00"'                                //Version number as a string//
'xOLEName = "tm2bond1"'                            //Not displayed - can be anything//
'xDataIconNumber = "8"'                            //Icon resource number to use in Explorer//
'xTotalNumberofExtensions = 9'                      //Normally this would be 1//











'   //DECLARATIONS SECTION (No need to alter)//

'   //***** CONSTANTS *****//

'   //Windows V3.x Predefined Root Key//
Const HKEY_CLASSES_ROOT3 = 1

'   //Windows 95 Predefined Root Keys//
Const HKEY_CLASSES_ROOT4 = &H80000000
Const HKEY_CURRENT_USER = &H80000001
Const HKEY_LOCAL_MACHINE = &H80000002
Const HKEY_USERS = &H80000003
Const HKEY_PERFORMANCE_DATA = &H80000004
Const HKEY_CURRENT_CONFIG = &H80000005
Const HKEY_DYN_DATA = &H80000006

'   //For Win 3.1 this is the only REG_SZ allowed//
Const REG_SZ = 1

'   //16bit API Return Values (Long Types)//
Const Error_Success = 0
Const Error_BadDB = 1
Const Error_BadKey = 2
Const Error_CantOpen = 3
Const Error_CantRead = 4
Const Error_CantWrite = 5
Const Error_OutOfMemory = 6
Const Error_Invalid_Parameter = 7
Const Error_Access_Denied = 8


'   //Windows 95 standard Keys and SubKeys//
'   //All are subkeys of HKEY_LOCAL_MACHINE//
Const KEY_UNINSTALL = "\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall"
Const DKEY_UNINSTALL = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\"

Const SUBKEY_UNINSTALL_NAME = "Displayname"'     = "Description of Uninstall Application"
Const SUBKEY_UNINSTALL_PATH = "UninstallString"' = "DRIVE:\PATH\UNINSTALLERPROG.EXE"

Const KEY_APPPATHS = "\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths"
Const DKEY_APPPATHS = "SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\"

Const KEY_CLASSES = "\SOFTWARE\Classes"
Const DKEY_CLASSES = "SOFTWARE\Classes\"

Const DKEY_SHAREDDLLS = "\SOFTWARE\Microsoft\Windows\CurrentVersion\SharedDLLS"
Const SKEY_SHAREDDLLS = "SOFTWARE\Microsoft\Windows\CurrentVersion\SharedDLLS"

Const KEY_MACHINE = "HKEY_LOCAL_MACHINE"
Const KEY_SOFTWARE = "\SOFTWARE"
Const DKEY_SOFTWARE = "SOFTWARE\"

Const SUBKEY_APP = "Default"'    = "DRIVE:\PATH\PROGRAM.EXE"
Const SUBKEY_APP_Path = "Path"'  = "DRIVE:\PATH"
Const ROOTKEY = "HKEY_CLASSES_ROOT"


'   //To Add yourself or your company, use:
'   //sz_NewKey = KEY_SOFTWARE & "\" & sz_GROUPNAME

'   //To Add your application, use:
'   //sz_NewKey = KEY_SOFTWARE & "\" & sz_GROUPNAME & "\" & sz_AppName

'   //To Add your application version, use:
'   //sz_NewKey = KEY_SOFTWARE & "\" & sz_GROUPNAME & "\" & sz_AppName & "\Version"




'   //***** WINDOWS 3.1 API DECLARES *****//

Declare Function RegCreateKey Lib "SHELL.DLL" (ByVal sz_RootKey As Long, ByVal sz_NewKey As String, l_hKey As Long) As Long
Declare Function RegOpenKey Lib "SHELL.DLL" (ByVal sz_RootKey As Long, ByVal sz_NewKey As String, l_hKey As Long) As Long
'   //sz_RootKey="HKEY_CLASSES_ROOT"//
'   //sz_NewKey=".TXT"
'   //l_hKey is returned as the Key Handle//

Declare Function RegSetValue Lib "SHELL.DLL" (ByVal l_hKey As Long, ByVal sz_SubKey As String, ByVal l_REG_SZ As Long, ByVal sz_NewVal As String, ByVal l_NewValLen As Long) As Long
'   //l_hKey was returned by RegCreateKey or RegOpenKey//
'   //l_hKey can be HKEY_CLASSES_ROOT which is always open//
'   //sz_SubKey is the key with which sz_NewVal will be associated//
'   //if sz_SubKey is an empty string, then the value of the l_hKey Key is set//
'   //l_REG_SZ=1//


Declare Function RegCloseKey Lib "SHELL.DLL" (ByVal l_hKey As Long) As Long
'   //l_hKey was set in RegOpenKey or RegCreateKey//
'   //l_hKey cannot be HKEY_CLASSES_ROOT which is always open//

Declare Function RegQueryValue Lib "SHELL.DLL" (ByVal l_hKey As Long, ByVal sz_QueryKey As String, ByVal sz_255Buffer As String, i_BuffLen As Long) As Long
'   //l_hKey was set in RegOpenKey or RegCreateKey//
'   //l_hKey can be HKEY_CLASSES_ROOT which is always open//
'   //if sz_QueryKey="" then the value of the key reffered to by l_hKey is queried//
'   //sz_255Buffer must be set to String$(255,0) before this call//
'   //i_BuffLen is set to 255//
'   //Return value is Left$(sz_255Buffer,i_BuffLen)

Declare Function RegDeleteKey Lib "SHELL.DLL" (ByVal l_hKey As Long, ByVal sz_KeyStringToDelete As String) As Long
'   //l_hKey was set in RegOpenKey or RegCreateKey//
'   //l_hKey can be HKEY_CLASSES_ROOT or HKEY_LOCAL_MACHINE etc. which are always open//
'   //sz_KeyStringToDelete is a string of a subkey of l_hKey (does NOT start with a backslash) //

Declare Function IsRunning Lib "KERNEL" Alias "GetModuleUsage" (hInstance As Integer) As Integer

'   //***** FORM-LEVEL VARIABLES *****//
Dim l_RetVal As Long
Dim l_hKey As Long
Dim sz_KeyString As String
Dim i_Success As Integer

Dim sz_GROUPNAME As String
Dim sz_MyCompanyName As String
Dim sz_Programmer As String
Dim sz_AppEXEName As String
Dim sz_AppEXEPath As String
Dim sz_AppFullEXEPath As String
Dim sz_AppUnInstallerName As String
Dim sz_AppUnInstallerPath As String
Dim sz_AppFullUnInstallerPath As String

Dim sz_Buffer As String * 255
Dim sz_BuffLEN As Integer
Dim sz_LongAppName As String
Dim sz_Version As String
Dim sz_DataIconNumber As String
Dim sza_Extensions() As String * 4'  //i.e. ".TXT"
Dim sza_ExtensionsDesc() As String'  //i.e. "Text File"
Dim i_TotalNumberofExtensions As Integer'    //Upperbound of array//
Dim sz_OLEName As String'   //Shortened version of appname//
Dim sz_OLEDesc As String'    //Generic Datafile Description//

'   //***** FLAGS *****//
Dim FLAG_REG_GROUPNAME As Integer
Dim FLAG_REG_APPNAME As Integer
Dim FLAG_REG_APPPATH As Integer

Dim FLAG_REG_APPVERSION As Integer
Dim FLAG_REG_UNINSTALL As Integer

Dim FLAG_REG_SHAREDDLLS As Integer
Dim FLAG_REG_DATANAMES As Integer

Dim FLAG_REG_COMMAND_OPEN As Integer
Dim FLAG_REG_COMMAND_PRINT As Integer

Sub AssignRegistrationVars ()


'   /* Created Sunday 06 August 1995 [GB] */


'   //********** Set the flags for your application here *************//
'   //Take care that the combinations make sense//
'   //the routine tries to make an intelligent guess, based on the
'   //information presented to the Do(un)Registration call//

'   //If the FLAG is False, then the corresponding variable is ignored//
FLAG_REG_GROUPNAME = True'    //Make all your apps part of a group//
FLAG_REG_APPNAME = sz_AppEXEName <> "" '                //Register this app under SOFTWARE//
FLAG_REG_APPPATH = sz_AppEXEPath <> ""'                 //Register this App with Windows//
FLAG_REG_UNINSTALL = sz_AppUnInstallerName <> ""'       //There is an Uninstaller for this app//
FLAG_REG_APPVERSION = sz_Version <> ""'                     //Register the Version number with Windows//
FLAG_REG_DATANAMES = i_TotalNumberofExtensions > 0'     //Register the Data file's descriptions//

FLAG_REG_COMMAND_OPEN = i_TotalNumberofExtensions > 0'  //Double-Click a data file to open my app//
FLAG_REG_COMMAND_PRINT = False'                         //No Printing needed//

'   //********* Set these Variables for your application here ********//

sz_MyCompanyName = "Maxim Training Consultants"
sz_GROUPNAME = "MAXIM"' //All future apps could use this groupname, so choose with care!//

sz_Programmer = "gbamber@mistral.co.uk"'    //If it's a great application, leave this alone! :-) //
sz_OLEDesc = "Trademaker 2 Scenario"'               //Only Win95 users will see this//

'   //****************************************************************//

'   //Leave these alone//
sz_AppFullEXEPath = sz_AppEXEPath & sz_AppEXEName
sz_AppFullUnInstallerPath = sz_AppUnInstallerPath & sz_AppUnInstallerName


'   //*****************************************************************//

'   //Here I prepare extensions *.SB0, *.SB1, *.SB2 .. *.SB8//

ReDim sza_Extensions(0 To i_TotalNumberofExtensions - 1)
ReDim sza_ExtensionsDesc(0 To i_TotalNumberofExtensions - 1)

If i_TotalNumberofExtensions > 1 Then
    Dim i_Count As Integer
    For i_Count = 0 To i_TotalNumberofExtensions - 1
	sza_Extensions(i_Count) = ".S" & gsz_TM2Type & "" & Format$(i_Count, "0")
	sza_ExtensionsDesc(i_Count) = sz_OLEDesc
    Next i_Count
Else
    '   //Only one to register//
    sza_Extensions(0) = ".S" & gsz_TM2Type & "0"
    sza_ExtensionsDesc(0) = sz_OLEDesc
End If
End Sub

Sub CheckResult (sz_Function As String, l_Value As Long)

'   /* Created Sunday 06 August 1995 [GB] */

'   //If the Reg Function performs OK, then i_Success is left as TRUE//

'   //If command parameter contains "regmsg" then messagebox reports errors//
Dim msg As String
Select Case l_Value
    Case Error_Success
	'   //Leave i_success alone, and get outa here//
	Exit Sub
    Case Error_BadDB
	msg = "Bad Registration Database"
    Case Error_BadKey
	msg = "Bad Key passed"
    Case Error_CantOpen
	msg = "Could not open Registration Database"
    Case Error_CantRead
	msg = "Could not read Registration Database"
    Case Error_CantWrite
	msg = "Could not write to Registration Database"
    Case Error_OutOfMemory
	msg = "Out of Memory error"
    Case Error_Invalid_Parameter
	msg = "Invalid parameter passed."
    Case Error_Access_Denied
	msg = "Registration Database access was denied."
    Case Else
	msg = "Unknown Error"
End Select

i_Success = False

'   //Enable/disable the messagebox as needed//
If InStr(1, LCase$(Command$), "regmsg") <> 0 Then MsgBox msg, 48, sz_Function

End Sub

Function DoRegistration (xLongAppName As String, xVersion As String, xAPPEXEPath As String, xAppEXEName As String, xAppUnInstallerPath As String, xAppUnInstallerName As String, xOLEName As String, xDataIconNumber As String, xTotalNumberofExtensions As Integer) As Integer


'   /* Created Sunday 06 August 1995 [GB] */

'   //Call this routine from your SETUP program just before it exits//

'   //Assign Global variables//
sz_AppEXEPath = xAPPEXEPath
sz_AppEXEName = xAppEXEName
sz_AppUnInstallerPath = xAppUnInstallerPath
sz_AppUnInstallerName = xAppUnInstallerName
sz_OLEName = xOLEName
sz_Version = xVersion
sz_LongAppName = xLongAppName
sz_DataIconNumber = xDataIconNumber'    //0 is OK//
i_TotalNumberofExtensions = xTotalNumberofExtensions

'   //Assign the rest//
AssignRegistrationVars


'   //Check the OS, and do the appropriate routine//
Dim i_RetVal As Integer
If FetchWinVersion() = 395 Then
    '   //Win 95 has special treatment//
    i_RetVal = DoRegistration4()
Else
    '   //Treat NT like Win3.x//
    i_RetVal = DoRegistration3()
End If

'   //Failure=False, Success=True//
DoRegistration = i_RetVal

End Function

Function DoRegistration3 () As Integer

'   //For Windows V3.x//

'   /* Created Sunday 06 August 1995 [GB] */

i_Success = True
Dim l_ExtKey As Long
l_hKey = 0
l_ExtKey = 0

'   //Set for failure//
DoRegistration3 = False


If FLAG_REG_COMMAND_OPEN Or FLAG_REG_COMMAND_PRINT Then

    '   //LUUP THRU ALL THE EXTENSIONS//
    Dim i_Count As Integer
    For i_Count = 0 To i_TotalNumberofExtensions - 1
	'   //Create h Key//
	sz_KeyString = sza_Extensions(i_Count)
	l_RetVal = RegCreateKey(HKEY_CLASSES_ROOT3, sz_KeyString, l_hKey)
	CheckResult "RegCreateKey", l_RetVal
	
	'   //Add Desc. to h Key//
	sz_KeyString = sz_OLEName
	l_RetVal = RegSetValue(l_hKey, "", REG_SZ, sz_KeyString, Len(sz_KeyString))
	CheckResult "RegSetValue", l_RetVal
	'   //Close lh Key//
	If i_Success Then l_RetVal = RegCloseKey(l_hKey)
    Next i_Count
    
    '   //Create Ext Key//
    sz_KeyString = sz_OLEName
    l_RetVal = RegCreateKey(HKEY_CLASSES_ROOT3, sz_KeyString, l_ExtKey)
    CheckResult "RegCreateKey", l_RetVal
    
    '   //Add Desc. to Ext Key//
    sz_KeyString = sz_OLEDesc
    l_RetVal = RegSetValue(l_ExtKey, "", REG_SZ, sz_KeyString, Len(sz_KeyString))
    CheckResult "RegSetValue", l_RetVal
    
    
    
    
    If FLAG_REG_COMMAND_OPEN And i_Success Then
	'   //Create Open Command Key//
	sz_KeyString = "shell\open\command"
	l_RetVal = RegCreateKey(l_ExtKey, sz_KeyString, l_hKey)
	CheckResult "RegCreateKey", l_RetVal
	If i_Success Then
	    '   //Add value to Command Key//
	    sz_KeyString = sz_AppFullEXEPath & " /open %1"
	    l_RetVal = RegSetValue(l_hKey, "", REG_SZ, sz_KeyString, Len(sz_KeyString))
	    CheckResult "RegSetValue", l_RetVal
	End If
	'   //Close lh Key//
	If i_Success Then l_RetVal = RegCloseKey(l_hKey)
    End If
    
    If FLAG_REG_COMMAND_PRINT And i_Success Then
	'   //Create Print Command Key//
	sz_KeyString = "shell\print\command"
	l_RetVal = RegCreateKey(l_ExtKey, sz_KeyString, l_hKey)
	CheckResult "RegCreateKey", l_RetVal
	If i_Success Then
	    '   //Add value to Command Key//
	    sz_KeyString = sz_AppFullEXEPath & " /print %1"
	    l_RetVal = RegSetValue(l_hKey, "", REG_SZ, sz_KeyString, Len(sz_KeyString))
	    CheckResult "RegSetValue", l_RetVal
	End If
	'   //Close lh Key//
	If i_Success Then l_RetVal = RegCloseKey(l_hKey)
    End If
    '   //Close Ext Key//
    If i_Success Then l_RetVal = RegCloseKey(l_ExtKey)

End If
End Function

Function DoRegistration4 () As Integer

'   /* Created Sunday 06 August 1995 [GB] */
'   //For Windows 95//

Dim l_CompanyKey As Long
Dim l_ThisAppKey As Long
Dim l_UninstallKey As Long
Dim l_AppPathsKey As Long
Dim l_ClassesKey As Long
Dim l_ExtKey As Long
Dim l_IconKey As Long
l_hKey = 0
l_CompanyKey = 0
l_UninstallKey = 0
l_ThisAppKey = 0
l_AppPathsKey = 0
l_ClassesKey = 0
l_ExtKey = 0
l_IconKey = 0

'   //This is set to FALSE if ANY error occurrs in the REG functions//
i_Success = True

'   //Assume failure//
DoRegistration4 = False

If FLAG_REG_GROUPNAME And i_Success Then
    '   HKEY_LOCAL_MACHINE/XYZCompany
    '   //Create Company Key using HKEY_LOCAL_MACHINE//
    sz_KeyString = KEY_SOFTWARE & "\" & sz_GROUPNAME
    l_RetVal = RegCreateKey(HKEY_LOCAL_MACHINE, sz_KeyString, l_CompanyKey)
    CheckResult "RegCreateKey", l_RetVal
    
    '   HKEY_LOCAL_MACHINE/MAXIM : (Default) = "Maxim Training Consultants"
    If i_Success Then
	'   //Add value to Company Key//
	sz_KeyString = sz_MyCompanyName
	l_RetVal = RegSetValue(l_CompanyKey, "", REG_SZ, sz_KeyString, Len(sz_KeyString))
	CheckResult "RegSetValue", l_RetVal
	'   //Close Company Key?//
	If FLAG_REG_APPNAME = False Then l_RetVal = RegCloseKey(l_CompanyKey)
    End If
End If

If FLAG_REG_GROUPNAME And FLAG_REG_APPNAME And i_Success Then
    
    '   HKEY_LOCAL_MACHINE/XYZCompany/MyKiller.App
    '   //Create ThisApp Key using l_CompanyKey//
    sz_KeyString = "\" & sz_LongAppName
    l_RetVal = RegCreateKey(l_CompanyKey, sz_KeyString, l_ThisAppKey)
    CheckResult "RegCreateKey", l_RetVal
    
    If i_Success Then
	'   HKEY_LOCAL_MACHINE/XYZCompany/MyKiller.App : (Default) = "My Killer Application"
	'   //Add value to ThisApp Key//
	sz_KeyString = sz_LongAppName
	l_RetVal = RegSetValue(l_ThisAppKey, "", REG_SZ, sz_KeyString, Len(sz_KeyString))
	CheckResult "RegSetValue", l_RetVal
    End If
    '   //Close Company Key//
    If i_Success Then l_RetVal = RegCloseKey(l_CompanyKey)
    '   //Close ThisApp Key//
    If i_Success And (FLAG_REG_APPVERSION = False) Then l_RetVal = RegCloseKey(l_ThisAppKey)

End If

If FLAG_REG_APPPATH And i_Success Then
    
    '   //Create AppPaths Key using HKEY_LOCAL_MACHINE//
    sz_KeyString = KEY_APPPATHS & "\" & sz_AppEXEName
    l_RetVal = RegCreateKey(HKEY_LOCAL_MACHINE, sz_KeyString, l_AppPathsKey)
    CheckResult "RegCreateKey", l_RetVal
    
    If i_Success Then
	'   //Add value to AppPath Default Key//
	sz_KeyString = sz_AppFullEXEPath
	l_RetVal = RegSetValue(l_AppPathsKey, "", REG_SZ, sz_KeyString, Len(sz_KeyString))
	CheckResult "RegSetValue", l_RetVal
    End If
    '   //Close AppPaths Key//
    If i_Success Then l_RetVal = RegCloseKey(l_AppPathsKey)

End If


If FLAG_REG_UNINSTALL And FLAG_REG_APPPATH And i_Success Then
    
    '   //Create Uninstall Key using HKEY_LOCAL_MACHINE//
    sz_KeyString = KEY_UNINSTALL
    l_RetVal = RegCreateKey(HKEY_LOCAL_MACHINE, sz_KeyString, l_UninstallKey)
    CheckResult "RegCreateKey", l_RetVal
    
    '   //Use it to create my app entry//
    If i_Success Then
	sz_KeyString = "\" & sz_LongAppName
	l_RetVal = RegCreateKey(l_UninstallKey, sz_KeyString, l_UninstallKey)
	CheckResult "RegCreateKey", l_RetVal
    End If

'   //Unforunately, we cannot use the 32-bit RegSetValueEx function to
'   //set the Displayname = xxx and UninstallString = yyy
'   //keys here, so we will create a REG file later//

    If i_Success Then
	'   //Add descriptive value to Uninstall Myapp Key//
	sz_KeyString = "Uninstaller for " & sz_LongAppName
	l_RetVal = RegSetValue(l_UninstallKey, "", REG_SZ, sz_KeyString, Len(sz_KeyString))
	CheckResult "RegSetValue", l_RetVal
    End If
    
    '   //Re-Create AppPaths Key using HKEY_LOCAL_MACHINE//
    sz_KeyString = KEY_APPPATHS & "\" & sz_AppUnInstallerName
    l_RetVal = RegCreateKey(HKEY_LOCAL_MACHINE, sz_KeyString, l_AppPathsKey)
    CheckResult "RegCreateKey", l_RetVal
    
    If i_Success Then
	'   //Add value to AppPaths Key//
	sz_KeyString = sz_AppFullUnInstallerPath
	l_RetVal = RegSetValue(l_AppPathsKey, "", REG_SZ, sz_KeyString, Len(sz_KeyString))
	CheckResult "RegSetValue", l_RetVal
    End If

    '   //Close Keys//
    If i_Success Then l_RetVal = RegCloseKey(l_UninstallKey)
    If i_Success Then l_RetVal = RegCloseKey(l_AppPathsKey)
    
    i_Success = MakeandMergeUninstallRegFile()
End If

If FLAG_REG_GROUPNAME And FLAG_REG_APPNAME And FLAG_REG_APPVERSION And i_Success Then
    
    '   //Create l_hKey using  ThisApp key//
    sz_KeyString = "\Version"
    l_RetVal = RegCreateKey(l_ThisAppKey, sz_KeyString, l_hKey)
    CheckResult "RegCreateKey", l_RetVal
    
    '   //Use it to create version entry//
    If i_Success Then
	'   //Add descriptive value to Version Key//
	sz_KeyString = sz_Version
	l_RetVal = RegSetValue(l_hKey, "", REG_SZ, sz_KeyString, Len(sz_KeyString))
	CheckResult "RegSetValue", l_RetVal
    End If

    '   //Close Version Key//
    If i_Success Then l_RetVal = RegCloseKey(l_hKey)
    
    '   //Create l_hKey using  ThisApp key//
    sz_KeyString = "\Programmer"
    l_RetVal = RegCreateKey(l_ThisAppKey, sz_KeyString, l_hKey)
    CheckResult "RegCreateKey", l_RetVal
    
    '   //Use it to create programmer entry//
    If i_Success Then
	'   //Add descriptive value to Programmer Key//
	sz_KeyString = sz_Programmer
	l_RetVal = RegSetValue(l_hKey, "", REG_SZ, sz_KeyString, Len(sz_KeyString))
	CheckResult "RegSetValue", l_RetVal
    End If

    '   //Close programmer Key//
    If i_Success Then l_RetVal = RegCloseKey(l_hKey)
    
    '   //Close ThisApp Key//
    If i_Success Then l_RetVal = RegCloseKey(l_ThisAppKey)


End If

If FLAG_REG_DATANAMES And i_Success Then
    '   //Trap error//
    If sz_DataIconNumber = "" Then sz_DataIconNumber = "1"
    
    '   //Create Classes Key using HKEY_LOCAL_MACHINE//
    sz_KeyString = KEY_CLASSES & "\" & sz_OLEName
    l_RetVal = RegCreateKey(HKEY_LOCAL_MACHINE, sz_KeyString, l_ClassesKey)
    CheckResult "RegCreateKey", l_RetVal
    
    If i_Success Then
	'   //Add value to Classes Key//
	sz_KeyString = sz_OLEDesc
	l_RetVal = RegSetValue(l_ClassesKey, "", REG_SZ, sz_KeyString, Len(sz_KeyString))
	CheckResult "RegSetValue", l_RetVal
    End If

    '   //Create Icon Key using Ext Key//
    sz_KeyString = "DEFAULTICON"
    l_RetVal = RegCreateKey(l_ClassesKey, sz_KeyString, l_IconKey)
    CheckResult "RegCreateKey", l_RetVal
    
    '   //Add IconNumber to Icon Key//
    sz_KeyString = sz_AppFullEXEPath & "," & sz_DataIconNumber
    l_RetVal = RegSetValue(l_IconKey, "", REG_SZ, sz_KeyString, Len(sz_KeyString))
    CheckResult "RegSetValue", l_RetVal

    '   //Close IconKey//
    If i_Success Then l_RetVal = RegCloseKey(l_IconKey)


    If i_Success Then
	Dim i_Count As Integer
	For i_Count = 0 To i_TotalNumberofExtensions - 1
	    '   //Create Ext Key using HKEY_CLASSES_ROOT4//
	    sz_KeyString = sza_Extensions(i_Count)
	    l_RetVal = RegCreateKey(HKEY_CLASSES_ROOT4, sz_KeyString, l_hKey)
	    CheckResult "RegCreateKey", l_RetVal
	    '   //Add Desc. to Ext Key//
	    sz_KeyString = sz_OLEName
	    l_RetVal = RegSetValue(l_hKey, "", REG_SZ, sz_KeyString, Len(sz_KeyString))
	    CheckResult "RegSetValue", l_RetVal
	    
	    '   //Close Ext Key//
	    If i_Success Then l_RetVal = RegCloseKey(l_hKey)
	Next i_Count
    End If' //of i_Success//
	    
    '   //Create Ext Key using HKEY_CLASSES_ROOT4//
    sz_KeyString = sz_OLEName
    l_RetVal = RegCreateKey(HKEY_CLASSES_ROOT4, sz_KeyString, l_ExtKey)
    CheckResult "RegCreateKey", l_RetVal
    
    '   //Add Desc. to Ext Key//
    sz_KeyString = sz_OLEDesc
    l_RetVal = RegSetValue(l_ExtKey, "", REG_SZ, sz_KeyString, Len(sz_KeyString))
    CheckResult "RegSetValue", l_RetVal


    '   //Create Icon Key using Ext Key//
    sz_KeyString = "DEFAULTICON"
    l_RetVal = RegCreateKey(l_ExtKey, sz_KeyString, l_IconKey)
    CheckResult "RegCreateKey", l_RetVal
    
    '   //Add IconNumber to Icon Key//
    sz_KeyString = sz_AppFullEXEPath & "," & sz_DataIconNumber
    l_RetVal = RegSetValue(l_IconKey, "", REG_SZ, sz_KeyString, Len(sz_KeyString))
    CheckResult "RegSetValue", l_RetVal

    '   //Close IconKey//
    If i_Success Then l_RetVal = RegCloseKey(l_IconKey)

    If FLAG_REG_COMMAND_OPEN And i_Success Then
	'   //Create l_hKey Key using Ext Key//
	sz_KeyString = "shell\open\command"
	l_RetVal = RegCreateKey(l_ExtKey, sz_KeyString, l_hKey)
	CheckResult "RegCreateKey", l_RetVal
	If i_Success Then
	    '   //Add value to Command Key - Your app will have to process this//
	    sz_KeyString = sz_AppFullEXEPath & " /open %1"
	    l_RetVal = RegSetValue(l_hKey, "", REG_SZ, sz_KeyString, Len(sz_KeyString))
	    CheckResult "RegSetValue", l_RetVal
	End If
	'   //Close Ext lHKey//
	If i_Success Then l_RetVal = RegCloseKey(l_hKey)
	End If
    
    If FLAG_REG_COMMAND_PRINT And i_Success Then
	'   //Create l_hKey Key using Ext Key//
	sz_KeyString = "shell\print\command"
	l_RetVal = RegCreateKey(l_ExtKey, sz_KeyString, l_hKey)
	CheckResult "RegCreateKey", l_RetVal
	If i_Success Then
	    '   //Add value to Command Key//
	    sz_KeyString = sz_AppFullEXEPath & " /print %1"
	    l_RetVal = RegSetValue(l_hKey, "", REG_SZ, sz_KeyString, Len(sz_KeyString))
	    CheckResult "RegSetValue", l_RetVal
	End If
	'   //Close Ext lHKey//
	If i_Success Then l_RetVal = RegCloseKey(l_hKey)
	End If
    '   //Close Ext Key//
    If i_Success Then l_RetVal = RegCloseKey(l_ExtKey)

    '   //Close Classes Key?//
    If i_Success And (FLAG_REG_COMMAND_OPEN = False) Then l_RetVal = RegCloseKey(l_ClassesKey)

End If

If FLAG_REG_DATANAMES And FLAG_REG_COMMAND_OPEN And i_Success Then
	
	'   //Create l_hKey Key using Classes Key//
	sz_KeyString = "shell\open\command"
	l_RetVal = RegCreateKey(l_ClassesKey, sz_KeyString, l_hKey)
	CheckResult "RegCreateKey", l_RetVal

    If i_Success Then
	'   //Add value to Command Key//
	sz_KeyString = sz_AppFullEXEPath & " /open %1"
	l_RetVal = RegSetValue(l_hKey, "", REG_SZ, sz_KeyString, Len(sz_KeyString))
	CheckResult "RegSetValue", l_RetVal
    End If

    '   //Close Classes Key//
    If i_Success Then l_RetVal = RegCloseKey(l_ClassesKey)
    '   //Close lH Key//
    If i_Success Then l_RetVal = RegCloseKey(l_hKey)

End If

If FLAG_REG_DATANAMES And FLAG_REG_COMMAND_PRINT And i_Success Then
	
	'   //Create l_hKey Key using Classes Key//
	sz_KeyString = "shell\print\command"
	l_RetVal = RegCreateKey(l_ClassesKey, sz_KeyString, l_hKey)
	CheckResult "RegCreateKey", l_RetVal

    If i_Success Then
	'   //Add value to Command Key//
	sz_KeyString = sz_AppFullEXEPath & " /print %1"
	l_RetVal = RegSetValue(l_hKey, "", REG_SZ, sz_KeyString, Len(sz_KeyString))
	CheckResult "RegSetValue", l_RetVal
    End If
    
    '   //Close lH Key//
    If i_Success Then l_RetVal = RegCloseKey(l_hKey)
End If

DoRegistration4 = i_Success
End Function

Function DoUnregistration (uLongAppName As String, uVersion As String, uAPPEXEPath As String, uAppEXEName As String, uAppUnInstallerPath As String, uAppUnInstallerName As String, uOLEName As String, uDataIconNumber As String, uTotalNumberofExtensions As Integer) As Integer


'   /* Created Sunday 06 August 1995 [GB] */

'   //Call this routine from your UNINSTALL program just before it exits//

'   //Assign variables//
sz_AppEXEPath = uAPPEXEPath'                            //blank or path with backslash//
sz_AppEXEName = uAppEXEName'                            //blank or 8.3 EXE name//
sz_AppUnInstallerPath = uAppUnInstallerPath'            //blank or path with backslash//
sz_AppUnInstallerName = uAppUnInstallerName'            //blank or 8.3 EXE name//
sz_OLEName = uOLEName'                                  //blank or unique short string//
sz_Version = uVersion'                                  //blank or number-as-a-string//
sz_LongAppName = uLongAppName'                          //blank or Full descriptive name//
sz_DataIconNumber = uDataIconNumber'                    //0=default icon//
i_TotalNumberofExtensions = uTotalNumberofExtensions'   //0 or a valid number//

'   //Assign the rest//
AssignRegistrationVars


'   //Check the OS, and do the appropriate routine//
Dim i_RetVal As Integer
If FetchWinVersion() = 395 Then
    '   //Win 95 has special treatment//
    i_RetVal = DoUnRegistration4()
Else
    '   //Treat NT like Win3.x//
    i_RetVal = DoUnRegistration3()
End If

'   //Failure=False, Success=True//
DoUnregistration = i_RetVal

End Function

Function DoUnRegistration3 () As Integer

'   //For Windows V3.x//

'   /* Created Sunday 06 August 1995 [GB] */

i_Success = True
Dim l_ExtKey As Long
l_hKey = 0
l_ExtKey = 0

'   //Set for failure//
DoUnRegistration3 = False


If FLAG_REG_DATANAMES And i_Success Then

Dim i_Count As Integer
For i_Count = 0 To i_TotalNumberofExtensions - 1
    '   //Create Ext Key//
    sz_KeyString = sza_Extensions(i_Count)
    l_RetVal = RegDeleteKey(HKEY_CLASSES_ROOT3, sz_KeyString)
    
Next i_Count
End If


DoUnRegistration3 = i_Success

End Function

Function DoUnRegistration4 () As Integer

'   /* Created Sunday 06 August 1995 [GB] */
'   //For Windows 95//
Dim l_Dummy As Long

'   //Assume failure//
DoUnRegistration4 = False
i_Success = True

If FLAG_REG_GROUPNAME And FLAG_REG_APPNAME And i_Success Then
    '   //Create Company Key//
    sz_KeyString = DKEY_SOFTWARE & sz_GROUPNAME & "\" & sz_LongAppName
    l_RetVal = RegDeleteKey(HKEY_LOCAL_MACHINE, sz_KeyString)
    CheckResult "RegDeleteKey", l_RetVal
End If

If FLAG_REG_UNINSTALL And i_Success Then
	sz_KeyString = DKEY_UNINSTALL & sz_LongAppName
	'   //Kill the bugger//
	l_RetVal = RegDeleteKey(HKEY_LOCAL_MACHINE, sz_KeyString)
	CheckResult "RegDeleteKey", l_RetVal
End If


If FLAG_REG_APPPATH And i_Success Then
    
    '   //Create AppPath AppName Key//
    sz_KeyString = DKEY_APPPATHS & sz_AppEXEName
    l_RetVal = RegDeleteKey(HKEY_LOCAL_MACHINE, sz_KeyString)
    CheckResult "RegDeleteKey", l_RetVal

End If



If FLAG_REG_DATANAMES And i_Success Then
    
    '   //Create Classes Key//
    sz_KeyString = DKEY_CLASSES & sz_OLEName
    l_RetVal = RegDeleteKey(HKEY_LOCAL_MACHINE, sz_KeyString)
    CheckResult "RegDeleteKey", l_RetVal

    If i_Success Then
	Dim i_Count As Integer
	For i_Count = 0 To i_TotalNumberofExtensions - 1
	    '   //Create Ext Key//
	    sz_KeyString = sza_Extensions(i_Count)
	    l_RetVal = RegDeleteKey(HKEY_CLASSES_ROOT4, sz_KeyString)
	    CheckResult "RegDeleteKey", l_RetVal
	Next i_Count
    End If' //of i_Success//
End If


DoUnRegistration4 = i_Success
End Function

Function FetchWinVersion ()


'   /* Modified Sunday 20 August 1995 [GB] */

Dim i_Ret As Integer
'   //Fetch only the Low Word of the longint//
i_Ret = LoWord(GetVersion())

'   //Minor-Major//
FetchWinVersion = LoByte(i_Ret) * 100 + HiByte(i_Ret)

End Function

Function HiByte (xWord As Integer) As Integer


'   /* Modified Sunday 20 August 1995 [GB] */

If xWord < 0 Then
    HiByte = (xWord + &H10000) \ &H100
Else
    HiByte = xWord \ &H100
End If
End Function

Function LoByte (xWord As Integer) As Integer


'   /* Modified Sunday 20 August 1995 [GB] */

LoByte = xWord And 255
End Function

Function LoWord (l_LongInt As Long) As Integer

'   /* Modified Sunday 20 August 1995 [GB] */

'   //We only need the low word of GetVersion//
If (l_LongInt And &HFFFF&) > &H7FFF Then
    LoWord = (l_LongInt And &HFFFF&) - &H10000
Else
    LoWord = l_LongInt And &HFFFF&
End If

End Function

Function MakeandMergeUninstallRegFile () As Integer

'   /* Created Sunday 06 August 1995 [GB] */
'   //For Windows 95//

Dim fn As Integer
Dim SZ_REGFILEPATH As String
Dim sz As String
Dim i_RetVal As Integer

On Error GoTo EH_BAD

'   //Assume Failure//
MakeandMergeUninstallRegFile = False

'   //Make a dummy reg file name//
SZ_REGFILEPATH = App.Path & "\dumpme.reg"
fn = FreeFile

'   //Open for sequential ASII output//
Open SZ_REGFILEPATH For Output As #fn

'   //Identify as a Win 95 REG file//
Print #fn, "REGEDIT4"
Print #fn,

'   //Set fixed reg path//
sz = "[" & KEY_MACHINE & KEY_UNINSTALL & "\"

'   //Add just the AppName - the registry already holds the path//
sz = sz & sz_LongAppName & "]"
Print #fn, sz

'   //This name is displayed in Add/Remove programs dialog//
sz = Chr$(34) & "Displayname" & Chr$(34) & "=" & Chr$(34) & "Uninstall " & sz_LongAppName & Chr$(34)
Print #fn, sz

'   //Just the name NOT the path. Put the Uninstaller in the WINDOWS path//
sz = Chr$(34) & "UninstallString" & Chr$(34) & "=" & Chr$(34) & sz_AppUnInstallerName & Chr$(34)
Print #fn, sz
Close #fn
DoEvents

'   //Merge the newly-created file (quietly, so as not to make a fuss) //
i_RetVal = Shell("regedit.exe /s " & SZ_REGFILEPATH, 6)
DoEvents
If i_RetVal >= 32 Then
    '   //Enter a do-nothing loop until REGEDIT has done its stuff//
    While IsRunning(i_RetVal) <> 0: DoEvents: Wend
    '   //Delete the temporary reg file//
    Kill SZ_REGFILEPATH
    MakeandMergeUninstallRegFile = True'    //Stonking success//
Else
    MakeandMergeUninstallRegFile = False'    //Miserable failure//
End If

'   //(Optional)//
'   //KILL SZ_REGFILEPATH//

RES_OUTAHERE:
Exit Function

EH_BAD:
Resume RES_OUTAHERE
End Function

