Option Explicit

' Define a data type to hold a record:
' Define global variables to hold the file number and record number
' of the current data file.
' Default file name to show in dialog boxes.
Type udtRecord
    AccountNumber   As Long
    Status          As String * 1
    Forename        As String * 12
    Surname         As String * 12
    Company         As String * 30
    Address1        As String * 30
    Address2        As String * 30
    Address3        As String * 30
    PostCode        As String * 15
    Telephone       As String * 15
    Fax             As String * 15
    EMail           As String * 15
End Type

Global Const MAX_DATAFIELDS = 12      'Make this equal to the number of fields in the udtRecord structure
Global Const MAX_RECORDS = 2147483647


Global Const SAVEFILE = 1, LOADFILE = 2
Global Const REPLACEFILE = 1, READFILE = 2, ADDTOFILE = 3
Global Const RANDOMFILE = 4, BINARYFILE = 5

Global Const Err_DeviceUnavailable = 68
Global Const Err_DiskNotReady = 71, Err_FileAlreadyExists = 58
Global Const Err_TooManyFiles = 67, Err_RenameAcrossDisks = 74
Global Const Err_Path_FileAccessError = 75, Err_DeviceIO = 57
Global Const Err_DiskFull = 61, Err_BadFileName = 64
Global Const Err_BadFileNameOrNumber = 52, Err_FileNotFound = 53
Global Const Err_PathDoesNotExist = 76, Err_BadFileMode = 54
Global Const Err_FileAlreadyOpen = 55, Err_InputPastEndOfFile = 62
Global Const MB_EXCLAIM = 48, MB_STOP = 16

'From CONSTANT.TXT
' Colors
Global Const BLACK = &H0&
Global Const RED = &HFF&
Global Const GREEN = &HFF00&
Global Const YELLOW = &HFFFF&
Global Const BLUE = &HFF0000
Global Const MAGENTA = &HFF00FF
Global Const CYAN = &HFFFF00
Global Const WHITE = &HFFFFFF

Global Const WM_USER = &H400
Global Const LB_SETTABSTOPS = WM_USER + 19

Declare Function SendMessage Lib "User" (ByVal hWnd As Integer, ByVal wMsg As Integer, ByVal wParam As Integer, lParam As Any) As Long
'SendMessage used here to create our own tab stops in the lstResults ListBox

Function ExtractElement (TheString As String, TheElement As Integer) As String
    Dim strSource       As String
    Dim intElement      As Integer
    Dim intCount        As Integer
    Dim intPos          As Integer
    Dim strTab          As String
    strTab = Chr$(9)
    strSource = TheString
    intElement = TheElement
    intPos = InStr(strSource, strTab)
    While intPos > 0
	If intCount = intElement Then
	    ExtractElement = Left$(strSource, intPos - 1)
	    Exit Function
	Else
	    strSource = Mid$(strSource, intPos + 1)
	End If
	intPos = InStr(strSource, strTab)
	intCount = intCount + 1
    Wend
End Function

Function FileErrors (errVal As Integer) As Integer
    ' Return Value  Meaning
    ' 0             Resume
    ' 1             Resume Next
    ' 2             Unrecoverable error
    ' 3             Unrecognized error
    Dim MsgType     As Integer
    Dim Response    As Integer
    Dim Action      As Integer
    Dim Msg         As String
    
    MsgType = MB_EXCLAIM
    Select Case errVal
	Case Err_DeviceUnavailable  ' Error #68
	    Msg = "That device appears to be unavailable."
	    MsgType = MB_EXCLAIM + 5
	Case Err_DiskNotReady       ' Error #71
	    Msg = "The disk is not ready."
	Case Err_DeviceIO
	    Msg = "The disk is full."
	Case Err_BadFileName, Err_BadFileNameOrNumber   ' Errors #64 & 52
	    Msg = "That file name is illegal."
	Case Err_PathDoesNotExist                        ' Error #76
	    Msg = "That path doesn't exist."
	Case Err_BadFileMode                            ' Error #54
	    Msg = "Can't open your file for that type of access."
	Case Err_FileAlreadyOpen                        ' Error #55
	    Msg = "That file is already open."
	Case Err_InputPastEndOfFile                     ' Error #62
	    Msg = "This file has a nonstandard end-of-file marker,"
	    Msg = Msg + "or an attempt was made to read beyond "
	    Msg = Msg + "the end-of-file marker."
	Case Else
	    FileErrors = 3
	    Exit Function
	End Select
	Response = MsgBox(Msg, MsgType, "File Error")
	Select Case Response
	    Case 4          ' Retry button.
		FileErrors = 0
	    Case 5          ' Ignore button.
		FileErrors = 1
	    Case 1, 2, 3    ' Ok and Cancel buttons.
		FileErrors = 2
	    Case Else
		FileErrors = 3
	End Select
End Function

Function FileOpener (NewFileName As String, Mode As Integer, RecordLen As Integer, Confirm As Integer) As Integer
     Dim NewFileNum         As Integer
     Dim Action             As Integer
     Dim FileExists         As Integer
     Dim Msg                As String
     
     On Error GoTo OpenerError
     If NewFileName Like "*[;-?[* ]*" Or NewFileName Like "*]*" Then Error Err_BadFileName
     If Confirm Then
	If Dir(NewFileName) = "" Then
	    FileExists = False
	Else
	    FileExists = True
	End If
	If Mode = REPLACEFILE And FileExists Then
	    Msg = "Replace contents of " + NewFileName + "?"
	    If MsgBox(Msg, 49, "Replace File?") = 2 Then
		FileOpener = 0
		Exit Function
	    End If
	End If
	If Not FileExists Then
	    Msg = "The file " + NewFileName + " does not exist. "
	    Msg = Msg + "Do you want to create it?"
	    If MsgBox(Msg, 1, "Create File?") = 2 Then
		FileOpener = 0
		Exit Function
	    End If
	End If
     End If
     NewFileNum = FreeFile
     Select Case Mode
	  Case REPLACEFILE
	    Open NewFileName For Output As NewFileNum
	  Case READFILE
	    Open NewFileName For Input As NewFileNum
	  Case ADDTOFILE
	    Open NewFileName For Append As NewFileNum
	  Case RANDOMFILE
	    Open NewFileName For Random As NewFileNum Len = RecordLen
	  Case BINARYFILE
	    Open NewFileName For Binary As NewFileNum
	  Case Else
	    Exit Function
     End Select
     FileOpener = NewFileNum
Exit Function

OpenerError:
     Action = FileErrors(Err)
     Select Case Action
	Case 0
	    Resume
	Case Else
	    FileOpener = 0
	    Exit Function
     End Select
End Function

Function GetFilename (Prompt As String, TheDefault As String) As String
    GetFilename = LTrim$(RTrim$(UCase$(InputBox$(Prompt, "Enter File Name", TheDefault))))
End Function

