' **************************************************************************
' Orginal file: VIM.BAS
' PURPOSE: Visual Basic declarations in using the VIM.DLL.  This file is a
'          translation on the file VIM.H.  Those function calls starting
'          with the prefix "vb_" come from the VIMVBWRP.DLL which provides
'          the wrapper functions and necessary C structures in using the
'          VIM.DLL with Visual Basic.
' Version: 1.0
' **************************************************************************

Global Const VIM_CURRENT_VERSION = 100&
Global Const VB_MAXBUFFERSIZE = 2048
Global Const VB_MAXNAMESIZE = 256


' **********************************************************************
'  VIM Types
' **********************************************************************

Type vb_vimref
   Ref0 As Long
   Ref1 As Long
End Type

Type vb_vimEnumRef
   Ref0 As Long
   Ref1 As Long
End Type


Type VIMdistinguishedname       ' Distinguished Entity Name
   SType As Long                ' Type of name (e.g., VIMSEL_X500)
   AddressBook As String * 256  ' Address book name
   Value As String * 1024       ' Entity name
End Type

Type Newdistinguishedname       ' Distinguished Entity Name
   SType As Long                ' Type of name (e.g., VIMSEL_X500)
   AddressBook As String * 256  ' Address book name
   Value As String * 126        ' Entity name
End Type

Type publicdistinguishedname       ' Distinguished Entity Name
   SType As Long                ' Type of name (e.g., VIMSEL_X500)
   AddressBook As String * 256  ' Address book name
   Value As String * 126        ' Entity name
End Type


Type vimAddress
   SType As Long                ' Type of address (e.g., VIMSEL_X400)
   Value As String * 1024       ' Address string
End Type


Type vimRecipient
   SType As Long                    ' VIMSEL_ENTITY, GROUP, etc.
   DName As VIMdistinguishedname    ' Name
   Address As vimAddress            ' Address
End Type


Type vb_vimattrdesc             ' Attribute descriptor with fix size Buffer
   Attr As Long                 ' Attribute selector
   Size As Long                 ' Buffer or buffer array entry size
   'buffer As String * VB_MAXBUFFERSIZE  ' Buffer or buffer array pointer
   buffer As String * 29
End Type
            
Type vimAttrDesc                ' Attribute descriptor with variable length Buffer
   Attr As Long                 ' Attribute selector
   Size As Long                 ' Buffer or buffer array entry size
   buffer As Long               ' To be allocated from C routine
End Type


Type vb_vimNamedAttrDesc        ' Name attribute descriptor.  Fix size Buffer and Attr fields
   Attr As String * VB_MAXNAMESIZE
   Size As Long
   buffer As String * VB_MAXBUFFERSIZE
End Type

Type vimNamedAttrDesc
    Attr As Long            ' To be allocated explicitly
    Size As Long
    buffer As Long          ' To be allocated explicitly
End Type


Type vimItemDesc
   Class As Long            ' VIMSEL_NOTE_PART,VIMSEL_ATTACH,VIMSEL_APP_DEFINED
   SType As String * 64     ' Item Type
   Name As String * 256     ' Title for note part OR file name for attachments
   Path As String * 256     ' Holds pathname for attachments
   Size As Long             ' Item size
   Ref As vb_vimref         ' item ref
End Type


Type vb_vimBuffFileDesc     ' File Buffer Descriptor.  Fix size Buffer and FileName
   Size As Long             ' Buffer size or number of bytes to read
                            ' MUST BE ZERO if FileName is used
   buffer As String * VB_MAXBUFFERSIZE
   Offset As Long           ' Starting offset at which to start
   FileName As String * VB_MAXNAMESIZE  ' File name string
End Type

Type vimBuffFileDesc
    Size As Long
    buffer As Long      ' A void pointer To be allocated
    Offset As Long
    FileName As Long    ' A void pointer to be allocated
End Type


Type vimDate
   Zone As Long      ' Time zone (VIMSEL_LOCAL means local time,
                     ' VIMSEL_GMT means GMT, other values TBD
   Date As Long      ' Date
                     ' low-order byte is day (1 to 31)
                     ' next-order byte is month (1 to 12)
                     ' high-order word is year (1980 to 2099)
                     ' VIM_UNKNOWN_DATE means undefined and
                     ' Time is ignored
   Time As Long      ' Time
                     ' low-order byte is 0.01 second (0 to 99)
                     ' next-order byte is second (0 to 59)
                     ' next-order byte is minute (0 to 59)
                     ' high-order byte is hour (0 to 23)
                     ' VIM_UNKNOWN_TIME means undefined time
                     ' even though date may be known.
End Type


Type vimDateRange      ' Date Range
   Start As vimDate    ' Starting date and time
   Stop As vimDate     ' Ending date and time
End Type

' **********************************************************************
'  vimSelector values.
' **********************************************************************

Global Const VIMSEL_ADDRESS = 1&
Global Const VIMSEL_ADMINISTRATOR = 2&
Global Const VIMSEL_ALL_NOTE_PARTS_SUPP = 3&
Global Const VIMSEL_APP_DEFINED = 4&
Global Const VIMSEL_APPLESINGLE = 5&
Global Const VIMSEL_ATTACH = 6&
Global Const VIMSEL_ATTACH_DIRS = 7&
Global Const VIMSEL_ATTACH_TYPE_SUPP = 8&
Global Const VIMSEL_BCC = 9&
Global Const VIMSEL_CC = 10&
Global Const VIMSEL_CCMAIL = 11&
Global Const VIMSEL_CERTIFIER = 12&
Global Const VIMSEL_CLASS = 13&
Global Const VIMSEL_COMMENTS = 14&
Global Const VIMSEL_CONVERSATION_ID = 15&
Global Const VIMSEL_CP1252 = 16&
Global Const VIMSEL_CP437 = 17&
Global Const VIMSEL_CP850 = 18&
Global Const VIMSEL_DATE = 19&
Global Const VIMSEL_DELIVERY_DATE = 20&
Global Const VIMSEL_DELIVERY_REPORT = 21&
Global Const VIMSEL_DISPLAY_NAME = 22&
Global Const VIMSEL_DRAFT = 23&
Global Const VIMSEL_ENCRYPT = 24&
Global Const VIMSEL_ENCRYPT_WITH_KEY = 25&
Global Const VIMSEL_ENTITY = 26&
Global Const VIMSEL_EXPIRATION_DATE = 27&
Global Const VIMSEL_FAILED = 28&
Global Const VIMSEL_FAILURE_CODE = 29&
Global Const VIMSEL_FAILURE_REASON = 30&
Global Const VIMSEL_FAX = 31&
Global Const VIMSEL_FIRST_NAME = 32&
Global Const VIMSEL_FORWARD = 33&
Global Const VIMSEL_FROM = 34&
Global Const VIMSEL_FROM_NAME = 35&
Global Const VIMSEL_FULL = 36&
Global Const VIMSEL_GMT = 37&
Global Const VIMSEL_GROUP = 38&
Global Const VIMSEL_IMAG = 39&
Global Const VIMSEL_IN_REPLY_TO = 40&
Global Const VIMSEL_ISTRING = 41&
Global Const VIMSEL_KEYWORD = 42&
Global Const VIMSEL_LAST_NAME = 43&
Global Const VIMSEL_LMBCS = 44&
Global Const VIMSEL_LOCAL = 45&
Global Const VIMSEL_MAX_SUBJECT_LEN = 46&
Global Const VIMSEL_MAX_TEXT_LEN = 47&
Global Const VIMSEL_MAX_TYPE_LEN = 48&
Global Const VIMSEL_MHS = 49&
Global Const VIMSEL_MIDDLE_NAME = 50&
Global Const VIMSEL_MOVIE = 51&
Global Const VIMSEL_MSGMGR = 52&
Global Const VIMSEL_NAME = 53&
Global Const VIMSEL_NAME_REQUIRED = 54&
Global Const VIMSEL_NATIVE = 55&
Global Const VIMSEL_NESTED_MSG = 56&
Global Const VIMSEL_NESTING_DEPTH = 57&
Global Const VIMSEL_NO_FILTER = 58&
Global Const VIMSEL_NONDELIVERY_CONTENTS = 59&
Global Const VIMSEL_NONDELIVERY_REPORT = 60&
Global Const VIMSEL_NOT_SUPPORTED = 61&
Global Const VIMSEL_NOTE_PART = 62&
Global Const VIMSEL_NOTES = 63&
Global Const VIMSEL_NSTD_DERIVED_FORWRDS = 64&
Global Const VIMSEL_NSTD_DERIVED_REPLIES = 65&
Global Const VIMSEL_OCE = 66&
Global Const VIMSEL_PARTIAL = 67&
Global Const VIMSEL_PASS_REQUIRED = 68&
Global Const VIMSEL_PATH_REQUIRED = 69&
Global Const VIMSEL_PICT = 70&
Global Const VIMSEL_PRIORITY = 71&
Global Const VIMSEL_PRODUCT = 72&
Global Const VIMSEL_RDN = 73&
Global Const VIMSEL_READ_DATE = 74&
Global Const VIMSEL_RECIPIENT = 75&
Global Const VIMSEL_REF = 76&
Global Const VIMSEL_REPLY = 77&
Global Const VIMSEL_RESPOND_BY = 78&
Global Const VIMSEL_RETURN_RECEIPT = 79&
Global Const VIMSEL_RTF = 80&
Global Const VIMSEL_SAVE = 81&
Global Const VIMSEL_SENSITIVITY = 82&
Global Const VIMSEL_SENT = 83&
Global Const VIMSEL_SIGN = 84&
Global Const VIMSEL_SIGNER = 85&
Global Const VIMSEL_SORT_ORDER = 86&
Global Const VIMSEL_SORTED_LASTNAME = 87&
Global Const VIMSEL_SORTED_NAME = 88&
Global Const VIMSEL_SORTED_RDN = 89&
Global Const VIMSEL_STYLED = 90&
Global Const VIMSEL_SUBJECT = 91&
Global Const VIMSEL_SUBJECT_LEN = 92&
Global Const VIMSEL_SUBTREE = 93&
Global Const VIMSEL_SUCCEEDED = 94&
Global Const VIMSEL_SUPP_WITH_CONV = 95&
Global Const VIMSEL_SUPP_WITHOUT_CONV = 96&
Global Const VIMSEL_TO = 97&
Global Const VIMSEL_TYPE = 98&
Global Const VIMSEL_UNICODE = 99&
Global Const VIMSEL_UNIQUE_MSG_ID = 100&
Global Const VIMSEL_UNKNOWN_RECIP_TYPE = 101&
Global Const VIMSEL_UNKNOWN_SORT = 102&
Global Const VIMSEL_UNREAD_MAIL = 103&
Global Const VIMSEL_UNSORTED = 104&
Global Const VIMSEL_UNWRAPPED_TEXT = 105&
Global Const VIMSEL_VERSION = 106&
Global Const VIMSEL_X400 = 107&
Global Const VIMSEL_X500 = 108&


' **********************************************************************
'  Symbolic Names
' **********************************************************************

Global Const VIM_DLR = "VIM_DLR"
Global Const VIM_FAX = "VIM_FAX"
Global Const VIM_IMAG = "VIM_IMAG"
Global Const VIM_MAIL = "VIM_MAIL"
Global Const VIM_MOVIE = "VIM_MOVIE"
Global Const VIM_NDLR = "VIM_NDLR"
Global Const VIM_PICT = "VIM_PICT"
Global Const VIM_PRIVATE = "VIM_PRIVATE"
Global Const VIM_PUBLIC = "VIM_PUBLIC"
Global Const VIM_RTF = "VIM_RTF"
Global Const VIM_RTRC = "VIM_RTRC"
Global Const VIM_STYLED = "VIM_STYLED"
Global Const VIM_TEXT = "VIM_TEXT"
Global Const VIM_UNWRAPPED_TEXT = "VIM_UNWRAPPED_TEXT"


' **********************************************************************
'  TRUE/FALSE.
' **********************************************************************
Global Const VIM_FALSE = 0
Global Const VIM_TRUE = 1

' **********************************************************************
'  Priority values for VIMSEL_PRIORITY.
' **********************************************************************

Global Const VIM_LOW_PRIORITY = 0
Global Const VIM_NORMAL_PRIORITY = 1
Global Const VIM_HIGH_PRIORITY = 2

' **********************************************************************
' Bits for dwFlags parameter of VIMCreateDerrivedMessage call when
' VIMSEL_FORWARD is used.
' **********************************************************************
Global Const VIM_HISTORY = &H1

' **********************************************************************
'  Bits for dwFlags parameter of VIMCreateDerrivedMessage call when
'   VIMSEL_REPLY is used.
' **********************************************************************
Global Const VIM_INHERIT_CONTENTS = &H2
Global Const VIM_ALL_RECIPIENTS = &H4

'Global Const VIM_UNREADONLY = &H1
Global Const VIM_UNREADONLY = 1&

Global Const VIM_NORMAL_SENS = 0
Global Const VIM_PRIVATE_SENS = 1
Global Const VIM_PERSONAL_SENS = 2
Global Const VIM_CO_CONFID_SENS = 3
Global Const VIM_APP_DEF_SENS = 16384

' **********************************************************************
'  Bits for flags parameter of VIMExtract Message call
' **********************************************************************
Global Const VIM_EXTRACT_REF = &H1

Declare Function vb_VIM_SKIP_RECIP% Lib "VIMVBWRP.DLL" ()

Declare Function vb_VIM_UNKNOWN_DATE& Lib "VIMVBWRP.DLL" ()

Declare Function vb_VIM_UNKNOWN_TIME& Lib "VIMVBWRP.DLL" ()

' **********************************************************************
'  Macros for accessing the VIM error or the extended error.
' **********************************************************************

Declare Function vb_VIM_STATUS% Lib "VIMVBWRP.DLL" (ByVal L&)
Declare Function vb_VIM_EXT_STATUS% Lib "VIMVBWRP.DLL" (ByVal L&)


' **********************************************************************
'  Macros for manipulating a vimRef or vimEnumRef.
' **********************************************************************

Declare Sub vb_VIM_UND_REF Lib "VIMVBWRP.DLL" (x As Any)
Declare Sub vb_VIM_ROOT_REF Lib "VIMVBWRP.DLL" (x As Any)
Declare Sub vb_VIM_PARENT_REF Lib "VIMVBWRP.DLL" (x As Any)

' **********************************************************************
'  Status returns.
' **********************************************************************

Global Const VIMSTS_SUCCESS = 0
Global Const VIMSTS_FAILURE = 1
Global Const VIMSTS_FATAL = 2

Global Const VIMSTS_ALL_PARAMS_REQUIRED = 3
Global Const VIMSTS_ATTACHMENT_NOT_FOUND = 4
Global Const VIMSTS_BAD_PARAM = 5
Global Const VIMSTS_BUF_TOO_SMALL = 6
Global Const VIMSTS_CONV_NOT_SUPPORTED = 7
Global Const VIMSTS_INSUFFICIENT_MEMORY = 8
Global Const VIMSTS_INVALID_CONFIGURATION = 9
Global Const VIMSTS_INVALID_OBJECT = 10
Global Const VIMSTS_INVALID_PASSWORD = 11
Global Const VIMSTS_INVALID_SELECTOR = 12
Global Const VIMSTS_INVALID_SIGNATURE = 13
Global Const VIMSTS_NAME_EXISTS = 14
Global Const VIMSTS_NAME_NOT_FOUND = 15
Global Const VIMSTS_NOT_SUPPORTED = 16
Global Const VIMSTS_NO_COMMON_CERTIFICATES = 17
Global Const VIMSTS_NO_DEFAULT = 18
Global Const VIMSTS_NO_MATCH = 19
Global Const VIMSTS_NO_SIGNATURE = 20
Global Const VIMSTS_NO_SUCH_ATTRIBUTE = 21
Global Const VIMSTS_OPEN_FAILURE = 22
Global Const VIMSTS_PASS_REQUIRED = 23
Global Const VIMSTS_READ_FAILURE = 24
Global Const VIMSTS_UNSUP_TYPE = 25
Global Const VIMSTS_UNSUP_VERSION = 26
Global Const VIMSTS_WRITE_FAILURE = 27


' **********************************************************************
'  Function Prototypes
' **********************************************************************

' vimStatus VIMAPIENTRY VIMAddGroupMember(   vimAddressBook addressBook,
'                                vimRef entryRef,
'                                vimStringPtr entryName,
'                                vimDistinguishedNamePtr pDisName);
'Declare Function vb_VIMAddGroupMember& Lib "VIMVBWRP.DLL" (ByVal AddressBook&, entryRef As vb_vimref, ByVal entryName As Any, pDisName As VIMdistinguishedname)
Declare Function vb_VIMAddGroupMember& Lib "VIMVBWRP.DLL" (ByVal AddressBook&, entryRef As vb_vimref, ByVal entryName As Any, pDisName As Newdistinguishedname)

' vimStatus VIMAPIENTRY VIMCloseAddressBook( vimAddressBook addrBook);
Declare Function VIMCloseAddressBook& Lib "VIM.DLL" (ByVal addrBook&)

'vimStatus VIMAPIENTRY VIMCloseMessage( vimMsg message);
Declare Function VIMCloseMessage& Lib "VIM.DLL" (ByVal message&)

'vimStatus VIMAPIENTRY VIMCloseMessageContainer( vimMsgContainer msgContainer);
Declare Function VIMCloseMessageContainer& Lib "VIM.DLL" (ByVal msgContainer&)

'vimStatus VIMAPIENTRY VIMCloseMessageItem(  vimMsgItem msgItem);
Declare Function VIMCloseMessageItem& Lib "VIM.DLL" (ByVal msgItem&)

'vimStatus VIMAPIENTRY VIMCloseSession(   vimSes session);
Declare Function VIMCloseSession& Lib "VIM.DLL" (ByVal session&)


'vimStatus VIMAPIENTRY VIMCreateAddressBookEntry(  vimAddressBook addressBook,
'                                      vimSelector entryType,
'                                      vimWord attrCount,
'                                      vimAttrDescPtr pAttrDesc);
Declare Function VIMCreateAddressBookEntry& Lib "VIM.DLL" (ByVal AddressBook&, ByVal entryType&, ByVal attrCount%, pAttrDesc As vimAttrDesc)
Declare Function vb_VIMCreateAddressBookEntry& Lib "VIMVBWRP.DLL" (ByVal AddressBook&, ByVal entryType&, ByVal attrCount%, pAttrDesc As vb_vimattrdesc)


' vimStatus VIMAPIENTRY VIMCreateDerivedMailMessage(  vimMsg message,
'                                      vimSelector selMsgType,
'                                      vimDWord dwFlags,
'                                      vimMsgPtr pMessage);
Declare Function VIMCreateDerivedMailMessage& Lib "VIM.DLL" (ByVal message&, ByVal selMsgType&, ByVal dwFlags&, pMessage&)

' vimStatus VIMAPIENTRY VIMCreateMessage( vimSes session,
'                                vimStringPtr psType,
'                                vimMsgPtr pMessage);
Declare Function VIMCreateMessage& Lib "VIM.DLL" (ByVal session&, ByVal psType$, pMessage&)

' vimStatus VIMAPIENTRY VIMEnumerateABEntryAttrNames(
'                          vimAddressBook addressBook,
'                          vimRef entryRef,
'                          vimStringPtr entryName,
'                          vimEnumRefPtr pPos,
'                          vimInt skipCount,
'                          vimWord buffEntrySize,
'                          vimStringPtr pBuffArray,
'                          vimWordPtr pCount,
'                          vimBoolPtr pMore);
 Declare Function vb_VIMEnumerateABEntryAttrNames Lib "VIMVBWRP.DLL" (ByVal AddressBook&, entryRef As vb_vimref, ByVal entryName As Any, pPos As vb_vimEnumRef, ByVal skipCount&, ByVal buffEntrySize%, ByVal pBuffArray As Any, pCount%, pMore%)

' vimStatus VIMAPIENTRY VIMEnumerateAddressBookEntries(
'                          vimAddressBook addressBook,
'                          vimRef subtreeRef,
'                          vimStringPtr subtreeName,
'                          vimEnumRefPtr pPos,
'                          vimInt skipCount,
'                          vimWord attrCount,
'                          vimAttrDescPtr pAttrDesc,
'                          vimWordPtr pCount,
'                          vimSelector selFiltType,
'                          vimDataPtr pFiltData,
'                          vimBoolPtr pMore);
Declare Function vb1_VIMEnumerateABEntries& Lib "VIMVBWRP.DLL" (ByVal ab&, sRef As vb_vimref, ByVal N As Any, pPos As vb_vimEnumRef, ByVal skip&, ByVal Attr%, desc As vb_vimattrdesc, pCount%, ByVal sFiltType&, pFiltData As Any, pMore%)
Declare Function vb2_VIMEnumerateABEntries& Lib "VIMVBWRP.DLL" (ByVal ab&, sRef As vb_vimref, ByVal N As Any, pPos As vb_vimEnumRef, ByVal skip&, ByVal Attr%, desc As vimAttrDesc, pCount%, ByVal sFiltType&, pFiltData As Any, pMore%)


' vimStatus VIMAPIENTRY VIMEnumerateAddressBooks(  vimSes session,
'                                      vimEnumRefPtr pPos,
'                                      vimInt skipCount,
'                                      vimWord attrCount,
'                                      vimAttrDescPtr pAttrDesc,
'                                      vimWordPtr pCount,
'                                      vimBoolPtr pMore);
Declare Function VIMEnumerateAddressBooks& Lib "VIM.DLL" (ByVal session&, pPos As vb_vimEnumRef, ByVal skipCount&, ByVal attrCount%, pAttrDesc As vimAttrDesc, pCount%, pMore%)
Declare Function vb_VIMEnumerateAddressBooks& Lib "VIMVBWRP.DLL" (ByVal session&, pPos As vb_vimEnumRef, ByVal skipCount&, ByVal attrCount%, pAttrDesc As vb_vimattrdesc, pCount%, pMore%)

 
' vimStatus VIMAPIENTRY VIMEnumerateGroupMembers(  vimAddressBook addressBook,
'                                      vimRef entryRef,
'                                      vimStringPtr entryName,
'                                      vimEnumRefPtr pPos,
'                                      vimInt skipCount,
'                                      vimWord attrCount,
'                                      vimAttrDescPtr pAttrDesc,
'                                      vimWordPtr pCount,
'                                      vimBoolPtr pMore);
Declare Function vb1_VIMEnumerateGroupMembers& Lib "VIMVBWRP.DLL" (ByVal AddressBook&, entryRef As vb_vimref, ByVal entryName As Any, pPos As vb_vimEnumRef, ByVal skipCount&, ByVal attrCount%, pAttrDesc As vb_vimattrdesc, pCount%, pMore%)
Declare Function vb2_VIMEnumerateGroupMembers& Lib "VIMVBWRP.DLL" (ByVal AddressBook&, entryRef As vb_vimref, ByVal entryName As Any, pPos As vb_vimEnumRef, ByVal skipCount&, ByVal attrCount%, pAttrDesc As vimAttrDesc, pCount%, pMore%)

' vimStatus VIMAPIENTRY VIMEnumerateMessages(   vimMsgContainer msgContainer,
'                                   vimEnumRefPtr pPos,
'                                   vimInt skipCount,
'                                   vimWord attribCount,
'                                   vimAttrDescPtr pAttribDesc,
'                                   vimWordPtr pMsgCount,
'                                   vimSelector selFiltType,
'                                   vimDataPtr pFiltData,
'                                   vimDWord flags,
'                                   vimBoolPtr pMore);
Declare Function VIMEnumerateMessages& Lib "VIM.DLL" (ByVal msgContainer&, pPos As vb_vimEnumRef, ByVal skipCount&, ByVal attribCount%, pAttribDesc As vimAttrDesc, pMsgCount%, ByVal selFiltType&, ByVal pFiltData As Any, ByVal flags&, pMore%)
Declare Function vb_VIMEnumerateMessages& Lib "VIMVBWRP.DLL" (ByVal msgContainer&, pPos As vb_vimEnumRef, ByVal skipCount&, ByVal attribCount%, pAttribDesc As vb_vimattrdesc, pMsgCount%, ByVal selFiltType&, ByVal pFiltData As Any, ByVal flags&, pMore%)
 
' vimStatus VIMAPIENTRY VIMEnumerateMessageHeaderAttrs(
'                                   vimMsg msg,
'                                   vimSelector selAttr,
'                                   vimEnumRefPtr pPos,
'                                   vimInt skipCount,
'                                   vimWord buffEntrySize,
'                                   vimStringPtr pBuffArray,
'                                   vimWordPtr pCount,
'                                   vimBoolPtr pMore);
Declare Function VIMEnumerateMessageHeaderAttrs& Lib "VIM.DLL" (ByVal msg&, ByVal selAttr&, pPos As vb_vimEnumRef, ByVal skipCount&, ByVal buffEntrySize%, ByVal pBuffArray As Any, pCount&, pMore%)
 
' vimStatus VIMAPIENTRY VIMEnumerateMessageItems(  vimMsg message,
'                                      vimEnumRefPtr pPos,
'                                      vimInt skipCount,
'                                      vimWordPtr pCount,
'                                      vimItemDescPtr pDesc,
'                                      vimSelector selFiltType,
'                                      vimDataPtr pFiltData,
'                                      vimBoolPtr pMore);
Declare Function VIMEnumerateMessageItems& Lib "VIM.DLL" (ByVal message&, pPos As vb_vimEnumRef, ByVal skipCount&, pCount%, pDesc As vimItemDesc, ByVal selFiltType&, pFiltData As Any, pMore%)


' vimStatus VIMAPIENTRY VIMEnumerateMessageRecipients(
'                                   vimMsg message,
'                                   vimSelector selType,
'                                   vimEnumRefPtr pPos,
'                                   vimInt skipCount,
'                                   vimWord attrCount,
'                                   vimAttrDescPtr pAttrDesc,
'                                   vimWordPtr pCount,
'                                   vimBoolPtr pMore);
Declare Function VIMEnumerateMessageRecipients& Lib "VIM.DLL" (ByVal message&, ByVal selType&, pPos As vb_vimEnumRef, ByVal skipCount&, ByVal attrCount%, pAttrDesc As vimAttrDesc, pCount%, pMore%)
Declare Function vb_VIMEnumerateMessageRecipients& Lib "VIMVBWRP.DLL" (ByVal message&, ByVal selType&, pPos As vb_vimEnumRef, ByVal skipCount&, ByVal attrCount%, pAttrDesc As vb_vimattrdesc, pCount%, pMore%)


' vimStatus VIMAPIENTRY VIMEnumerateMsgAttrValues(
'                                   vimMsgContainer msgContr,
'                                   vimSelector selAttr,
'                                   vimEnumRefPtr pPos,
'                                   vimInt skipCount,
'                                   vimWord buffEntrySize,
'                                   vimStringPtr pBuffArray,
'                                   vimWordPtr pCount,
'                                   vimBoolPtr pMore);
Declare Function VIMEnumerateMsgAttrValues& Lib "VIM.DLL" (ByVal msgContr&, ByVal selAttr&, pPos As vb_vimEnumRef, ByVal skipCount&, ByVal buffEntrySize%, ByVal pBuffArray As Any, pCount%, pMore%)

' vimStatus VIMAPIENTRY VIMExtractMessage(   vimMsg msg,
'                                vimDWord dwFlags,
'                                vimStringPtr strFileSpec );
Declare Function VIMExtractMessage& Lib "VIM.DLL" (ByVal msg&, ByVal dwFlags&, ByVal strFileSpec$)
 
' vimStatus VIMAPIENTRY VIMGetABEntryAttributes(   vimAddressBook addressBook,
'                                   vimRef entryRef,
'                                   vimStringPtr entryName,
'                                   vimWord attrCount,
'                                   vimAttrDescPtr pAttrDesc);
Declare Function vb1_VIMGetABEntryAttributes& Lib "VIMVBWRP.DLL" (ByVal AddressBook&, entryRef As vb_vimref, ByVal entryName As Any, ByVal attrCount%, pAttrDesc As vb_vimattrdesc)
Declare Function vb2_VIMGetABEntryAttributes& Lib "VIMVBWRP.DLL" (ByVal AddressBook&, entryRef As vb_vimref, ByVal entryName As Any, ByVal attrCount%, pAttrDesc As vimAttrDesc)


' vimStatus VIMAPIENTRY VIMGetABEntryNamedAttributes(
'                                   vimAddressBook addressBook,
'                                   vimRef entryRef,
'                                   vimStringPtr entryName,
'                                   vimWord attrCount,
'                                   vimNamedAttrDescPtr pAttrDesc);
Declare Function vb1_VIMGetABEntryNamedAttributes& Lib "VIMVBWRP.DLL" (ByVal AddressBook&, entryRef As vb_vimref, ByVal entryName As Any, ByVal attrCount%, pAttrDesc As vb_vimNamedAttrDesc)
Declare Function vb2_VIMGetABEntryNamedAttributes& Lib "VIMVBWRP.DLL" (ByVal AddressBook&, entryRef As vb_vimref, ByVal entryName As Any, ByVal attrCount%, pAttrDesc As vimNamedAttrDesc)


 
' vimStatus VIMAPIENTRY VIMGetCurrentSubtree(   vimAddressBook addressBook,
'                                   vimRefPtr pRef,
'                                   vimWord wNameSize,
'                                   vimStringPtr psName);
Declare Function VIMGetCurrentSubtree& Lib "VIM.DLL" (ByVal AddressBook&, pRef As vb_vimref, ByVal wNameSize%, ByVal psName$)

 
' vimStatus VIMAPIENTRY VIMGetDefaultSessionInfo(  vimWord sizePath,
'                                      vimStringPtr psPathSpec,
'                                      vimWord sizeName,
'                                      vimStringPtr psName);
Declare Function VIMGetDefaultSessionInfo& Lib "VIM.DLL" (ByVal sizePath%, ByVal psPathSpec$, ByVal sizeName%, ByVal psName$)
 
' vimStatus VIMAPIENTRY VIMGetEntityName( vimSes session,
'                                vimDistinguishedNamePtr pDistName);
Declare Function VIMGetEntityName& Lib "VIM.DLL" (ByVal session&, pDistName As VIMdistinguishedname)
 
' vimStatus VIMAPIENTRY VIMGetMessageHeader( vimMsg message,
'                                vimWord attrCount,
'                                vimAttrDescPtr pAttrDesc);
Declare Function VIMGetMessageHeader& Lib "VIM.DLL" (ByVal message&, ByVal attrCount%, pAttrDesc As vimAttrDesc)
Declare Function vb_VIMGetMessageHeader& Lib "VIMVBWRP.DLL" (ByVal message&, ByVal attrCount%, pAttrDesc As vb_vimattrdesc)

' vimStatus VIMAPIENTRY VIMGetMessageItem(   vimMsg message,
'                                vimRef refItem,
'                                vimStringPtr psConvertType,
'                                vimSelector selFlags,
'                                vimBuffFileDescPtr pBuffFileDesc );
Declare Function vb1_VIMGetMessageItem& Lib "VIMVBWRP.DLL" (ByVal message&, refItem As vb_vimref, ByVal psConvertType As Any, ByVal selFlags&, pBuffFileDesc As vb_vimBuffFileDesc)
Declare Function vb2_VIMGetMessageItem& Lib "VIMVBWRP.DLL" (ByVal message&, refItem As vb_vimref, ByVal psConvertType As Any, ByVal selFlags&, pBuffFileDesc As vimBuffFileDesc)


' vimStatus VIMAPIENTRY VIMInitialize( vimVoid );
Declare Function VIMInitialize& Lib "VIM.DLL" ()

' vimStatus VIMAPIENTRY VIMMarkMessageAsRead(   vimMsgContainer msgContainer,
'                                   vimRef msgRef );
Declare Function vb_VIMMarkMessageAsRead& Lib "VIMVBWRP.DLL" (ByVal msgContainer&, msgRef As vb_vimref)

' vimStatus VIMAPIENTRY VIMMatchAddressBook( vimAddressBook addressBook,
'                                vimRef subtreeRef,
'                                vimStringPtr subtreeName,
'                                vimSelector selAttr,
'                                vimDataPtr pData,
'                                vimSelector ft,
'                                vimRefPtr pRef,
'                                vimEnumRefPtr pEnumRef);
Declare Function vb_VIMMatchAddressBook& Lib "VIMVBWRP.DLL" (ByVal AddressBook&, subtreeRef As vb_vimref, ByVal subtreeName As Any, ByVal selAttr&, pData As Any, ByVal ft&, pRef As vb_vimref, pEnumRef As Any)

' vimStatus VIMAPIENTRY VIMOpenAddressBook(  vimSes session,
'                                vimStringPtr psName,
'                                vimAddressBookPtr pAddressBook);
Declare Function VIMOpenAddressBook& Lib "VIM.DLL" (ByVal vimSes&, ByVal psName$, pAddressBook&)
 
' vimStatus VIMAPIENTRY VIMOpenExtractedMessage( vimSes session,
'                                   vimStringPtr strFileSpec,
'                                   vimMsgPtr pMsg );
Declare Function VIMOpenExtractedMessage& Lib "VIM.DLL" (ByVal session&, ByVal strFileSpec$, pMsg&)
 
' vimStatus VIMAPIENTRY VIMOpenMessage(   vimMsgContainer msgContainer,
'                             vimRef refMessage,
'                             vimStringPtr key,
'                             vimMsgPtr pMessage);
Declare Function vb_VIMOpenMessage& Lib "VIMVBWRP.DLL" (ByVal msgConatiner&, refMessage As vb_vimref, ByVal key As Any, pMessage&)


' vimStatus VIMAPIENTRY VIMOpenMessageContainer(   vimSes session,
'                                   vimStringPtr psContainerName,
'                                   vimMsgContainerPtr pMsgContainer);
Declare Function VIMOpenMessageContainer& Lib "VIM.DLL" (ByVal session&, ByVal psContainerName As Any, pMsgContainer&)
 
' vimStatus VIMAPIENTRY VIMOpenMessageItem(  vimMsg message,
'                                vimRef refMsgItem,
'                                vimStringPtr psConvertType,
'                                vimSelector selFlags,
'                                vimMsgItemPtr pMsgItem);
Declare Function vb_VIMOpenMessageItem& Lib "VIMVBWRP.DLL" (ByVal message&, refMsgItem As vb_vimref, ByVal psConvertType As Any, ByVal selFlags&, pMsgItem&)

' vimStatus VIMAPIENTRY VIMOpenNestedMessage(   vimMsg message,
'                                   vimRef refNested,
'                                   vimMsgPtr pNestedMessage);
Declare Function vb_VIMOpenNestedMessage& Lib "VIMVBWRP.DLL" (ByVal message&, refNested As vb_vimref, pNestedMessage&)
 
' vimStatus VIMAPIENTRY VIMOpenSession(   vimStringPtr psPathSpec,
'                             vimStringPtr psName,
'                             vimStringPtr psPass,
'                             vimDWord dwVersion,
'                             vimSelector selCharSet,
'                             vimSesPtr pSession);
Declare Function VIMOpenSession& Lib "VIM.DLL" (ByVal psPathSpec As Any, ByVal psName As Any, ByVal psPass As Any, ByVal dwVersion&, ByVal selCharSet&, session&)


' vimStatus VIMAPIENTRY VIMQueryCapability(  vimSelector selType,
'                                vimWord sizeData,
'                                vimDataPtr pData);
Declare Function VIMQueryCapability& Lib "VIM.DLL" (ByVal selType&, ByVal sizeData%, pData As Any)

' vimStatus VIMAPIENTRY VIMQueryNewMessages( vimMsgContainer msgContainer,
'                                vimBoolPtr pbNewMessages);
Declare Function VIMQueryNewMessages& Lib "VIM.DLL" (ByVal msgContainer&, pbNewMessages%)
 
' vimStatus VIMAPIENTRY VIMQueryUnreadMailCount(   vimMsgContainer inbox,
'                                   vimDWordPtr pdwNumUnread);
Declare Function VIMQueryUnreadMailCount& Lib "VIM.DLL" (ByVal inbox&, pdwNumUnread&)
 
' vimStatus VIMAPIENTRY VIMReadMessageItem(  vimMsgItem msgItem,
'                                vimBuffFileDescPtr pBuffFileDesc);
Declare Function VIMReadMessageItem& Lib "VIM.DLL" (ByVal msgItem&, pBuffFileDesc As vimBuffFileDesc)
Declare Function vb_VIMReadMessageItem& Lib "VIMVBWRP.DLL" (ByVal msgItem&, pBuffFileDesc As vb_vimBuffFileDesc)

' vimStatus VIMAPIENTRY VIMRemoveAddressBookEntry(
'                             vimAddressBook addressBook,
'                             vimRef entryRef,
'                             vimStringPtr entryName);
Declare Function vb_VIMRemoveAddressBookEntry& Lib "VIMVBWRP.DLL" (ByVal AddressBook&, entryRef As vb_vimref, ByVal entryName As Any)

 
' vimStatus VIMAPIENTRY VIMRemoveGroupMember(
'                             vimAddressBook addressBook,
'                             vimRef entryRef,
'                             vimStringPtr entryName,
'                             vimDistinguishedNamePtr pDisName);
'Declare Function vb_VIMRemoveGroupMember Lib "VIMVBWRP.DLL" (ByVal AddressBook&, entryRef As vb_vimref, ByVal entryName As Any, pDisName As VIMdistinguishedname)
Declare Function vb_VIMRemoveGroupMember& Lib "VIMVBWRP.DLL" (ByVal AddressBook&, entryRef As vb_vimref, ByVal entryName As Any, pDisName As publicdistinguishedname)

' vimStatus VIMAPIENTRY VIMRemoveMessage( vimMsgContainer msgContainer,
'                                vimRef msgRef);
Declare Function vb_VIMRemoveMessage& Lib "VIMVBWRP.DLL" (ByVal msgContainer&, msgRef As vb_vimref)

' vimStatus VIMAPIENTRY VIMSendMessage(   vimMsg message,
'                             vimDataPtr pCallbackParam,
'                             vimSendCallback callBack );
Declare Function VIMSendMessage& Lib "VIM.DLL" (ByVal message&, pCallbackParam As Any, ByVal callBack As Any)
Declare Function vb_VIMSendMessage& Lib "VIMVBWRP.DLL" (ByVal message&, pCallbackParam As Any, ByVal callBack As Any, ByVal vbCallback%)
' vbCallback in vb_VIMSendMessage is for predefined callback functions to VIMSendMessage
' 0: no callback ( pass NULLs to VIMSendMessage )
' 1: send the message to all valid recipients and ignore the invalid ones.
' 2: reject the message if the callback is called.

' vimStatus VIMAPIENTRY VIMSetABEntryAttributes(   vimAddressBook addressBook,
'                                   vimRef entryRef,
'                                   vimStringPtr entryName,
'                                   vimWord attrCount,
'                                   vimAttrDescPtr pAttrDesc);
Declare Function vb1_VIMSetABEntryAttributes& Lib "VIMVBWRP.DLL" (ByVal AddressBook&, entryRef As vb_vimref, ByVal entryName As Any, ByVal attrCount%, pAttrDesc As vb_vimattrdesc)
Declare Function vb2_VIMsetabentryattributes& Lib "VIMVBWRP.DLL" (ByVal AddressBook&, entryRef As vb_vimref, ByVal entryName As Any, ByVal attrCount%, pAttrDesc As vimAttrDesc)


' vimStatus VIMAPIENTRY VIMSetABEntryNamedAttributes(
'                             vimAddressBook addressBook,
'                             vimRef entryRef,
'                             vimStringPtr entryName,
'                             vimWord attrCount,
'                             vimNamedAttrDescPtr pAttrDesc);
Declare Function vb1_VIMSetABEntryNamedAttributes& Lib "VIMVBWRP.DLL" (ByVal AddressBook&, entryRef As vb_vimref, ByVal entryName As Any, ByVal attrCount%, pAttrDesc As vb_vimNamedAttrDesc)
Declare Function vb2_VIMSetABEntryNamedAttributes& Lib "VIMVBWRP.DLL" (ByVal AddressBook&, entryRef As vb_vimref, ByVal entryName As Any, ByVal attrCount%, pAttrDesc As vimNamedAttrDesc)


' vimStatus VIMAPIENTRY VIMSetCurrentSubtree(   vimAddressBook addressBook,
'                                   vimRef subtreeRef,
'                                   vimStringPtr subtreeName);
Declare Function vb_VIMSetCurrentSubtree& Lib "VIMVBWRP.DLL" (ByVal AddressBook&, subtreeRef As vb_vimref, ByVal subtreeName As Any)

 
' vimStatus VIMAPIENTRY VIMSetMessageHeader( vimMsg message,
'                                vimSelector selAttr,
'                                vimWord wAttrSize,
'                                vimDataPtr pAttr);
Declare Function VIMSetMessageHeader& Lib "VIM.DLL" (ByVal message&, ByVal selAttr&, ByVal wAttrSize%, pAttr As Any)

' vimStatus VIMAPIENTRY VIMSetMessageItem(   vimMsg message,
'                                vimSelector selClass,
'                                vimStringPtr strType,
'                                vimSelector selFlags,
'                                vimStringPtr strName,
'                                vimBuffFileDescPtr pDesc );
Declare Function VIMSetMessageItem& Lib "VIM.DLL" (ByVal message&, ByVal selClass&, ByVal strType$, ByVal selFlags&, ByVal strName As Any, pDesc As vimBuffFileDesc)
Declare Function vb_VIMSetMessageItem& Lib "VIMVBWRP.DLL" (ByVal message&, ByVal selClass&, ByVal strType$, ByVal selFlags&, ByVal strName As Any, pDesc As vb_vimBuffFileDesc)
 
' vimStatus VIMAPIENTRY VIMSetMessageRecipient( vimMsg message,
'                                   vimSelector selClass,
'                                   vimRecipientPtr pRecip);
Declare Function VIMSetMessageRecipient& Lib "VIM.DLL" (ByVal message&, ByVal selClass&, pRecip As vimRecipient)
 
' vimStatus VIMAPIENTRY VIMStatusText( vimSes session,
'                             vimStatus status,
'                             vimWord wTextSize,
'                             vimStringPtr pText,
'                             vimWord wExtTextSize,
'                             vimStringPtr pExtText);
Declare Function VIMStatusText& Lib "VIM.DLL" (ByVal session&, ByVal status&, ByVal wTextSize, ByVal pText As Any, ByVal wExtTextSize, ByVal pExtText As Any)

' vimStatus VIMAPIENTRY VIMTerminate( vimVoid );
Declare Function VIMTerminate& Lib "VIM.DLL" ()
Declare Function vb_VIMTerminate& Lib "VIMVBWRP.DLL" ()
' vb_VIMTerminate calls FreeLibrary for MEMMAN.DLL if necessary before calling
' VIMTerminate

 
' vimStatus VIMAPIENTRY VIMVerifyMessageSignature( vimMsg message,
'                                      vimWord attrCount,
'                                      vimAttrDescPtr pAttrDesc);
Declare Function VIMVerifyMessageSignature& Lib "VIM.DLL" (ByVal message&, ByVal attrCount%, pAttrDesc As vimAttrDesc)
Declare Function vb_VIMVerifyMessageSignature& Lib "VIMVBWRP.DLL" (ByVal message&, ByVal attrCount%, pAttrDesc As vb_vimattrdesc)



' **********************************************************************
' VIMEXT.H is the public header file for cc:Mail specific VIM extensions
' **********************************************************************

Global Const VIM_NO_FLAGS = &H0&

Global Const VIM_CD = "VIM_CD"

' Status Value Extensions

Global Const VIMSTS_NO_RECIPIENTS = 256
Global Const VIMSTS_RECIPIENT_NOT_FOUND = 257
Global Const VIMSTS_RECIPIENT_NOT_UNIQUE = 258
Global Const VIMSTS_CONTAINER_CORRUPT = 259
Global Const VIMSTS_INVALID_MESSAGE = 260
Global Const VIMSTS_USER_CANCEL = 261


Global Const VIMSEL_CATEGORY = 256&
Global Const VIMSEL_LOCATION = 257&
Global Const VIMMSEL_DIALIN = 259&
Global Const VIMSEL_REMOTE = 260&
Global Const VIMSEL_FAN = 261&
Global Const VIMSEL_RECIP_STATUS = 262&
Global Const VIMSEL_SENT_TO = 263&
Global Const VIMSEL_SENT_CC = 264&
Global Const VIMSEL_SENT_BCC = 265&
Global Const VIMSEL_MSG_LEN = 266&
Global Const VIMSEL_UNDELIVERED = 267&

Global Const VIMSEL_ENTRY_NUMBER = 268&
Global Const VIMSEL_TOTAL_ENTRIES = 269&
Global Const VIMSEL_CD = 270&
Global Const VIMSEL_IMPLEMENTATION = 271&
Global Const VIMSEL_IMPLEMENTATION_VERSION = 272&
Global Const VIMSEL_DIRECT_POSTOFFICE = 273&
Global Const VIMSEL_INDIRECT_POSTOFFICE = 274&
Global Const VIMSEL_PASSWORD = 275&
Global Const VIMSEL_SHARED_CONTAINER = 276&


'vimStatus VIMAPIENTRY VIMOpenGatewaySession(   vimStringPtr psPathSpec,
'                                               vimStringPtr psPostOffice,
'                                               vimStringPtr psPass,
'                                               vimDWord dwVersion,
'                                               vimSelector selCharSet,
'                                               vimSesPtr pSession);
Declare Function VIMOpenGatewaySession& Lib "VIM.DLL" (ByVal psPathSpec As Any, ByVal psPostOffice As Any, ByVal psPass As Any, ByVal dwVersion&, ByVal selCharSet&, pSession&)

'vimStatus VIMAPIENTRY VIMRemoveMessageCategory( vimMsgContainer msgContr,
'                                                vimRef msgRef,
'                                                vimStringPtr psCatName);
Declare Function vb_VIMRemoteMessageCategory& Lib "VIMVBWRP.DLL" (ByVal msgContr&, msgRef As vb_vimref, ByVal psCatName$)

'vimStatus VIMAPIENTRY VIMSetMessageCategory(   vimMsgContainer msgContr,
'                                               vimRef msgRef,
'                                               vimStringPtr psCatName);
Declare Function vb_VIMSetMessageCategory& Lib "VIMVBWRP.DLL" (ByVal msgContr&, msgRef As vb_vimref, ByVal psCatName$)


'vimStatus VIMAPIENTRY VIMAddressAndSend(vimDWord dwUIParam,
'                                        vimDataPtr msg,
'                                        vimDWord dwReserved);
Declare Function VIMAddressAndSend& Lib "VIM.DLL" (ByVal dwUIParam&, ByVal msg As Any, ByVal dwReserved&)


'vimStatus VIMAPIENTRY VIMGetSessionAttributes( vimSes session,
'                                               vimWord attrCount,
'                                               vimAttrDescPtr pAttrs );
Declare Function VIMGetSessionAttributes& Lib "VIM.DLL" (ByVal session&, ByVal attrCount%, pAttrs As vimAttrDesc)
Declare Function vb_VIMGetSessionAttributes& Lib "VIMVBWRP.DLL" (ByVal session&, ByVal attrCount%, pAttrs As vb_vimattrdesc)

'vimStatus VIMAPIENTRY VIMSetSessionAttributes(  vimSes session,
'                                                vimWord attrCount,
'                                                vimAttrDescPtr pAttrs );
Declare Function VIMSetSessionAttributes& Lib "VIM.DLL" (ByVal session&, ByVal attrCount%, pAttrs As vimAttrDesc)
Declare Function vb_VIMSetSessionAttributes& Lib "VIMVBWRP.DLL" (ByVal session&, ByVal attrCount%, pAttrs As vb_vimattrdesc)


' **********************************************************************
' Memory and ultility routines provided in VIMVBWRP
' **********************************************************************

Declare Sub vb_getOneDistinguishedName Lib "VIMVBWRP.DLL" (ByVal buffer As Any, ByVal index%, N As VIMdistinguishedname)
Declare Sub vb_getOneWord Lib "VIMVBWRP.DLL" (ByVal buffer As Any, ByVal index%, w As Integer)
Declare Sub vb_getOneDWord Lib "VIMVBWRP.DLL" (ByVal buffer As Any, ByVal index%, dw As Long)
Declare Sub vb_getOneBool Lib "VIMVBWRP.DLL" (ByVal buffer As Any, ByVal index%, b As Integer)
Declare Sub vb_getOneVimDate Lib "VIMVBWRP.DLL" (ByVal buffer As Any, ByVal index%, d As vimDate)
Declare Sub vb_date2str Lib "VIMVBWRP.DLL" (d As vimDate, ByVal s$)
Declare Sub vb_getOneStr Lib "VIMVBWRP.DLL" (ByVal buffer As Any, ByVal elemSize&, ByVal index%, ByVal s$)
Declare Sub vb_getOneVimRef Lib "VIMVBWRP.DLL" (ByVal buffer As Any, ByVal index%, refPtr As vb_vimref)
Declare Sub vb_getOneVimAddress Lib "VIMVBWRP.DLL" (ByVal buffer As Any, ByVal index%, Address As vimAddress)
Declare Sub vb_getOneVimDateRange Lib "VIMVBWRP.DLL" (ByVal buffer As Any, ByVal index%, dateRange As vimDateRange)
Declare Sub vb_getOneVimRecipient Lib "VIMVBWRP.DLL" (ByVal buffer As Any, ByVal index%, recipPtr As vimRecipient)

Declare Function vb_allocBuffer& Lib "VIMVBWRP.DLL" (buffer&, ByVal entrySize&, ByVal itmInBuffer%)
Declare Function vb_freeBuffer& Lib "VIMVBWRP.DLL" (ByVal buffer&)

' **************************************************************************
' End of VIM.BAS
' **************************************************************************

Global szPath As String * 1024
Global szName As String * 255
Global szPassword As String * 255
Global loginButton As Integer
Global session As Long

