'global defs and types are in globals.bas

Sub add_delete_letter (current_form As Form, ByVal cap_st As String, ByVal r_st As String)

'add the delete statment to the caption of the passed form

screen_width% = ((current_form.Width / 1440) * 12) - 10

If screen_width% Mod 2 = 0 Then
    'even length
    screen_width% = screen_width% - 1
End If

ReDim cap_array(screen_width%)
For i = 1 To screen_width%    'load the array with blanks
    cap_array(i) = Chr$(160)
Next i

'MsgBox "cap_st$ " + cap_st$

'load existing caption into array
For i = 1 To Len(cap_st$)
    cap_array(i) = Mid$(cap_st$, i, 1)
Next i

'put delete marker in caption array
start_pos% = (screen_width% - Len(r_st$)) + 1

For i = 1 To Len(r_st$)
    cap_array(start_pos%) = Mid$(r_st$, i, 1)
    start_pos% = start_pos% + 1
Next i

cap_st$ = ""
For i = 1 To screen_width%
    cap_st$ = cap_st$ + cap_array(i)
Next i
current_form.Caption = cap_st$

End Sub

Sub add_three_part_caption (current_form As Form, ByVal l_st As String, ByVal m_st As String, ByVal r_st As String)
'screen_width% = ((current_form.Width / 1440) * 12) - 10
screen_width% = 53

If screen_width% Mod 2 = 0 Then
    'even length
    screen_width% = screen_width% - 1
End If

ReDim cap_array(screen_width%)
For i = 1 To screen_width%    'load the array with blanks
    cap_array(i) = Chr$(160)
Next i

'put left part in array
For i = 1 To Len(l_st$)
    cap_array(i) = Mid$(l_st$, i, 1)
Next i

'put middle in array
If Len(m_st$) Mod 2 = 0 Then
    is_even = True
Else
    is_even = False
End If

If is_even Then
    start_pos% = (Int(screen_width% / 2) - Int(Len(m_st$) / 2)) + 1
Else
    start_pos% = Int(screen_width% / 2) - Int(Len(m_st$) / 2)
End If
For i = 1 To Len(m_st$)
    cap_array(start_pos%) = Mid$(m_st$, i, 1)
    start_pos% = start_pos% + 1
Next i

'put right part in array
start_pos% = (screen_width% - Len(r_st$)) + 1
For i = 1 To Len(r_st$)
    cap_array(start_pos%) = Mid$(r_st$, i, 1)
    start_pos% = start_pos% + 1
Next i

'build caption string
cap_st$ = ""
For i = 1 To screen_width%
    cap_st$ = cap_st$ + cap_array(i)
Next i

cap_st$ = replace_blanks(cap_st$)
current_form.Caption = cap_st$
    
hold_st$ = cap_st$

End Sub

Function backup_file (source As String, dest As String, error_num As Integer, nonex As Integer)
error_num = 0
backup_file = False

On Error GoTo copy_err

If nonex% = 0 Then  'non exclusive is NOT checked
    fnumber = FreeFile
    Open source$ For Input As fnumber
    Close fnumber
End If
    
If file_exists(dest$) Then
    If Not kill_file(dest$) Then
	GoTo copy_err
    End If
End If

FileCopy source$, dest$
backup_file = True
Exit Function

copy_err:
error_num = Err
Exit Function
     
End Function

Function build_anal5 (cmd As String) As Integer

    po_path$ = anal5.Combo1.Text
    cmd$ = ini_array(6).setting + "analyze" + " " + "/d" + po_path$
    If anal5.Text4.Text <> "" And anal5.Text4.Enabled Then
	cmd$ = cmd$ + " /n" + Chr$(34) + anal5.Text4.Text + Chr$(34)
    ElseIf anal5.Check5.Value = 1 Then    '/users
	cmd$ = cmd$ + " /users"
    ElseIf anal5.List1.Text <> "" Then
	cmd$ = cmd$ + " /usr/" + Mid(anal5.List1.Text, 4, Len(anal5.List1.Text) - 3)
    End If
    If anal5.Check1.Value = 1 Then
	cmd$ = cmd$ + " /batch"
    End If
    If anal5.Check2.Value = 1 Then
	cmd$ = cmd$ + " /diagnostics"
    End If
    If anal5.Check3.Value = 1 Then
	cmd$ = cmd$ + " /directory"
    End If
    If anal5.Check4.Value = 1 Then
	cmd$ = cmd$ + " /messages"
    End If

    If cmd$ <> "" Then
	build_anal5 = True
    Else
	build_anal5 = False
    End If

End Function

Sub build_combo_list (f As Form)
    
    'add default po to top of list
    ret_st$ = String$(256, " ")
    x% = GetPrivateProfileString("Default_PO", "Default_PO", "None", ret_st$, Len(ret_st$), INI_FILE)
    If InStr(ret_st$, "none") = 0 Then
	'strip po_path from full string containing po_name and po_password seperated by ]
	ret_st$ = trim_null(ret_st$)
	x% = InStr(ret_st$, "]")
	If x% <> 0 Then
	    If Mid$(ret_st$, x% - 1, 1) = "\" Then  'strip \ off
		'ret_st$ = Mid$(ret_st$, 1, Len(ret_st$) - 1)
		x% = x% - 1 'dont take '\' at end
	    End If
	    ret_st$ = Mid$(ret_st$, 1, x% - 1)
	    f.Combo1.AddItem ret_st$
	Else
	    f.Combo1.AddItem ret_st$
	End If
    End If

    ret_st$ = String$(256, " ")
    x% = GetPrivateProfileString("prev_po", "po1", "none", ret_st$, Len(ret_st$), INI_FILE)
    If InStr(ret_st$, "none") = 0 Then
	'strip po_path from full string containing po_name and po_password seperated by ]
	ret_st$ = trim_null(ret_st$)
	x% = InStr(ret_st$, "]")
	If x% <> 0 Then
	    If Mid$(ret_st$, Len(ret_st$), 1) = "\" Then    'strip \ off of end if present
		ret_st$ = Mid$(ret_st$, 1, Len(ret_st$) - 1)
	    End If
	    ret_st$ = Mid$(ret_st$, 1, x% - 1)
	    f.Combo1.AddItem ret_st$
	Else
	    f.Combo1.AddItem ret_st$
	End If
    End If

    ret_st$ = String$(256, " ")
    x% = GetPrivateProfileString("prev_po", "po2", "none", ret_st$, Len(ret_st$), INI_FILE)
    If InStr(ret_st$, "none") = 0 Then
	'strip po_path from full string containing po_name and po_password seperated by ]
	ret_st$ = trim_null(ret_st$)
	x% = InStr(ret_st$, "]")
	If x% <> 0 Then
	    If Mid$(ret_st$, Len(ret_st$), 1) = "\" Then    'strip \ off of end if present
		ret_st$ = Mid$(ret_st$, 1, Len(ret_st$) - 1)
	    End If
	    ret_st$ = Mid$(ret_st$, 1, x% - 1)
	    f.Combo1.AddItem ret_st$
	Else
	    f.Combo1.AddItem ret_st$
	End If
    End If
    
    ret_st$ = String$(256, " ")
    x% = GetPrivateProfileString("prev_po", "po3", "none", ret_st$, Len(ret_st$), INI_FILE)
    If InStr(ret_st$, "none") = 0 Then
	'strip po_path from full string containing po_name and po_password seperated by ]
	ret_st$ = trim_null(ret_st$)
	x% = InStr(ret_st$, "]")
	If x% <> 0 Then
	    If Mid$(ret_st$, Len(ret_st$), 1) = "\" Then    'strip \ off of end if present
		ret_st$ = Mid$(ret_st$, 1, Len(ret_st$) - 1)
	    End If
	    ret_st$ = Mid$(ret_st$, 1, x% - 1)
	    f.Combo1.AddItem ret_st$
	Else
	    f.Combo1.AddItem ret_st$
	End If
    End If

    ret_st$ = String$(256, " ")
    x% = GetPrivateProfileString("prev_po", "po4", "none", ret_st$, Len(ret_st$), INI_FILE)
    If InStr(ret_st$, "none") = 0 Then
	'strip po_path from full string containing po_name and po_password seperated by ]
	ret_st$ = trim_null(ret_st$)
	x% = InStr(ret_st$, "]")
	If x% <> 0 Then
	    If Mid$(ret_st$, Len(ret_st$), 1) = "\" Then    'strip \ off of end if present
		ret_st$ = Mid$(ret_st$, 1, Len(ret_st$) - 1)
	    End If
	    ret_st$ = Mid$(ret_st$, 1, x% - 1)
	    f.Combo1.AddItem ret_st$
	Else
	    f.Combo1.AddItem ret_st$
	End If
    End If
    
    ret_st$ = String$(256, " ")
    x% = GetPrivateProfileString("prev_po", "po5", "none", ret_st$, Len(ret_st$), INI_FILE)
    If InStr(ret_st$, "none") = 0 Then
	'strip po_path from full string containing po_name and po_password seperated by ]
	ret_st$ = trim_null(ret_st$)
	x% = InStr(ret_st$, "]")
	If x% <> 0 Then
	    If Mid$(ret_st$, Len(ret_st$), 1) = "\" Then    'strip \ off of end if present
		ret_st$ = Mid$(ret_st$, 1, Len(ret_st$) - 1)
	    End If
	    ret_st$ = Mid$(ret_st$, 1, x% - 1)
	    f.Combo1.AddItem ret_st$
	Else
	    f.Combo1.AddItem ret_st$
	End If
    End If
    
End Sub

Sub build_ini_array ()
'builds ini_array which hold the INI_FILE info
'The structure is:
'Type ini_info
'    AppName As String       'Section in manager.ini e.g [Welcome]
'    KeyName As String       'Name in section - e.g. Welcome_Screen
'    Default As String       'default value for entry
'    Setting As String       'value read next to keyname (read in)
'End Type

    'ini_array is defined as follows
    '(1) = Welcome Screen True or False
    '(2) = Default PO for program - full path name
    '(3) = not used
    '(4) = default Backup destination - full path name
    '(5) = Def PO Name
    '(6) = Directory location of admin programs - full path name
    '(7) = Administrators cc:Mail User name
    '(8) = PO Password
    '(9) = User password placed here during execution of program
    '(10) = Product registered to
    '(11) = Company name - ok if blank
    '(12) = Program directory
    '(13) = default cmd directory
    '(14) = if "true" then lock pc during batch file execution
    '(15) = if "true" then first time running program - open demo.cmd
    
    ReDim ini_array(16)

    ret_st$ = String$(256, " ")
    x% = GetPrivateProfileString("Welcome_Screen", "Welcome_Screen", "None", ret_st$, Len(ret_st$), INI_FILE)
    ini_array(1).appname = "Welcome_Screen"
    ini_array(1).keyname = "Welcome_Screen"
    ini_array(1).default = "true"
    If InStr(ret_st$, "None") Then
	'manager.ini not there
	show_error (3) 'stop program manager.ini missing
	End
    End If
    If InStr(ret_st$, "true") Then
	ini_array(1).setting = "true"
    Else
	ini_array(1).setting = "false"
    End If
    
    ret_st$ = String$(256, " ")
    x% = GetPrivateProfileString("Default_PO", "default_po", "None", ret_st$, Len(ret_st$), INI_FILE)
    ini_array(2).appname = "default_po"
    ini_array(2).keyname = "default_po"
    ini_array(2).default = "None"
    ret_st$ = trim_null(ret_st$)
    ret_st$ = get_string(ret_st$, "]", 1)       'get first part of default_po which is the path to the default PO
    If Mid$(ret_st$, Len(ret_st$), 1) = "\" Then
	ret_st$ = Mid$(ret_st$, 1, Len(ret_st$) - 1)
    End If
    ini_array(2).setting = ret_st$
    
    ret_st$ = String$(256, " ")
    x% = GetPrivateProfileString("Def_Back", "Def_Back", "None", ret_st$, Len(ret_st$), INI_FILE)
    ini_array(4).appname = "Def_Back"
    ini_array(4).keyname = "Def_Back"
    ini_array(4).default = "None"
    ini_array(4).setting = trim_null(ret_st$)

    ret_st$ = String$(256, " ")
    x% = GetPrivateProfileString("default_po", "default_po", "None", ret_st$, Len(ret_st$), INI_FILE)
    ini_array(5).appname = "default_po"
    ini_array(5).keyname = "default_po"
    ini_array(5).default = "None"
    ret_st$ = trim_null(ret_st$)
    ret_st$ = get_string(ret_st$, "]", 2)       'get first part of po_name which is the path to the default PO
    ini_array(5).setting = ret_st$
    
    ret_st$ = String$(256, " ")
    x% = GetPrivateProfileString("Admin_Dir", "Admin_Dir", "None", ret_st$, Len(ret_st$), INI_FILE)
    ini_array(6).appname = "Admin_Dir"
    ini_array(6).keyname = "Admin_Dir"
    ini_array(6).default = "None"
    ini_array(6).setting = trim_null(ret_st$)

    ret_st$ = String$(256, " ")
    x% = GetPrivateProfileString("default_po", "default_po", "None", ret_st$, Len(ret_st$), INI_FILE)
    ini_array(8).appname = "default_po"
    ini_array(8).keyname = "default_po"
    ini_array(8).default = "None"
    ret_st$ = trim_null(ret_st$)
    ret_st$ = get_string(ret_st$, "]", 3)       'get first part of po password which is the path to the default PO
    ini_array(8).setting = ret_st$
   
    ret_st$ = String$(256, " ")
    x% = GetPrivateProfileString("User_Name", "User_Name", "None", ret_st$, Len(ret_st$), INI_FILE)
    ini_array(10).appname = "User_Name"
    ini_array(10).keyname = "User_Name"
    ini_array(10).default = "None"
    ini_array(10).setting = trim_null(ret_st$)
    
    ret_st$ = String$(256, " ")
    x% = GetPrivateProfileString("Company", "Company", " ", ret_st$, Len(ret_st$), INI_FILE)
    ini_array(11).appname = "Company"
    ini_array(11).keyname = "Company"
    ini_array(11).default = " "
    ini_array(11).setting = trim_null(ret_st$)
    
    ret_st$ = String$(256, " ")
    x% = GetPrivateProfileString("Prog_Dir", "Prog_Dir", "c:\manager\", ret_st$, Len(ret_st$), INI_FILE)
    ini_array(12).appname = "Prog_Dir"
    ini_array(12).keyname = "Prog_Dir"
    ini_array(12).default = "c:\manager\manager.dat"
    ini_array(12).setting = trim_null(ret_st$)

    filename$ = ini_array(12).setting + "manager.dat"
    
    If file_exists(filename$) Then
	file_num = FreeFile
	Open filename$ For Input As #file_num
    Else

	Call show_error(1)
	End
    End If
    Line Input #file_num, ret_st$
    Close #file_num
    
    ini_array(9).appname = "Password"
    ini_array(9).keyname = "Password"
    ini_array(9).default = "None"
    ini_array(9).setting = Trim$(ret_st$)
    
    ret_st$ = String$(256, " ")
    x% = GetPrivateProfileString("Def_cmd_Dir", "Def_cmd_Dir", "c:\", ret_st$, Len(ret_st$), INI_FILE)
    ini_array(13).appname = "Def_cmd_Dir"
    ini_array(13).keyname = "Def_cmd_Dir"
    ini_array(13).default = "c:\"
    ini_array(13).setting = trim_null(ret_st$)


    ret_st$ = String$(256, " ")
    x% = GetPrivateProfileString("lock_pc", "lock_pc", "None", ret_st$, Len(ret_st$), INI_FILE)
    ini_array(14).appname = "lock_pc"
    ini_array(14).keyname = "lock_pc"
    ini_array(14).default = "true"
    If InStr(ret_st$, "true") Then
	ini_array(14).setting = "true"
    Else
	ini_array(14).setting = "false"
    End If
    lock_pc = False
    If ini_array(14).setting = "true" Then lock_pc = True
    
    ret_st$ = String$(256, " ")
    x% = GetPrivateProfileString("First_Time", "First_Time", "None", ret_st$, Len(ret_st$), INI_FILE)
    ini_array(15).appname = "First_Time"
    ini_array(15).keyname = "First_Time"
    ini_array(15).default = "false"
    If InStr(ret_st$, "true") Then
	ini_array(15).setting = "true"
    Else
	ini_array(15).setting = "false"
    End If

    ret_st$ = String$(256, " ")
    x% = GetPrivateProfileString("Language", "Language", "None", ret_st$, Len(ret_st$), INI_FILE)
    ini_array(16).appname = "Language"
    ini_array(16).keyname = "Language"
    ini_array(16).default = "false"
    ini_array(16).setting = trim_null(ret_st$)
    
End Sub

Function build_one_file () As String

build_one_file = ""
return_string$ = ""

For i = 1 To last_line
    found_command = True
    st$ = cmdline(i).Panel3D1.Caption  'ccmail command
    If InStr(1, st$, "Super ChkStat") <> 0 Then
	found_command = False
    End If
    If InStr(1, st$, "Backup Options") <> 0 Then
	found_command = False
    End If
    If InStr(1, st$, "ChkStat Options") <> 0 Then
	found_command = False
    End If
    If InStr(1, st$, "Reclaim Options") <> 0 Then
	found_command = False
    End If

    If found_command Then
	return_string$ = return_string$ + st$ + crlf$
    End If
    
Next i
build_one_file = return_string$

End Function

Sub center_form (form_name As Form, vertical_center As Integer)
    'centers a form on the screen.
    'if vertical_center then just center horizontally

    If window_state = 0 Then
	If vertical_center = 1 Then
	    form_name.Move (screen.Width - form_name.Width) / 2
	    
	Else
	    form_name.Move (screen.Width - form_name.Width) / 2, (screen.Height - form_name.Height) / 2
	    
	End If
    End If
End Sub

Sub check_combo1_list (f As Form, ByVal po_path As String, ByVal po_name As String, ByVal po_password As String)

'8/21/94 - htm
'this procedure checks to see if added po in combo list is already in list and if not then adds it to the list
'and writes the new po out to the manager.ini file under the key [prev_po].  ini file delmiter = ]
'if analyze running then po_name and po_password are passed as null

    If po_path$ = "" Then Exit Sub
    If Mid$(po_path$, Len(po_path$), 1) = "\" Then po_path$ = Mid$(po_path$, 1, Len(po_path$) - 1)
    
    x% = f.Combo1.ListCount - 1  'how many items

    For i = 0 To x%

	'First check if \ in combo1.list(i) path, if so then take it off to normalize compare
	'take off \ if at end of path (e.g. default_po has this)

	ch$ = Mid$(f.Combo1.List(i), Len(f.Combo1.List(i)), 1)
	If ch$ = "\" Then
	    comp_st$ = Mid$(f.Combo1.List(i), 1, Len(f.Combo1.List(i)) - 1)
	Else
	    comp_st$ = f.Combo1.List(i)
	End If

	If LCase$(po_path$) = LCase$(comp_st$) Then
	    'found it now set the combo box to it
	    f.Combo1.ListIndex = i
	    Exit Sub
	End If
    Next

    'did not find it
    f.Combo1.AddItem po_path$
    f.Combo1.ListIndex = f.Combo1.ListCount - 1
    
    'read in first four so you can move them down
    ret_st$ = String$(256, " ")
    x% = GetPrivateProfileString("prev_po", "po1", "none", ret_st$, Len(ret_st$), INI_FILE)
    po1$ = trim_null(ret_st$)
    If Mid$(po1$, Len(po1$), 1) = "\" Then po1$ = Mid$(po1$, 1, Len(po1$) - 1)

    ret_st$ = String$(256, " ")
    x% = GetPrivateProfileString("prev_po", "po2", "none", ret_st$, Len(ret_st$), INI_FILE)
    po2$ = trim_null(ret_st$)
    If Mid$(po2$, Len(po2$), 1) = "\" Then po2$ = Mid$(po2$, 1, Len(po2$) - 1)

    ret_st$ = String$(256, " ")
    x% = GetPrivateProfileString("prev_po", "po3", "none", ret_st$, Len(ret_st$), INI_FILE)
    po3$ = trim_null(ret_st$)
    If Mid$(po3$, Len(po3$), 1) = "\" Then po3$ = Mid$(po3$, 1, Len(po3$) - 1)

    ret_st$ = String$(256, " ")
    x% = GetPrivateProfileString("prev_po", "po4", "none", ret_st$, Len(ret_st$), INI_FILE)
    po4$ = trim_null(ret_st$)
    If Mid$(po4$, Len(po4$), 1) = "\" Then po4$ = Mid$(po4$, 1, Len(po4$) - 1)
    
    'now re-write list in ini file
    If WritePrivateProfileString("prev_po", "po2", po1$, INI_FILE) = 0 Then
	MsgBox "Unable to write profile string", 48, ini_array(1).appname
    End If
    If WritePrivateProfileString("prev_po", "po3", po2$, INI_FILE) = 0 Then
	MsgBox "Unable to write profile string", 48, ini_array(1).appname
    End If
    If WritePrivateProfileString("prev_po", "po4", po3$, INI_FILE) = 0 Then
	MsgBox "Unable to write profile string", 48, ini_array(1).appname
    End If
    If WritePrivateProfileString("prev_po", "po5", po4$, INI_FILE) = 0 Then
	MsgBox "Unable to write profile string", 48, ini_array(1).appname
    End If

    ini_st$ = po_path$ + "]" + po_name$ + "]" + po_password$
    If WritePrivateProfileString("prev_po", "po1", ini_st$, INI_FILE) = 0 Then
	MsgBox "Unable to write profile string", 48, ini_array(1).appname
    End If
    
End Sub

Sub check_pass_file (ByVal file_num As Integer)

On Error GoTo err_in
    
    Open fname For Input As #file_num
    
    Exit Sub

err_in:

    MsgBox "No password file found"
    End

End Sub

Function check_resource () As Integer
    
    'checks to see if the language resource is out there
    'ini_array(16) reads the .ri file from manager.ini
    
    check_resource = False
    st$ = ini_array(6).setting + ini_array(16).setting
    If Not file_exists(st$) Then
	MsgBox "Could not find: " + st$, 48, "Utility Program Error"
    Else
	check_resource = True
    End If
    
End Function

Sub clear_box ()
	    cmdline(current_line).Line (1920, 960)-(5520, 2400), QBColor(7), BF
	    cmdline(current_line).DrawWidth = 2
	    cmdline(current_line).Line (1920, 960)-(5520, 960), QBColor(8)       'top
	    cmdline(current_line).Line (1920, 960)-(1920, 2400), QBColor(15)       'left
	    cmdline(current_line).Line (5520, 960)-(5520, 2400), QBColor(8)       'right
	    cmdline(current_line).Line (1920, 2400)-(5520, 2400), QBColor(15)     'bottom

End Sub

Sub close_current_file ()

    For i = 1 To last_line
	Unload cmdline(i)
    Next i
    last_line = 1
    current_line = 1
    ReDim cmdline(256)
    


End Sub

Function copy_it (source As String, dest As String) As Integer
copy_it = False

On Error GoTo copy_error

If file_exists(source$) Then
    If Not kill_file(dest$) Then
	GoTo copy_error
    End If
End If

FileCopy source$, dest$
copy_it = True
Exit Function

copy_error:
copy_it = Err

Exit Function


End Function

Sub copy_my_file (source As String, dest As String)

On Error GoTo copy_my
FileCopy source$, dest$
Exit Sub

copy_my:
Exit Sub

End Sub

Sub do_cmdline_backup (cmd_st As String)
'parse out backup batch file command and execute from windows
    Call post_message("Running Backup...")
    do_usr_files = False
    do_mlandata = False
    do_clandata = False
    source$ = ""
    destination$ = ""

    'If InStr(1, cmd_st$, "for") > 0 Then 'usr files
    If InStr(1, cmd_st$, "usr?????") > 0 Then 'usr files
	do_usr_files = True
    End If
    If InStr(1, cmd_st$, "mlandata") > 0 Then 'mlandata
	do_mlandata = True
    End If
    If InStr(1, cmd_st$, "clandata") > 0 Then   'clandata
	do_clandata = True
    End If

    'now get source and destination paths
    If InStr(1, cmd_st$, "mlandata") > 0 Then
	temp$ = ""
	ch$ = ""
	i = 1
	Do
	    temp$ = temp$ + ch$
	    ch$ = Mid$(cmd_st$, i + 5, 1)
	    i = i + 1
	Loop Until ch$ = Chr$(32)
	
	st2$ = Mid$(cmd_st$, i + 5, Len(cmd_st$) - i + 1)   'for finding destination
	x% = InStr(1, st2$, Chr$(13))
	If x% = 0 Then
	    temp2$ = st2$
	Else
	    end_pos% = x% - 1
	    temp2$ = Mid$(st2$, 1, end_pos%)
	End If
	
	destination$ = temp2$

	x% = InStr(1, temp$, "mlandata")
	temp$ = Mid$(temp$, 1, x% - 1)
	source$ = temp$
    
    ElseIf InStr(1, cmd_st$, "clandata") > 0 Then
	temp$ = ""
	ch$ = ""
	i = 1
	Do
	    temp$ = temp$ + ch$
	    ch$ = Mid$(cmd_st$, i + 5, 1)
	    i = i + 1
	Loop Until ch$ = Chr$(32)
	st2$ = Mid$(cmd_st$, i + 5, Len(cmd_st$) - i + 1)   'for finding destination
	x% = InStr(1, st2$, Chr$(13))
	If x% = 0 Then
	    temp2$ = st2$
	Else
	    end_pos% = x% - 1
	    temp2$ = Mid$(st2$, 1, end_pos%)
	End If
	destination$ = temp2$
	
	x% = InStr(1, temp$, "clandata")
	temp$ = Mid$(temp$, 1, x% - 1)
	source$ = temp$
    ElseIf InStr(1, cmd_st$, "usr?????") > 0 Then 'usr files
	start_pos% = 13
	end_pos% = InStr(1, cmd_st$, "usr") - 1
	temp$ = Mid$(cmd_st$, start_pos%, end_pos% - start_pos% + 1)
	source$ = temp$
	
	start_pos% = InStr(1, cmd_st$, "copy %%") + 9
	end_pos% = InStr(1, cmd_st$, "usr????? >>") - 1
	temp$ = Mid$(cmd_st$, start_pos%, end_pos% - start_pos% + 1)
	destination$ = temp$

    End If

    If source$ = "" Then Exit Sub
    If destination$ = "" Then Exit Sub

    If Not kill_file(outfile$) Then
    End If
	
    filenum = open_for_output(outfile$)
    If filenum = 0 Then
	Exit Sub
    End If
    timestamp = Now
    st$ = "Backup Report: " + crlf$
    st$ = st$ + "Created on " + Format(timestamp, "mm/dd/yy") + " at " + Format(timestamp, "h:mm:ss AM/PM") + crlf$
    Print #filenum, st$
    st$ = "Source Post Office Directory: " + source$ + crlf$ + crlf$
    Print #filenum, st$
    st$ = "The following files were copied to: " + destination$ + crlf$
    Print #filenum, st$
    st$ = "  File                           Bytes" + crlf$
    Print #filenum, st$
    
    On Error GoTo err_backup

    Load newstatus
    newstatus.Panel3D1.FloodPercent = 1
    newstatus.Caption = BACKUP + " In Progress..."
    Call center_form(newstatus, 0)
    newstatus.Show
    newstatus.Refresh
    done% = 0
    total_done% = 0
    
    If do_clandata Then
	total_done% = 1
    End If
    If do_usr_files Then
	cmdline(current_line).File1.Path = source$
	cmdline(current_line).File1.Pattern = "USR?????.*"
	total_done% = total_done% + cmdline(current_line).File1.ListCount
    End If
    If do_mlandata Then
	total_done% = total_done% + 1
    End If

    If do_clandata Then  'backup clandata
	FileCopy source$ + "clandata.", destination$ + "\" + "clandata"
	done% = done% + 1
	newstatus.Panel3D1.FloodPercent = (done% / total_done%) * 100
	x% = DoEvents()
	Print #filenum, "clandata" + Space(25) + Str$(FileLen(source$ + "clandata"))
    End If

    If do_usr_files = True Then    'copy usr???? files
	cmdline(current_line).File1.Path = source$
	cmdline(current_line).File1.Pattern = "USR?????.*"
	For i = 0 To cmdline(current_line).File1.ListCount - 1
	    file_name = cmdline(current_line).File1.List(i)
	    FileCopy source$ + file_name, destination$ + "\" + file_name
	    done% = done% + 1
	    newstatus.Panel3D1.FloodPercent = (done% / total_done%) * 100
	    x% = DoEvents()
	    Print #filenum, file_name + Space(25) + Str$(FileLen(source$ + file_name))
	Next i
    End If

    If do_mlandata Then   'backup mlandata
	FileCopy source$ + "mlandata.", destination$ + "\" + "mlandata"
	done% = done% + 1
	newstatus.Panel3D1.FloodPercent = (done% / total_done%) * 100
	x% = DoEvents()
	Print #filenum, "mlandata" + Space(25) + Str$(FileLen(source$ + "mlandata"))
    End If

    Print #filenum, crlf$ + crlf$
    Print #filenum, "Backup Process Successful"
    Close #filenum
    Unload newstatus
    GoTo the_end

err_backup:
    Unload batchgauge
    st$ = cmdline(current_line).Tag
    st$ = "Frame: " + pad_it(st$)
    post_message (st$)
    Exit Sub

the_end:
    cmdline(current_line).buttons(4).Enabled = True
    st$ = cmdline(current_line).Tag
    st$ = "Frame: " + pad_it(st$)
    post_message (st$)

End Sub

Function encrypt (ByVal in_st As String, shift As Integer) As String
'encrypts using simple shifted array


in_st$ = transpose(in_st$)

Dim trans() As String
ReDim trans(95, 2) As String

x% = 1
For i% = 32 To 126
    trans(x%, 1) = Chr$(i%)
    x% = x% + 1
Next i%
 
x% = shift%
For i% = 32 To (126 - (shift% - 1))     '116
    trans(x%, 2) = Chr$(i%)
    x% = x% + 1
Next i%

x% = 1
For i% = (126 - (shift% - 2)) To 126        '117
    trans(x%, 2) = Chr$(i%)
    x% = x% + 1
Next i%
 
out_st$ = ""
For i% = 1 To Len(in_st$)
    x% = 0
    match% = 0
    ch$ = Mid$(in_st$, i%, 1)
    Do
	x% = x% + 1
	match_ch$ = trans(x%, 1)
	If match_ch$ = ch$ Then
	    match% = 1
	End If
    Loop Until match% = 1
    out_st$ = out_st$ + trans(x%, 2)
Next i%

encrypt = out_st$

End Function

Sub end_program ()
	    
	    End 'Exit selected

End Sub

Function file_exists (fname As String) As Integer
    file_exists = False
    On Error GoTo err_exists
    fnum = FreeFile
    Open fname For Input As fnum
    file_exists = True
    Close fnum
    Exit Function

err_exists:
    Close fnum
    Exit Function

End Function

Function find_user_info (fname As String, username As String, compname As String) As Integer

find_user_info = False
program% = FreeFile

Open fname$ For Binary As #program%

    st$ = String$(50, " ")
    Get #program%, 80, st$
    
    username$ = Mid$(st$, 1, 25)
    compname$ = Mid$(st$, 26, 25)
    
    username$ = remove_blanks(username$)
    
    compname$ = remove_blanks(compname$)

    find_user_info = True

End Function

Function get_mess (st As String, param As String, start_pos As Integer, end_pos As Integer) As Integer
    get_mess = False

    start_pos% = InStr(st$, param$)
    If start_pos% > 0 Then
	get_mess = True
	end_pos% = InStr(start_pos% + 1, st$, "/")
	If end_pos% = start_pos% Or end_pos% = 0 Then
	    end_pos% = Len(st$)     'no more "/"
	Else
	    end_pos% = end_pos% - 1
	End If
    End If

End Function

Function get_outfile () As String

    get_outfile = ""
    tag_st$ = cmdline(current_line).Tag
    tag_st$ = Trim$(tag_st$)
    pad$ = String$(3 - Len(tag_st$), "0")
    tag_st$ = pad$ + tag_st$
    suffix$ = Mid$(fname$, 1, Len(fname$) - 3)
    get_outfile$ = LCase$(suffix$ + tag_st$)
    
End Function

Function get_outfile2 () As String
    get_outfile2 = ""
    tag_st$ = cmdline(last_line).Tag
    tag_st$ = Trim$(tag_st$)
    pad$ = String$(3 - Len(tag_st$), "0")
    tag_st$ = pad$ + tag_st$
    suffix$ = Mid$(fname$, 1, Len(fname$) - 3)
    get_outfile2 = LCase$(suffix$ + tag_st$)

End Function

Sub get_poname_passwd (combo As Control, po_path As String, po_name As String, po_passwd As String)
'Stop
po_passwd$ = ""
po_name$ = ""

found = False
profile$ = ""

If InStr(combo.List(0), po_path) > 0 Then
    found = True
    profile$ = "Default_PO"
ElseIf InStr(combo.List(1), po_path) > 0 Then
    found = True
    profile$ = "po1"
ElseIf InStr(combo.List(2), po_path) > 0 Then
    found = True
    profile$ = "po2"
ElseIf InStr(combo.List(3), po_path) > 0 Then
    found = True
    profile$ = "po3"
ElseIf InStr(combo.List(4), po_path) > 0 Then
    found = True
    profile$ = "po4"
ElseIf InStr(combo.List(5), po_path) > 0 Then
    found = True
    profile$ = "po5"
End If

If found = True Then
    ret_st$ = String$(256, " ")
    If profile$ = "Default_PO" Then
	x% = GetPrivateProfileString("Default_PO", profile$, "none", ret_st$, Len(ret_st$), INI_FILE)
    Else
	x% = GetPrivateProfileString("prev_po", profile$, "none", ret_st$, Len(ret_st$), INI_FILE)
    End If
    
    start% = InStr(ret_st$, "]")
    If start% <> 0 Then
	'remove po_path part of string
	ret_st$ = Mid$(ret_st$, start% + 1, Len(ret_st$) - start%)
	x% = InStr(ret_st$, "]")
	If x% <> 0 Then
	    po_name$ = Mid$(ret_st$, 1, x% - 1)
	    po_passwd$ = Mid$(ret_st$, x% + 1, Len(ret_st$) - x%)
	End If
    End If
End If


End Sub

Function get_string (st As String, delim As String, occur As Integer) As String
'8/21/94 - htm
'returns a string containing the text to the left occurance of delim string

get_string = ""
If InStr(st$, delim) = 0 Then Exit Function

'example   c:\ccdata]demo]test

If occur = 1 Then
    x% = InStr(st$, delim)
    If x% <> 0 Then 'found it
	get_string = Mid$(st$, 1, x% - 1)
	Exit Function
    End If
End If

If occur = 2 Then
    x% = InStr(st$, delim)
    If x% <> 0 Then 'found first delim
	st$ = Mid$(st$, x% + 1, Len(st$) - x%)
	x% = InStr(st$, delim)
	If x% <> 0 Then 'found second delim
	    get_string = Mid$(st$, 1, x% - 1)
	    Exit Function
	End If
    End If
End If

If occur = 3 Then
    x% = InStr(st$, delim)
    If x% <> 0 Then 'found first delim
	st$ = Mid$(st$, x% + 1, Len(st$) - x%)
	x% = InStr(st$, delim)
	If x% <> 0 Then 'found second delim
	    get_string = Mid$(st$, x% + 1, Len(st$) - x%)
	    Exit Function
	End If
    End If
End If

End Function

Function get_text (st As String) As String
'returns the string up to the next space
'if no space returns a null string and leaves st alone

x% = InStr(1, st$, Chr$(32))
If x% > 0 Then
    get_text = Mid$(st$, 1, x% - 1)
    st = Mid$(st$, x% + 1, Len(st$) - x%)
Else
    'no spaces therefore return st as get_text
    get_text = st$
    st$ = ""
End If

End Function

Sub init_error_array ()
    ReDim error_array(10)
    
    error_array(1).cap_st$ = "Fatal Error"
    error_array(1).message = "Program not installed correctly" + crlf$ + "Please re-install " + program_name
    error_array(1).err_type = 16

    error_array(2).cap_st$ = "Password Problem"
    error_array(2).message = "Password File not found" + crlf$ + "Please re-install " + program_name
    error_array(2).err_type = 16

    error_array(3).cap_st$ = "Fatal Error"
    error_array(3).message = "Windows ini file is missing" + crlf$ + "Please re-install " + program_name
    error_array(3).err_type = 16
    
    error_array(4).cap_st$ = "Problem with Post Office"
    error_array(4).message = "Invalid Post Office Path"
    error_array(4).err_type = 48

    error_array(5).cap_st$ = "Invalid Date Entered"
    error_array(5).message = "Check the date format in the /mm/dd/yy box"
    error_array(5).err_type = 16

    error_array(6).cap_st$ = "Problem opening output file"
    error_array(6).message = "Could not open output file"
    error_array(6).err_type = 16

    
End Sub

Sub init_prev_pos ()
'This sub routine makes sure that the keys are present under [prev_po] whether blank or not

    ret_st$ = String$(256, " ")
    x% = GetPrivateProfileString("prev_po", "po1", "none", ret_st$, Len(ret_st$), INI_FILE)
    
    If Mid$(ret_st$, 1, 1) = Chr$(0) Then   'blank line
	'po1 not there so add blank key
	If WritePrivateProfileString("prev_po", "po1", "none", INI_FILE) = 0 Then
	    MsgBox "Unable to write profile string", 48, ini_array(1).appname
	End If
    End If
    ret_st$ = String$(256, " ")
    x% = GetPrivateProfileString("prev_po", "po2", "none", ret_st$, Len(ret_st$), INI_FILE)
    
    If Mid$(ret_st$, 1, 1) = Chr$(0) Then   'blank line
	'po2 not there so add blank key
	If WritePrivateProfileString("prev_po", "po2", "none", INI_FILE) = 0 Then
	    MsgBox "Unable to write profile string", 48, ini_array(1).appname
	End If
    End If
    ret_st$ = String$(256, " ")
    x% = GetPrivateProfileString("prev_po", "po3", "none", ret_st$, Len(ret_st$), INI_FILE)
    
    If Mid$(ret_st$, 1, 1) = Chr$(0) Then   'blank line
	'po3 not there so add blank key
	If WritePrivateProfileString("prev_po", "po3", "none", INI_FILE) = 0 Then
	    MsgBox "Unable to write profile string", 48, ini_array(1).appname
	End If
    End If

    ret_st$ = String$(256, " ")
    x% = GetPrivateProfileString("prev_po", "po4", "none", ret_st$, Len(ret_st$), INI_FILE)
    If Mid$(ret_st$, 1, 1) = Chr$(0) Then   'blank line
	'po4 not there so add blank key
	If WritePrivateProfileString("prev_po", "po4", "none", INI_FILE) = 0 Then
	    MsgBox "Unable to write profile string", 48, ini_array(1).appname
	End If
    End If
    
    ret_st$ = String$(256, " ")
    x% = GetPrivateProfileString("prev_po", "po5", "none", ret_st$, Len(ret_st$), INI_FILE)
    If Mid$(ret_st$, 1, 1) = Chr$(0) Then   'blank line
	'po5 not there so add blank key
	If WritePrivateProfileString("prev_po", "po5", "none", INI_FILE) = 0 Then
	    MsgBox "Unable to write profile string", 48, ini_array(1).appname
	End If
    End If

End Sub

Sub insert_commandline (last_line As Integer, position As String)
    If position = "after" Then

	'SendKeys "{down}"  'default to Analyze
	SendKeys "{up}"
	'cmdline(last_line).Combo1.Text = cmdline(last_line).Combo1.List(0)
	If last_line > 1 Then
	    mdimain!mnuEditItem(2).Enabled = True
	End If
	Load cmdline(last_line)
	cmdline(last_line).Tag = last_line   'save array position
	cmdline(last_line).description.Visible = True
	cmdline(last_line).Label1.Visible = True
	cmdline(last_line).Combo1.Visible = True
	'cmdline(last_line).Desc.visible = True   'description
	cmdline(last_line).Panel3D1.Visible = True  'description
	cmdline(last_line).Sequence.Visible = True
	cmdline(last_line).Combo2.Visible = True
	cmdline(last_line).Move_Button.Visible = True
	For j = 0 To 4
	    cmdline(last_line).buttons(j).Visible = True
	Next j
	mdimain.Arrange CASCADE
	
	'dirty = True

    End If
    
End Sub

'------------------------------------------------------
' Function:   IsValidPath as integer
' arguments:  DestPath$         a string that is a full path
'             DefaultDrive$     the default drive.  eg.  "C:"
'
'  If DestPath$ does not include a drive specification,
'  IsValidPath uses Default Drive
'
'  When IsValidPath is finished, DestPath$ is reformated
'  to the format "X:\dir\dir\dir\"
'
' Result:  True (-1) if path is valid.
'          False (0) if path is invalid
'-------------------------------------------------------
Function isvalidpath (destpath$, ByVal DefaultDrive$) As Integer

    '----------------------------
    ' Remove left and right spaces
    '----------------------------
    destpath$ = RTrim$(LTrim$(destpath$))
    

    '-----------------------------
    ' Check Default Drive Parameter
    '-----------------------------
    If Right$(DefaultDrive$, 1) <> ":" Or Len(DefaultDrive$) <> 2 Then
	MsgBox "Bad default drive parameter specified in IsValidPath Function.  You passed,  """ + DefaultDrive$ + """.  Must be one drive letter and "":"".  For example, ""C:"", ""D:""...", 64, "Setup Kit Error"
	GoTo parseErr
    End If
    

    '-------------------------------------------------------
    ' Insert default drive if path begins with root backslash
    '-------------------------------------------------------
    If Left$(destpath$, 1) = "\" Then
	destpath$ = DefaultDrive + destpath$
    End If
    
    '-----------------------------
    ' check for invalid characters
    '-----------------------------
    On Error Resume Next
    'tmp$ = Dir$(DestPath$)
    current$ = CurDir$
    ChDir destpath$
    If Err <> 0 Then
	ChDir current$
	GoTo parseErr
    End If
    ChDir current$
    
    '-----------------------------------------
    ' Check for wildcard characters and spaces
    '-----------------------------------------
    If (InStr(destpath$, "*") <> 0) GoTo parseErr
    If (InStr(destpath$, "?") <> 0) GoTo parseErr
    If (InStr(destpath$, " ") <> 0) GoTo parseErr
	 
    
    '------------------------------------------
    ' Make Sure colon is in second char position
    '------------------------------------------
    If Mid$(destpath$, 2, 1) <> Chr$(58) Then GoTo parseErr
    

    '-------------------------------
    ' Insert root backslash if needed
    '-------------------------------
    If Len(destpath$) > 2 Then
      If Right$(Left$(destpath$, 3), 1) <> "\" Then
	destpath$ = Left$(destpath$, 2) + "\" + Right$(destpath$, Len(destpath$) - 2)
      End If
    End If

    '-------------------------
    ' Check drive to install on
    '-------------------------
    drive$ = Left$(destpath$, 1)
    ChDrive (drive$)                                                        ' Try to change to the dest drive
    If Err <> 0 Then GoTo parseErr
    
    '-----------
    ' Add final \
    '-----------
    If Right$(destpath$, 1) <> "\" Then
	destpath$ = destpath$ + "\"
    End If
    

    '-------------------------------------
    ' Root dir is a valid dir
    '-------------------------------------
    If Len(destpath$) = 3 Then
	If Right$(destpath$, 2) = ":\" Then
	    GoTo ParseOK
	End If
    End If
    

    '------------------------
    ' Check for repeated Slash
    '------------------------
    If InStr(destpath$, "\\") <> 0 Then GoTo parseErr
	
    '--------------------------------------
    ' Check for illegal directory names
    '--------------------------------------
    legalChar$ = "!#$%&'()-0123456789@ABCDEFGHIJKLMNOPQRSTUVWXYZ^_`{}~."
    BackPos = 3
    forePos = InStr(4, destpath$, "\")
    Do
	temp$ = Mid$(destpath$, BackPos + 1, forePos - BackPos - 1)
	
	'----------------------------
	' Test for illegal characters
	'----------------------------
	For i = 1 To Len(temp$)
	    If InStr(legalChar$, UCase$(Mid$(temp$, i, 1))) = 0 Then GoTo parseErr
	Next i

	'-------------------------------------------
	' Check combinations of periods and lengths
	'-------------------------------------------
	periodPos = InStr(temp$, ".")
	length = Len(temp$)
	If periodPos = 0 Then
	    If length > 8 Then GoTo parseErr                         ' Base too long
	Else
	    If periodPos > 9 Then GoTo parseErr                      ' Base too long
	    If length > periodPos + 3 Then GoTo parseErr             ' Extension too long
	    If InStr(periodPos + 1, temp$, ".") <> 0 Then GoTo parseErr' Two periods not allowed
	End If

	BackPos = forePos
	forePos = InStr(BackPos + 1, destpath$, "\")
    Loop Until forePos = 0

ParseOK:
    isvalidpath = True
    Exit Function

parseErr:
    isvalidpath = False
End Function

Function kill_file (fname As String) As Integer
 
kill_file = False
On Error GoTo kill_err

    Kill fname
    kill_file = True
    Exit Function

kill_err:
    'MsgBox Str$(Err)
    kill_file = False
    Exit Function


End Function

Sub makebevel (TheControl As Control)
    TheControl.DrawWidth = 2
    TheControl.ScaleMode = 3
    BoxTop% = 0 + 1
    BoxBottom% = TheControl.ScaleHeight - 1
    BoxLeft% = 0 + 1
    BoxRight% = TheControl.ScaleWidth - 1
    TheControl.AutoRedraw = True
    TheControl.Line (BoxLeft%, BoxBottom%)-(BoxRight%, BoxBottom%), QBColor(15), B
    TheControl.Line (BoxRight%, BoxTop%)-(BoxRight%, BoxBottom%), QBColor(15), B
    TheControl.Line (BoxLeft%, BoxTop%)-(BoxRight%, BoxTop%), QBColor(8), B
    TheControl.Line (BoxLeft%, BoxTop%)-(BoxLeft%, BoxBottom%), QBColor(8), B
    TheControl.AutoRedraw = False
End Sub

Sub open_demo_file ()
		
		fname$ = ini_array(13).setting + "demo.cmd"
		
		recordlen = Len(cmd_rec)
		filenum = FreeFile
		If open_random_file(fname$) Then
		    new_file = False
		    mdimain.mnufileitem(2).Enabled = True 'file open
		    mdimain.mnufileitem(3).Enabled = True 'file close
		    mdimain.mnufileitem(4).Enabled = True   'save
		    mdimain.mnufileitem(5).Enabled = True   'save as
		    For i = 0 To 2
			mdimain!mnuEditItem(i).Enabled = True
		    Next i
		    For i = 0 To 3
			mdimain.mnuWindowItem(i).Enabled = True
		    Next i
		    Call close_current_file  'closes out child forms
		    last_line = 0
		    mdimain.Caption = program_name + " - [" + fname$ + "]"
		    cmd_file_name$ = fname$
		    
		    rec_num = LOF(filenum) / Len(cmd_rec)
		    For read_recs = 1 To rec_num
			last_line = last_line + 1
			Get filenum, last_line, cmd_rec
			temp1$ = RTrim$(cmd_rec.cap_st$)
			temp2$ = RTrim$(cmd_rec.command$)
			temp3$ = RTrim$(cmd_rec.Desc$)
			Load cmdline(last_line)
			mdimain.Arrange CASCADE
			bounce_back = True
			cmdline(last_line).Caption = temp1$
			If temp2$ = "Analyze" Then
			    cmdline(last_line).Combo1.ListIndex = 0
			ElseIf temp2$ = "Backup" Then
			    cmdline(last_line).Combo1.ListIndex = 1
			ElseIf temp2$ = "ChkStat" Then
			    cmdline(last_line).Combo1.ListIndex = 2
			Else
			    cmdline(last_line).Combo1.ListIndex = 3
			End If
			bounce_back = False
			cmdline(last_line).Panel3D1.Caption = temp3$
			cmdline(last_line).Tag = last_line   'save array position
			cmdline(last_line).Label1.Visible = True
			cmdline(last_line).description.Visible = True
			cmdline(last_line).Combo1.Visible = True
			cmdline(last_line).Panel3D1.Visible = True   'description
			cmdline(last_line).Sequence.Visible = True
			cmdline(last_line).Combo2.Visible = True
			cmdline(last_line).Move_Button.Visible = True
			cmdline(last_line).Caption = temp1$
			cmdline(last_line).Panel3D1.Caption = temp3$

			st$ = get_outfile2()
			If file_exists(st$) Then    'turn on buttons
			    cmdline(last_line).buttons(1).Enabled = True
			    cmdline(last_line).buttons(4).Enabled = True
			End If
			'check to see if run should be on
			Desc$ = cmdline(current_line).Panel3D1.Caption
			If InStr(Desc$, "chkstat") <> 0 Then
			    cmdline(last_line).buttons(1).Enabled = True
			ElseIf InStr(Desc$, "reclaim") <> 0 Then
			    cmdline(last_line).buttons(1).Enabled = True
			ElseIf InStr(Desc$, "analyze") <> 0 Then
			    cmdline(last_line).buttons(1).Enabled = True
			ElseIf InStr(Desc$, "copy") <> 0 Then
			    cmdline(last_line).buttons(1).Enabled = True
			End If
			For j = 0 To 4
			    cmdline(last_line).buttons(j).Visible = True
			Next j
		    Next read_recs
		    dirty = False
		    
		    Close filenum
		    UpdateMainMenu  'add fname to file menu
		End If

End Sub

Function open_existing_file () As Integer
	    open_existing_file = False
	    Load frmopenfile
	    Unload frmopenfile
	    Load frmopenfile
	    frmopenfile.Caption = "Open File"
	    frmopenfile.file_desc.Enabled = False
	    frmopenfile.Show 1
	    If frmopenfile.Text1.Text <> "" Then
		fname$ = frmopenfile.Text1.Text
		'Stop
		If Mid$(fname$, 2, 1) <> ":" Then   'no path entered
		    If Mid$(frmopenfile.Dir1.Path, Len(frmopenfile.Dir1.Path), 1) = "\" Then
			fname$ = frmopenfile.Dir1.Path + frmopenfile.Text1.Text
		    Else
			fname$ = frmopenfile.Dir1.Path + "\" + frmopenfile.Text1.Text
		    End If
		End If
		    
		If Not file_exists(fname$) Then
		    st$ = UCase(fname$) + crlf$ + crlf$ + "This filename is not valid"
		    rr% = MsgBox(st$, 48, "File Open")
		    If rr% = 7 Then Exit Function
		End If
		
		recordlen = Len(cmd_rec)
		filenum = FreeFile
		If open_random_file(fname$) Then
		    new_file = False
		    mdimain.mnufileitem(2).Enabled = True 'file open
		    mdimain.mnufileitem(3).Enabled = True 'file close
		    mdimain.mnufileitem(4).Enabled = True   'save
		    mdimain.mnufileitem(5).Enabled = True   'save as
		    For i = 0 To 2
			mdimain!mnuEditItem(i).Enabled = True
		    Next i
		    For i = 0 To 3
			mdimain.mnuWindowItem(i).Enabled = True
		    Next i
		    Call close_current_file  'closes out child forms
		    last_line = 0
		    mdimain.Caption = program_name + " - [" + fname$ + "]"
		    cmd_file_name$ = fname$
		    
		    rec_num = LOF(filenum) / Len(cmd_rec)
		    For read_recs = 1 To rec_num
			last_line = last_line + 1
			Get filenum, last_line, cmd_rec
			temp1$ = RTrim$(cmd_rec.cap_st$)
			temp2$ = RTrim$(cmd_rec.command$)
			temp3$ = RTrim$(cmd_rec.Desc$)
			Load cmdline(last_line)
			mdimain.Arrange CASCADE
			bounce_back = True
			cmdline(last_line).Caption = temp1$
			If temp2$ = "Analyze" Then
			    cmdline(last_line).Combo1.ListIndex = 0
			ElseIf temp2$ = "Backup" Then
			    cmdline(last_line).Combo1.ListIndex = 1
			ElseIf temp2$ = "ChkStat" Then
			    cmdline(last_line).Combo1.ListIndex = 2
			Else
			    cmdline(last_line).Combo1.ListIndex = 3
			End If
			bounce_back = False
			cmdline(last_line).Panel3D1.Caption = temp3$
			cmdline(last_line).Tag = last_line   'save array position
			cmdline(last_line).description.Visible = True
			cmdline(last_line).Label1.Visible = True
			cmdline(last_line).Combo1.Visible = True
			cmdline(last_line).Panel3D1.Visible = True   'description
			cmdline(last_line).Sequence.Visible = True
			cmdline(last_line).Combo2.Visible = True
			cmdline(last_line).Move_Button.Visible = True
			cmdline(last_line).Caption = temp1$
			cmdline(last_line).Panel3D1.Caption = temp3$

			st$ = get_outfile2()
			If file_exists(st$) Then    'turn on buttons
			    cmdline(last_line).buttons(1).Enabled = True
			    cmdline(last_line).buttons(4).Enabled = True
			End If
			'check to see if run should be on
			Desc$ = cmdline(current_line).Panel3D1.Caption
			If InStr(Desc$, "chkstat") <> 0 Then
			    cmdline(last_line).buttons(1).Enabled = True
			ElseIf InStr(Desc$, "reclaim") <> 0 Then
			    cmdline(last_line).buttons(1).Enabled = True
			ElseIf InStr(Desc$, "analyze") <> 0 Then
			    cmdline(last_line).buttons(1).Enabled = True
			ElseIf InStr(Desc$, "copy") <> 0 Then
			    cmdline(last_line).buttons(1).Enabled = True
			End If
			For j = 0 To 4
			    cmdline(last_line).buttons(j).Visible = True
			Next j
			
		    Next read_recs
		    dirty = False
		    open_existing_file = True
		    Close filenum
		    UpdateMainMenu  'add fname to file menu
		End If
	    End If

End Function

Function open_for_input (fname As String) As Integer
'opens a file for input

open_for_input = 0

On Error GoTo err_input
    filenum = FreeFile
    Open fname For Input As filenum
    open_for_input = filenum
    Exit Function

err_input:
    Exit Function

End Function

Function open_for_output (fname As String) As Integer
'opens a file for output

open_for_output = 0

On Error GoTo err_open
    filenum = FreeFile
    Open fname For Output As filenum
    open_for_output = filenum
    Exit Function

err_open:
    Exit Function
End Function

Function open_random_file (fname As String) As Integer

open_random_file = False
On Error GoTo open_error

Open fname$ For Random As filenum Len = recordlen

recordlen = Len(cmd_rec)

open_random_file = True
Exit Function

open_error:
st$ = "Unable to Create File: " + fname$
rr% = MsgBox(st$, 16, "File Error")

Exit Function


End Function

Sub pack_it ()

		rr% = MsgBox("This will remove any reports attached to your cc:Mail commands.", 17, "Pack File")
		If rr% = 2 Then
		    Exit Sub
		End If
		
		the_file$ = fname$
		recordlen = Len(cmd_rec)
		If Not kill_file(the_file$) Then
		End If
		
		filenum% = FreeFile
		j = 1
		If open_random_file(the_file$) Then
		    For i = 1 To last_line
			'delete report files if there...
			rname$ = Mid$(the_file$, 1, Len(the_file$) - 4)
			old_tag$ = String$(3 - Len(LTrim$(Str$(i))), "0") + Trim$(Str$(i))
			If Not kill_file(rname$ + "." + old_tag$) Then
			End If
			
			If InStr(cmdline(i).Caption, "Excluded") = 0 Then
			    ss$ = Mid$(cmdline(i).Caption, 4, Len(cmdline(i).Caption) - 3)
			    tag_st$ = Str$(j)
			    tag_st$ = LTrim$(tag_st$)
			    tag_st$ = String$(3 - Len(tag_st$), "0") + tag_st$
			    cmd_rec.cap_st$ = tag_st$ + ss$
			    
			    cmd_rec.command$ = cmdline(i).Combo1.Text
			    cmd_rec.Desc = cmdline(i).Panel3D1.Caption
			    Put #filenum%, j, cmd_rec
			    j = j + 1
			Else
			    dirty = True
			End If
		    Next i
		    dirty = False
		    Close filenum%
		End If
		
		recordlen = Len(cmd_rec)
		filenum = FreeFile
		If open_random_file(the_file$) Then
		    Call close_current_file  'closes out child forms
		    last_line = 0
		    
		    rec_num = LOF(filenum) / Len(cmd_rec)
		    For read_recs = 1 To rec_num
			last_line = last_line + 1
			Get filenum, last_line, cmd_rec
			temp1$ = RTrim$(cmd_rec.cap_st$)
			temp2$ = RTrim$(cmd_rec.command$)
			temp3$ = RTrim$(cmd_rec.Desc$)
			
			Load cmdline(last_line)
			mdimain.Arrange CASCADE

			bounce_back = True
			cmdline(last_line).Caption = temp1$
			If temp2$ = "Analyze" Then
			    cmdline(last_line).Combo1.ListIndex = 0
			ElseIf temp2$ = "Backup" Then
			    cmdline(last_line).Combo1.ListIndex = 1
			ElseIf temp2$ = "ChkStat" Then
			    cmdline(last_line).Combo1.ListIndex = 2
			Else
			    cmdline(last_line).Combo1.ListIndex = 3
			End If
			bounce_back = False

			cmdline(last_line).Panel3D1.Caption = temp3$
			cmdline(last_line).Tag = last_line   'save array position
			cmdline(last_line).description.Visible = True
			cmdline(last_line).Combo1.Visible = True
			cmdline(last_line).Panel3D1.Visible = True   'description
			cmdline(last_line).Sequence.Visible = True
			cmdline(last_line).Combo2.Visible = True
			cmdline(last_line).Move_Button.Visible = True
			For j = 0 To 4
			    cmdline(last_line).buttons(j).Visible = True
			Next j
			cmdline(last_line).Caption = temp1$
			cmdline(last_line).Panel3D1.Caption = temp3$
			
			st$ = get_outfile2()
			If file_exists(st$) Then    'turn on buttons
			    cmdline(last_line).buttons(1).Enabled = True
			    cmdline(last_line).buttons(4).Enabled = True
			End If
			
		    Next read_recs
		    Close filenum
		End If
		


End Sub

Function pad_it (st As String) As String
If st = "" Then
    pad_it = ""
    Exit Function
End If
pad_it = String$(3 - Len(st), "0") + st
End Function

Function parse_anal5 (st As String) As Integer
parse_anal5 = False
If st$ = "" Then Exit Function

If InStr(1, st$, "/users") > 0 Then
    anal5.Check5.Value = 1
End If

If InStr(1, st$, "/batch") > 0 Then
    anal5.Check1.Value = 1
End If

If InStr(1, st$, "/diagnostics") > 0 Then
    anal5.Check2.Value = 1
End If

If InStr(1, st$, "/directory") > 0 Then
    anal5.Check3.Value = 1
End If

If InStr(1, st$, "/messages") > 0 Then
    anal5.Check4.Value = 1
End If

If InStr(1, st$, "/d") > 0 Then     'po path
    done% = False
    path_start = InStr(1, st$, "/d") + 2    'first letter in path part
    i = 0
    While Not done%
	ch$ = Mid$(st$, path_start + i, 1)
	If path_start + i = Len(st$) Then   'they only entered a po path
	    done% = True
	ElseIf ch$ = " " Then
	    done% = True
	    i = i - 1
	Else
	    i = i + 1
	End If
    Wend
    po_path$ = Mid$(st$, path_start, ((path_start + i) - path_start) + 1)
    Call check_combo1_list(anal5, po_path$, "", "")'check if po_path in list and add to combo box and prev_po list if necessary


End If

If InStr(1, st$, "/usr") > 0 Then
    done% = False
    usr_start = InStr(1, st$, "/usr") + 5
    i = 0
    While Not done%
	ch$ = Mid$(st$, usr_start + i, 1)
	If usr_start + i = Len(st$) Then
	    done% = True
	ElseIf ch$ = " " Then
	    done% = True
	    i = i - 1
	Else
	    i = i + 1
	End If
    Wend
    usr$ = "usr" + Mid$(st$, usr_start, ((usr_start + i) - usr_start) + 1)
    For i = 0 To anal5.List1.ListCount - 1
	If anal5.List1.List(i) = usr$ Then
	    anal5.List1.Selected(i) = True
	End If
    Next i
End If

If InStr(1, st$, "/n") > 0 Then
    done% = False
    usr_start = InStr(1, st$, "/n") + 3
    i = 0
    While Not done%
	ch$ = Mid$(st$, usr_start + i, 1)
	If usr_start + i = Len(st$) Then
	    done% = True
	ElseIf ch$ = Chr$(34) Then
	    done% = True
	    i = i - 1
	Else
	    i = i + 1
	End If
    Wend
    anal5.Text4.Text = Mid$(st$, usr_start, ((usr_start + i) - usr_start) + 1)
End If

End Function

Function parse_backup (st As String) As Integer

s = False
d = False

On Error GoTo parse_error
    parse_backup = False
    If InStr(1, st$, "for") > 0 Then 'usr files
	If InStr(1, st$, "[Enter]") = 0 Then
	    ccbackup.chkfile1.Value = True
	End If
    End If
    If InStr(1, st$, "mlandata") > 0 Then 'mlandata
	ccbackup.chkfile2.Value = True
    End If
    If InStr(1, st$, "clandata") > 0 Then   'clandata
	ccbackup.chkfile0.Value = True
    End If

    x% = ccbackup.chkfile0.Value + ccbackup.chkfile1.Value + ccbackup.chkfile2.Value
    If x% = -3 Then
	ccbackup.chkfile3.Value = True
    End If

    'now get source and destination paths
    If InStr(1, st$, "mlandata") > 0 Then
	temp$ = ""
	ch$ = ""
	i = 1
	Do
	    temp$ = temp$ + ch$
	    ch$ = Mid$(st$, i + 5, 1)
	    i = i + 1
	Loop Until ch$ = Chr$(32)
	
	st2$ = Mid$(st$, i + 5, Len(st$) - i + 1)   'for finding destination
	x% = InStr(1, st2$, Chr$(13))
	If x% = 0 Then
	    temp2$ = st2$
	Else
	    end_pos% = x% - 1
	    temp2$ = Mid$(st2$, 1, end_pos%)
	End If

	x% = InStr(temp2$, ">>")
	If x% > 0 Then
	    temp2$ = Mid$(temp2$, 1, x% - 2)
	End If
	
	d = True
	ccbackup.Dir2.Path = temp2$     'destination
	d = False
	x% = InStr(1, temp$, "mlandata")
	temp$ = Mid$(temp$, 1, x% - 1)
	s = True
	ccbackup.Dir1.Path = temp$
	s = False
    ElseIf InStr(1, st$, "clandata") > 0 Then
	temp$ = ""
	ch$ = ""
	i = 1
	Do
	    temp$ = temp$ + ch$
	    ch$ = Mid$(st$, i + 5, 1)
	    i = i + 1
	Loop Until ch$ = Chr$(32)
	st2$ = Mid$(st$, i + 5, Len(st$) - i + 1)   'for finding destination
	x% = InStr(1, st2$, Chr$(13))
	If x% = 0 Then
	    temp2$ = st2$
	Else
	    end_pos% = x% - 1
	    temp2$ = Mid$(st2$, 1, end_pos%)
	End If
	
	x% = InStr(temp2$, ">>")
	If x% > 0 Then
	    temp2$ = Mid$(temp2$, 1, x% - 2)
	End If

	d = True
	ccbackup.Dir2.Path = temp2$     'destination
	d = False
	x% = InStr(1, temp$, "clandata")
	temp$ = Mid$(temp$, 1, x% - 1)
	s = True
	ccbackup.Dir1.Path = temp$
	s = False
    ElseIf InStr(1, st$, "for") > 0 Then
	start_pos% = 13
	end_pos% = InStr(1, st$, "usr") - 1
	temp$ = Mid$(st$, start_pos%, end_pos% - start_pos% + 1)
	s = True
	ccbackup.Dir1.Path = temp$
	s = False
	start_pos% = InStr(1, st$, "copy %%") + 9
	end_pos% = InStr(1, st$, "usr????? >") - 1
	temp2$ = Mid$(st$, start_pos%, end_pos% - start_pos% + 1)
	d = True
	ccbackup.Dir2.Path = temp2$
	d = False
    End If

   
Exit Function

parse_error:
If s = True Then
    'ccbackup.source.Text = ""
    last_ch$ = Mid$(temp$, Len(temp$), 1)
    If last_ch$ = "\" Then
	ccbackup.source.Text = Mid$(temp$, 1, Len(temp$) - 1)
    Else
	ccbackup.source.Text = temp$
    End If

End If
If d = True Then
    'ccbackup.destination.Text = ""
    last_ch$ = Mid$(temp2$, Len(temp2$), 1)
    If last_ch$ = "\" Then
	ccbackup.destination.Text = Mid$(temp2$, 1, Len(temp2$) - 1)
    Else
	ccbackup.destination.Text = temp2$
    End If
End If
Resume Next

    
End Function

Function parse_filename (ByVal st As String) As String

parse_filename = Mid$(st$, 1, Len(st$) - 4)
Exit Function



done = False
i = Len(st$) - 4    'start at character before dot
new_st$ = ""
While Not done
    ch$ = Mid$(st$, i, 1)
    If ch$ = ":" Or ch$ = "\" Or ch$ = "/" Then
	done = True
    ElseIf i = 1 Then   'at beginning of string
	done = True
	new_st$ = new_st$ + ch$
    Else
	new_st$ = new_st$ + ch$
    End If
    i = i - 1
Wend

temp$ = ""  'reverse it
For i = 1 To Len(new_st$)
    ch$ = Mid$(new_st$, i, 1)
    temp$ = ch$ + temp$
Next i

parse_filename = temp$

End Function

Function parse_newchk (st As String) As Integer
parse_newchk = False
'first get the poname, pass, and path

'remove any leading blanks
done = False
While Not done
    ch$ = Mid$(st$, 1, 1)
    If ch$ = " " Then
	st$ = Mid$(st$, 2, Len(st$) - 1)
    Else
	done = True
    End If
Wend
'remove and trailing blanks
done = False
While Not done
    ch$ = Mid$(st$, Len(st$), 1)
    If ch$ = " " Then
	st$ = Mid$(st$, 1, Len(st$) - 1)
    Else
	done = True
    End If
Wend

x% = InStr(1, st$, "chkstat")
If x% = 0 Then Exit Function
'take off chkstat.exe
st$ = Mid$(st$, x% + 8, Len(st$) - (x% - 7))

done = False
i = 0
While Not done
    temp$ = get_text(st$)
    
    ch$ = Mid$(temp$, 2, 1)

    If ch$ = "n" Then
	newchk!poname.Text = Mid$(temp$, 3, Len(temp$) - 2)
    ElseIf ch$ = "d" Then
	
	popath = Mid$(temp$, 3, Len(temp$) - 2)
	found = False
	marker = 0
	For xx = 0 To (newchk!combo1.ListCount - 1)
	    If LCase$(newchk!combo1.List(xx)) = LCase$(popath) Then
		found = True
		marker = xx 'place found
	    End If
	Next xx

	If found Then
	    newchk!combo1.ListIndex = marker
	Else
	    newchk!combo1.AddItem popath
	    newchk!combo1.ListIndex = newchk!combo1.ListCount - 1 'set combo1 to display this path
	End If
	
    ElseIf ch$ = "p" Then
	newchk!popassword.Text = Mid$(temp$, 3, Len(temp$) - 2)
    Else
	Exit Function
    End If
    i = i + 1
    If i = 3 Then done = True
Wend
parse_newchk = True

End Function

Function parse_reclaim (st As String) As Integer
    done = False
    Do
	temp$ = get_text(st)
	'now check for ccmail options
	If InStr(1, temp$, "/n") > 0 Then
	    frm_reclaim.Text1.Text = Mid$(temp$, 3, Len(temp$) - 2)
	ElseIf InStr(1, temp$, "/p") > 0 Then
	    frm_reclaim.Text2.Text = Mid(temp$, 3, Len(temp$) - 2)
	ElseIf InStr(1, temp$, "/d") > 0 Then
	    'frm_reclaim.Text3.Text = Mid(temp$, 3, Len(temp$) - 2)
	    frm_reclaim.Combo1.List(0) = Mid(temp$, 3, Len(temp$) - 2)
	ElseIf temp$ = "/Rename" Then
	    frm_reclaim.Check7.Value = 1
	ElseIf InStr(1, temp$, "/Directory") > 0 Then
	    'parse /Directory command
	    frm_reclaim.Check1.Value = 1
	    If Len(temp$) > 10 Then 'option on end
		frm_reclaim.Check2.Value = 1
		frm_reclaim.Text7.Text = Mid$(temp$, 12, (Len(temp$) - 12) + 1)
	    End If
	ElseIf InStr(1, temp$, "/NFT/O") > 0 Then
	    frm_reclaim.Check6.Value = 1
	ElseIf temp$ = "/Messages" Then
	    frm_reclaim.Check5.Value = 1
	ElseIf InStr(1, temp$, "/Diagnostics") > 0 Then
	    'parse /Diagnostics option
	    frm_reclaim.Check3.Value = 1
	    If Len(temp$) > 12 Then 'option on end
		frm_reclaim.Check9.Value = 1    'only option available
	    End If
	ElseIf InStr(1, temp$, "/Ekey") > 0 Then
	    frm_reclaim.Check4.Value = 1
	    If Len(temp$) > 5 Then  'get option
		frm_reclaim.Text4.Text = Mid$(temp$, 7, (Len(temp$) - 7) + 1)
	    End If
	ElseIf InStr(1, temp$, "/Target") > 0 Then
	    frm_reclaim.Check8.Value = 1
	    If Len(temp$) > 7 Then
		frm_reclaim.Text5.Text = Mid$(temp$, 9, (Len(temp$) - 9) + 1)
	    End If
	End If
	If st$ = "" Then    'get_text finished with last call to it
	    done = True
	End If
    Loop Until done

End Function

Function path_exists (st As String) As Integer

    path_exists = False
    cur_dir$ = CurDir$
    If st$ = "" Then Exit Function
    If Mid$(st$, Len(st$), 1) = ":" Then st$ = st$ + "\"
    If Mid$(st$, Len(st$), 1) = "\" Then
	If Mid$(st$, Len(st$) - 1, 1) <> ":" Then
	    st$ = Mid$(st$, 1, Len(st$) - 1)
	End If
    End If

On Error GoTo path_error
    ChDir st
    ChDir cur_dir$
    path_exists = True
    Exit Function

path_error:
    ChDir cur_dir$  'put current directory back
    Exit Function

End Function

Sub post_message (message As String)
    l = 75
    mdimain.Picture1.DrawWidth = 15
    mdimain.Picture1.Line (l, 130)-(l + 2500, 130), QBColor(7)
    mdimain.Picture1.DrawWidth = 2
    mdimain.Picture1.CurrentX = 75
    mdimain.Picture1.CurrentY = 52
    mdimain.Picture1.Print message
End Sub

Function remove_blanks (st As String) As String

done = False
remove_blanks = ""

While Not done
    ch$ = Mid$(st$, Len(st$), 1)
    If ch$ = " " Then
	st$ = Mid$(st$, 1, Len(st$) - 1)
    Else
	remove_blanks = st$
	Exit Function
    End If
    If Len(st$) = 1 Then
	remove_blanks = String$(25, "X")
	Exit Function
    End If
Wend

End Function

Sub rename (st1 As String, st2 As String)
'Stop
On Error GoTo ren_err
    Name st1$ As st2
    Exit Sub

ren_err:
    Exit Sub


End Sub

Function replace_blanks (ByVal st As String) As String

new_st$ = ""
For i = 1 To Len(st$)
    char$ = Mid$(st$, i, 1)
    If char$ = Chr$(32) Then
	new_st$ = new_st$ + Chr$(160)
    Else
	new_st$ = new_st$ + char$
    End If
Next i

replace_blanks = new_st$

End Function

Sub save_untitled ()
'automatically save as untitled.cmd

screen_width% = 53
l_st$ = "001"
m_st$ = "Analyze"
r_st$ = ""

If screen_width% Mod 2 = 0 Then
    'even length
    screen_width% = screen_width% - 1
End If
ReDim cap_array(screen_width%)
For i = 1 To screen_width%    'load the array with blanks
    cap_array(i) = Chr$(160)
Next i
'put left part in array

For i = 1 To Len(l_st$)
    cap_array(i) = Mid$(l_st$, i, 1)
Next i
'put middle in array
If Len(m_st$) Mod 2 = 0 Then
    is_even = True
Else
    is_even = False
End If
If is_even Then
    start_pos% = (Int(screen_width% / 2) - Int(Len(m_st$) / 2)) + 1
Else
    start_pos% = Int(screen_width% / 2) - Int(Len(m_st$) / 2)
End If
For i = 1 To Len(m_st$)
    cap_array(start_pos%) = Mid$(m_st$, i, 1)
    start_pos% = start_pos% + 1
Next i
'put right part in array
start_pos% = (screen_width% - Len(r_st$)) + 1
For i = 1 To Len(r_st$)
    cap_array(start_pos%) = Mid$(r_st$, i, 1)
    start_pos% = start_pos% + 1
Next i
'build caption string
cap_st$ = ""
For i = 1 To screen_width%
    cap_st$ = cap_st$ + cap_array(i)
Next i
cap_st$ = replace_blanks(cap_st$)

fname$ = ini_array(13).setting + "Untitled.cmd"
recordlen = Len(cmd_rec)
If Not kill_file(fname$) Then
End If



filenum% = FreeFile
If open_random_file(fname$) Then
    cmd_rec.file_desc$ = "No Description"
    cmd_rec.cap_st$ = cap_st$
    cmd_rec.command$ = "Analyze"
    'cmd_rec.desc = "Run Analyze"
    st$ = "Run Analyze a 'Super ChkStat'" + crlf$ + crlf$
    st$ = st$ + "The output of this program is can be" + crlf$
    st$ = st$ + "useful to cc:Mail" + R$ + " Support if you are experiencing Post Office errors."
    cmd_rec.Desc = st$
    Put #filenum%, 1, cmd_rec
    Close filenum%
End If




End Sub

Sub saveas ()
	    del_file$ = fname$
	    old_filename$ = parse_filename(fname$)
	    dirty = False
	    
	    Unload frmopenfile
	    Load frmopenfile
	    
	    frmopenfile.Caption = "Save As"
	    frmopenfile.cmdOpen.Caption = "OK"
	    frmopenfile.file_desc.Enabled = True
	    
	    frmopenfile.Show 1
	    
	    If frmopenfile.Text1.Text <> "" Then
		fname$ = frmopenfile.Text1.Text
		file_description$ = frmopenfile.file_desc.Text

		If Mid$(fname$, 2, 1) <> ":" Then   'no path entered
		    If Mid$(frmopenfile.Dir1.Path, Len(frmopenfile.Dir1.Path), 1) = "\" Then
			fname$ = frmopenfile.Dir1.Path + frmopenfile.Text1.Text
		    Else
			fname$ = frmopenfile.Dir1.Path + "\" + frmopenfile.Text1.Text
		    End If
		End If
		new_fname$ = parse_filename(fname$)
		
		If file_exists(fname$) Then
		    st$ = UCase(fname$) + crlf$ + crlf$ + "Replace existing file?"
		    rr% = MsgBox(st$, 308, "Save File As")
		    If rr% = 7 Then Exit Sub
		End If
		
		recordlen = Len(cmd_rec)
		If Not kill_file(fname$) Then
		    'just means it was not there
		End If
		filenum% = FreeFile
		
		If open_random_file(fname$) Then
		    For i = 1 To last_line
			cmd_rec.file_desc$ = file_description$
			cmd_rec.cap_st$ = cmdline(i).Caption
			cmd_rec.command$ = cmdline(i).Combo1.Text
			cmd_rec.Desc = cmdline(i).Panel3D1.Caption
			Put #filenum%, i, cmd_rec
			pad$ = LTrim$(Str$(i))
			pad$ = String$(3 - Len(pad$), "0")
			tag_st$ = "." + pad$ + LTrim$(Str$(i))
			'Call rename(old_filename$ + tag_st$, new_fname$ + tag_st$)
			Call copy_my_file(old_filename$ + tag_st$, new_fname$ + tag_st$)
			
			mdimain.Caption = fname$
		    Next i
		    Close filenum%

		End If

	    End If
	    Unload frmopenfile
End Sub

Sub show_ascii (ByVal st As String)
new_st = ""
For i = 1 To Len(st)
    ch = Mid$(st, i, 1)
    ch = Str$(Asc(ch))
    If Len(ch) = 1 Then
	ch = "0" + ch
    End If
    new_st = new_st + ch
Next i
MsgBox new_st
End Sub

Sub show_error (pos As Integer)
    'pos is the message to show in error_array

    MsgBox error_array(pos).message$, error_array(pos).err_type, error_array(pos).cap_st$
    
End Sub

Function startup () As Integer

    clear_on = False

    R$ = Chr(174)
    crlf$ = Chr$(13) + Chr$(10)
    po_path_error = False

    recordlen = Len(cmd_rec)

    did_not_open_file = False
    mainarraynum = 0    'no menus in file menu yet
    init_error_array    'build error_array
    build_ini_array

    init_prev_pos   'make sure keys are there...
    
    fname$ = ini_array(13).setting + "untitled.cmd"
    If Not kill_file(ini_array(13).setting + "tempfile.cmd") Then
    End If

    startup = False
    screen.MousePointer = 11
    
    ret_st$ = ini_array(12).setting + "manager.dat"
    file_num = FreeFile
    
    On Error GoTo err_pass
    Open ret_st$ For Input As #file_num  'no error check since done in check_pass
    
    ret_st$ = ""
    Line Input #file_num, ret_st$
    Close #file_num

    encrypted_pass$ = trim_null(ret_st$)
    st$ = Mid(encrypted_pass$, Len(encrypted_pass$) - 1, 2)
    shift% = Val(st$)
    
    st$ = Mid(encrypted_pass$, 1, Len(encrypted_pass$) - 2)
    current_password$ = unencrypt(st$, shift%)
    If current_password$ <> "" Then
	screen.MousePointer = 1
	passform.Show 1
    End If  'else do show if password is null
    
    ReDim cmdline(256)
    ReDim state_array(256)
    ReDim ch_params(256)
    
    mdimain.WindowState = 2
    last_line = 1  'start program with one midi form
    cancel_pressed = False
    new_file = False
    screen.MousePointer = 0

    For i = 0 To 1
	mdimain!mnuEditItem(i).Enabled = True
    Next i
    'mdimain.mnuHelpitem(1).Caption = "&About " + program_name + "..."
    startup = True
    Exit Function

err_pass:
    Call show_error(1)
    End

End Function

Function strip (ByVal st As String) As String

strip = ""
new_st$ = ""
For i = 1 To Len(st$)
    ch$ = Mid$(st$, i, 1)
    If ch$ <> Chr(32) Then
	new_st$ = new_st$ + ch$
    End If
Next i
strip = new_st$


End Function

Function transpose (ByVal in_st As String) As String
'performs tranposition on in_st

If Len(in_st) Mod 2 <> 0 Then   'odd len
    in_st = in_st + " "
End If

rows = Len(in_st) / 2

Dim trans() As String
ReDim trans(rows, 2) As String

x = 1
y = 1
For i = 1 To Len(in_st) / 2
    trans(x, 1) = Mid$(in_st, y, 1)
    y = y + 1
    trans(x, 2) = Mid$(in_st, y, 1)
    x = x + 1
    y = y + 1
Next i

out_st$ = ""
row_num = x - 1
For i = 1 To row_num
    out_st$ = out_st$ + trans(i, 1)
Next i
For i = 1 To row_num
    out_st$ = out_st$ + trans(i, 2)
Next i

transpose = out_st$

End Function

Function trim_null (st As String) As String
    st$ = LTrim$(RTrim$(st$))
    end_st$ = Mid(st$, Len(st$), 1)
    If Asc(end_st$) = 0 Then
	st$ = Mid$(st$, 1, Len(st$) - 1)
    End If
    trim_null = st$
End Function

Function unencrypt (ByVal in_st As String, shift As Integer) As String
Dim trans() As String
ReDim trans(95, 2) As String

x = 1
For i = 32 To 126
    trans(x, 1) = Chr$(i)
    x = x + 1
Next i


x = shift%
For i = 32 To (126 - (shift% - 1))    '116
    trans(x, 2) = Chr$(i)
    x = x + 1
Next i

x = 1
For i = (126 - (shift% - 2)) To 126
    trans(x, 2) = Chr$(i)
    x = x + 1
Next i

out_st = ""
For i = 1 To Len(in_st)
    x = 0
    match = 0
    ch = Mid$(in_st, i, 1)
    Do
	x = x + 1
	match_ch = trans(x, 2)
	If match_ch = ch Then
	    match = 1
	End If
    Loop Until match = 1
    out_st = out_st + trans(x, 1)
    
Next i

unencrypt = untranspose(out_st)


End Function

Function untranspose (ByVal in_st As String) As String

out_st = ""
half = Len(in_st) / 2    'transpose puts extra space if needed
For i = 1 To half
    out_st = out_st + Mid$(in_st, i, 1)
    out_st = out_st + Mid$(in_st, i + half, 1)
Next i
    
out_st = RTrim$(out_st) 'remove any pads
untranspose = out_st

End Function

Sub UpdateMainMenu ()
    If mainarraynum = 4 Then
	For i = 2 To 4
	    mdimain.mainmnuarray(i - 1).Caption = mdimain.mainmnuarray(i).Caption
	Next i
	Unload mdimain.mainmnuarray(4)
	mainarraynum = 3
    End If

    If mainarraynum > 0 Then
	For i = 0 To mainarraynum
	    
	    If mdimain!mainmnuarray(i).Caption = fname$ Then
		Exit Sub
	    End If
	Next i
    End If

    If InStr(1, fname$, "untitled") = 0 Then
	mdimain.mainmnuarray(0).Visible = True            ' Make the initial element visible / display separator bar.
	mainarraynum = mainarraynum + 1                             ' Increment index property of control array.
	Load mdimain!mainmnuarray(mainarraynum)               ' Create a new menu control.
	mdimain!mainmnuarray(mainarraynum).Caption = fname$ ' Set the caption of the new menu item.
	mdimain!mainmnuarray(mainarraynum).Visible = True     ' Make the new menu item visible.
    End If

End Sub

Sub view_report (cmd_file_name As String, st As String)
outfile$ = get_outfile()

If file_exists(outfile$) Then
    filenum = FreeFile
    Open outfile$ For Input As filenum
    did_not_open_file = True
    Load frmeditor
    frmeditor.Caption = "[" + outfile$ + "]" + st$
    frmeditor.mnufileitem(4).Enabled = True
    nextline = ""
    frmeditor.txtEdit.Text = Input$(LOF(filenum), filenum)
    Close filenum
    frmeditor.Show 1
End If

End Sub

