Option Explicit

Const HWND_BROADCAST = &HFFFF
Const WM_WININICHANGE = &H1A

Declare Function duini_nGetWindowsDirectory Lib "Kernel" Alias "GetWindowsDirectory" (ByVal lpDirName As String, ByVal nSize As Integer) As Integer

Declare Function duini_nWriteProfileString Lib "Kernel" Alias "WriteProfileString" (ByVal lpAppName As String, ByVal lpKeyName As String, ByVal lpString As String) As Integer
Declare Function duini_nWritePrivateProfileString Lib "Kernel" Alias "WritePrivateProfileString" (ByVal lpAppName As String, ByVal lpKeyName As String, ByVal lpString As String, ByVal lpFileName As String) As Integer

Declare Function duini_nGetProfileString Lib "Kernel" Alias "GetProfileString" (ByVal lpAppName As String, ByVal lpKeyName As String, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer) As Integer
Declare Function duini_nGetPrivateProfileString Lib "Kernel" Alias "GetPrivateProfileString" (ByVal lpAppName As String, ByVal lpKeyName As String, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer, ByVal lpFileName As String) As Integer
Declare Function duini_nGetProfileKeys Lib "Kernel" Alias "GetProfileString" (ByVal lpAppName As String, ByVal lpKeyName As Long, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer) As Integer
Declare Function duini_nGetPrivateProfileKeys Lib "Kernel" Alias "GetPrivateProfileString" (ByVal lpAppName As String, ByVal lpKeyName As Long, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer, ByVal lpFileName As String) As Integer

Declare Function duini_nDeleteProfileKey Lib "Kernel" Alias "WriteProfileString" (ByVal lpAppName As String, ByVal lpKeyName As String, ByVal lpString As Long) As Integer
Declare Function duini_nDeletePrivateProfileKey Lib "Kernel" Alias "WritePrivateProfileString" (ByVal lpAppName As String, ByVal lpKeyName As String, ByVal lpString As Long, ByVal lpFileName As String) As Integer
Declare Function duini_nDeleteProfileSection Lib "Kernel" Alias "WriteProfileString" (ByVal lpAppName As String, ByVal lpKeyName As Long, ByVal lpString As Long) As Integer
Declare Function duini_nDeletePrivateProfileSection Lib "Kernel" Alias "WritePrivateProfileString" (ByVal lpAppName As String, ByVal lpKeyName As Long, ByVal lpString As Long, ByVal lpFileName As String) As Integer

Declare Function duini_nBroadcastWININIChange Lib "User" Alias "PostMessage" (ByVal hWnd As Integer, ByVal wMsg As Integer, ByVal wParam As Integer, ByVal lParam As String) As Integer

Sub duini_DeleteKey (sSectionName As String, sKeyName As String, sProfileName As String)

'This routine removes a keyname, and its associated value.

Dim nRC As Integer


If Trim$(sProfileName) = "" Then
   nRC = duini_nDeleteProfileKey(sSectionName, sKeyName, 0)
Else
   nRC = duini_nDeletePrivateProfileKey(sSectionName, sKeyName, 0, sProfileName)
End If

End Sub

Sub duini_DeleteSection (sSectionName As String, sProfileName As String)

'This routine removes an entire section.  All keynames
'and their associated values are deleted.

Dim nRC As Integer


If Trim$(sProfileName) = "" Then
   nRC = duini_nDeleteProfileSection(sSectionName, 0, 0)
Else
   nRC = duini_nDeletePrivateProfileSection(sSectionName, 0, 0, sProfileName)
End If

End Sub

Sub duini_GetKeyNames (sSectionName As String, sKeyNames() As String, sProfileName As String)

'This routine enumerates all the keynames present in a
'given section.

Dim nStrPos As Integer, nKeyCount As Integer, nStart As Integer
Dim nKeyNamesLength As Integer
Dim sKeyNameString As String


sKeyNameString = Space$(1024)

If Trim$(sProfileName) = "" Then
   nKeyNamesLength = duini_nGetProfileKeys(sSectionName, 0, "", sKeyNameString, Len(sKeyNameString))
Else
   nKeyNamesLength = duini_nGetPrivateProfileKeys(sSectionName, 0, "", sKeyNameString, Len(sKeyNameString), sProfileName)
End If

nKeyCount = 0
ReDim sKeyNames(0)

If nKeyNamesLength > 0 Then
   sKeyNameString = Left$(sKeyNameString, nKeyNamesLength)

   If Right$(sKeyNameString, 1) <> Chr$(0) Then
      sKeyNameString = sKeyNameString + Chr$(0)
   End If

   nKeyNamesLength = Len(sKeyNameString)
   nStart = 1
   Do
      nStrPos = InStr(nStart, sKeyNameString, Chr$(0))

      If nStrPos > 0 Then
         nKeyCount = nKeyCount + 1
         ReDim Preserve sKeyNames(nKeyCount)
         sKeyNames(nKeyCount) = Mid$(sKeyNameString, nStart, nStrPos - nStart)

         If nStrPos < nKeyNamesLength Then
            nStart = nStrPos + 1
         Else
            Exit Do
         End If
      Else
         Exit Do
      End If
   Loop
End If

End Sub

Sub duini_GetSectionNames (sSectionNames() As String, sProfileName As String)

'This routine enumerates all the sections present in a
'given .INI file.

Dim nProfileNameHandle As Integer, nSectionCount As Integer
Dim nDirLength As Integer
Dim sProfileRecord As String, sWindowsDir As String
Dim sProfileSpec As String


On Error GoTo duini_GetSectionNames_Err

sWindowsDir = Space$(256)
nDirLength = duini_nGetWindowsDirectory(sWindowsDir, Len(sWindowsDir))
sWindowsDir = Left$(sWindowsDir, nDirLength)

nProfileNameHandle = FreeFile

If Trim$(sProfileName) = "" Then
   sProfileSpec = sWindowsDir + "\WIN.INI"
Else
   If InStr(sProfileName, ":") Or InStr(sProfileName, "\") Then
      sProfileSpec = sProfileName
   Else
      sProfileSpec = sWindowsDir + "\" + sProfileName
   End If
End If

Open sProfileSpec For Input As #nProfileNameHandle

nSectionCount = 0
ReDim sSectionNames(0)

While Not EOF(nProfileNameHandle)
   Line Input #nProfileNameHandle, sProfileRecord
   sProfileRecord = Trim$(sProfileRecord)

   If Len(sProfileRecord) >= 3 Then
      If Left$(sProfileRecord, 1) = "[" Then
         If Right$(sProfileRecord, 1) = "]" Then
            nSectionCount = nSectionCount + 1
            ReDim Preserve sSectionNames(nSectionCount)
            sSectionNames(nSectionCount) = Mid$(sProfileRecord, 2, Len(sProfileRecord) - 2)
         End If
      End If
   End If
Wend

'==========================
duini_GetSectionNames_Exit:
'==========================
Close #nProfileNameHandle

Exit Sub

'=========================
duini_GetSectionNames_Err:
'=========================
ReDim sSectionNames(0)
Resume duini_GetSectionNames_Exit

End Sub

Function duini_sGetString (sSectionName As String, sKeyName As String, sDefaultValue As String, sProfileName As String) As String

'This function returns the value associated with a given
'keyname, within a given section.  If either the keyname,
'the section, or the .INI file itself is not present,
'the "default" value is returned instead.

Dim nKeyValueLength As Integer
Dim sKeyValue As String


sKeyValue = Space$(256)

If Trim$(sProfileName) = "" Then
   nKeyValueLength = duini_nGetProfileString(sSectionName, sKeyName, sDefaultValue, sKeyValue, Len(sKeyValue))
Else
   nKeyValueLength = duini_nGetPrivateProfileString(sSectionName, sKeyName, sDefaultValue, sKeyValue, Len(sKeyValue), sProfileName)
End If

duini_sGetString = Left$(sKeyValue, nKeyValueLength)

End Function

Sub duini_WININIChange (sSectionName As String)

'This routine notifies all running tasks of a change
'to a WIN.INI setting.

Dim nRC As Integer


nRC = duini_nBroadcastWININIChange(HWND_BROADCAST, WM_WININICHANGE, 0, sSectionName)

End Sub

Sub duini_WriteString (sSectionName As String, sKeyName As String, sKeyValue As String, sProfileName As String)

'This routine updates the value associated with a given
'keyname, within a given section.  If either the keyname,
'the section, or the .INI file itself is not present,
'they are created.

Dim nRC As Integer


If Trim$(sProfileName) = "" Then
   nRC = duini_nWriteProfileString(sSectionName, sKeyName, sKeyValue)
Else
   nRC = duini_nWritePrivateProfileString(sSectionName, sKeyName, sKeyValue, sProfileName)
End If

End Sub

