VERSION 2.00
Begin Form frmPrinterDemo 
   Caption         =   "Printer Pick / Print Cancel Demo"
   ClientHeight    =   3735
   ClientLeft      =   2460
   ClientTop       =   2160
   ClientWidth     =   4755
   Height          =   4140
   Left            =   2400
   LinkTopic       =   "Form1"
   ScaleHeight     =   3735
   ScaleWidth      =   4755
   Top             =   1815
   Width           =   4875
   Begin TextBox Text1 
      Height          =   285
      Left            =   3120
      TabIndex        =   5
      Text            =   "20"
      Top             =   2880
      Width           =   435
   End
   Begin CommandButton cmdPrintTest 
      Caption         =   "Print"
      Height          =   375
      Left            =   1200
      TabIndex        =   6
      Top             =   3240
      Width           =   2355
   End
   Begin CommandButton cmdSetPrinter 
      Caption         =   "(second printer)"
      Height          =   435
      Index           =   1
      Left            =   120
      TabIndex        =   3
      Top             =   2160
      Width           =   4515
   End
   Begin CommandButton cmdSetPrinter 
      Caption         =   "(first printer)"
      Height          =   435
      Index           =   0
      Left            =   120
      TabIndex        =   2
      Top             =   1680
      Width           =   4515
   End
   Begin ListBox lstAvailable 
      Height          =   1200
      Left            =   120
      TabIndex        =   1
      Top             =   360
      Width           =   4515
   End
   Begin Label Label1 
      Caption         =   "Nbr of pages to print:"
      Height          =   195
      Left            =   1200
      TabIndex        =   4
      Top             =   2940
      Width           =   1875
   End
   Begin Label lblAvailable 
      Caption         =   "Available printers:"
      Height          =   255
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   4515
   End
End
Option Explicit

'If you have questions, comments, or suggestions for
'improving the code presented here, please forward them
'to me; your input is welcome:
'
'        Brad Kaenel
'        PC HELP-LINE
'        35250 Silver Leaf Circle
'        Yucaipa, CA  92399
'        United States
'        CIS: 72357,3523
'        Internet: 72357.3523@compuserve.com
'

'Nobody ever said that VB's Printer object was perfect.
'Unfortunately, two of its most obvious short-comings
'happen to be things that are pretty common -- sending
'output to multiple printers, and cancelling a print job
'that's in progress.

'The Printer object always points to whichever printer
'the end-user has designated as the "default" Windows
'printer.  There may be situations, however, when an
'application may want to send output to an installed
'printer that is not currently designated as the "default",
'or perhaps to multiple printers simultaneously (or more
'correctly, in sequence, serially).

'While it is not possible to change the behavior of the
'Printer object, it is possible to "point" the Printer
'object at will to any desired, installed printer.  This
'can be accomplished, indirectly, by modifying the
'appropriate WIN.INI settings on-the-fly.

'In addition, with a little Windows API help, it's
'possible to popup a "print status" window, complete
'with a familiar "Cancel" button that flushes the job
'from the print queue.

'This sample demonstrates a collection of printer
'routines that enable you to obtain a list of the
'currently installed printers, modify WIN.INI
'so that any available printer can be "hooked-up"
'to the VB Printer object at runtime, and easily
'provide a status window and "Cancel" button for
'your print jobs.

'Note that this demo always saves the value of the
'default printer before setting it to something else,
'and then restores the original setting when it is
'through.  "Good neighbor" applications should remember
'to "leave things as they found them" when manipulating
'user-defined settings under the covers.

Dim recInstalledPrinters() As typWindowsDevice
Dim nSelectedPrinter(1) As Integer

Const nFIRST_PRINTER = 0
Const nSECOND_PRINTER = 1
Const sFIRST_PRINTER = "First"
Const sSECOND_PRINTER = "Second"
Const sPRINTER_NONE = "(none)"

Sub cmdPrintTest_Click ()

Dim recSaveOrigPrinter As typWindowsDevice


Call duprt_GetDefaultPrinter(recSaveOrigPrinter)

If nSelectedPrinter(nFIRST_PRINTER) > 0 Then
   Call PrintTest(nFIRST_PRINTER)
End If
If nSelectedPrinter(nSECOND_PRINTER) > 0 Then
   Call PrintTest(nSECOND_PRINTER)
End If

Call duprt_SetDefaultPrinter(recSaveOrigPrinter)

End Sub

Sub cmdSetPrinter_Click (Index As Integer)

Dim sPrinterName As String, sPrinterSeq As String
Dim sNewCaption As String


If lstAvailable.ListIndex < 0 Then
   Exit Sub
End If

If Index = nFIRST_PRINTER Then
   sPrinterSeq = sFIRST_PRINTER
Else
   sPrinterSeq = sSECOND_PRINTER
End If

If lstAvailable.ListIndex = 0 Then
   nSelectedPrinter(Index) = 0
   sPrinterName = sPRINTER_NONE
   sNewCaption = "Set " + sPrinterSeq + " Printer " + sPrinterName
Else
   nSelectedPrinter(Index) = lstAvailable.ListIndex
   sPrinterName = recInstalledPrinters(lstAvailable.ListIndex).sWindowsDeviceUserName
   sNewCaption = sPrinterSeq + " Printer (" + sPrinterName + ")"
End If

cmdSetPrinter(Index).Caption = sNewCaption

End Sub

Sub Form_Load ()
    
Dim nPrinterCount As Integer
ReDim recInstalledPrinters(0) As typWindowsDevice


Call duprt_GetInstalledPrinters(recInstalledPrinters())

For nPrinterCount = 1 To UBound(recInstalledPrinters)
   lstAvailable.AddItem recInstalledPrinters(nPrinterCount).sWindowsDeviceUserName + " on " + recInstalledPrinters(nPrinterCount).sWindowsDevicePortName
Next

lstAvailable.AddItem sPRINTER_NONE, 0
lstAvailable.ListIndex = 0

cmdSetPrinter(nFIRST_PRINTER).Caption = "Set " + sFIRST_PRINTER + " Printer " + sPRINTER_NONE
cmdSetPrinter(nSECOND_PRINTER).Caption = "Set " + sSECOND_PRINTER + " Printer " + sPRINTER_NONE

End Sub

Sub PrintTest (nPrinterSeq As Integer)

Dim nPage As Integer, nLine As Integer
Dim nNbrPages As Integer
Dim recTestPrinter As typWindowsDevice


recTestPrinter.sWindowsDeviceUserName = recInstalledPrinters(nSelectedPrinter(nPrinterSeq)).sWindowsDeviceUserName
recTestPrinter.sWindowsDeviceShortName = recInstalledPrinters(nSelectedPrinter(nPrinterSeq)).sWindowsDeviceShortName
recTestPrinter.sWindowsDevicePortName = recInstalledPrinters(nSelectedPrinter(nPrinterSeq)).sWindowsDevicePortName

Call duprt_SetDefaultPrinter(recTestPrinter)

Printer.FontName = "arial"
Printer.FontSize = 24
Printer.FontBold = False

nNbrPages = Val(Trim$(Text1.Text))

Call duprt_BeginDoc
Call duprt_StatusDoc("Print Demo", "Now printing GOODBYE.DOC" & Chr$(10) & "on " & recInstalledPrinters(nSelectedPrinter(nPrinterSeq)).sWindowsDeviceUserName, "")

For nPage = 1 To nNbrPages
   For nLine = 1 To 50
      If duprt_tfPrintCancelled() Then
         GoTo PrintTestDone
      Else
         Printer.Print "Goodbye Broadway" & "   " & "Goodbye Broadway"
         Call duprt_StatusDoc("", "", "Page" & Str$(nPage) & " Line" & Str$(nLine))
      End If
   Next

   Printer.NewPage
Next

PrintTestDone:

Call duprt_EndDoc

End Sub

