Option Explicit
'   This information was obtained from the MSDN CD.
'
'   Declare API calls needed to read/write to INI files
'
Declare Function KRN_GetProfileInt Lib "Kernel" Alias "GetProfileInt" (ByVal msHeader As String, ByVal msKeyWord As String, ByVal mnDefault As Integer) As Integer
Declare Function KRN_GetProfileString Lib "Kernel" Alias "GetProfileString" (ByVal msHeader As String, ByVal msKeyWord As String, ByVal msDefault As String, ByVal msReturnString As String, ByVal msReturnSize As Integer) As Integer
Declare Function KRN_WriteProfileString Lib "Kernel" Alias "WriteProfileString" (ByVal msHeader As String, ByVal msKeyWord As String, ByVal msEntry As String) As Integer
Declare Function KRN_GetPrivateProfileInt Lib "Kernel" Alias "GetPrivateProfileInt" (ByVal msHeader As String, ByVal msKeyWord As String, ByVal mnDefault As Integer, ByVal msININame As String) As Integer
Declare Function KRN_GetPrivateProfileString Lib "Kernel" Alias "GetPrivateProfileString" (ByVal msHeader As String, ByVal msKeyWord As String, ByVal msDefault As String, ByVal msReturnString As String, ByVal msReturnSize As Integer, ByVal msININame As String) As Integer
Declare Function KRN_WritePrivateProfileString Lib "Kernel" Alias "WritePrivateProfileString" (ByVal msHeader As String, ByVal msKeyWord As String, ByVal msEntry As String, ByVal msININame As String) As Integer
'
'   Parameters are as follows:
'
'   Argument           Description
'   --------           -----------
'   msHeader            Name of a Windows application that appears in the
'                       initialization file.
'   msKeyWord           Key name that appears in the initialization file.
'   mnDefault           Specifies the default value for the given key if the
'                       key cannot be found in the initialization file.
'   msININame           Points to a string that names the initialization
'                       file. If lpFileName does not contain a path to the
'                       file, Windows searches for the file in the Windows
'                       directory.
'   msDefault           Specifies the default value for the given key if the
'                       key cannot be found in the initialization file.
'   msReturnString      Specifies the buffer that receives the character
'                       string.
'   msReturnSize        Specifies the maximum number of characters (including
'                       the last null character) to be copied to the buffer.
'   msEntry           Specifies the string that contains the new key value.

Function ProfileInt (sININame As String, sSection As String, sKeyword As String, nDefault As Integer) As Integer
'
'   This routine will get a string from an INI file. The user must pass the
'   following information:
'
'   Input Values
'       sININame   - The name of the INI file (with path if desired)
'       sSection   - The section head to search for
'       sKeyword   - The keyword within the section to return
'       nDefault   - The default value to return if nothing is found
'
'   Output Value
'       An integer with the value found or nDefault. NOTE: IF A RETURN VALUE
'       OF ZERO IS OBTAINED, AND nDefault IS NOT ZERO, THEN THE SPECIFIED ITEM
'       IS NOT AN INTEGER
'
    On Error GoTo ProfileInt_ER

    If IsEmpty(sININame) Or IsEmpty(sSection) Or IsEmpty(sKeyword) Then
        ProfileInt = nDefault
        Exit Function
    End If
                     
    If Right$(UCase$(sININame), 7) = "WIN.INI" Then
        ProfileInt = KRN_GetProfileInt(sSection, sKeyword, nDefault)
    Else
        ProfileInt = KRN_GetPrivateProfileInt(sSection, sKeyword, nDefault, sININame)
    End If
    Exit Function

ProfileInt_ER:
    ProfileInt = nDefault
    Exit Function
End Function

Function ProfileString (sININame As String, sSection As String, sKeyword As String, vsDefault As String) As String
'
'   This routine will get a string from an INI file. The user must pass the
'   following information:
'
'   Input Values
'       sININame   - The name of the INI file (with path if desired)
'       sSection   - The section head to search for
'       sKeyword   - The keyword within the section to return
'       vsDefault   - The default value to return if nothing is found
'
'   Output Value
'       A string with the value found (max length = 512)
'
    Dim sReturnValue As String
    Dim nReturnSize As Integer
    Dim nValidSize As Integer

    On Error GoTo ProfileString_ER

    If IsEmpty(sININame) Or IsEmpty(sSection) Or IsEmpty(sKeyword) Then
        ProfileString = vsDefault
        Exit Function
    End If

    sReturnValue = Space$(512)
    nReturnSize = Len(sReturnValue)

    If Right$(UCase$(sININame), 7) = "WIN.INI" Then
        nValidSize = KRN_GetProfileString(sSection, sKeyword, vsDefault, sReturnValue, nReturnSize)
    Else
        nValidSize = KRN_GetPrivateProfileString(sSection, sKeyword, vsDefault, sReturnValue, nReturnSize, sININame)
    End If

    ProfileString = Left$(sReturnValue, nValidSize)
    Exit Function

ProfileString_ER:
    ProfileString = vsDefault
    Exit Function
End Function

Function SetProfileString (sININame As String, sSection As String, sKeyword As String, vsEntry As String) As Integer
'
'   This routine will write a string to an INI file. The user must pass the
'   following information:
'
'   Input Values
'       sININame   - The name of the INI file (with path if desired)
'       sSection   - The section head to search for
'       sKeyword   - The keyword within the section to return
'       vsEntry     - The value to write for the keyword
'
'   Output Value
'       non-zero if successful, zero if failure.
'
    On Error GoTo SetProfileString_ER

    If IsEmpty(sININame) Or IsEmpty(sSection) Or IsEmpty(sKeyword) Then
        SetProfileString = 0
        Exit Function
    End If

    If Right$(UCase$(sININame), 7) = "WIN.INI" Then
        SetProfileString = KRN_WriteProfileString(sSection, sKeyword, vsEntry)
    Else
        SetProfileString = KRN_WritePrivateProfileString(sSection, sKeyword, vsEntry, sININame)
    End If
    Exit Function

SetProfileString_ER:
    SetProfileString = 0
    Exit Function
End Function

