VERSION 2.00
Begin Form Form1 
   BackColor       =   &H00E0E0E0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Printer Status Demo"
   ClientHeight    =   2565
   ClientLeft      =   3645
   ClientTop       =   2295
   ClientWidth     =   4035
   Height          =   3255
   Icon            =   FORM1.FRX:0000
   Left            =   3585
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   2565
   ScaleWidth      =   4035
   Top             =   1665
   Width           =   4155
   Begin CommandButton Command1 
      Caption         =   " &Exit"
      Height          =   315
      Left            =   3180
      TabIndex        =   14
      Top             =   2160
      Width           =   675
   End
   Begin TextBox Text 
      Height          =   315
      Index           =   6
      Left            =   180
      TabIndex        =   13
      Top             =   2160
      Width           =   495
   End
   Begin TextBox Text 
      Height          =   285
      Index           =   5
      Left            =   2760
      TabIndex        =   5
      Top             =   1680
      Width           =   495
   End
   Begin TextBox Text 
      Height          =   285
      Index           =   4
      Left            =   780
      TabIndex        =   4
      Top             =   1680
      Width           =   495
   End
   Begin TextBox Text 
      Height          =   285
      Index           =   2
      Left            =   780
      TabIndex        =   3
      Top             =   1020
      Width           =   495
   End
   Begin TextBox Text 
      Height          =   285
      Index           =   3
      Left            =   2760
      TabIndex        =   2
      Top             =   1020
      Width           =   495
   End
   Begin TextBox Text 
      Height          =   285
      Index           =   1
      Left            =   2760
      TabIndex        =   1
      Top             =   360
      Width           =   495
   End
   Begin Timer Timer1 
      Interval        =   1000
      Left            =   4200
      Top             =   1680
   End
   Begin TextBox Text 
      Height          =   285
      Index           =   0
      Left            =   780
      TabIndex        =   0
      Top             =   360
      Width           =   495
   End
   Begin Label Label 
      Alignment       =   2  'Center
      BackColor       =   &H00E0E0E0&
      Height          =   255
      Index           =   6
      Left            =   780
      TabIndex        =   12
      Top             =   2190
      Width           =   2295
   End
   Begin Line Line2 
      BorderColor     =   &H80000002&
      X1              =   0
      X2              =   4020
      Y1              =   2040
      Y2              =   2040
   End
   Begin Line Line1 
      BorderColor     =   &H80000002&
      X1              =   1980
      X2              =   1980
      Y1              =   0
      Y2              =   2040
   End
   Begin Label Label 
      Alignment       =   2  'Center
      BackColor       =   &H00E0E0E0&
      Height          =   255
      Index           =   5
      Left            =   2070
      TabIndex        =   11
      Top             =   1380
      Width           =   1905
   End
   Begin Label Label 
      Alignment       =   2  'Center
      BackColor       =   &H00E0E0E0&
      Height          =   255
      Index           =   4
      Left            =   60
      TabIndex        =   10
      Top             =   1380
      Width           =   1845
   End
   Begin Label Label 
      Alignment       =   2  'Center
      BackColor       =   &H00E0E0E0&
      Height          =   255
      Index           =   3
      Left            =   2070
      TabIndex        =   9
      Top             =   720
      Width           =   1905
   End
   Begin Label Label 
      Alignment       =   2  'Center
      BackColor       =   &H00E0E0E0&
      Height          =   255
      Index           =   2
      Left            =   60
      TabIndex        =   8
      Top             =   720
      Width           =   1845
   End
   Begin Label Label 
      Alignment       =   2  'Center
      BackColor       =   &H00E0E0E0&
      Height          =   255
      Index           =   1
      Left            =   2070
      TabIndex        =   7
      Top             =   60
      Width           =   1905
   End
   Begin Label Label 
      Alignment       =   2  'Center
      BackColor       =   &H00E0E0E0&
      Height          =   255
      Index           =   0
      Left            =   60
      TabIndex        =   6
      Top             =   60
      Width           =   1845
   End
   Begin Menu MnuHelp 
      Caption         =   "&Help"
      Begin Menu MnuReadMe 
         Caption         =   "&Read Me First"
         Index           =   0
      End
      Begin Menu MnuReadMe 
         Caption         =   "ReadMe.&Txt"
         Index           =   1
      End
      Begin Menu MnuReadMe 
         Caption         =   "-"
         Index           =   2
      End
      Begin Menu MnuReadMe 
         Caption         =   "&About Printer Status Demo..."
         Index           =   3
      End
   End
End
'
'****************************************************************************

' All code and files Copyright (c) 1994, 1995 Gregory H. Bragg
' Phone:      (416) 399-0995
' Fax:        (416) 497-3397
' Compuserve: 75027,2674
' Internet:   75027.2674@compuserve.com
' Written:    September 23, 1995
' Revised:    October 18, 1995

'****************************************************************************
'
Option Explicit

' PRNTSTAT.DLL functions for querying the printer status
Declare Function GetTimeoutStatus Lib "PRNTSTAT.DLL" (ByVal PortNo As Integer) As Integer
Declare Function GetPaperStatus Lib "PRNTSTAT.DLL" (ByVal PortNo As Integer) As Integer
Declare Function GetOnlineStatus Lib "PRNTSTAT.DLL" (ByVal PortNo As Integer) As Integer
Declare Function GetErrorStatus Lib "PRNTSTAT.DLL" (ByVal PortNo As Integer) As Integer
Declare Function GetBusyStatus Lib "PRNTSTAT.DLL" (ByVal PortNo As Integer) As Integer
Declare Function GetAcknowledgeStatus Lib "PRNTSTAT.DLL" (ByVal PortNo As Integer) As Integer
Declare Function GetReadyStatus Lib "PRNTSTAT.DLL" (ByVal PortNo As Integer) As Integer

' this variable stores the return values of the various PRNTSTAT.DLL functions
' called and will be used to update the fields and labels in Form1...
Dim retval(6) As Integer

Sub Command1_Click ()
    Unload Form1
End Sub

Sub Form_Load ()
' open the app window in the top left corner of the screen...
    Me.Left = (Screen.Width / 2) - Me.Width - 500
    Me.Top = (Screen.Height / 2) - Me.Height
End Sub

Sub Form_Unload (Cancel As Integer)
    End
End Sub

'
' *********************************************************************************
'
'   This code snippet demonstrates how easy it is to check for the presence of
'   paper in the paper tray of your printer by using PRNTSTAT.DLL. This code
'   only access two functions in the dll to find out the status of the printer
'   connected to "NumOfPort".
'
' *********************************************************************************
'
Sub GetPaperTrayStatus (NumOfPort As Integer)

    Dim ACK_retval As Integer, PAP_retval As Integer

    ' first get the acknowledge status of the printer to see if
    ' it is on and online...
    ACK_retval = GetAcknowledgeStatus(NumOfPort)

    If ACK_retval = 1 Then

    ' printer acknowledges so now we can check for paper in the tray
        PAP_retval = GetPaperStatus(NumOfPort)

        If PAP_retval = 0 Then
        ' printer is out of paper, so inform the user...
            Dim NL As String
            NL = Chr$(13) & Chr$(10)
            MsgBox "Check paper tray..." & NL & " Paper tray is empty", 4144, "Attention!"
        End If

    End If

End Sub

Sub MnuReadMe_Click (Index As Integer)

    Dim FilePath As String
    Dim hInstance As Integer

    Select Case Index
        Case 0
            FilePath = "NOTEPAD " + app.Path + "\DEMO.TXT"
            hInstance = Shell(FilePath, 1)
        Case 1
            FilePath = "NOTEPAD " + app.Path + "\README.TXT"
            hInstance = Shell(FilePath, 1)
        Case 3
            Dim msg As String, NL As String
            NL = Chr$(13) & Chr$(10)
            msg = "Copyright (c) 1994, 1995 Gregory H. Bragg" & NL
            msg = msg & "(416) 399-0995,  " & "CompuServe: 75027, 2674" & NL & NL
            msg = msg & "Written using Visual Basic 3.0 and Borland C++ 4.5"
            MsgBox msg, 64, "About Printer Status Demo..."
    End Select

End Sub

'
'****************************************************************************
'
' The following code does all the work of finding the status of a printer.
' If you are familiar with Windows message loops in C then this will be self
' explanatory... the Timer control will work the same way but you'll have
' more control over when the event is fired and it'll yield control back to
' Windows better. I decided on this route rather than use a Do Loop or
' something similiar as I would have to include the DoEvents function in the
' loop to relinquish control. I found this solution to be better in my apps.
' See the ReadMe.Txt and Demo.Txt for more information.
'
' For more help, comments or suggestions contact me at:
'
' Compuserve: 75027,2674
' Internet:   75027.2674@compuserve.com
'
' Gregory H. Bragg
' September 24, 1995
'
'****************************************************************************
'
Sub Timer1_Timer ()

' Before we start to check the printer status we must check to see if the
' user has selected a different default printer while the Printer Status
' Demo has been running...
' So let's read WIN.INI to get the name, port type and port number of the
' default printer.
' Note: This method also works for Windows 95 as it still uses WIN.INI
'       to register all the information of the default printer.

    Dim tmp As String, CommType As String, PortNum As String
    Dim PrntrNo As Integer, i As Integer

    tmp = GetIniProfileString("windows", "device", "LPT1:")
    CommType = Right$(tmp, 5)
    PortNum = Mid$(CommType, 4, 1)
    PrntrNo = Val(PortNum)

    ' now we can do our checks on the printer status without error...

    If Left$(CommType, 3) = "LPT" Then 'CommType = LPTx:  parallel port

    ' NOTE: If the CommType is a COMx: we won't be able to check for
    '       status since two way communication to the printer is NOT
    '       supported through a serial comm port.
    '
    ' */ start checking the printer status /*
    ' Let's call all PRNTSTAT.DLL functions and get the return
    ' values from each...

        retval(0) = GetTimeoutStatus(PrntrNo)
        retval(1) = GetErrorStatus(PrntrNo)
        retval(2) = GetOnlineStatus(PrntrNo)
        retval(3) = GetPaperStatus(PrntrNo)
        retval(4) = GetAcknowledgeStatus(PrntrNo)
        retval(5) = GetBusyStatus(PrntrNo)
        retval(6) = GetReadyStatus(PrntrNo)

    ' now we're going to display the results in the
    ' Printer Status Demo text and label fields

        For i = 0 To 6
            Text(i).Text = Str$(retval(i))
            Select Case retval(i)
                Case 0
                    Select Case i
                        Case 0
                            Label(i).Caption = "No Time Out"
                        Case 1
                            Label(i).Caption = "No Errors"
                        Case 2
                            Label(i).Caption = "Printer Off Line"
                        Case 3
                            Label(i).Caption = "No Paper"
                        Case 4
                            Label(i).Caption = "No Acknowledge"
                        Case 5
                            Label(i).Caption = "Busy"
                        Case 6
                            Label(i).Caption = "Not Ready to Print"
                    End Select
                Case 1
                    Select Case i
                        Case 0
                            Label(i).Caption = "Time Out"
                        Case 1
                            Label(i).Caption = "Error"
                        Case 2
                            Label(i).Caption = "Printer On Line"
                        Case 3
                            Label(i).Caption = "Printer Has Paper"
                        Case 4
                            Label(i).Caption = "Acknowledge"
                        Case 5
                            Label(i).Caption = "Not Busy"
                        Case 6
                            Label(i).Caption = "Ready to Print"
                    End Select
                Case 9
                ' this is the default value returned if all else fails
                    Label(i).Caption = "Printer not available"
            End Select
        Next i
    ' */ end checks for printer status */

    ' Now for an example of how all this works we'll check the
    ' printer's paper tray to see if it has any paper... Try pulling
    ' out the paper tray from the printer while it is on to see this
    ' demo in action!

        GetPaperTrayStatus (PrntrNo)

    Else 'CommType = COMx:  serial port

    ' clear all fields and labels displayed on Form1...
        For i = 0 To 6
            Text(i).Text = ""
            Label(i).Caption = ""
        Next i
    ' inform the user of the problem...
        Dim msg As String, NL As String
        NL = Chr$(13) & Chr$(10)
        msg = "This Printer is connected to a serial port..." & NL
        msg = msg & "The Printer Status Demo can only read a parallel port"
        MsgBox msg, 48, "Printer Status Error"

    End If

End Sub

