'Print File
' Prints the specified file. Use in place of SpoolFile
' Scott Johnston 7-29-94 CIS:72677,1570 MHS:ScottJ@Alta
DefInt A-Z

Type DOCINFO
    cbSize As Integer
    lpszDocName As Long
    lpszOutput As Long
End Type


Declare Function CreateDC Lib "GDI" (ByVal lpDriverName As String, ByVal lpDeviceName As String, ByVal lpOutput As String, ByVal lpInitData As String) As Integer
Declare Function DeleteDC Lib "GDI" (ByVal hdc As Integer) As Integer
Declare Function Escape Lib "GDI" (ByVal hdc As Integer, ByVal nEscape As Integer, ByVal nCount As Integer, ByVal lplnData As Any, ByVal lpOutData As Any) As Integer
Declare Function StartDoc Lib "GDI" (ByVal hdc As Integer, lpdi As DOCINFO) As Integer
Declare Function EndDocAPI Lib "GDI" Alias "EndDoc" (ByVal hdc As Integer) As Integer
Declare Function GetProfileString Lib "Kernel" (ByVal lpAppName As String, ByVal lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer) As Integer
Declare Function lstrcpy Lib "Kernel" (ByVal lpString1 As Any, ByVal lpString2 As Any) As Long


Global Const QUERYESCSUPPORT = 8
Global Const PASSTHROUGH = 19

Sub GetDefPrinter (printDriver$, printDevice$, printOut$)
    ErrMsg$ = "Unable to determine default printer."
    printerINI$ = Space$(256)
    r% = GetProfileString("Windows", "device", "None", printerINI$, Len(printerINI$))
    printerINI$ = Left$(printerINI$, InStr(printerINI$, Chr$(0)) - 1)
    If printerINI$ <> "None" Then
	CPos = InStr(printerINI$, ",")
	If CPos > 0 Then
	    printDevice$ = Left$(printerINI$, CPos - 1) + Chr$(0)
	    printerINI$ = Mid$(printerINI$, CPos + 1)
	    CPos = InStr(printerINI$, ",")
	    If CPos > 0 Then
		printDriver$ = Left$(printerINI$, CPos - 1) + Chr$(0)
		printOut$ = Mid$(printerINI$, CPos + 1) + Chr$(0)
	    Else
		MsgBox ErrMsg$
		printerDriver$ = ""
	    End If
	Else
	    MsgBox ErrMsg$
	    printerDriver$ = ""
	End If
    Else
	MsgBox ErrMsg$
	printerDriver$ = ""
    End If

End Sub

Function PrintFile (FileName$) As Integer
    'prints the specified file to the default printer
    'returns 1 if successful, 0 if not

    ret% = 1
    GetDefPrinter printDriver$, printDevice$, printOut$
    If Len(printDriver$) > 0 Then
	hpDC = CreateDC(printDriver$, printDevice$, printOut$, "")
	If hpDC <> 0 Then
	    strPASS$ = Chr$(PASSTHROUGH And &HFF) + Chr$(PASSTHROUGH \ 256)
	    rQuery% = Escape(hpDC, QUERYESCSUPPORT, 2, strPASS$, "")
	    If rQuery% <> 0 Then
		ret% = SendFile(hpDC, FileName$)
	    Else
		MsgBox printDevice$ + " does not support the PASSTHROUGH escape."
		ret% = 0
	    End If
	    rDelDC% = DeleteDC(hpDC)
	    If rDelDC% = 0 Then
		MsgBox "Error deleting DC."
		ret% = 0
	    End If
	Else
	    MsgBox "Unable to create DC."
	    ret% = 0
	End If
    End If
    PrintFile = ret%
End Function

Function SendFile (hpDC, FileName$)
    'actually passthrough the file to the printerDC
    'returns 1 if successful, 0 if not
    ret% = 1
    Dim dInfo As DOCINFO
    FileNum = FreeFile
    Open FileName$ For Binary Access Read Shared As FileNum
    If Len(FileNum) > 0 Then
	bSize% = 4096
	CurrPos# = 1
	DocName$ = FileName$ + Chr$(0)
	If Len(DocName$) > 32 Then
	    DocName$ = Left$(DocName$, 31) + Chr$(0)
	End If
	dInfo.lpszDocName = lstrcpy(DocName$, DocName$)
	dInfo.lpszOutput = 0
	dInfo.cbSize = Len(DocName$)
	rStart% = StartDoc(hpDC, dInfo)
	If rStart% > 0 Then
	    Do
		If CurrPos# + bSize% > LOF(FileNum) Then
		    bSize% = LOF(FileNum) - CurrPos# + 1
		End If
		Buffer$ = Space$(bSize%)
		Get #FileNum, CurrPos#, Buffer$
		DataLen$ = Chr$(bSize% And &HFF) + Chr$(bSize% \ 256)
		printData$ = DataLen$ + Buffer$
		rPrint% = Escape(hpDC, PASSTHROUGH, 0, printData$, "")
		If rPrint% <= 0 Then
		    MsgBox "Error in PASSTHROUGH Escape."
		    ret% = 0
		    Exit Do
		End If
		CurrPos# = CurrPos# + bSize%
	    Loop Until CurrPos# > LOF(FileNum)
	    If rPrint% > 0 Then
		rEnd% = EndDocAPI(hpDC)
		If rEnd% < 0 Then
		    MsgBox "Error in EndDoc."
		    ret% = 0
		End If
	    End If
	Else
	    MsgBox "Error in StartDoc."
	    ret% = 0
	End If
    Else
	MsgBox "File not found"
	ret = 0
    End If
    SendFile = ret%
End Function

