VERSION 2.00
Begin Form PMMainForm 
   BackColor       =   &H8000000F&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Form1"
   ClientHeight    =   3195
   ClientLeft      =   2430
   ClientTop       =   3060
   ClientWidth     =   5910
   Height          =   3600
   Icon            =   PMMAIN.FRX:0000
   Left            =   2370
   LinkMode        =   1  'Source
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   3195
   ScaleWidth      =   5910
   Top             =   2715
   Width           =   6030
   Begin CommandButton PrintButton 
      Caption         =   "Save To Word"
      Enabled         =   0   'False
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   375
      Left            =   2160
      TabIndex        =   4
      Top             =   2760
      Width           =   1575
   End
   Begin CommandButton PMInfoButton 
      Caption         =   "Get Progman Info"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   375
      Left            =   120
      TabIndex        =   1
      Top             =   2760
      Width           =   1575
   End
   Begin CommandButton QuitButton 
      Caption         =   "Quit"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   375
      Left            =   4200
      TabIndex        =   3
      Top             =   2760
      Width           =   1575
   End
   Begin TextBox DDEText 
      Height          =   285
      Left            =   120
      TabIndex        =   0
      Top             =   3000
      Visible         =   0   'False
      Width           =   1455
   End
   Begin Ctl3D Ctl3D1 
      CenterDialogs   =   -1  'True
      ClassList       =   PMMAIN.FRX:0302
      IgnoreColors    =   -1  'True
      Left            =   0
      Top             =   2280
   End
   Begin Outline PMOutline 
      Height          =   2535
      Left            =   120
      PictureClosed   =   PMMAIN.FRX:0310
      PictureLeaf     =   PMMAIN.FRX:046A
      PictureMinus    =   PMMAIN.FRX:05C4
      PictureOpen     =   PMMAIN.FRX:071E
      PicturePlus     =   PMMAIN.FRX:0878
      TabIndex        =   2
      Top             =   120
      Width           =   5655
   End
End

Sub Form_Load ()

CenterForm PMMainForm
PMMainForm.Caption = ProgTitle

End Sub

Sub PMInfoButton_Click ()

Dim Looper As Integer

On Error GoTo PMInfoError

Screen.MousePointer = 11

'turn off the print button (in case this isn't the first time we're running this
PrintButton.Enabled = False

'set up our DDE topics with progman so we can get the info we want
DDEText.LinkTopic = "ProgMan|ProgMan"
DDEText.LinkItem = "PROGMAN"
DDEText.LinkMode = COLD_LINK

'get the text from program manager of all the groups
DDEText.LinkRequest

'parse out the group names into an array
If Not FillGroupList() Then
  'if couldn't get group name list then quit
  MsgBox "Unable to get list of groups.", 16, ProgTitle
  Screen.MousePointer = 0
  Exit Sub
End If

'clear out the text so we can get the individual information for each group
DDEText.Text = ""

'dimension the group information array
ReDim GroupInfoList(0)

'go through each group and read in all the information
For Looper = 1 To UBound(GroupList)
  'set the linkitem equal to the name of the group for which we want information
  DDEText.LinkItem = GroupList(Looper).Name
  'turn the conversation on to suck in the information
  DDEText.LinkMode = COLD_LINK
  'request the info
  DDEText.LinkRequest

  'plug the group information into our array
  If Not FillGroupInfoList(Looper) Then
    MsgBox "Unable to get individual group information.", 16, ProgTitle
    Screen.MousePointer = 0
    Exit Sub
  End If

Next Looper

'compile the information into our master list
If Not FillMasterList() Then
  MsgBox "Unable to compile ProgMan information.", 16, ProgTitle
  Screen.MousePointer = 0
  Exit Sub
End If

'clear the outline control
PMOutline.Clear

'fill the outline with the ProgMan data
FillPMOutline

'enable the print button
PrintButton.Enabled = True

PMInfoResume:
Screen.MousePointer = 0
Exit Sub

PMInfoError:
MsgBox "Error #" + Trim$(Str$(Err)) + " - " + Error + " - has occurred."
Resume PMInfoResume

End Sub

Sub PrintButton_Click ()

Dim Looper As Integer
Dim CurLevel As Integer
Dim LastLevel As Integer
Dim Msg As String

On Error GoTo PrintError

Msg = "This will take a few moments; the screen won't be updated until "
Msg = Msg + "all the information has been put into Word.  Do you want "
Msg = Msg + "to continue?"

'let the user know that they're going to have to wait
If MsgBox(Msg, YES_NO_QUESTION, ProgTitle) = NO Then Exit Sub

'open up Word
Set OhMyWord = CreateObject("word.basic")

'maximize the window if necessary
If Not OhMyWord.AppMaximize() Then OhMyWord.AppMaximize

'open a new document
OhMyWord.FileNew

'set the header information
OhMyWord.ViewHeader        'move to the header
OhMyWord.Bold              'turn on bold
OhMyWord.Insert ProgTitle  'insert my program name
OhMyWord.Insert Chr$(9)    'tab over once
OhMyWord.Insert Chr$(9)    'tab over again
OhMyWord.Insert Format$(Date, "mmmm d, yyyy")  'insert the date
OhMyWord.Bold              'turns bold back off
OhMyWord.ViewHeader        'move back to the document

'switch to outline view
OhMyWord.ViewOutline

'initialize level variable
LastLevel = 1

For Looper = 1 To UBound(MasterList)
  'add the text to the document
  OhMyWord.Insert MasterList(Looper).Name
  
  'figure out indentation
  CurLevel = MasterList(Looper).Level

  If CurLevel = LastLevel Then          'we're at the same level; don't need to do anything
  ElseIf CurLevel > LastLevel Then      'we've gone down a level
    OhMyWord.OutlineDemote              'move the outline down a level
  ElseIf LastLevel - CurLevel = 1 Then  'we've gone up one level
    OhMyWord.OutlinePromote
  Else                                  'we've gone up two levels
    OhMyWord.OutlinePromote
    OhMyWord.OutlinePromote
  End If
  
  'go to the next line
  OhMyWord.InsertPara

  'set the level indicator
  LastLevel = CurLevel

Next Looper

'save the document
OhMyWord.FileSaveAs DOC_NAME

'move to the start of the document
OhMyWord.StartOfDocument

PMMainForm.WindowState = WINDOW_MINIMIZED

PrintResume:
Exit Sub

PrintError:
MsgBox "Error #" + Trim$(Str$(Err)) + " - " + Error + " - has occurred."
Resume PrintResume

End Sub

Sub QuitButton_Click ()

End

End Sub

