Option Explicit
'
' Routines to Set and Get Application Level parameters and
' to pass variables from Form-to-Form
'
  '
  ' Constants for Number of Parameters
  '
  ' Set these constants to the actual number of parameters
  ' you will be using in the program or a large enough handle
  ' any expected contengency.  This is the only part
  ' of this set of routines that needs to be modified from
  ' program to program.  If you wish, these could be moved
  ' to Global Constants.
  '
    Const P_MAX_FORM = 4
    Const P_MAX_APP = 1
  '
  ' Module Level Variables
  '
    '
    ' These items can be module level or they could be move to
    ' Static arrays in a Private function to further limit
    ' their scope, if desired.
    '
      '
      ' Form Level Parameters
      '
        Dim msFormParams(P_MAX_FORM) As String

      '
      ' Application Level Parameters
      '
        Dim msAppParams(P_MAX_APP) As String

Sub ClearFormParam ()
  '
  ' Clear Form Level Parameters
  '
  Erase msFormParams
End Sub

Function GetAppParam (iElement As Integer) As String
  '
  ' Return specified Application Parameter
  '
  If iElement > P_MAX_APP Then
    Debug.Print "Invalid iElement sent to GetAppParam"
    GetAppParam = ""
  Else
    GetAppParam = msAppParams(iElement)
  End If
End Function

Function GetFormParam (iElement As Integer) As String
  '
  ' Return specified Form Level Parameter
  '
  If iElement > P_MAX_FORM Then
    Debug.Print "Invalid iElement sent to GetFormParam"
    GetFormParam = ""
  Else
    GetFormParam = msFormParams(iElement)
  End If
End Function

Sub SetAppParam (sParam As String, iElement As Integer)
  '
  ' Set specified Application Parameter
  '
  If iElement > P_MAX_APP Then
    Debug.Print "Invalid iElement sent to SetFormParam"
  Else
    msAppParams(iElement) = sParam
  End If
End Sub

Sub SetFormParam (sParam As String, iElement As Integer)
  '
  ' Set specified Form level Parameter
  '
  If iElement > P_MAX_FORM Then
    Debug.Print "Invalid iElement sent to SetFormParam"
  Else
    msFormParams(iElement) = sParam
  End If
End Sub

