Option Explicit
'global variables
Global nl$, tx%, ty%
'array of 'ListWindow' forms
Global ListWin() As New ListWindow
Global ListWinOpen%()

'data for each item in the list
'each window will declare an array of this type
Type ITEMDATA
    cap As String           'description
    cline As String         'command line
    dir As String           'working dir
    iconpath As String      '-
    iconindex As Integer    '-
    min As Integer          'run minimized
End Type

Type PointAPI
    x As Integer
    y As Integer
End Type

Type rect
    left As Integer
    top As Integer
    right As Integer
    bottom As Integer
End Type

Declare Function GetWindowLong Lib "User" (ByVal hWnd As Integer, ByVal nIndex As Integer) As Long
Declare Function GetSystemMetrics% Lib "User" (ByVal nIndex%)
Declare Function SetWindowLong& Lib "User" (ByVal hWnd%, ByVal nIndex%, ByVal dwNewLong&)

Declare Function ShellExecute Lib "Shell.dll" (ByVal hWnd%, ByVal lpszOp$, ByVal lpszFile$, ByVal lpszParams As Any, ByVal lpszDir$, ByVal fsShowCnd%) As Integer

Sub GetIcon (file$, ndx%)
Dim h%, r%, inst%
inst% = GetWindowWord(mnu.hWnd, GWW_HINSTANCE)
h% = ExtractIcon(inst%, file$, ndx%)
mnu.loader.Cls
If h% > 1 Then 'has icons
    r% = DrawIcon(mnu.loader.hDC, 0, 0, h%)
Else
    mnu.loader = mnu.dosicon
End If
End Sub

Sub GetPMGroups ()
Dim i%, s$, n%
Dim items$()
'
GetPMLinkData "PROGMAN"
s$ = mnu.txt
'
i = InStr(s$, nl)

'get list of grps from PM
Do While i
    If n Mod 20 = 0 Then ReDim Preserve items(1 To n + 20)
    n = n + 1
    items(n) = Left$(s$, i - 1)
    s$ = Mid$(s$, i + 2)
    i = InStr(s$, nl)
Loop 'Debug.Print n

'load groups into menu
If n > 0 Then
    For i = 1 To n
        Load mnu.zgroup(i)
        mnu.zgroup(i).Caption = items(i)
    Next
    mnu.zgroup(0).Visible = 0
End If
End Sub

Sub GetPMItems (group$, pm As LISTDATA, items() As ITEMDATA)
'called by InitializeWin
'retrieves the items in a PM group and
'parses them into the item() array
Dim s$(), t$
Dim i%, x%, CT%, cap$, Temp$, y%
Dim r1%, r2%
' get num of items in the program group
    mnu.txt = ""
      GetPMLinkData group$
      Temp$ = mnu.txt
      'Debug.Print temp
      i% = InStr(Temp$, nl)
      cap$ = Left$(Temp$, i% - 1)
      cap$ = Trim(cap$)
      
      i% = InStr(cap$, ",")
      i% = InStr(i% + 1, cap$, ",")
      cap$ = Mid$(cap$, i% + 1)
      pm.itemcount = Val(cap$)
      Debug.Print pm.itemcount
      If pm.itemcount < 1 Then Exit Sub
ReDim items(1 To pm.itemcount)
ReDim s$(1 To pm.itemcount)
' strip off 1st line of label
      i% = InStr(Temp$, nl)
      If i% Then
        Temp$ = Mid$(Temp$, i% + 2)
        i% = InStr(Temp$, nl)
      End If
      CT% = 1
' extract each item's data
Do While i%
    ' add item's data string to s()
    s(CT%) = Left$(Temp$, InStr(Temp$, nl) - 1)
     Temp$ = Mid$(Temp$, i% + 2)
     i% = InStr(Temp$, nl)
     CT% = CT% + 1
Loop
' loop through s() getting the the item data
For i% = 1 To pm.itemcount
    'extract command line/work dir
    t$ = s(i%)
    'Debug.Print t
    'get caption (strip quotes)
    r1% = InStr(t$, ",")
    cap$ = Left$(t$, r1% - 1)
    items(i%).cap = Mid$(cap$, 2, Len(cap$) - 2)
    'get cline (strip quotes)
    r2% = InStr(r1% + 1, t$, ",")
    cap$ = Mid$(t$, r1 + 2, r2 - 2 - (r1 + 1))
    items(i%).cline = cap$
    'get def dir
    r1% = InStr(r2% + 1, t$, ",")
    cap$ = Mid$(t$, r2% + 1, r1 - 1 - r2)
    items(i%).dir = cap$
    'get iconpath
    r2% = InStr(r1% + 1, t$, ",")
    cap$ = Mid$(t$, r1% + 1, r2 - 1 - r1)
    items(i%).iconpath = cap$
    'xpos
    r1% = InStr(r2% + 1, t$, ",")
    cap$ = Mid$(t$, r2% + 1, r1 - 1)
    'items(i%).xpos = Val(cap$)
    'ypos
    r2% = InStr(r1% + 1, t$, ",")
    cap$ = Mid$(t$, r1% + 1, r2 - 1)
    'items(i%).ypos = Val(cap$)
    'get icon index
    r1% = InStr(r2% + 1, t$, ",")
    cap$ = Mid$(t$, r2% + 1, r1 - 1 - r2)
    items(i%).iconindex = Val(cap$)
    'get min
    cap$ = Mid$(t$, r2% + 1, 1)
    items(i%).min = Val(cap$)
    
Next i%

End Sub

Sub GetPMLinkData (item$)
On Error Resume Next
mnu.txt.LinkItem = item$
mnu.txt.LinkMode = 2
mnu.txt.LinkRequest
mnu.txt.LinkMode = 0
End Sub

Sub gItemClear ()
gItem.cap = ""
gItem.cline = ""
gItem.dir = ""
gItem.iconpath = ""
gItem.iconindex = 0
gItem.min = 0
End Sub

Function launch% (F As Form, item As ITEMDATA)
Dim s$, m%, t$, r%
Dim hWnd%, state%
Dim cnclform%
'check min param
If item.min < 1 Or item.min > 9 Then state% = 5 Else state% = item.min
'check if the file can be found
s$ = Trim$(item.cline)
'launch w/ vb
On Error GoTo shellerr
r = Shell(s$, state%)
r = DoEvents()
launch = -1
screen.MousePointer = 0
Exit Function
'--------------------------------------------------------------
shellerr:
    screen.MousePointer = 0
    'try api instead
    r% = ShellExecute(F.hWnd, "Open", s$, 0&, item.dir, state%)
    If r% < 32 Then
    MsgBox "Can't launch" & nl & item.cline + nl + Error(Err), 64, "LAUNCH ERROR"
    Else
    Exit Function
    End If
Exit Function
'
End Function

Function LoadListWindow (Caption$, index%)
Static totalwindows%
Dim i%, ndx%
'see if its already open
Debug.Print "totalwindows=" & totalwindows: Debug.Print "caption=" & Caption$

If index% > 0 Then 'close the window
    Debug.Print "Closing " & index%
    totalwindows = totalwindows - 1
    Debug.Print Caption
    ListWinOpen(index%) = 0
Else 'open a new win
    If totalwindows Then
    Debug.Print "ubound(ListWin)=" & UBound(ListWin)
    For i = 1 To UBound(ListWin)
        If ListWinOpen(i) Then
        'Debug.Print "i=" & i
        'Debug.Print "ListWin(i).cap=" & ListWin(i).caption
        If ListWin(i).Caption = Caption$ Then
            'show it, it may be in iconbar
            'to_do
            MsgBox "already loaded"
            Exit Function
        End If
        End If
    Next
    End If
    'find unused index
    If totalwindows Then
    Debug.Print "ubound(ListWin)=" & UBound(ListWin)
    For i% = 1 To UBound(ListWin)
        If ListWinOpen(i%) = 0 Then
            ndx% = i%
            Debug.Print "unused index=" & ndx
            Exit For
        End If
    Next
    End If
    'if no unused slots, expand array
    If ndx% = 0 Then
        totalwindows = totalwindows + 1
        ReDim Preserve ListWin(1 To totalwindows)
        ReDim Preserve ListWinOpen(1 To totalwindows)
        ndx% = totalwindows
        Debug.Print "expanding array=" & ndx
    End If
    Debug.Print "Opening" & ndx
    '
    ListWinOpen(ndx%) = -1
    'pass the window its caption:
    
    gItem.cap = Caption$
    'load form, pass the window its index:
    ListWin(ndx%).Tag = ndx%
    ListWin(ndx%).Show
End If

End Function

