Option Explicit
Dim PosChange%

Function CheckNum (num$)
  
  Dim x%, char%, onedec%, rtn$

  'allow just numbers & one decimal point
  For x% = 1 To Len(num$)
    char% = Asc(Mid(num$, x%, 1))
    '0 = Chr$(48), 9 = Chr$(57), dec pt = Chr$(46)
    If (char% > 47 And char% < 58) Or (char% = 46 And Not onedec%) Then
      If char% = 46 Then onedec% = True
      rtn$ = rtn$ & Chr$(char)
    Else
      CheckNum = "bad"
      Exit Function
    End If
  Next
  
  'remove leading zeros
  For x% = 1 To Len(rtn$)
    If Left$(rtn$, 1) = "0" Then
      rtn$ = Right$(rtn$, Len(rtn$) - 1)
    Else
      Exit For
    End If
  Next
  
  CheckNum = Format$(rtn$, "0.00")

End Function

Function Get11to19 (num%)
  
  Select Case num%
    Case 1: Get11to19 = "Eleven"
    Case 2: Get11to19 = "Twelve"
    Case 3: Get11to19 = "Thirteen"
    Case 4: Get11to19 = "Fourteen"
    Case 5: Get11to19 = "Fifteen"
    Case 6: Get11to19 = "Sixteen"
    Case 7: Get11to19 = "Seventeen"
    Case 8: Get11to19 = "Eighteen"
    Case 9: Get11to19 = "Nineteen"
  End Select

End Function

Function Get1to9 (num%)
  
  Select Case num%
    Case 1: Get1to9 = "One"
    Case 2: Get1to9 = "Two"
    Case 3: Get1to9 = "Three"
    Case 4: Get1to9 = "Four"
    Case 5: Get1to9 = "Five"
    Case 6: Get1to9 = "Six"
    Case 7: Get1to9 = "Seven"
    Case 8: Get1to9 = "Eight"
    Case 9: Get1to9 = "Nine"
  End Select

End Function

Function GetMultHundred (numlen%)
  
  Select Case numlen%
    Case 3: GetMultHundred = "Hundred"
    Case 4: GetMultHundred = "Thousand "
    Case 7: GetMultHundred = "Million "
    Case 10: GetMultHundred = "Billion "
  End Select

End Function

Function GetMultTen (num%)
  
  Select Case num%
    Case 1: GetMultTen = "Ten"
    Case 2: GetMultTen = "Twenty"
    Case 3: GetMultTen = "Thirty"
    Case 4: GetMultTen = "Forty"
    Case 5: GetMultTen = "Fifty"
    Case 6: GetMultTen = "Sixty"
    Case 7: GetMultTen = "Seventy"
    Case 8: GetMultTen = "Eighty"
    Case 9: GetMultTen = "Ninety"
  End Select

End Function

Function GetString (digit%, digitpos%, nextdigit%, next2digits%, prevdigit%)
  
  If digitpos% = 1 Then  'take care of 1s digit
    GetString = Get1to9(digit%)
  ElseIf nextdigit% = 0 Then 'multiples of 10
    Select Case digitpos%
      Case 3, 4, 7, 10
        GetString = Get1to9(digit%) & GetMultHundred(digitpos%)
      Case 2, 5, 8, 11
        GetString = GetMultTen(digit%) & GetMultHundred(digitpos% - 1) & " "
      Case 6, 9, 12
        If next2digits% <> 0 Then
          GetString = Get1to9(digit%) & "Hundred"
        Else
          GetString = Get1to9(digit%) & "Hundred" & GetMultHundred(digitpos% - 2)
        End If
    End Select
    PosChange% = 2
  Else  'everything else
    Select Case digitpos%
      Case 4 'use teens & mult of tens w/ 4 digit #s
        If digit% = 1 And prevdigit% = -1 Then
          PosChange% = 2
          GetString = Get11to19(nextdigit%) & GetMultHundred(digitpos% - 1) & " "
        ElseIf prevdigit% = -1 Then
          GetString = GetMultTen(digit%)
        Else
          GetString = Get1to9(digit%) & GetMultHundred(digitpos%)
        End If
      Case 2, 5, 8, 11  'even mult of tens checked above
        If digit% = 1 Then
          PosChange% = 2
          GetString = Get11to19(nextdigit%) & GetMultHundred(digitpos% - 1)
        Else
          GetString = GetMultTen(digit%) & GetMultHundred(digitpos%)
        End If
      Case 3, 7, 10
        GetString = Get1to9(digit%) & GetMultHundred(digitpos%)
      Case 6, 9, 12
        GetString = Get1to9(digit%) & "Hundred" & GetMultHundred(digitpos%)
    End Select
  End If

End Function

Sub Main ()

  Dim num$, wholenum$, strpos%, digitpos%
  Dim digit%, nextdigit%, next2digits%, prevdigit%, rtn$

Start:
  num$ = InputBox("Enter a decimal number", "Num2Txt")
  If num$ = "" Then Exit Sub 'cancel
  
  num$ = CheckNum(num$)
  
  'make sure we're dealing w/ a valid number
  If num$ = "bad" Or Val(num$) = 0 Then
    MsgBox "That is not a valid number"
    GoTo Start
  End If
  
  wholenum$ = Trim$(Str$(Int(Val(num$))))
  
  If Len(wholenum$) > 12 Then 'handle up to 1 trillion
    MsgBox "Can I have some money?"
    GoTo Start
  End If

  'for the purposes of this procedure, string function
  'positions are the reverse of whole digit decimal places:
  '(in a 5 whole digit str, the 1st string pos is the 5th digit)
  strpos% = 1
  digitpos% = Len(wholenum$)
  
  'get digits from left to right
  Do
    PosChange% = 1
    'value of the current digit
    digit% = Val(Mid$(wholenum$, strpos%, 1))

    If digit% <> 0 Then
      nextdigit% = Val(Mid$(wholenum$, strpos% + 1, 1))
      next2digits% = Val(Mid$(wholenum$, strpos% + 1, 2))
      If strpos% = 1 Then
        prevdigit% = -1
      ElseIf strpos% > 1 Then
        prevdigit% = Val(Mid$(wholenum$, strpos% - 1, 1))
      End If
      rtn$ = rtn$ & GetString(digit%, digitpos%, nextdigit%, next2digits%, prevdigit%)
    End If
    
    strpos% = strpos% + PosChange%
    digitpos% = digitpos% - PosChange%

  Loop Until digitpos% = 0
  
  If wholenum$ <> "0" Then rtn$ = rtn$ & " & "
  rtn$ = rtn$ & Right$(num$, 2) & "/100"
  MsgBox Format$(num$, "#,###.00") & "=" & Chr$(10) & Chr$(10) & rtn$
  
  Main  'keep going

End Sub

