VERSION 2.00
Begin Form Modmcfg 
   Caption         =   "Modem Configuration"
   ClientHeight    =   3960
   ClientLeft      =   1875
   ClientTop       =   1800
   ClientWidth     =   7155
   Height          =   4365
   Icon            =   MODMCFG.FRX:0000
   Left            =   1815
   LinkTopic       =   "Form1"
   ScaleHeight     =   3960
   ScaleWidth      =   7155
   Top             =   1455
   Width           =   7275
   Begin MSComm Comm1 
      Interval        =   55
      Left            =   240
      RTSEnable       =   -1  'True
      Top             =   120
   End
   Begin CommandButton InitModem 
      Caption         =   "Initialize Modem"
      Height          =   855
      Left            =   5280
      TabIndex        =   4
      Top             =   600
      Width           =   1695
   End
   Begin ListBox ModemList 
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   12
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   1230
      Left            =   1080
      TabIndex        =   2
      Top             =   375
      Width           =   3915
   End
   Begin TextBox ModemConfig 
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   12
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   2055
      Left            =   1065
      MultiLine       =   -1  'True
      TabIndex        =   1
      Text            =   "Configuration"
      Top             =   1800
      Width           =   5970
   End
   Begin Label Label2 
      Caption         =   "Config."
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   12
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   360
      Left            =   105
      TabIndex        =   0
      Top             =   2520
      Width           =   960
   End
   Begin Label Label1 
      Caption         =   "Modem"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   12
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   360
      Left            =   120
      TabIndex        =   3
      Top             =   855
      Width           =   990
   End
End
Option Explicit
Dim Config(200) As String

Function FindModem (BitRate&) As Integer                          'this routine leaves the commport open, if found

  Dim I%
  Dim PortNum%
  Dim ErrCode%

    If Comm1.PortOpen Then Comm1.PortOpen = False
    BitRate& = 1200
    Comm1.RTSEnable = True
    Comm1.Settings = Format$(BitRate&) & ",n,8,1"       'lowest common denominator
    On Error Resume Next
     For I% = 1 To 9
        '-- Check ports 1 through 9
        Comm1.CommPort = I%
        '-- Try to open the port
        Comm1.PortOpen = True
        If Comm1.PortOpen Then
            '-- Port opened OK. Now test for modem by sending "AT"
            ErrCode% = ModemCommand("AT")
            If ErrCode% = 0 Then
                PortNum% = I%
                Exit For
            Else
                '-- OK was not received. Close the port
                Comm1.PortOpen = False
                PortNum% = 0
            End If
        End If
     Next I%
     If PortNum% > 0 Then                               'modem found?
       BitRate& = 38400
       Do
         Comm1.Settings = Format$(BitRate&) & ",n,8,1"   'start at the highest speed
      '-- Port opened OK. Now test for modem speed by sending "AT"
        ErrCode% = ModemCommand("AT")
        If ErrCode% = 0 Then Exit Do
        BitRate& = BitRate& \ 2
       Loop Until BitRate& = 1200

       FindModem = PortNum%
  End If
End Function

Sub Form_Load ()
Dim Modem As String
Dim I As Integer
Dim PortNumber As Integer
Dim BitRate As Long

Open "Modem.txt" For Input As #1
Do While Not EOF(1)
    Input #1, Modem
    If Len(Modem) < 1 Then Exit Do
    Input #1, Config(I)
    ModemList.AddItem Modem
    I = I + 1
Loop

Close

Modmcfg.Show
DoEvents

ModemList.ListIndex = 0

PortNumber = FindModem(BitRate)

If PortNumber = 0 Then MsgBox ("No modem detected")

End Sub

Sub InitModem_Click ()
Dim I As Integer
Dim ConfigString As String
Dim Ret As Integer
Dim ErrorDet As Integer

For I = 1 To Len(Config(ModemList.ListIndex))
    If Mid$(Config(ModemList.ListIndex), I, 2) = "^^" Then
        Ret = ModemCommand(ConfigString)
        If Ret = 1 Then
            MsgBox ("An error was detected on command: " & ConfigString)
            ErrorDet = True   'needed because a subsequent string may be OK
        End If
        ConfigString = ""
        I = I + 1
    Else ConfigString = ConfigString & Mid$(Config(ModemList.ListIndex), I, 1)
    End If
Next I
If ErrorDet = False Then MsgBox ("The modem initialized successfully")

End Sub

Function ModemCommand (ATCommand$) As Integer
    Dim RThreshold%
    Dim Timeout&
    Dim Process%                                        'uncomment Comm Lib 3
    Dim Buffer$

    RThreshold% = Comm1.RThreshold                     'disable OnComm receive events
    Comm1.RThreshold = 0                               'process receive data in this function
    Comm1.Output = ATCommand$ & Chr$(13)
    ModemCommand = 2                                     'assume a timeout error
    Timeout& = Timer + 1                                 'this section of code fails at midnight
    Do Until Timer > Timeout&                            'so, you may want to enhance it
        DoEvents
        Buffer$ = Buffer$ & Comm1.Input
        If InStr(Buffer$, "OK" & Chr$(13) & Chr$(10)) Then
            ModemCommand = 0                            'OK!
            Exit Do
        End If
        If InStr(Buffer$, "ERROR" & Chr$(13) & Chr$(10)) Then
           ModemCommand = 1                             'Error!
           Exit Do
        End If
    Loop
    Comm1.RThreshold = RThreshold%                    'restore OnComm handling
End Function

Sub ModemList_Click ()
Dim I As Integer

ModemConfig.Text = ""
For I = 1 To Len(Config(ModemList.ListIndex))
    If Mid$(Config(ModemList.ListIndex), I, 2) = "^^" Then
        ModemConfig.SelText = Chr$(13) & Chr$(10)
        I = I + 1
    Else ModemConfig.SelText = Mid$(Config(ModemList.ListIndex), I, 1)
    End If
Next I

End Sub

