'***************************************************************************
'** MINIFILE.BAS
'***************
'** VB Module for simplifying .INI file operations
'**
'** Usage:
'** --------
'** Either use ReadIni and SaveIni ad-hoc, or record the application name
'** and INI file name using MINIFILERegister and call
'** [Get|Put]Profile[String|Int] as necessary.
'**
'***************************************************************************

'** Windows API calls

Declare Function GetPrivateProfileInt Lib "Kernel" (ByVal lpAppName As String, ByVal lpKeyName As String, ByVal nDefault As Integer, ByVal lpFileName As String) As Integer
Declare Function GetPrivateProfileString Lib "Kernel" (ByVal lpAppName As String, ByVal lpKeyName As String, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer, ByVal lpFileName As String) As Integer
Declare Function WritePrivateProfileString Lib "Kernel" (ByVal lpAppName As String, ByVal lpKeyName As String, ByVal lpString As String, ByVal lpFileName As String) As Integer

'** Redefine WPPS() to allow a NULL pointer (instead of a pointer to a NULL string...
Declare Function WriteNullPrivateProfileString Lib "Kernel" Alias "WritePrivateProfileString" (ByVal lpAppName As String, ByVal lpKeyName As String, ByVal lpStrPtr As Long, ByVal lpFileName As String) As Integer

'***************************************************************************

'** Module-level variables for application and .INI file names
'** (maintained by MINIFILERegister)

Dim smAppName As String
Dim smIniFile As String

Sub ClearProfileString (sKeyName As String)

'**************************************************************************
'** Use this sub to set the value of a key to NULL (blank, or whatever).
'** Use DeleteProfileKey(KeyName) to remove the entry altogether.
'**************************************************************************

x% = WritePrivateProfileString(smAppName, sKeyName, "", smIniFile)

End Sub

Sub DeleteProfileKey (sKeyName As String)

'***********************************************************************
'** When a null pointer (rather than a pointer to null - see ClearProfileString)
'** is passed to WritePrivateProfileString(), the whole line in the INI file
'** is removeed.
'***********************************************************************

x% = WriteNullPrivateProfileString(smAppName, sKeyName, 0, smIniFile)

End Sub

Function GetProfileInt (sKeyName As String, nDefaultValue As Integer) As Integer

GetProfileInt = GetPrivateProfileInt(smAppName, sKeyName, nDefaultValue, smIniFile)

End Function

Function GetProfileString (sKeyName As String, sDefaultValue As String) As String

Dim sTemp As String * 255
Dim nLen As Integer
Dim nRet As Integer

nLen = 255
nRet = GetPrivateProfileString(smAppName, sKeyName, sDefaultValue, sTemp, nLen, smIniFile)
GetProfileString = Left$(sTemp, nRet)

End Function

Sub MINIFILERegister (sAppName As String, sIniFileName As String)

smAppName = sAppName
smIniFile = sIniFileName

End Sub

Function PutProfileInt (sKeyName As String, ByVal nValue As Integer) As Integer

PutProfileInt = WritePrivateProfileString(smAppName, sKeyName, Str$(nValue), smIniFile)

End Function

Function PutProfileString (sKeyName As String, ByVal sValue As String) As Integer

PutProfileString = WritePrivateProfileString(smAppName, sKeyName, sValue, smIniFile)

End Function

Sub ReadIni (AppName$, KeyName$, nDefault, DefaultStr$, ReturnStr$, Numeric%, IniFileName$)

If Numeric% Then    'we are looking for integer input
  Numeric% = GetPrivateProfileInt(AppName$, KeyName$, nDefault, IniFileName$)
Else
  Dim RetStr As String * 255 'Create an empty string to be filled
  nSize% = 255               'uncertain - possibly length of fill string
  lenRetString% = GetPrivateProfileString(AppName$, KeyName$, DefaultStr$, RetStr$, nSize%, IniFileName$)
  ReturnStr$ = Left$(RetStr$, lenRetString%)
End If

End Sub

Sub SaveIni (AppName$, IniFileName$, KeyName$, NewVal$)
    
' Update INI file
        
ResultCode% = WritePrivateProfileString(AppName$, KeyName$, NewVal$, IniFileName$)
If ResultCode% = 0 Then
  MsgBox "Error updating INI file!", 16, "ERROR!"
End If
    
End Sub

