/*  Project test
    Caprock Software
    Copyright  1995. Caprock Software. All Rights Reserved.

    SUBSYSTEM:    test.exe Application
    FILE:         testapp.cpp
    AUTHOR:       Scott Stubbs


    OVERVIEW
    ========
    Source file for implementation of testApp (TApplication).      
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include <owl\vbxctl.h>


#include "testapp.h"
#include "tsttdlgc.h"                        // Definition of client class.       


//{{testApp Implementation}}


//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(testApp, TApplication)
//{{testAppRSP_TBL_BEGIN}}
    EV_COMMAND(CM_HELPABOUT, CmHelpAbout),
//{{testAppRSP_TBL_END}}
END_RESPONSE_TABLE;


//////////////////////////////////////////////////////////
// testApp
// =====
//
testApp::testApp () : TApplication("Test Meter Bar VBX")
{

    // INSERT>> Your constructor code here.
}


testApp::~testApp ()
{
    // INSERT>> Your destructor code here.
}


//////////////////////////////////////////////////////////
// testApp
// =====
// Application intialization.
//
void testApp::InitMainWindow ()
{
    if (nCmdShow != SW_HIDE)
        nCmdShow = (nCmdShow != SW_SHOWMINNOACTIVE) ? SW_SHOWNORMAL : nCmdShow;

    SDIDecFrame *frame = new SDIDecFrame(0, GetName(), 0, true);
    frame->SetFlag(wfShrinkToClient);

    //
    // Assign ICON w/ this application.
    //
    frame->SetIcon(this, IDI_SDIAPPLICATION);


    TStatusBar *sb = new TStatusBar(frame, TGadget::Recessed,
                                    TStatusBar::CapsLock        |
                                    TStatusBar::NumLock         |
                                    TStatusBar::ScrollLock      |
                                    TStatusBar::Overtype);
	frame->Insert(*sb, TDecoratedFrame::Bottom);
  
	SetMainWindow(frame);
}


//{{SDIDecFrame Implementation}}


SDIDecFrame::SDIDecFrame (TWindow *parent, const char far *title, TWindow *clientWnd, bool trackMenuSelection, TModule *module)
    : TDecoratedFrame(parent, title, clientWnd == 0 ? new testTDLGClient(0) : clientWnd, trackMenuSelection, module)
{
    // INSERT>> Your constructor code here.

}


SDIDecFrame::~SDIDecFrame ()
{
    // INSERT>> Your destructor code here.

}


void SDIDecFrame::SetupWindow ()
{
    TDecoratedFrame::SetupWindow();
    
    TRect  r;
    GetWindowRect(r);

	r.bottom += 30;
    SetWindowPos(0, r, SWP_NOZORDER | SWP_NOMOVE);

    // INSERT>> Your code here.

}


//////////////////////////////////////////////////////////
// testApp
// ===========
// Menu Help About test.exe command
void testApp::CmHelpAbout ()
{
}

int OwlMain (int , char* [])
{
	TBIVbxLibrary   vbxSupport;                 // This application has VBX controls.
	try {
	   testApp	app;
	   return app.Run();
	}
    catch (xmsg& x) {
        ::MessageBox(0, x.why().c_str(), "Exception", MB_OK);
    }

    return -1;
}
