VERSION 2.00
Begin Form frmVBProjectListSpy 
   BackColor       =   &H0080FFFF&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "VB Project List Spy"
   ClientHeight    =   4995
   ClientLeft      =   2565
   ClientTop       =   2265
   ClientWidth     =   6540
   Height          =   5430
   Icon            =   PLISTSPY.FRX:0000
   Left            =   2490
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   4995
   ScaleWidth      =   6540
   Top             =   1905
   Width           =   6690
   Begin CommandButton cmdAbout 
      Caption         =   "A&bout..."
      Height          =   330
      Left            =   4425
      TabIndex        =   13
      Top             =   4110
      Width           =   1665
   End
   Begin CommandButton cmdFindForm 
      BackColor       =   &H0000FFFF&
      Caption         =   "Fin&d next entry containing string above"
      Height          =   330
      Index           =   4
      Left            =   165
      TabIndex        =   8
      Top             =   3480
      Width           =   3495
   End
   Begin TextBox txtFormName 
      Height          =   330
      Index           =   1
      Left            =   165
      TabIndex        =   7
      Top             =   3060
      Width           =   3495
   End
   Begin CommandButton cmdHuh 
      BackColor       =   &H0080FFFF&
      Caption         =   "?"
      Height          =   330
      Left            =   3345
      TabIndex        =   12
      Top             =   465
      Width           =   315
   End
   Begin CommandButton cmdFindForm 
      BackColor       =   &H0080FFFF&
      Caption         =   "F&ind Index of Exact Filename Above"
      Height          =   330
      Index           =   1
      Left            =   165
      TabIndex        =   3
      Top             =   1305
      Width           =   3495
   End
   Begin CommandButton cmdFindForm 
      BackColor       =   &H0080FFFF&
      Caption         =   "Fi&nd and Select Form Above"
      Height          =   330
      Index           =   3
      Left            =   165
      TabIndex        =   5
      Top             =   2145
      Width           =   3495
   End
   Begin CommandButton cmdFindForm 
      BackColor       =   &H0000FFFF&
      Caption         =   "N&ame and Index of Current Selection..."
      Height          =   330
      Index           =   5
      Left            =   165
      TabIndex        =   9
      Top             =   4110
      Width           =   3495
   End
   Begin CommandButton cmdFindForm 
      BackColor       =   &H0080FFFF&
      Caption         =   "&Select Form Above in Project Window"
      Height          =   330
      Index           =   2
      Left            =   165
      TabIndex        =   4
      Top             =   1725
      Width           =   3495
   End
   Begin CommandButton cmdFindForm 
      BackColor       =   &H0000FFFF&
      Caption         =   "&List Files In Project"
      Height          =   330
      Index           =   6
      Left            =   165
      TabIndex        =   10
      Top             =   4530
      Width           =   3495
   End
   Begin CommandButton c3dExit 
      BackColor       =   &H0080FFFF&
      Caption         =   "E&xit"
      Height          =   330
      Left            =   4425
      TabIndex        =   11
      Top             =   4530
      Width           =   1665
   End
   Begin TextBox txtFormName 
      Height          =   330
      Index           =   0
      Left            =   165
      TabIndex        =   1
      Top             =   465
      Width           =   3135
   End
   Begin CommandButton cmdFindForm 
      BackColor       =   &H0080FFFF&
      Caption         =   "&Find Index of Form Prefix Above"
      Default         =   -1  'True
      Height          =   330
      Index           =   0
      Left            =   165
      TabIndex        =   2
      Top             =   885
      Width           =   3495
   End
   Begin Label Label1 
      BackColor       =   &H0080FFFF&
      Caption         =   "En&ter a string to find in the list..."
      Height          =   225
      Index           =   1
      Left            =   165
      TabIndex        =   6
      Top             =   2790
      Width           =   3495
   End
   Begin Label Label1 
      BackColor       =   &H0080FFFF&
      Caption         =   "&Enter a filename prefix to find in the list..."
      Height          =   225
      Index           =   0
      Left            =   165
      TabIndex        =   0
      Top             =   195
      Width           =   3735
   End
End
'This project code 1994 David Stewart
'Project demonstrating the use of Windows List Box messages
'to derive and find FileNamePrefixs and strings in the Visual
'Basic Project window.
   Option Explicit
   DefInt A-Z
   
   'Const NORMAL% = 0
   'Const MINIMIZED% = 1
   'Const MAXIMIZED% = 2
   
   Const WM_USER = &H400
   Const LB_FINDSTRING = (WM_USER + 16)
   Const LB_FINDSTRINGEXACT = (WM_USER + 35)
   Const LB_GETCOUNT = (WM_USER + 12)
   Const LB_GETTEXT = (WM_USER + 10)
   Const LB_GETTEXTLEN = (WM_USER + 11)
   Const LB_SELECTSTRING = (WM_USER + 13)
   Const LB_GETCURSEL = (WM_USER + 9)
   Const LB_SETCURSEL = (WM_USER + 7)
   '  GetWindow() Constants
   Const GW_HWNDFIRST = 0
   Const GW_HWNDLAST = 1
   Const GW_HWNDNEXT = 2
   Const GW_HWNDPREV = 3
   Const GW_OWNER = 4
   Const GW_CHILD = 5
   
   Declare Function FindWindow Lib "User" (ByVal lpClassName As Any, ByVal lpCaption As Any)
   'Declare Function GetActiveWindow Lib "User" () As Integer
   Declare Function GetNextWindow Lib "User" (ByVal hWnd As Integer, ByVal wFlag As Integer) As Integer
   Declare Function GetWindow Lib "User" (ByVal hWnd As Integer, ByVal wCmd As Integer) As Integer
   'Declare Sub HideCaret Lib "user" (ByVal hWnd As Integer)
   'Declare Function IsIconic Lib "User" (ByVal hWnd As Integer) As Integer
   'Declare Function IsZoomed Lib "User" (ByVal hWnd As Integer)
   'Declare Sub MoveWindow Lib "User" (ByVal hWnd As Integer, ByVal x As Integer, ByVal Y As Integer, ByVal nWidth As Integer, ByVal nHeight As Integer, ByVal bRepaint As Integer)
   Declare Function SendMsgByStr& Lib "User" Alias "SendMessage" (ByVal hWnd%, ByVal wMsg%, ByVal wParam%, ByVal lParam$)
   Declare Function SendMsgByNum& Lib "User" Alias "SendMessage" (ByVal hWnd%, ByVal wMsg%, ByVal wParam%, ByVal lParam&)
   'Declare Sub SetActiveWindow Lib "User" (ByVal hWnd)
   'Declare Function SetWindowPos Lib "User" (ByVal hWnd As Integer, ByVal hWndInsertAfter As Integer, ByVal x As Integer, ByVal Y As Integer, ByVal cx As Integer, ByVal cy As Integer, ByVal wFlags As Integer)
   'Declare Sub ShowCaret Lib "user" (ByVal hWnd As Integer)
   'Declare Function GetFocus Lib "User" () As Integer
   
   Dim Msg$, DblSp$

Sub c3dExit_Click ()
   Unload Me
   End
End Sub

Sub cmdAbout_Click ()
   Msg$ = "VB Project Spy List" & Chr(10)
   Msg$ = Msg$ & "Copyright 1994 David Stewart" & DblSp
   Msg$ = Msg$ & "VB Project Spy List demonstrates the "
   Msg$ = Msg$ & "ability of Visual Basic applications "
   Msg$ = Msg$ & "to read the filename contents of the VB "
   Msg$ = Msg$ & "design environment's Project window. "
   Msg$ = Msg$ & "This can be useful for developing VB "
   Msg$ = Msg$ & "add-in tools (which is why I worked up "
   Msg$ = Msg$ & "the method myself)." & DblSp
   Msg$ = Msg$ & "You may use and distribute the code in "
   Msg$ = Msg$ & "this project freely. If you have questions, "
   Msg$ = Msg$ & "suggestions or brainstorms you'd like to "
   Msg$ = Msg$ & "share, write to me on AOL, Doc Yeah; "
   Msg$ = Msg$ & "CompuServe, 72122,03562; or Internet, "
   Msg$ = Msg$ & "docyeah@aol.com or 72122.03562@compuserve.com. "
   Msg$ = Msg$ & DblSp & "Cheers!"
   MsgBox Msg$, 48, "VB Project List Spy"
End Sub

Sub cmdFindForm_Click (Index As Integer)
   Dim Response%
   Dim hPROJECTWnd%, PROJECTListBox%, FrmListPos%
   Dim EntriesCount%, LenEntryText%, CurSelPos%, BufLen%, i%, j%
   Dim IsStringIn%
   Dim FileNamePrefix$, EntryText$, Buf$, Msg$
   
   Cls   'Clear the form of any printing we've done to it.
   
   'Get a handle for the Project window. NB: The project
   'window does NOT have to be visible on screen to find it!
   'As long as VB is open, it should be available and manipulable,
   'whether visible or not. PROJECT is the class of the Project
   'window.
   hPROJECTWnd = FindWindow("PROJECT", 0&)
   If hPROJECTWnd <> 0 Then
      'Once we've found it, drill down into it to get
      'a handle for the list box. It's the first child
      'window of the Project window.
      PROJECTListBox = GetWindow(hPROJECTWnd, GW_CHILD)
   Else
      MsgBox "Can't find the project window. Visual Basic must not be running.", 32, "Demo Copyright 1994 David Stewart"
      Exit Sub
   End If
   'Initialize the prefix variable with the contents
   'of the upper text box.
   FileNamePrefix = txtFormName(0).Text
   
   'Action depending on what button's pressed...
   Select Case Index
      Case 0   'Find Index of Form Above
         If txtFormName(0).Text = "" Then Exit Sub 'Can't do a thing without something to look for.
         'Get the position in the list box of the user-
         'specified string prefix, starting search at
         'list entry index 0.
         FrmListPos = SendMsgByStr(PROJECTListBox, LB_FINDSTRING, 0, FileNamePrefix)
         If FrmListPos >= 0 Then
            'If it's in the list, let the user know.
            MsgBox "The index position in the project list box of the file named above is" & Str(FrmListPos) & ".", 64, "Demo Copyright 1994 David Stewart"
         Else
            'And if not, also alert the user.
            MsgBox "The file entered above is not in the Project window's list box.", 64, "Demo Copyright 1994 David Stewart"
         End If
      Case 1
         If txtFormName(0).Text = "" Then Exit Sub
         'Same as above, LB_FINDSTRING, but LB_FINDSTRINGEXACT looks for exactly the
         'WHOLE string given, no more and no less, not treating it as a prefix.
         FrmListPos = SendMsgByStr(PROJECTListBox, LB_FINDSTRINGEXACT, 0, FileNamePrefix)
         If FrmListPos >= 0 Then
            MsgBox "The index position in the project list box of the file named above is" & Str(FrmListPos) & ".", 64, "Demo Copyright 1994 David Stewart"
         Else
            Msg$ = "Either the FileNamePrefix entered above "
            Msg$ = Msg$ & "does not EXACTLY match a list entry "
            Msg$ = Msg$ & "in the Project window's list box, "
            Msg$ = Msg$ & "or the file is not in the project. This message tests an EXACT "
            Msg$ = Msg$ & "match of FileNamePrefix."
            MsgBox Msg$, 64, "VB Project List Spy"
         End If
      Case 2   'Select Form Above in Project Window
         If txtFormName(0).Text = "" Then Exit Sub
         FrmListPos = SendMsgByStr(PROJECTListBox, LB_SELECTSTRING, 0, FileNamePrefix)
         If FrmListPos < 0 Then MsgBox "The file prefix entered above is not in the Project window's list box, so it cannot be selected.", 64, "Demo Copyright 1994 David Stewart"
      Case 3   'Find and Select Form Above
         'This does essentially the same thing as Case 2, but divides it into two steps.
         If txtFormName(0).Text = "" Then Exit Sub
         'Same as in Case 0...
         FrmListPos = SendMsgByStr(PROJECTListBox, LB_FINDSTRING, 0, FileNamePrefix)
         'If we find it,
         If FrmListPos >= 0 Then
            '...ask user if he wants to select it in the list.
            Response = MsgBox("The prefix entered above has been found in the Project window's list box. Do you want to select the form in the list box?", 36, "Demo Copyright 1994 David Stewart")
            'Possible Response values: 6--YES, 7--NO.
            'If yes, then select it and leave the sub.
            If Response = 6 Then
               i = SendMsgByStr(PROJECTListBox, LB_SETCURSEL, 0, FileNamePrefix)
               Exit Sub
            'If not, get out of the routine.
            ElseIf Response = 7 Then
               Exit Sub
            End If
         Else
            'If the user entered a prefix that's not in any file in the list...
            MsgBox "The file prefix entered above is not in the Project window's list box, so it cannot be selected.", 64, "Demo Copyright 1994 David Stewart"
         End If
      Case 4   'Find Next Entry Containing String Above
         'This starts with the list entry below whatever one is
         'currently selected, and looks for the string in
         'its text box INSIDE the strings of list entries, until
         'it finds the next list entry that contains the
         'search string.
         'First, count the number of entries...
         EntriesCount% = SendMsgByNum(PROJECTListBox, LB_GETCOUNT, 0, 0)
         '...then find out where the cursor is currently.
         CurSelPos = SendMsgByNum(PROJECTListBox, LB_GETCURSEL, 0, 0)
         If CurSelPos = EntriesCount - 1 Then CurSelPos = CurSelPos - 1
         'If there are no items in the list, split.
         If EntriesCount% = 0 Then
            MsgBox "There are no files listed in the Project list box.", 64, "Demo Copyright 1994 David Stewart"
            Exit Sub
         Else
            'Begin the search at the list entry below the
            'current selection, go to last entry. We want this
            'procedure to loop around to the beginning, though,
            'so that we can find the entry if it is ABOVE the
            'currently selected one or in case the currently selected
            'one is the only entry that matches. We'll enter
            'another For loop to do that when we reach
            'the last index value of this one. There may be a more
            'efficient way of doing this, but I couldn't think of it
            'at the time.
            For i = CurSelPos + 1 To (EntriesCount - 1) Step 1
               'Get the length of the text in the current entry.
               LenEntryText = SendMsgByNum(PROJECTListBox, LB_GETTEXTLEN, i, 0)
               'Initialize a string to hold the text.
               Buf = String$(LenEntryText + 1, 0)
               'This will obtain the string, storing it in Buf, and return
               'the length of the string.
               BufLen = SendMsgByStr(PROJECTListBox, LB_GETTEXT, i, Buf)
               'Search the Buf string for the string fragment the user's typed in...
               IsStringIn = InStr(1, Buf, txtFormName(1).Text)
               'If we find it, its starting point will be > 0.
               If IsStringIn > 0 Then
                  'Let use know we've found it.
                  MsgBox "The string fragment '" & txtFormName(1).Text & "' has been found" & Chr(10) & "in index entry" & Str(i) & ", " & Left(Buf, LenEntryText) & ".", 64, "Demo Copyright 1994 David Stewart"
                  'Select the entry.
                  FrmListPos = SendMsgByNum(PROJECTListBox, LB_SETCURSEL, i, 0)
                  Exit For
               Else
                  'If we get to the end of the list without having found our string...
                  If i = (EntriesCount - 1) Then
                     '...start another loop from the top of the list to the position
                     'of the selected item when we started the i loop. This way, we miss
                     'no file as a search subject.
                     For j = 0 To CurSelPos Step 1
                        LenEntryText = SendMsgByNum(PROJECTListBox, LB_GETTEXTLEN, j, 0)
                        Buf = String$(LenEntryText + 1, 0)
                        BufLen = SendMsgByStr(PROJECTListBox, LB_GETTEXT, j, Buf)
                        IsStringIn = InStr(1, Buf, txtFormName(1).Text)
                        If IsStringIn > 0 Then
                           MsgBox "The string fragment '" & txtFormName(1).Text & "' has been found" & Chr(10) & "in index entry" & Str(j) & ", " & Left(Buf, LenEntryText) & ".", 64, "Demo Copyright 1994 David Stewart"
                           FrmListPos = SendMsgByNum(PROJECTListBox, LB_SETCURSEL, j, 0)
                           Exit For
                        End If
                     Next j
                  End If
               End If
            Next i
            'If we didn't find it in ANY part of the list box, let user know.
            If IsStringIn = 0 Then
               MsgBox "The string fragment '" & txtFormName(1).Text & "' has not been found" & Chr(10) & "in the Project window list.", 64, "Demo Copyright 1994 David Stewart"
            End If
         End If
      Case 5   'Name and Index of Current Selection...
         'Get the position currently selected in the list...
         CurSelPos = SendMsgByNum(PROJECTListBox, LB_GETCURSEL, 0, 0)
         'Get its length...
         LenEntryText = SendMsgByNum(PROJECTListBox, LB_GETTEXTLEN, CurSelPos, 0)
         'Buffer for it...
         Buf = String$(LenEntryText + 1, 0)
         'Get the string, store in Buf and length of buffer too...
         BufLen = SendMsgByStr(PROJECTListBox, LB_GETTEXT, CurSelPos, Buf)
         'Pass on information about the listing.
         Msg$ = "The file " & Left(Buf, LenEntryText) & " is currently "
         Msg$ = Msg$ & "selected in the Project window list box. "
         Msg$ = Msg$ & "Its entry index number is" & Str(CurSelPos) & "."
         MsgBox Msg$, 64, "Demo Copyright 1994 David Stewart"
      Case 6  'List Files in Project
         frmVBProjectListSpy.CurrentY = 200
         'Get the number of entries...
         EntriesCount% = SendMsgByNum(PROJECTListBox, LB_GETCOUNT, 0, 0)
         If EntriesCount% = 0 Then
            MsgBox "There are no files listed in the Project list box.", 64, "Demo Copyright 1994 David Stewart"
         Else
            'In general, let user know how many files are in the project.
            If EntriesCount = 1 Then
               MsgBox "There is one file listed in the Project list box.", 64, "Demo Copyright 1994 David Stewart"
            Else
               MsgBox "There are" & Str(EntriesCount) & " files listed in the Project list box.", 64, "Demo Copyright 1994 David Stewart"
            End If
            'Now cycle through them from first to last, getting their text.
            For i = 0 To (EntriesCount - 1) Step 1
               LenEntryText = SendMsgByNum(PROJECTListBox, LB_GETTEXTLEN, i, 0)
               Buf = String$(LenEntryText + 1, 0)
               LenEntryText = SendMsgByStr(PROJECTListBox, LB_GETTEXT, i, Buf)
               'Initialize values for the print starting point.
               frmVBProjectListSpy.CurrentX = 4300: frmVBProjectListSpy.CurrentY = frmVBProjectListSpy.CurrentY + 100
               'Print the current index...
               frmVBProjectListSpy.Print Left(Buf, LenEntryText)
            '...and move onto the next until we're done.
            Next i
         'When it's all done, get out.
         End If
   End Select
End Sub

Sub cmdHuh_Click ()
   Msg$ = "A FileNamePrefix prefix is the first n letters of "
   Msg$ = Msg$ & "the form or module FileNamePrefix you want to locate "
   Msg$ = Msg$ & "in the list." & DblSp & "In order for the API function and "
   Msg$ = Msg$ & "message to find the listing, you must begin with "
   Msg$ = Msg$ & "the beginning of the name." & DblSp & "VB can't automatically "
   Msg$ = Msg$ & "find a list entry by letters inside the name, though, "
   Msg$ = Msg$ & "of course, a procedure could be written that would reiteratively "
   Msg$ = Msg$ & "first get a list entry's complete FileNamePrefix text and then "
   Msg$ = Msg$ & "do an InStr search on it. Hey, there's a "
   Msg$ = Msg$ & "button here that does just exactly that! Try it."
   MsgBox Msg$, 64, "Demo Copyright 1994 David Stewart"
End Sub

Sub Form_Load ()
   DblSp = Chr(10) & Chr(10)
   Left = (Screen.Width - Width) / 2: Top = (Screen.Height - Height) / 2
End Sub

Sub txtFormName_GotFocus (Index As Integer)
   'Select all text in box for easy replacement,
   'when user selects either of the the text boxes.
   If Index = 0 Then
      txtFormName(0).SelStart = 0
      txtFormName(0).SelLength = 2500
   Else
      txtFormName(1).SelStart = 0
      txtFormName(1).SelLength = 2500
   End If
End Sub

Sub txtFormName_KeyPress (Index As Integer, KeyASCII As Integer)
   'Convert all typed letter characters to upper case as they're typed in.
   If KeyASCII > 96 And KeyASCII < 123 Then KeyASCII = KeyASCII - 32
End Sub

