VERSION 2.00
Begin Form Form1 
   Caption         =   "Drag Drop on the Grid"
   ClientHeight    =   2850
   ClientLeft      =   1575
   ClientTop       =   1590
   ClientWidth     =   7470
   Height          =   3255
   Left            =   1515
   LinkTopic       =   "Form1"
   ScaleHeight     =   2850
   ScaleWidth      =   7470
   Top             =   1245
   Width           =   7590
   Begin ListBox List1 
      Height          =   2565
      Left            =   0
      TabIndex        =   1
      Top             =   0
      Width           =   2415
   End
   Begin Grid Grid1 
      Cols            =   20
      Height          =   2655
      Left            =   2400
      Rows            =   20
      TabIndex        =   0
      Top             =   0
      Width           =   5055
   End
End
'Dragging is a flag used for each control to determine
'if we are dragging something.

Dim dragging As Integer

Sub Form_Load ()
For X = 1 To 10
   list1.AddItem X
Next X
End Sub

Sub Grid1_DragDrop (Source As Control, X As Single, Y As Single)
'Calculate the row to drop in.  Add each row until we pass Y
'All this is calculated in twips.

currentrow = grid1.TopRow
twipcount = grid1.RowHeight(currentrow)
While (twipcount <= Y)
   currentrow = currentrow + 1
   twipcount = twipcount + grid1.RowHeight(currentrow)
   
   'If there are gridlines, we have to add those in too
   If grid1.GridLines Then
      twipcount = twipcount + grid1.GridLineWidth * screen.TwipsPerPixelY
   End If
Wend

'Calculate the column to drop in.  Add each row until we pass X
'All this is calculated in twips.
currentcol = grid1.LeftCol
twipcount = grid1.ColWidth(currentcol)
While (twipcount <= X)
   currentcol = currentcol + 1
   twipcount = twipcount + grid1.ColWidth(currentcol)

   'If there are gridlines, we have to add those in too
   If grid1.GridLines Then
      twipcount = twipcount + grid1.GridLineWidth * screen.TwipsPerPixelX
   End If
Wend

'Assign value
grid1.Col = currentcol - 1
grid1.Row = currentrow - 1
grid1.Text = list1.Text

'End drag mode
list1.Drag 2
dragging = False
End Sub

Sub List1_DragDrop (Source As Control, X As Single, Y As Single)
'Ooops.  Dropped on ourselves.  Just cancel the drag mode.

list1.Drag 0
dragging = False
End Sub

Sub List1_MouseDown (Button As Integer, Shift As Integer, X As Single, Y As Single)
'If the mouse goes down, set the dragging flag in case this is for a drag
dragging = True
End Sub

Sub List1_MouseMove (Button As Integer, Shift As Integer, X As Single, Y As Single)
'If the dragging flag was set, then we will enable the drag
'MouseDown has to set the flag first
If dragging Then
   dragging = False  'Cancel the flag
   list1.Drag 1      'Start the drag mode
Else
   list1.Drag 0      'Cancel if flag was not set
End If
End Sub

Sub List1_MouseUp (Button As Integer, Shift As Integer, X As Single, Y As Single)
'Mouse released on text box so cancel the dragging mode

list1.Drag 0
dragging = False
End Sub

