' KeyState.Bas - Get or Set Caps Lock or Num Lock with an API
' 95/01/22 Adapted by Larry Rebich, The Bridge, Inc., CIS 71662,205
'
' According to the following article KeyStat.VBX can cause a GPF under the
' described conditions.  I have been using KeyStat to set the status of the
' caps and num lock on the status bar of an application I am developing.
' I adapted the concepts provided by the "workaround" to not only test the
' key state but to toggle it as well.
'
' I am sharing this code in hopes that if you develop useful code you will
' share it with others - including me!!!
'
' Cheers,
' Larry
'
    Option Explicit
    DefInt A-Z

    Declare Sub SetKeyboardState Lib "User" (ByVal lpKeyState As String)    'added by Larry Rebich
    Declare Sub GetKeyboardState Lib "User" (ByVal lpKeyState As String)
    Global Const VK_Capital = &H14      'pointer to location in string of caps info
    Global Const VK_NumLock = &H90      'pointer to location in string of num lock info
    Dim Keys As String * 256            'key values are retrieved into here
    Const BitOne = &H1

' ------------------  from the Microsoft Developers CD, volume 10 -------------
'PSS ID Number: Q121681
'Article last modified on 10-18-1994
'
'3.00
'
'WINDOWS
'
'---------------------------------------------------------------------
'The information in this article applies to:
'
'- Professional Edition of Microsoft Visual Basic for Windows,
'  version 3.0
'---------------------------------------------------------------------
'
'SYMPTOMS
'========
'
'When the KEYSTAT.VBX control is used in more than one application, and the
'parent window is minimized, the application causes a general protection
'(GP) fault.
'
'STATUS
'======
'
'Microsoft has confirmed this to be a bug in the Microsoft product listed
'at the beginning of this article. We are researching this problem and will
'post new information here in the Microsoft Knowledge Base as it becomes
'available.
'
'WORKAROUND
'==========

'To work around this problem, use the Windows API GetKeyboardState function
'directly as in the following example:
'
'1. Start a new project in Visual Basic. Form1 is created by default.
''
'2. Add the following code to the (general) (declarations) section
'
'    Declare Sub GetKeyboardState Lib "User" (ByVal lpKeyState As String)
'    Global Const VK_Capital = &H14
'    Global Const VK_NumLock = &H90
'
'3. Place a command button (Command1) on Form1, and add the following code
'   to the Command1 Click event:
'
'4. Run the application.
'
'Additional reference words: 3.00 buglist3.00 gpf
'KBCategory: kbprg kbbuglist kbcode
'KBSubcategory: PrgCtrlsCus
'
'=============================================================================
'
'Copyright Microsoft Corporation 1994.

Function GetKeyboardStateCapsLock () As String
    GetKeyboardState Keys           'API to get current state
    If BitOne = (Asc(Mid(Keys, VK_Capital + 1, 1)) And BitOne) Then
        GetKeyboardStateCapsLock = "Caps"
    End If
End Function

Function GetKeyboardStateNumLock () As String
    GetKeyboardState Keys           'API to get current state
    If BitOne = (Asc(Mid(Keys, VK_NumLock + 1, 1)) And BitOne) Then
        GetKeyboardStateNumLock = "Num"
    End If
End Function

Sub SetKeyboardStateCapsLock ()
    GetKeyboardState Keys       'get current setting
    ' toggle it
    SetKeyboardState Mid$(Keys, 1, VK_Capital) & Chr$(Asc(Mid$(Keys, VK_Capital + 1, 1)) Xor BitOne) & Mid$(Keys, VK_Capital + 2)
End Sub

Sub SetKeyboardStateNumLock ()
    GetKeyboardState Keys       'get current setting
    ' toggle it
    SetKeyboardState Mid$(Keys, 1, VK_NumLock) & Chr$(Asc(Mid$(Keys, VK_NumLock + 1, 1)) Xor BitOne) & Mid$(Keys, VK_NumLock + 2)
End Sub

