'   Functions for accessing the generic Joystick driver
'   thanks to William Nelson at MS for converting from 'c'

Global Const MM_JOY1MOVE = &H3A0
Global Const MM_JOY2MOVE = &H3A1
Global Const MM_JOY1ZMOVE = &H3A2
Global Const MM_JOY2ZMOVE = &H3A3
Global Const MM_JOY1BUTTONDOWN = &H3B5
Global Const MM_JOY2BUTTONDOWN = &H3B6
Global Const MM_JOY1BUTTONUP = &H3B7
Global Const MM_JOY2BUTTONUP = &H3B8

Global Const MMSYSERR_BASE = 0
Global Const JOYERR_BASE = 160

' general error return values
Global Const MMSYSERR_NOERROR = 0                           ' no error
Global Const MMSYSERR_ERROR = (MMSYSERR_BASE + 1)           ' unspecified error
Global Const MMSYSERR_BADDEVICEID = (MMSYSERR_BASE + 2)     ' device ID out or range
Global Const MMSYSERR_NOTENABLED = (MMSYSERR_BASE + 3)      ' driver failed enable
Global Const MMSYSERR_ALLOCATED = (MMSYSERR_BASE + 4)       ' device aleardy allocated
Global Const MMSYSERR_INVALHANDLE = (MMSYSERR_BASE + 5)     ' device handle is invalid
Global Const MMSYSERR_NODRIVER = (MMSYSERR_BASE + 6)        ' no device driver present
Global Const MMSYSERR_NOMEM = (MMSYSERR_BASE + 7)           ' memory allocation error
Global Const MMSYSERR_NOTSUPPORTED = (MMSYSERR_BASE + 8)    ' function isn't supported
Global Const MMSYSERR_BADERRNUM = (MMSYSERR_BASE + 9)       ' error value out of range
Global Const MMSYSERR_INVALFLAG = (MMSYSERR_BASE + 10)      ' invalid flag passed
Global Const MMSYSERR_INVALPARAM = (MMSYSERR_BASE + 11)     ' invalid parameter passsed
Global Const MMSYSERR_LASTERROR = (MMSYSERR_BASE + 12)      ' last error in range

' joystick error return values
Global Const JOYERR_NOERROR = 0                     ' no error
Global Const JOYERR_PARMS = (JOYERR_BASE + 5)       ' bad parameters
Global Const JOYERR_NOCANDO = (JOYERR_BASE + 6)     ' request not completed
Global Const JOYERR_UNPLUGGED = (JOYERR_BASE + 7)   ' joystick is unplugged

' constants used with JOYINFO structure and MM_JOY messages
Global Const JOY_BUTTON1 = &H1
Global Const JOY_BUTTON2 = &H2
Global Const JOY_BUTTON3 = &H4
Global Const JOY_BUTTON4 = &H8
Global Const JOY_BUTTON1CHG = &H100
Global Const JOY_BUTTON2CHG = &H200
Global Const JOYSTICKID1 = 0
Global Const JOYSTICKID2 = 1

Type JOYCAPS
    wMid As Integer
    wPid As Integer
    sxPname As String * 256
    wXmin As Integer
    wXmax As Integer
    wYmin As Integer
    wYmax As Integer
    wZmin As Integer
    wZmax As Integer
    wNumButtons As Integer
    wPeriodMin As Integer
    wPeriodMax As Integer
End Type

Type JOYINFO
    wXPos As Integer
    wYPos As Integer
    wZPos As Integer
    wButtons As Integer
End Type

Declare Function joyGetDevCaps Lib "MMSYSTEM" (ByVal wJoyID%, lpCaps As JOYCAPS, ByVal wSize%) As Integer
Declare Function JoyGetNumDevs Lib "MMSYSTEM" () As Integer
Declare Function joyGetPos Lib "MMSYSTEM" (ByVal wJoyID%, lpInfo As JOYINFO) As Integer
Declare Function joyGetThreshold Lib "MMSYSTEM" (ByVal wJoyID%, lpwThreshold%) As Integer
Declare Function joyReleaseCapture Lib "MMSYSTEM" (ByVal wJoyID%) As Integer
Declare Function joySetThreshold Lib "MMSYSTEM" (ByVal wJoyID%, ByVal wThreshold%) As Integer
Declare Function joySetCapture Lib "MMSYSTEM" (ByVal wHnd%, ByVal wJoyID%, ByVal wPeriod%, ByVal bChanged%) As Integer

Function Long2w (LongValue As Long) As Integer

    Long2w = CInt(LongValue - &H10000)

End Function

Function w2Long (wUINT As Integer) As Long

    w2Long = (CLng(wUINT) And &HFFFF&)

End Function

